/*
 * Decompiled with CFR 0.152.
 */
package ancestris.api.editor;

import ancestris.api.editor.Bundle;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.CommonActions;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class AncestrisEditor {
    static AbstractAction NOOP = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };

    public static List<AncestrisEditor> findEditors() {
        return (List)Lookup.getDefault().lookupAll(AncestrisEditor.class);
    }

    public static AncestrisEditor findEditor(Property property) {
        AncestrisEditor editor = null;
        AncestrisEditor backupEditor = null;
        if (property == null) {
            return null;
        }
        String canonicalName = GedcomOptions.getInstance().getDefaultEditor();
        for (AncestrisEditor edt : AncestrisEditor.findEditors()) {
            if (edt.canEdit(property) && edt.getName(true).contains(canonicalName)) {
                if (edt.isActive()) {
                    return edt;
                }
                editor = edt;
                continue;
            }
            if (edt.canEdit(property) && property instanceof PropertyPlace && edt.getName(true).contains("PlaceEditor")) {
                return edt;
            }
            if (!edt.canEdit(property)) continue;
            backupEditor = edt;
        }
        return editor != null ? editor : backupEditor;
    }

    public abstract boolean canEdit(Property var1);

    public abstract boolean isActive();

    @Deprecated
    public abstract Property edit(Property var1, boolean var2);

    public abstract Property add(Property var1);

    public Property edit(Property property) {
        return this.edit(property, false);
    }

    public abstract ImageIcon getIcon();

    public abstract String getName(boolean var1);

    public abstract Action getCreateParentAction(Indi var1, int var2);

    public abstract Action getCreateSpouseAction(Indi var1);

    public Action getDefaultAction(final Property property) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AncestrisEditor.this.edit(property);
            }
        };
    }

    public static final class OpenEditorAction
    extends AbstractAction
    implements ContextAwareAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup context) {
            Object action = CommonActions.NOOP;
            Property property = (Property)context.lookup(Property.class);
            AncestrisEditor editor = AncestrisEditor.findEditor(property);
            if (editor != null) {
                action = new OpenEditor(property, editor);
            }
            return action;
        }

        private static final class OpenEditor
        extends AbstractAncestrisAction {
            private final Property property;
            private final AncestrisEditor editor;

            public OpenEditor(Property context, AncestrisEditor editor) {
                this.property = context;
                this.editor = editor;
                this.setText(Bundle.OpenInEditor_title());
                this.setImage(editor.getIcon());
            }

            public void actionPerformed(ActionEvent e) {
                if (this.editor != null) {
                    this.editor.edit(this.property);
                }
            }
        }
    }

    private static class NoOpEditor
    extends AncestrisEditor {
        public static final AncestrisEditor instance = new NoOpEditor();
        private static ImageIcon editorIcon = new ImageIcon(AncestrisEditor.class.getResource("editor_cygnus.png"));

        private NoOpEditor() {
        }

        @Override
        public boolean canEdit(Property property) {
            return false;
        }

        @Override
        public Property edit(Property property, boolean isNew) {
            return null;
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public Property add(Property parent) {
            return null;
        }

        @Override
        public String getName(boolean canonical) {
            if (canonical) {
                return this.getClass().getCanonicalName();
            }
            return NbBundle.getMessage(AncestrisEditor.class, (String)"OpenIDE-Module-Name");
        }

        public String toString() {
            return this.getName(false);
        }

        @Override
        public Action getCreateParentAction(Indi indi, int sex) {
            return this.getDefaultAction((Property)indi);
        }

        @Override
        public Action getCreateSpouseAction(Indi indi) {
            return this.getDefaultAction((Property)indi);
        }

        @Override
        public ImageIcon getIcon() {
            return editorIcon;
        }
    }
}

