/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.chart.Chart;
import genj.chart.XYSeries;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import genj.util.DirectAccessTokenizer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReportPlaceHistory
extends Report {
    private static final String PLAC = "PLAC";
    private static final String DATE = "DATE";
    private int topn = 10;
    private int resolution = 10;

    public int getTopn() {
        return this.topn;
    }

    public void setTopn(int set) {
        this.topn = Math.max(0, Math.max(3, set));
    }

    public Chart start(Gedcom gedcom) {
        Object[] jurisdictions;
        int jurisdiction = 0;
        String format = gedcom.getPlaceFormat();
        if (format.length() > 0 && (jurisdictions = new DirectAccessTokenizer(format, ",").getTokens(true)).length > 0) {
            Object choice = this.getValueFromUser(this.translate("jurisdiction"), jurisdictions, jurisdictions[0]);
            if (choice == null) {
                return null;
            }
            for (int i = 0; i < jurisdictions.length; ++i) {
                if (jurisdictions[i] != choice) continue;
                jurisdiction = i;
            }
        }
        Map plac2series = this.getSeriesForPlaces(gedcom, jurisdiction);
        Iterator indis = gedcom.getEntities("INDI").iterator();
        while (indis.hasNext()) {
            this.analyze((Entity)((Indi)indis.next()), plac2series, jurisdiction);
        }
        Iterator fams = gedcom.getEntities("FAM").iterator();
        while (fams.hasNext()) {
            this.analyze((Entity)((Fam)fams.next()), plac2series, jurisdiction);
        }
        XYSeries[] series = new XYSeries[plac2series.size()];
        plac2series.values().toArray(series);
        String title = this.translate("title", new Object[]{gedcom.getName()});
        String xaxis = this.translate("xaxis", new Object[]{this.resolution});
        String yaxis = this.translate("yaxis");
        return new Chart(title, xaxis, yaxis, series, null, true);
    }

    private void analyze(Entity ent, Map plac2series, int jurisdiction) {
        for (PropertyPlace place : ent.getProperties(PropertyPlace.class)) {
            Property parent;
            Property date;
            XYSeries series = (XYSeries)plac2series.get(place.getJurisdiction(jurisdiction));
            if (series == null || !((date = (parent = place.getParent()).getProperty(DATE)) instanceof PropertyDate)) continue;
            try {
                int year = ((PropertyDate)date).getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                if (year == Integer.MAX_VALUE) continue;
                series.inc((float)(year / this.resolution * this.resolution));
                System.out.println(year);
            }
            catch (GedcomException gedcomException) {}
        }
    }

    private Map getSeriesForPlaces(Gedcom gedcom, int jurisdiction) {
        String[] jurisdictions = PropertyPlace.getAllJurisdictions((Gedcom)gedcom, (int)jurisdiction, (boolean)false);
        HashMap<String, XYSeries> result = new HashMap<String, XYSeries>();
        int s = jurisdictions.length - 1;
        for (int i = 0; s >= 0 && i < this.topn; --s, ++i) {
            result.put(jurisdictions[s], new XYSeries(jurisdictions[s]));
        }
        return result;
    }
}

