/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.document.view;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.resources.Images;
import ancestris.modules.document.view.AbstractDocumentView;
import ancestris.modules.document.view.HyperLinkTextPane;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Context;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbBundle;

public class HyperLinkTextDocumentView
extends AbstractDocumentView {
    HyperLinkTextPane textOutput;
    String title;

    public HyperLinkTextDocumentView(Context context, String title, String tooltip) {
        super(context, title, tooltip);
        this.title = title;
        this.textOutput = new HyperLinkTextPane();
        this.textOutput.setGedcom(context.getGedcom());
        this.setView(this.textOutput);
        this.setToolbarActions(new Action[]{new ActionSave()});
    }

    public void add(String txt) {
        this.textOutput.add(txt);
    }

    public boolean isEmpty() {
        return this.textOutput.getDocument().getLength() == 0 && this.textOutput.getPage() == null;
    }

    public void setPage(URL page) throws IOException {
        this.textOutput.setPage(page);
    }

    public void clear() {
        this.textOutput.clear();
    }

    private class ActionSave
    extends AbstractAncestrisAction {
        protected ActionSave() {
            this.setImage((Icon)Images.imgSave);
            this.setTip(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_SaveDocument"));
        }

        public void actionPerformed(ActionEvent event) {
            OutputStreamWriter out;
            File file = new FileChooserBuilder(HyperLinkTextDocumentView.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_SaveDocument", (Object)HyperLinkTextDocumentView.this.title)).setApproveText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"OK_Button")).setDefaultExtension(FileChooserBuilder.getTextFilter().getExtensions()[0]).setFileFilter((FileFilter)FileChooserBuilder.getTextFilter()).setAcceptAllFileFilterUsed(false).setFileHiding(true).setDefaultDirAsReportDirectory().showSaveDialog(true);
            if (file == null) {
                return;
            }
            try {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF8"));
            }
            catch (IOException ex) {
                DialogManager.createError((String)HyperLinkTextDocumentView.this.textOutput.getName(), (String)("Error while saving to\n" + file.getAbsolutePath())).show();
                return;
            }
            try {
                String line;
                String newline = System.getProperty("line.separator");
                BufferedReader in = new BufferedReader(new StringReader(HyperLinkTextDocumentView.this.textOutput.getText()));
                while ((line = in.readLine()) != null) {
                    out.write(line);
                    out.write(newline);
                }
                in.close();
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

