/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.document.view;

import ancestris.modules.document.view.Bundle;
import ancestris.modules.document.view.DocumentViewTopComponent;
import genj.gedcom.Context;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class AbstractDocumentView
extends JPanel {
    private transient JScrollPane scrollPane = null;
    private Action[] actions = null;
    private Context context;

    private AbstractDocumentView() {
        this.setFocusCycleRoot(true);
        this.scrollPane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
    }

    public AbstractDocumentView(Context context, String title, String tooltip) {
        this();
        this.context = context;
        this.setName(title);
        this.setToolTipText(tooltip);
        this.setView(null);
        this.setToolbarActions(null);
        this.init();
    }

    final void init() {
        DocumentViewTopComponent.findInstance().addPanel(this);
    }

    public Context getContext() {
        return this.context;
    }

    public final void setView(JComponent component) {
        if (component == null) {
            component = new JLabel(Bundle.nocontent());
        }
        this.scrollPane.setViewportView(component);
        this.validate();
    }

    private void setToolbar() {
        Component oldTb = ((BorderLayout)this.getLayout()).getLayoutComponent("West");
        if (oldTb != null) {
            this.remove(oldTb);
        }
        if (this.actions != null) {
            JToolBar toolBar = new JToolBar(1);
            toolBar.setFloatable(false);
            for (Action a : this.actions) {
                toolBar.add(a);
            }
            this.add((Component)toolBar, "West");
        }
        this.validate();
    }

    public final void setToolbarActions(Action[] actions) {
        this.actions = actions == null ? null : (Action[])actions.clone();
        this.setToolbar();
        this.validate();
    }

    public Action[] getToolbarActions() {
        return this.actions == null ? null : (Action[])this.actions.clone();
    }

    public void close() {
        DocumentViewTopComponent.findInstance().removePanel(this);
        this.closeNotify();
    }

    protected void closeNotify() {
        if (this.scrollPane != null) {
            this.scrollPane.setViewport(null);
        }
    }
}

