/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.nav;

import ancestris.api.editor.AncestrisEditor;
import ancestris.awt.FilteredMouseAdapter;
import ancestris.modules.beans.ABluePrintBeans;
import ancestris.modules.beans.AListBean;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;

public final class FamilyPanel
extends JPanel {
    private static final String EMPTY_BP = NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.empty");
    private static final String WIFE_EMPTY_BP = NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.wife.empty");
    private static final String HUSBAND_EMPTY_BP = NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.husband.empty");
    private static final String CHILD_EMPTY_BP = NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.child.empty");
    private static final String FATHER_EMPTY_BP = NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.father.empty");
    private static final String MOTHER_EMPTY_BP = NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.mother.empty");
    private static final String FAMS_EMPTY_BP = NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.fams.empty");
    private Context context;
    private Indi focusIndi;
    private Fam focusFam;
    private final EntitiesPanel childrenPanel;
    private final EntitiesPanel oFamsPanel;
    private final EntitiesPanel siblingsPanel;
    private final EntitiesPanel eventsPanel;
    private JPanel eventsTab;
    private ABluePrintBeans familyParent;
    private ABluePrintBeans familySpouse;
    private JPanel fatherPanel;
    private ABluePrintBeans husbFather;
    private ABluePrintBeans husbMother;
    private ABluePrintBeans husband;
    private JPanel indiPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JScrollPane jsEvents;
    private JPanel motherPanel;
    private JPanel otherSpousePanel;
    private JPanel relativesPanel;
    private JPanel spousePanel;
    private ABluePrintBeans wife;

    public FamilyPanel() {
        this.initComponents();
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.husband.addMouseListener((MouseListener)((Object)new ABeanHandler(false)));
        this.wife.addMouseListener((MouseListener)((Object)new SpouseHandler(this.husband)));
        this.husbFather.addMouseListener((MouseListener)((Object)new ParentHandler(this.husband, 1)));
        this.husbMother.addMouseListener((MouseListener)((Object)new ParentHandler(this.husband, 2)));
        this.familySpouse.addMouseListener((MouseListener)((Object)new ABeanHandler(false)));
        this.husband.setEmptyBluePrint(HUSBAND_EMPTY_BP);
        this.husband.setBlueprint("INDI", "<body bgcolor=#e9e9ff>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.INDI"));
        this.wife.setEmptyBluePrint(WIFE_EMPTY_BP);
        this.wife.setBlueprint("INDI", "<body bgcolor=#f1f1ff>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.INDI"));
        this.husbFather.setEmptyBluePrint(FATHER_EMPTY_BP);
        this.husbFather.setBlueprint("INDI", "<body bgcolor=#f1f1f1>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.INDI"));
        this.husbMother.setEmptyBluePrint(MOTHER_EMPTY_BP);
        this.husbMother.setBlueprint("INDI", "<body bgcolor=#f1f1f1>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.INDI"));
        this.familySpouse.setEmptyBluePrint(FAMS_EMPTY_BP);
        this.familySpouse.setBlueprint("FAM", "<body bgcolor=#f1f1ff>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.FAM"));
        this.childrenPanel = new EntitiesPanel(this.jScrollPane1){

            public Entity[] getEntities(Property rootProperty) {
                if (rootProperty != null && rootProperty instanceof Fam) {
                    return ((Fam)rootProperty).getChildren();
                }
                return null;
            }
        };
        this.oFamsPanel = new EntitiesPanel(this.jScrollPane2){

            public Entity[] getEntities(Property rootProperty) {
                if (rootProperty != null && rootProperty instanceof Indi) {
                    return ((Indi)rootProperty).getFamiliesWhereSpouse();
                }
                return null;
            }
        };
        this.siblingsPanel = new EntitiesPanel(this.jScrollPane3){

            public Entity[] getEntities(Property rootProperty) {
                if (rootProperty != null && rootProperty instanceof Indi) {
                    return ((Indi)rootProperty).getSiblings(false);
                }
                return null;
            }
        };
        this.eventsPanel = new EntitiesPanel(this.jsEvents){

            public Property[] getEntities(Property rootProperty) {
                if (rootProperty != null && rootProperty instanceof Indi) {
                    ArrayList<Property> result = new ArrayList<Property>(5);
                    for (Property p : rootProperty.getProperties()) {
                        if (!(p instanceof PropertyEvent)) continue;
                        result.add(p);
                    }
                    return result.toArray(new Property[0]);
                }
                return null;
            }
        };
        this.eventsPanel.setBlueprint("", "<i><name path=.></i>&nbsp;:&nbsp;<prop path=.:DATE img=no>&nbsp;(<prop path=.:PLAC>)");
    }

    public void setContext(Context context) {
        if (context == null || context.getGedcom() == null) {
            return;
        }
        if (this.context != null && !context.getGedcom().equals(this.context.getGedcom())) {
            return;
        }
        Entity entity = context.getEntity();
        if (entity == null) {
            return;
        }
        this.context = context;
        if (entity instanceof Fam) {
            Fam family = (Fam)entity;
            if (family.getNoOfSpouses() == 0) {
                this.refresh();
                return;
            }
            if (family.equals(this.focusFam)) {
                this.refresh();
                return;
            }
            this.focusFam = (Fam)entity;
            this.focusIndi = this.focusFam.getHusband();
            if (this.focusIndi == null) {
                this.focusIndi = this.focusFam.getWife();
            }
        } else if (entity instanceof Indi) {
            if (((Indi)entity).equals(this.focusIndi)) {
                this.refresh();
                return;
            }
            this.focusIndi = (Indi)entity;
            this.focusFam = null;
        } else {
            this.refresh();
            return;
        }
        this.refresh();
    }

    private void refresh() {
        if (this.focusIndi == null) {
            return;
        }
        if (this.focusFam == null && this.focusIndi != null && this.focusIndi.getNoOfFams() > 0) {
            this.focusFam = this.focusIndi.getFamiliesWhereSpouse()[0];
        }
        this.husband.setContext((Property)this.focusIndi);
        this.husbFather.setContext((Property)this.focusIndi.getBiologicalFather());
        this.husbMother.setContext((Property)this.focusIndi.getBiologicalMother());
        this.familySpouse.setContext((Property)this.focusFam);
        if (this.focusFam == null) {
            this.wife.setContext(null);
        } else {
            this.wife.setContext((Property)this.focusFam.getOtherSpouse(this.focusIndi));
        }
        this.childrenPanel.update((Property)(this.familySpouse.getProperty() == null ? null : (Fam)this.familySpouse.getProperty().getEntity()), null);
        this.setTooltip(this.childrenPanel);
        Fam famChild = ((Indi)this.husband.getProperty()).getFamilyWhereBiologicalChild();
        this.familyParent.setContext((Property)famChild);
        this.siblingsPanel.update(this.husband.getProperty(), null);
        this.setTooltip(this.siblingsPanel);
        this.oFamsPanel.update(this.husband.getProperty(), this.familySpouse == null ? null : this.familySpouse.getProperty());
        this.setTooltip(this.oFamsPanel);
        this.eventsPanel.update(this.husband.getProperty(), null);
    }

    private void initComponents() {
        this.fatherPanel = new JPanel();
        this.husbFather = new ABluePrintBeans();
        this.motherPanel = new JPanel();
        this.husbMother = new ABluePrintBeans();
        this.indiPanel = new JPanel();
        this.husband = new ABluePrintBeans();
        this.jLabel3 = new JLabel();
        this.spousePanel = new JPanel();
        this.wife = new ABluePrintBeans();
        this.jLabel2 = new JLabel();
        this.otherSpousePanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.familySpouse = new ABluePrintBeans();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel8 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.familyParent = new ABluePrintBeans();
        this.relativesPanel = new JPanel();
        this.eventsTab = new JPanel();
        this.jsEvents = new JScrollPane();
        this.setPreferredSize(new Dimension(622, 500));
        this.setRequestFocusEnabled(false);
        this.fatherPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.fatherPanel.border.title"), 2, 0, new Font("Dialog", 1, 14)));
        this.husbFather.setToolTipText(NbBundle.getMessage(FamilyPanel.class, (String)"GeneralTootlTipText"));
        this.husbFather.setMinimumSize(new Dimension(0, 80));
        this.husbFather.setPreferredSize(new Dimension(256, 80));
        GroupLayout husbFatherLayout = new GroupLayout((Container)this.husbFather);
        this.husbFather.setLayout((LayoutManager)husbFatherLayout);
        husbFatherLayout.setHorizontalGroup(husbFatherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        husbFatherLayout.setVerticalGroup(husbFatherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout fatherPanelLayout = new GroupLayout(this.fatherPanel);
        this.fatherPanel.setLayout(fatherPanelLayout);
        fatherPanelLayout.setHorizontalGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.husbFather, GroupLayout.Alignment.TRAILING, -1, 293, Short.MAX_VALUE));
        fatherPanelLayout.setVerticalGroup(fatherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.husbFather, GroupLayout.Alignment.TRAILING, -1, 94, Short.MAX_VALUE));
        this.motherPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.motherPanel.border.title"), 2, 0, new Font("Dialog", 1, 14)));
        this.husbMother.setToolTipText(NbBundle.getMessage(FamilyPanel.class, (String)"GeneralTootlTipText"));
        this.husbMother.setMinimumSize(new Dimension(0, 80));
        this.husbMother.setPreferredSize(new Dimension(256, 80));
        GroupLayout husbMotherLayout = new GroupLayout((Container)this.husbMother);
        this.husbMother.setLayout((LayoutManager)husbMotherLayout);
        husbMotherLayout.setHorizontalGroup(husbMotherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        husbMotherLayout.setVerticalGroup(husbMotherLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 94, Short.MAX_VALUE));
        GroupLayout motherPanelLayout = new GroupLayout(this.motherPanel);
        this.motherPanel.setLayout(motherPanelLayout);
        motherPanelLayout.setHorizontalGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.husbMother, -1, 287, Short.MAX_VALUE));
        motherPanelLayout.setVerticalGroup(motherPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.husbMother, -1, 94, Short.MAX_VALUE));
        this.indiPanel.setBorder(null);
        this.husband.setBorder(BorderFactory.createEtchedBorder(new Color(51, 102, 255), null));
        this.husband.setToolTipText(NbBundle.getMessage(FamilyPanel.class, (String)"GeneralTootlTipText"));
        GroupLayout husbandLayout = new GroupLayout((Container)this.husband);
        this.husband.setLayout((LayoutManager)husbandLayout);
        husbandLayout.setHorizontalGroup(husbandLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        husbandLayout.setVerticalGroup(husbandLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabel3.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel3.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.jLabel3.text"));
        GroupLayout indiPanelLayout = new GroupLayout(this.indiPanel);
        this.indiPanel.setLayout(indiPanelLayout);
        indiPanelLayout.setHorizontalGroup(indiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.husband, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE));
        indiPanelLayout.setVerticalGroup(indiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indiPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addGap(2, 2, 2).addComponent((Component)this.husband, -1, -1, Short.MAX_VALUE)));
        this.spousePanel.setBorder(null);
        this.wife.setBorder(BorderFactory.createBevelBorder(0));
        this.wife.setToolTipText(NbBundle.getMessage(FamilyPanel.class, (String)"GeneralTootlTipText"));
        this.wife.setMinimumSize(new Dimension(0, 40));
        this.wife.setPreferredSize(new Dimension(256, 60));
        GroupLayout wifeLayout = new GroupLayout((Container)this.wife);
        this.wife.setLayout((LayoutManager)wifeLayout);
        wifeLayout.setHorizontalGroup(wifeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        wifeLayout.setVerticalGroup(wifeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 87, Short.MAX_VALUE));
        this.jLabel2.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel2.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.jLabel2.text"));
        GroupLayout spousePanelLayout = new GroupLayout(this.spousePanel);
        this.spousePanel.setLayout(spousePanelLayout);
        spousePanelLayout.setHorizontalGroup(spousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.wife, GroupLayout.Alignment.TRAILING, -1, 299, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE));
        spousePanelLayout.setVerticalGroup(spousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spousePanelLayout.createSequentialGroup().addComponent(this.jLabel2).addGap(2, 2, 2).addComponent((Component)this.wife, -1, 91, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.jScrollPane2.setBorder(BorderFactory.createBevelBorder(0));
        this.jScrollPane2.setToolTipText("");
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.jLabel1.text"));
        GroupLayout otherSpousePanelLayout = new GroupLayout(this.otherSpousePanel);
        this.otherSpousePanel.setLayout(otherSpousePanelLayout);
        otherSpousePanelLayout.setHorizontalGroup(otherSpousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE));
        otherSpousePanelLayout.setVerticalGroup(otherSpousePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(otherSpousePanelLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(2, 2, 2).addComponent(this.jScrollPane2, -2, 49, -2)));
        this.jTabbedPane1.setBorder(null);
        this.jTabbedPane1.setFont(new Font("Dialog", 1, 14));
        this.familySpouse.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.familySpouse.setToolTipText(NbBundle.getMessage(FamilyPanel.class, (String)"ClicEntTootlTipText"));
        this.familySpouse.setPreferredSize(new Dimension(256, 80));
        GroupLayout familySpouseLayout = new GroupLayout((Container)this.familySpouse);
        this.familySpouse.setLayout((LayoutManager)familySpouseLayout);
        familySpouseLayout.setHorizontalGroup(familySpouseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 608, Short.MAX_VALUE));
        familySpouseLayout.setVerticalGroup(familySpouseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 31, Short.MAX_VALUE));
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 610, Short.MAX_VALUE).addComponent((Component)this.familySpouse, -1, 610, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.familySpouse, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 101, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.jPanel1.TabConstraints.tabTitle"), this.jPanel1);
        this.familyParent.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.familyParent.setPreferredSize(new Dimension(256, 80));
        GroupLayout familyParentLayout = new GroupLayout((Container)this.familyParent);
        this.familyParent.setLayout((LayoutManager)familyParentLayout);
        familyParentLayout.setHorizontalGroup(familyParentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 608, Short.MAX_VALUE));
        familyParentLayout.setVerticalGroup(familyParentLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 31, Short.MAX_VALUE));
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.familyParent, -1, 610, Short.MAX_VALUE).addComponent(this.jScrollPane3, -1, 610, Short.MAX_VALUE));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel8Layout.createSequentialGroup().addComponent((Component)this.familyParent, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 101, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.jPanel8.TabConstraints.tabTitle"), this.jPanel8);
        this.relativesPanel.setBackground(Color.white);
        this.relativesPanel.setToolTipText(NbBundle.getMessage(FamilyPanel.class, (String)"ClicTootlTipText"));
        GroupLayout relativesPanelLayout = new GroupLayout(this.relativesPanel);
        this.relativesPanel.setLayout(relativesPanelLayout);
        relativesPanelLayout.setHorizontalGroup(relativesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 610, Short.MAX_VALUE));
        relativesPanelLayout.setVerticalGroup(relativesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 140, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.relativesPanel.TabConstraints.tabTitle"), this.relativesPanel);
        this.eventsTab.setBackground(Color.white);
        this.jsEvents.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jsEvents.setHorizontalScrollBarPolicy(31);
        GroupLayout eventsTabLayout = new GroupLayout(this.eventsTab);
        this.eventsTab.setLayout(eventsTabLayout);
        eventsTabLayout.setHorizontalGroup(eventsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 610, Short.MAX_VALUE).addGroup(eventsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jsEvents, -1, 610, Short.MAX_VALUE)));
        eventsTabLayout.setVerticalGroup(eventsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 140, Short.MAX_VALUE).addGroup(eventsTabLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jsEvents, GroupLayout.Alignment.TRAILING, -1, 140, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(FamilyPanel.class, (String)"FamilyPanel.eventsTab.TabConstraints.tabTitle"), this.eventsTab);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fatherPanel, -1, -1, Short.MAX_VALUE).addComponent(this.indiPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.motherPanel, -1, -1, Short.MAX_VALUE).addComponent(this.spousePanel, -1, -1, Short.MAX_VALUE).addComponent(this.otherSpousePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.motherPanel, -1, -1, Short.MAX_VALUE).addComponent(this.fatherPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.spousePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.otherSpousePanel, -2, -1, -2)).addComponent(this.indiPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addContainerGap()));
    }

    public static boolean editEvent(PropertyEvent prop, boolean isNew) {
        return true;
    }

    private void setTooltip(EntitiesPanel panel) {
        for (Component c : panel.getComponents()) {
            if (!(c instanceof ABluePrintBeans)) continue;
            ABluePrintBeans bean = (ABluePrintBeans)c;
            bean.setToolTipText(NbBundle.getMessage(FamilyPanel.class, (String)"ClicTootlTipText"));
        }
    }

    private abstract class EntitiesPanel
    extends AListBean {
        public EntitiesPanel(JScrollPane pane) {
            this.setBlueprint("INDI", "<body bgcolor=#ffffe3>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.INDI.cell"));
            this.setBlueprint("FAM", "<body bgcolor=#f1f1ff>" + NbBundle.getMessage(FamilyPanel.class, (String)"blueprint.FAM.cell"));
            this.setBackground(Color.white);
            this.setLayout(new BoxLayout((Container)((Object)this), 3));
            pane.setViewportView((Component)((Object)this));
        }

        public abstract Property[] getEntities(Property var1);

        public void update(Property rootProperty, Property exclude) {
            this.removeAll();
            this.repaint();
            if (rootProperty != null) {
                this.add(this.getEntities(rootProperty), exclude, (MouseListener)((Object)new ABeanHandler()));
            }
            this.revalidate();
        }
    }

    private class ParentHandler
    extends ABeanHandler {
        int sex;
        private final ABluePrintBeans childBean;

        public ParentHandler(ABluePrintBeans indiBean, int sex) {
            this.childBean = indiBean;
            this.sex = sex;
        }

        public ActionListener getCreateAction() {
            AncestrisEditor editor;
            Indi child = null;
            if (this.childBean != null) {
                child = (Indi)this.childBean.getProperty();
            }
            if ((editor = AncestrisEditor.findEditor(child)) == null) {
                editor = AncestrisEditor.findEditor(null);
            }
            return editor.getCreateParentAction(child, this.sex);
        }
    }

    private class SpouseHandler
    extends ABeanHandler {
        private final ABluePrintBeans otherBean;

        public SpouseHandler(ABluePrintBeans other) {
            this.otherBean = other;
        }

        public ActionListener getCreateAction() {
            AncestrisEditor editor;
            Indi indi = null;
            if (this.otherBean != null) {
                indi = (Indi)this.otherBean.getProperty();
            }
            if ((editor = AncestrisEditor.findEditor(indi)) == null) {
                editor = AncestrisEditor.findEditor(null);
            }
            return editor.getCreateSpouseAction(indi);
        }
    }

    private class ABeanHandler
    extends FilteredMouseAdapter {
        private boolean editOnClick = false;
        private ActionListener action = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        };

        public ABeanHandler(Action action) {
            this.action = action;
        }

        private ABeanHandler() {
            this(false);
        }

        private ABeanHandler(boolean editOnClic) {
            this.editOnClick = editOnClic;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClickedFiltered(MouseEvent evt) {
            Property prop;
            if (evt.getButton() != 1 || evt.getID() != 500) {
                return;
            }
            Object src = evt.getSource();
            if (src == null) {
                return;
            }
            ABluePrintBeans bean = null;
            if (src instanceof ABluePrintBeans) {
                bean = (ABluePrintBeans)src;
            }
            if (this.editOnClick || MouseUtils.isDoubleClick((MouseEvent)evt) || bean == null || bean.getProperty() == null) {
                SelectionDispatcher.muteSelection((boolean)true);
                try {
                    if (bean != null && bean.getProperty() != null) {
                        AncestrisEditor editor = AncestrisEditor.findEditor((Property)bean.getProperty());
                        if (editor != null) {
                            editor.edit(bean.getProperty());
                        }
                    } else {
                        this.getCreateAction().actionPerformed(new ActionEvent(evt.getSource(), 0, ""));
                    }
                    FamilyPanel.this.refresh();
                }
                finally {
                    SelectionDispatcher.muteSelection((boolean)false);
                }
            } else if (evt.getClickCount() == 1 && (prop = bean.getProperty()) instanceof Entity) {
                SelectionDispatcher.fireSelection((Context)new Context(prop));
            }
        }

        public ActionListener getCreateAction() {
            return this.action;
        }
    }
}

