/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.AncestrisActionProvider;
import ancestris.util.swing.DialogManager;
import ancestris.view.SelectionDispatcher;
import genj.common.SelectEntityWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.UnitOfWork;
import genj.view.ViewContext;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRefBean
extends PropertyBean
implements AncestrisActionProvider {
    private PropertyBean.Preview preview = new PropertyBean.Preview();
    private PropertyXRef xref;

    public List<Action> getActions(boolean hasFocus, Node[] nodes) {
        if (!hasFocus) {
            return new ArrayList<Action>();
        }
        ArrayList<Action> result = new ArrayList<Action>(1);
        if (nodes != null) {
            result.add((Action)((Object)new Swivel()));
        }
        return result;
    }

    public XRefBean() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.preview);
        this.preview.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                if (XRefBean.this.xref == null) {
                    return;
                }
                SelectionDispatcher.fireSelection((AWTEvent)e, (Context)new ViewContext((Property)XRefBean.this.xref));
            }
        });
    }

    @Override
    protected void commitImpl(Property property) {
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setPropertyImpl(Property prop) {
        PropertyXRef xref;
        this.xref = xref = (PropertyXRef)prop;
        if (xref != null && xref.getTargetEntity() != null) {
            this.preview.setEntity(xref.getTargetEntity());
        } else {
            this.preview.setEntity(null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(64, 48);
    }

    private class Swivel
    extends AbstractAncestrisAction {
        public Swivel() {
            this.setText(PropertyBean.RESOURCES.getString("xref.swivel"));
            this.setImage((Icon)MetaProperty.IMG_LINK);
        }

        public void actionPerformed(ActionEvent event) {
            if (XRefBean.this.xref == null) {
                return;
            }
            SelectEntityWidget select = new SelectEntityWidget(XRefBean.this.xref.getGedcom(), XRefBean.this.xref.getTargetType(), null);
            if (DialogManager.OK_OPTION != DialogManager.create((String)this.getText(), (JComponent)select).setOptionType(2).setDialogId("xrefbean.swivel").show()) {
                return;
            }
            final Entity newTarget = select.getSelection();
            if (XRefBean.this.xref.getTarget() != null) {
                PropertyBean.LOG.fine("Swiveling " + XRefBean.this.xref.getEntity().getId() + "." + XRefBean.this.xref.getPath() + " from " + XRefBean.this.xref.getTarget().getEntity().getId() + " to " + newTarget.getId());
            } else {
                PropertyBean.LOG.fine("Swiveling " + XRefBean.this.xref.getEntity().getId() + "." + XRefBean.this.xref.getPath() + " to " + newTarget.getId());
            }
            try {
                XRefBean.this.xref.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        PropertyXRef backpointer = XRefBean.this.xref.getTarget();
                        if (backpointer != null) {
                            XRefBean.this.xref.unlink();
                            backpointer.getParent().delProperty((Property)backpointer);
                        }
                        XRefBean.this.xref.setValue("@" + newTarget.getId() + "@");
                        XRefBean.this.xref.link();
                    }
                });
            }
            catch (GedcomException ge) {
                DialogManager.create((String)this.getText(), (String)ge.getMessage()).setMessageType(2).show();
                PropertyBean.LOG.log(Level.FINER, ge.getMessage(), ge);
            }
        }
    }
}

