/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableModel;
import genj.common.PropertyTableWidget;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Gedcom;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class ReferencesBean
extends PropertyBean {
    public static Icon IMG = MetaProperty.IMG_LINK;
    private PropertyTableWidget table = new PropertyTableWidget();

    public ReferencesBean() {
        this.table.setVisibleRowCount(2);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.table);
    }

    public void removeNotify() {
        REGISTRY.put("refcols", this.table.getColumnLayout());
        super.removeNotify();
    }

    protected void commitImpl(Property property) {
    }

    protected void setPropertyImpl(Property prop) {
        Model model = null;
        if (prop != null) {
            model = this.getModel(prop);
        }
        this.table.setModel((PropertyTableModel)model);
        this.table.setColumnLayout(REGISTRY.get("refcols", ""));
    }

    private Model getModel(Property root) {
        ArrayList<PropertyXRef> rows = new ArrayList<PropertyXRef>();
        for (PropertyXRef ref : root.getProperties(PropertyXRef.class)) {
            if (ref instanceof PropertyHusband || ref instanceof PropertyWife || ref instanceof PropertyChild || ref instanceof PropertyFamilyChild || ref instanceof PropertyFamilySpouse || !ref.isValid()) continue;
            rows.add(ref);
        }
        return new Model(root, rows);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Model
    extends AbstractPropertyTableModel {
        private List<PropertyXRef> rows;
        private TagPath[] columns;

        Model(Property root, List<PropertyXRef> rows) {
            super(root.getGedcom());
            this.columns = new TagPath[]{new TagPath("..", Property.LABEL), new TagPath(".", Gedcom.getName((String)"REFN")), new TagPath("*:..:..", "*")};
            this.rows = rows;
        }

        public int getNumCols() {
            return this.columns.length;
        }

        public int getNumRows() {
            return this.rows.size();
        }

        public TagPath getColPath(int col) {
            return this.columns[col];
        }

        public Property getRowRoot(int row) {
            return (Property)this.rows.get(row);
        }

        public String getCellValue(Property property, int row, int col) {
            switch (col) {
                case 0: {
                    return property != ReferencesBean.this.getProperty() ? property.getPropertyName() : "";
                }
                case 1: {
                    PropertyXRef ref;
                    if (property instanceof PropertyXRef && (ref = (PropertyXRef)property).isTransient()) {
                        property = ref.getTarget().getParent();
                    }
                    return property.getPropertyName();
                }
            }
            return property.toString();
        }

        public int getCellAlignment(Property property, int row, int col) {
            return 2;
        }
    }
}

