/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.ChangeSupport;
import genj.util.EnvironmentChecker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;

public class FontChooser
extends JPanel {
    private static String[] families = null;
    private JComboBox fonts;
    private JTextField size;
    private ChangeSupport changes = new ChangeSupport(this);
    private static final boolean isRenderWithFont = null == EnvironmentChecker.getProperty("ancestris.debug.fontproblems", null, "supress font usage in font-selection-list");

    public FontChooser() {
        this.fonts = new JComboBox<Font>(FontChooser.getAllFonts());
        this.fonts.setEditable(false);
        this.fonts.setRenderer(new Renderer());
        this.size = new JTextField(3);
        this.fonts.addActionListener(this.changes);
        this.size.getDocument().addDocumentListener(this.changes);
        this.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fonts, "Center");
        this.add((Component)this.size, "East");
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension result = super.getPreferredSize();
        result.width = Integer.MAX_VALUE;
        return result;
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            this.fonts.setSelectedIndex(-1);
            this.size.setText("");
            return;
        }
        String family = font.getFamily();
        Font[] fs = FontChooser.getAllFonts();
        for (int i = 0; i < fs.length; ++i) {
            if (!fs[i].getFamily().equals(family)) continue;
            this.fonts.setSelectedIndex(i);
            break;
        }
        this.size.setText("" + font.getSize());
    }

    public Font getSelectedFont() {
        Font font = (Font)this.fonts.getSelectedItem();
        if (font == null) {
            return null;
        }
        return font.deriveFont((float)this.getSelectedFontSize());
    }

    private int getSelectedFontSize() {
        int result = 10;
        try {
            result = Integer.parseInt(this.size.getText());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Math.max(2, result);
    }

    private static Font[] getAllFonts() {
        if (families == null) {
            families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        Font[] values = new Font[families.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new Font(families[i], 0, 12);
        }
        return values;
    }

    public static void main(String[] args) {
        System.out.println("Running font test");
        Font[] fonts = FontChooser.getAllFonts();
        System.out.println("Found " + fonts.length + " fonts");
        String txt = "GenealogyJ";
        FontRenderContext ctx = new FontRenderContext(null, false, false);
        for (int f = 0; f < fonts.length; ++f) {
            Font font = fonts[f];
            System.out.println("Testing font " + font + "...");
            LineMetrics lm = font.getLineMetrics(txt, ctx);
            lm.getAscent();
            lm.getBaselineIndex();
            lm.getDescent();
            lm.getHeight();
            lm.getLeading();
            lm.getStrikethroughOffset();
            lm.getUnderlineOffset();
            lm.getUnderlineThickness();
            System.out.println("OK");
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changes.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changes.removeChangeListener(listener);
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Font) {
                Font font = (Font)value;
                super.getListCellRendererComponent((JList<?>)list, font.getFamily(), index, isSelected, cellHasFocus);
                if (isRenderWithFont) {
                    this.setFont(font);
                }
            } else {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
            return this;
        }
    }
}

