/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class InputSource {
    private String name;

    protected InputSource(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract InputStream open() throws IOException;

    public static InputSource get(File file) {
        return InputSource.get(file.getName(), file);
    }

    public static InputSource get(String name, File file) {
        return new FileInput(name, file);
    }

    public static InputSource get(String name, byte[] bytes) {
        return new ByteInput(name, bytes);
    }

    public static class ByteInput
    extends InputSource {
        private byte[] bytes;

        public ByteInput(String name, byte[] bytes) {
            super(name);
            this.bytes = bytes;
        }

        @Override
        public InputStream open() {
            return new ByteArrayInputStream(this.bytes);
        }

        public boolean equals(Object obj) {
            return obj instanceof ByteInput && ((ByteInput)obj).bytes.equals(this.bytes);
        }

        public int hashCode() {
            return this.bytes.hashCode();
        }

        public String toString() {
            return "byte array size=" + this.bytes.length + " name=" + this.getName();
        }
    }

    public static class FileInput
    extends InputSource {
        private File file;

        public FileInput(File file) {
            this(file.getName(), file);
        }

        public FileInput(String name, File file) {
            super(name);
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public InputStream open() throws IOException {
            return new FileInputStream(this.file);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FileInput)) {
                return false;
            }
            FileInput that = (FileInput)obj;
            return that.file.equals(this.file) && that.getName().equals(this.getName());
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public String toString() {
            return "file name=" + this.getName() + " file=" + this.file.toString();
        }
    }
}

