/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.crypto.Enigma;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.Submitter;
import genj.util.ReferenceSet;
import genj.util.WordBuffer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyName
extends Property {
    public static final int PREFIX_AS_IS = 0;
    public static final int PREFIX_LAST = 1;
    public static final int IGNORE_PREFIX = 2;
    public static final String TAG = "NAME";
    private static final String KEY_LASTNAME = "NAME.last";
    private static final String KEY_FIRSTNAME = "NAME.first";
    private String lastName = "";
    private String firstName = "";
    private String suffix = "";
    private String nameTagValue;
    private String nameAsString;
    private boolean isBusy = false;

    PropertyName(String tag) {
        super(tag);
    }

    public PropertyName() {
        super(TAG);
    }

    public PropertyName(String first, String last) {
        this();
        this.setName(first, last);
    }

    @Override
    public PropertyComparator2 getComparator() {
        return NAMEComparator.getInstance();
    }

    public String getFirstName() {
        return this.getFirstName(false);
    }

    public String getFirstName(boolean displayValue) {
        if (displayValue) {
            return this.firstName.replaceAll(" *, *", " ");
        }
        return this.firstName;
    }

    public String getGivenName() {
        String tagGiven = GedcomOptions.getInstance().getGivenTag();
        String[] firstNames = this.firstName.split(",");
        String given = null;
        if (tagGiven.isEmpty()) {
            for (String first : firstNames) {
                if (!(first = first.trim()).matches("\"[^\"]*\"") && !first.matches("<[^>]*>") && !first.matches("\\[[^\\]]*\\]")) continue;
                given = first.substring(1, first.length() - 1);
                break;
            }
        } else if (this.getProperty(tagGiven) != null) {
            given = this.getProperty(tagGiven).getValue();
        }
        return given == null ? firstNames[0] : given;
    }

    @Override
    public boolean isValid() {
        if (!(this.getEntity() instanceof Indi) && !(this.getEntity() instanceof Submitter)) {
            return true;
        }
        if (this.nameAsString != null) {
            return false;
        }
        if (this.nameTagValue == null) {
            return true;
        }
        return this.nameTagValue.replaceAll(" */ *", "/").replaceAll(" +", " ").equalsIgnoreCase(this.computeNameValue().replaceAll(" */ *", "/"));
    }

    public static String getLabelForFirstName() {
        return Gedcom.getResources().getString("prop.name.firstname");
    }

    public static String getLabelForLastName() {
        return Gedcom.getResources().getString("prop.name.lastname");
    }

    public static String getLabelForSuffix() {
        return Gedcom.getResources().getString("prop.name.suffix");
    }

    public String getLastName() {
        return this.getLastName(false);
    }

    public String getLastName(boolean displayValue) {
        if (displayValue) {
            if (this.lastName.indexOf(44) < 0) {
                return this.lastName;
            }
            return this.lastName.substring(0, this.lastName.indexOf(44));
        }
        return this.lastName;
    }

    @Deprecated
    public String getLastName(int prefixPresentation) {
        return this.getLastName();
    }

    public String getSuffix() {
        return this.getPropertyValue("NSFX");
    }

    public String getNick() {
        return this.getPropertyValue("NICK");
    }

    public String getSurnamePrefix() {
        return this.getPropertyValue("SPFX");
    }

    public String getNamePrefix() {
        return this.getPropertyValue("NPFX");
    }

    public void setNick(String nick) {
        Property n = this.getProperty("NICK");
        if (n == null) {
            if (nick.length() == 0) {
                return;
            }
            this.addProperty("NICK", nick);
        } else {
            n.setValue(nick);
        }
    }

    @Deprecated
    public String getName() {
        return this.getDisplayValue();
    }

    @Override
    public String getValue() {
        if (this.nameAsString != null) {
            return this.nameAsString;
        }
        if (this.nameTagValue != null) {
            return this.nameTagValue;
        }
        return this.computeNameValue();
    }

    private String computeNameValue() {
        return this.computeNameValue(this.getNamePrefix(), this.getFirstName(true), this.getSurnamePrefix(), this.getLastName(true), this.suffix);
    }

    private String computeNameValue(String npfx, String first, String spfx, String last, String nsfx) {
        String name;
        WordBuffer wb = new WordBuffer();
        if (!npfx.isEmpty()) {
            wb.append(npfx);
        }
        if (!first.isEmpty()) {
            wb.append(first);
        }
        if (!(name = spfx).isEmpty() && !last.isEmpty()) {
            name = name + " ";
        }
        if ((name = name + last).length() > 0 || nsfx.length() > 0) {
            wb.append("/" + name + "/");
        }
        if (nsfx.length() > 0) {
            wb.append(nsfx);
        }
        return wb.toString();
    }

    @Override
    public String getDisplayValue() {
        if (this.isSecret()) {
            return "";
        }
        if (this.nameAsString != null) {
            return this.nameAsString;
        }
        if (!this.isValid() && this.nameTagValue != null) {
            return this.nameTagValue;
        }
        WordBuffer b = new WordBuffer();
        if (GedcomOptions.getInstance().getNameFormat() == GedcomOptions.NameFormat.LAST) {
            String last = this.getLastName(true);
            if (last.length() == 0) {
                last = "?";
            }
            b.append(this.getSurnamePrefix());
            b.append(last);
            b.append(this.getSuffix());
            b.setFiller(", ");
            b.append(this.getFirstName(true));
        } else {
            b.append(this.getFirstName(true));
            b.append(this.getSurnamePrefix());
            b.append(this.getLastName(true));
        }
        return b.toString();
    }

    @Override
    Property.PropertyFormatter formatImpl(char marker) {
        if (marker == 'g') {
            return new Property.PropertyFormatter(this, this.getGivenName());
        }
        return super.formatImpl(marker);
    }

    public PropertyName setName(String setLast) {
        return this.setName(this.firstName, setLast, this.suffix);
    }

    public final PropertyName setName(String setFirst, String setLast) {
        return this.setName(setFirst, setLast, this.suffix);
    }

    public PropertyName setName(String setFirst, String setLast, String setSuffix) {
        return this.setName(setFirst, setLast, setSuffix, false);
    }

    public PropertyName setName(String first, String last, String suff, boolean replaceAllLastNames) {
        return this.setName(this.getPropertyValue("NPFX"), first, this.getPropertyValue("SPFX"), last, suff, replaceAllLastNames);
    }

    public PropertyName setName(String nPfx, String first, String sPfx, String last, String suff, boolean replaceAllLastNames) {
        String old;
        boolean hasParent = this.getParent() != null;
        String string = old = hasParent ? this.getValue() : null;
        if (GedcomOptions.getInstance().isUpperCaseNames()) {
            NameParser parser = new NameParser(last);
            last = parser.getPrefix() + parser.getLast().toUpperCase();
        }
        first = PropertyName.normalizeName(first, GedcomOptions.getInstance().spaceIsSeparator());
        last = PropertyName.normalizeName(last, false);
        suff = suff.trim();
        nPfx = nPfx.trim();
        sPfx = sPfx.trim();
        if (replaceAllLastNames) {
            Property[] others;
            for (Property other : others = this.getSameLastNames()) {
                if (!(other instanceof PropertyName) || other == this) continue;
                ((PropertyName)other).setName(last);
            }
        }
        this.remember(first, last);
        if (hasParent && !this.isBusy) {
            this.isBusy = true;
            boolean add = GedcomOptions.getInstance().getAddNameSubtags();
            this.addNameSubProperty(add || !nPfx.isEmpty() || first.matches(".*[^,] .*"), "GIVN", first);
            this.addNameSubProperty(add || !sPfx.isEmpty() || last.contains(","), "SURN", last);
            this.addNameSubProperty(add || !nPfx.isEmpty(), "NPFX", nPfx);
            this.addNameSubProperty(add || !sPfx.isEmpty(), "SPFX", sPfx);
            this.addNameSubProperty(add, "NSFX", suff);
        }
        this.nameAsString = null;
        this.lastName = last;
        this.firstName = first;
        this.suffix = suff;
        this.nameTagValue = null;
        if (old != null && !this.isBusy) {
            this.propagatePropertyChanged(this, old);
        }
        this.isBusy = false;
        return this;
    }

    private void addNameSubProperty(boolean force, String tag, String value) {
        String oldValue;
        Property sub = this.getProperty(tag);
        String string = oldValue = sub != null ? sub.getValue() : "";
        if (value.isEmpty()) {
            if (sub != null && !oldValue.isEmpty()) {
                this.delProperty(sub);
            }
            return;
        }
        if (sub == null) {
            sub = this.addProperty(tag, value);
        } else if (!value.equals(oldValue)) {
            sub.setValue(value);
        }
        sub.setGuessed(!force);
        sub.setReadOnly(true);
    }

    private static String normalizeName(String namePiece, boolean spaceIsSeparator) {
        String result = namePiece.trim().replaceAll(" *, *", ",");
        if (spaceIsSeparator) {
            result = result.replaceAll(" +", ",");
        }
        return result.replaceAll(",", ", ");
    }

    @Override
    void afterAddNotify() {
        super.afterAddNotify();
        this.remember(this.firstName, this.lastName);
    }

    @Override
    void beforeDelNotify() {
        this.remember("", "");
        super.beforeDelNotify();
    }

    @Override
    public void setValue(String newValue) {
        this.nameTagValue = newValue;
        if (Enigma.isEncrypted(newValue)) {
            this.setName("", "", "");
            this.nameAsString = newValue;
            return;
        }
        if (newValue.indexOf(47) < 0) {
            this.setName(newValue, "", "");
            return;
        }
        String f = newValue.substring(0, newValue.indexOf(47)).trim();
        String l = newValue.substring(newValue.indexOf(47) + 1);
        if (l.indexOf(47) == -1) {
            this.setName("", "", "");
            this.nameAsString = newValue;
            return;
        }
        String s = l.substring(l.indexOf(47) + 1);
        l = l.substring(0, l.indexOf(47));
        f = f.replaceAll(",", " ");
        f = f.replaceAll(" +", " ");
        newValue = this.computeNameValue("", f, "", l, s);
        String npfx = this.getPropertyValue("NPFX");
        f = PropertyName.stripPrefix(f, npfx);
        String spfx = this.getPropertyValue("SPFX");
        l = PropertyName.stripPrefix(l, spfx);
        f = f.replaceAll(" +", ", ");
        if (this.getProperty("SURN") != null && !this.getProperty("SURN").isGuessed()) {
            l = this.getPropertyValue("SURN");
        }
        if (this.getProperty("GIVN") != null && !this.getProperty("GIVN").isGuessed()) {
            f = this.getPropertyValue("GIVN");
        }
        if (this.getProperty("NSFX") != null && !this.getProperty("NSFX").isGuessed()) {
            s = this.getPropertyValue("NSFX");
        }
        this.setName(this.getPropertyValue("NPFX"), f, this.getPropertyValue("SPFX"), l, s, false);
        this.nameTagValue = newValue;
    }

    private static String stripPrefix(String value, String prefix) {
        if (value.toLowerCase().startsWith(prefix.toLowerCase())) {
            return value.substring(prefix.length()).trim();
        }
        return value;
    }

    private void refresh(Property property) {
        String tag = property.getTag();
        if (!this.isBusy) {
            this.setName(this.getPropertyValue("NPFX"), this.getPropertyValue("GIVN"), this.getPropertyValue("SPFX"), this.getPropertyValue("SURN"), this.getPropertyValue("NSFX"), false);
        }
    }

    @Override
    void propagatePropertyAdded(Property property, int pos, Property added) {
        this.refresh(added);
        super.propagatePropertyAdded(property, pos, added);
    }

    @Override
    void propagatePropertyDeleted(Property property, int pos, Property deleted) {
        this.refresh(deleted);
        super.propagatePropertyDeleted(property, pos, deleted);
    }

    @Override
    void propagatePropertyChanged(Property property, String oldValue) {
        this.refresh(property);
        super.propagatePropertyChanged(property, oldValue);
    }

    public List<String> getLastNames(boolean sortByName) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new ArrayList<String>(0);
        }
        return PropertyName.getLastNames(gedcom, sortByName);
    }

    public List<String> getFirstNames(boolean sortByName) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new ArrayList<String>(0);
        }
        return PropertyName.getFirstNames(gedcom, sortByName);
    }

    public static List<String> getLastNames(Gedcom gedcom, boolean sortByName) {
        return gedcom.getReferenceSet(KEY_LASTNAME).getKeys(sortByName ? gedcom.getCollator() : null);
    }

    public static List<String> getFirstNames(Gedcom gedcom, boolean sortByName) {
        return gedcom.getReferenceSet(KEY_FIRSTNAME).getKeys(sortByName ? gedcom.getCollator() : null);
    }

    public int getLastNameCount() {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return 0;
        }
        return PropertyName.getLastNameCount(gedcom, this.getLastName());
    }

    public static int getLastNameCount(Gedcom gedcom, String last) {
        return gedcom.getReferenceSet(KEY_LASTNAME).getReferences(last).size();
    }

    public Property[] getSameLastNames() {
        return PropertyName.toArray(this.getGedcom().getReferenceSet(KEY_LASTNAME).getReferences(this.getLastName()));
    }

    private void remember(String newFirst, String newLast) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return;
        }
        ReferenceSet<String, Property> refSet = gedcom.getReferenceSet(KEY_LASTNAME);
        if (this.lastName.length() > 0) {
            refSet.remove(this.lastName, this);
        }
        if (newLast.length() > 0) {
            refSet.add(newLast, this);
        }
        refSet = gedcom.getReferenceSet(KEY_FIRSTNAME);
        if (this.firstName.length() > 0) {
            refSet.remove(this.firstName, this);
        }
        if (newFirst.length() > 0) {
            refSet.add(newFirst, this);
        }
    }

    private static class NAMEComparator
    extends PropertyComparator2.Default<PropertyName> {
        private static final NAMEComparator INSTANCE = new NAMEComparator();

        private NAMEComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public String getSortGroup(PropertyName p) {
            return this.shortcut(p.getLastName().trim(), 1);
        }

        @Override
        public int compare(PropertyName p1, PropertyName p2) {
            int r = this.compareNull(p1, p2);
            if (r != Integer.MAX_VALUE) {
                return r;
            }
            Collator c = p1.getGedcom().getCollator();
            r = c.compare(p1.getLastName(), p2.getLastName());
            if (r != 0) {
                return r;
            }
            return c.compare(p1.getFirstName(), p2.getFirstName());
        }
    }

    private static class NameParser {
        private static final Pattern PREFIX_PATTERN = Pattern.compile("(d'|von der|von|zu|del|de las|de les|de los|de|las|la|os|das|da|dos|af|av)( +)(.*)");
        private String prefix = "";
        private String last = "";

        public NameParser(String last) {
            Matcher m = PREFIX_PATTERN.matcher(last);
            if (m.matches()) {
                this.prefix = m.group(1) + " ";
                this.last = m.group(3);
            } else {
                this.prefix = "";
                this.last = last;
            }
        }

        String getPrefix() {
            return this.prefix;
        }

        String getLast() {
            return this.last;
        }
    }
}

