/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class PropertyFile
extends Property {
    public static final ImageIcon DEFAULT_IMAGE = Grammar.V55.getMeta(new TagPath("INDI:OBJE:FILE")).getImage();
    private String file;
    private boolean isRelativeChecked = false;

    public PropertyFile(String tag) {
        super(tag);
    }

    @Override
    public boolean addFile(File file) {
        this.setValue(file.getAbsolutePath(), true);
        return true;
    }

    @Override
    public String getValue() {
        Gedcom gedcom;
        if (this.file == null) {
            return "";
        }
        if (!this.isRelativeChecked && (gedcom = this.getGedcom()) != null) {
            String relative = gedcom.getOrigin().calcRelativeLocation(this.file);
            if (relative != null) {
                this.file = relative;
            }
            this.isRelativeChecked = true;
        }
        return this.file;
    }

    @Override
    public synchronized void setValue(String value) {
        String old = this.getValue();
        this.file = value.replace('\\', '/');
        this.isRelativeChecked = false;
        this.propagatePropertyChanged(this, old);
    }

    public void setValue(String value, boolean updateMeta) {
        Property form;
        this.setValue(value);
        Property media = this.getParent();
        if (!updateMeta || !media.getTag().equals("OBJE")) {
            return;
        }
        Property parent = this;
        if (!this.getMetaProperty().allows("FORM")) {
            if (!media.getMetaProperty().allows("FORM")) {
                return;
            }
            parent = media;
        }
        if ((form = parent.getProperty("FORM")) == null) {
            parent.addProperty("FORM", PropertyFile.getSuffix(this.file));
        } else {
            form.setValue(PropertyFile.getSuffix(this.file));
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.getGedcom().getOrigin().open(this.file);
    }

    public File getFile() {
        Gedcom gedcom = this.getGedcom();
        return gedcom != null ? gedcom.getOrigin().getFile(this.file) : null;
    }

    public static int getMaxValueAsIconSize(boolean kb) {
        return (kb ? 1 : 1024) * GedcomOptions.getInstance().getMaxImageFileSizeKB();
    }

    public String getSuffix() {
        return PropertyFile.getSuffix(this.file);
    }

    public static String getSuffix(String value) {
        int i;
        String result = "";
        if (value != null && (i = value.lastIndexOf(46)) >= 0) {
            result = value.substring(i + 1);
        }
        return result;
    }
}

