/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.EnvironmentChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Grammar {
    private static final Logger LOG = Logger.getLogger("ancestris.gedcom");
    public static final Grammar V55 = new Grammar("contrib/LDS/gedcom-5-5.xml");
    public static final Grammar V551 = new Grammar("contrib/LDS/gedcom-5-5-1.xml");
    public static final String GRAMMAR55 = "5.5";
    public static final String GRAMMAR551 = "5.5.1";
    private String version;
    private Map<String, MetaProperty> tag2root = new HashMap<String, MetaProperty>();

    private Grammar(String descriptor) {
        SAXParser parser;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Throwable t) {
            Gedcom.LOG.log(Level.SEVERE, "couldn't setup SAX parser", t);
            throw new Error(t);
        }
        try {
            InputStream in = this.getClass().getResourceAsStream("/" + descriptor);
            if (in != null) {
                LOG.info("Loading grammar through classloader");
            } else {
                try {
                    in = new FileInputStream(new File(EnvironmentChecker.getProperty("user.dir", ".", "current directory for grammar"), descriptor));
                }
                catch (FileNotFoundException e) {
                    in = new FileInputStream(new File("../app/" + descriptor));
                }
            }
            parser.parse(new InputSource(new InputStreamReader(in)), (DefaultHandler)new Parser());
        }
        catch (Throwable t) {
            Gedcom.LOG.log(Level.SEVERE, "couldn't parse grammar", t);
            throw new Error(t);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public TagPath[] getAllPaths(String etag, Class<? extends Property> property) {
        return this.getPathsRecursively(etag, property);
    }

    private TagPath[] getPathsRecursively(String etag, Class<? extends Property> property) {
        ArrayList<TagPath> result = new ArrayList<TagPath>();
        for (MetaProperty root : this.tag2root.values()) {
            String tag = root.getTag();
            if (etag != null && !tag.equals(etag)) continue;
            this.getPathsRecursively(root, property, new TagPath(tag), result);
        }
        return TagPath.toArray(result);
    }

    private void getPathsRecursively(MetaProperty meta, Class<? extends Property> property, TagPath path, Collection<TagPath> result) {
        if (!meta.isInstantiated) {
            return;
        }
        if (property.isAssignableFrom(meta.getType())) {
            result.add(path);
        }
        for (MetaProperty nested : meta.nested) {
            this.getPathsRecursively(nested, property, new TagPath(path, nested.getTag()), result);
        }
    }

    public MetaProperty getMeta(TagPath path) {
        return this.getMeta(path, true);
    }

    public MetaProperty getMeta(TagPath path, boolean persist) {
        return this.getMetaRecursively(path, persist);
    }

    MetaProperty getMetaRecursively(TagPath path, boolean persist) {
        String tag = path.get(0);
        MetaProperty root = this.tag2root.get(tag);
        if (root == null) {
            root = new MetaProperty(this, tag, new HashMap<String, String>(), false);
            this.tag2root.put(tag, root);
        }
        return root.getNestedRecursively(path, 1, persist);
    }

    public boolean isValid(TagPath path) {
        String tag = path.get(0);
        MetaProperty root = this.tag2root.get(tag);
        if (root == null) {
            return false;
        }
        for (int i = 1; i < path.length(); ++i) {
            tag = path.get(i);
            if (!root.allows(tag)) {
                return false;
            }
            root = root.getNested(tag, false);
        }
        return true;
    }

    private class Parser
    extends DefaultHandler {
        private Stack<MetaProperty> stack = null;

        private Parser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            MetaProperty meta;
            if (this.stack == null) {
                if (!"GEDCOM".equals(qName)) {
                    throw new RuntimeException("expected GEDCOM");
                }
                Grammar.this.version = attributes.getValue("version");
                if (Grammar.this.version == null) {
                    throw new RuntimeException("expected GEDCOM version");
                }
                this.stack = new Stack();
                return;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            int j = attributes.getLength();
            for (int i = 0; i < j; ++i) {
                properties.put(attributes.getQName(i), attributes.getValue(i));
            }
            try {
                meta = new MetaProperty(Grammar.this, qName, properties, true);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Problem instantiating meta property for " + qName + " with " + properties, t.getCause() != null ? t.getCause() : t);
                throw new Error("Can't parse Gedcom Grammar");
            }
            if (this.stack.isEmpty()) {
                meta.isInstantiated = true;
                Grammar.this.tag2root.put(qName, meta);
            } else {
                this.stack.peek().addNested(meta);
            }
            this.stack.push(meta);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("GEDCOM".equals(qName)) {
                this.stack = null;
            } else {
                this.stack.pop();
            }
        }
    }
}

