/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import ancestris.awt.FilteredMouseAdapter;
import ancestris.swing.atable.ATable;
import ancestris.swing.atable.ATableFilterWidget;
import ancestris.view.SelectionDispatcher;
import genj.common.AbstractPropertyTableModel;
import genj.common.PropertyTableModel;
import genj.common.PropertyTableModelListener;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.io.BasicTransferable;
import genj.util.WordBuffer;
import genj.util.swing.HeadlessLabel;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PropertyTableWidget
extends JPanel {
    private static final Logger LOG = Logger.getLogger("ancestris.common");
    private Table table = new Table();
    private boolean ignoreSelection = false;
    private int visibleRowCount = -1;
    private TransferHandler transferer;
    private Map<PropertyTableModel, Table.Model> tableModels;

    public PropertyTableWidget() {
        this((PropertyTableModel)null);
    }

    public PropertyTableWidget(PropertyTableModel propertyModel) {
        this.setModel(propertyModel, false);
        this.setRowSelection(2);
        this.setColSelection(2);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.table));
    }

    public void setShortcut(JPanel s) {
        this.table.setShortCut(s);
    }

    public Component getTableComponent() {
        return this.table;
    }

    public void setFilterWidget(ATableFilterWidget filter) {
        this.table.setFilterWidget(filter);
    }

    public void tsvExport(File file) throws IOException {
        this.table.tsvExport(file);
    }

    public void setColSelection(int set) {
        this.table.setColSelection(set);
    }

    public void setRowSelection(int set) {
        this.table.setRowSelection(set);
    }

    public TableModel getTableModel() {
        return this.table.getModel();
    }

    public void setModel(PropertyTableModel set) {
        this.table.setPropertyTableModel(set, false);
    }

    public void setModel(PropertyTableModel set, boolean reset) {
        this.table.setPropertyTableModel(set, reset);
    }

    public void setVisibleRowCount(int rows) {
        this.visibleRowCount = rows;
        this.revalidate();
        this.repaint();
    }

    public void eraseAll() {
        if (this.tableModels == null) {
            return;
        }
        for (PropertyTableModel key : this.tableModels.keySet()) {
            Table.Model model = this.tableModels.get(key);
            model.eraseCells();
        }
    }

    public PropertyTableModel getModel() {
        return this.table.getPropertyTableModel();
    }

    public void setAutoResize(boolean on) {
        this.table.setAutoResizeMode(on ? 4 : 0);
    }

    public int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    public Property getSelectedRow() {
        int i = this.table.getSelectedRow();
        return i < 0 ? null : this.table.getRowRoot(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void select(Context context) {
        if (this.ignoreSelection) {
            return;
        }
        if (context.getGedcom() != this.getModel().getGedcom()) {
            throw new IllegalArgumentException("select on wrong gedcom");
        }
        try {
            void var5_7;
            this.ignoreSelection = true;
            List<? extends Property> props = context.getProperties();
            if (props.isEmpty()) {
                ArrayList<? extends Property> ps = new ArrayList<Property>(context.getProperties());
                for (Entity entity : context.getEntities()) {
                    if (ps.contains(entity)) continue;
                    ps.add(entity);
                }
                props = ps;
            }
            ListSelectionModel rows = this.table.getSelectionModel();
            ListSelectionModel cols = this.table.getColumnModel().getSelectionModel();
            this.table.clearSelection();
            Point point = new Point();
            for (Property property : props) {
                Point point2 = this.table.getCell(property);
                if (point2.y >= 0) {
                    point2.y = this.table.convertRowIndexToView(point2.y);
                    rows.addSelectionInterval(point2.y, point2.y);
                    if (point2.x < 0) continue;
                    point2.x = this.table.convertColumnIndexToView(point2.x);
                    cols.addSelectionInterval(point2.x, point2.x);
                    continue;
                }
                int row = this.table.getRow(property);
                if (row < 0) continue;
                row = this.table.convertRowIndexToView(row);
                rows.addSelectionInterval(row, row);
                cols.addSelectionInterval(0, this.table.getColumnCount() - 1);
                point2.y = row;
            }
            if (var5_7.y >= 0) {
                Rectangle visible = this.table.getVisibleRect();
                Rectangle rectangle = this.table.getCellRect(var5_7.y, var5_7.x, true);
                if (var5_7.x < 0) {
                    rectangle.x = visible.x;
                }
                this.table.scrollRectToVisible(rectangle);
                this.table.scrollRectToVisible(rectangle);
            }
        }
        finally {
            this.ignoreSelection = false;
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.table.getSelectionModel().removeListSelectionListener(listener);
    }

    public String getColumnLayout() {
        TableColumnModel columns = this.table.getColumnModel();
        WordBuffer result = new WordBuffer(",");
        result.append(columns.getColumnCount());
        for (int c = 0; c < columns.getColumnCount(); ++c) {
            result.append(columns.getColumn(c).getWidth());
        }
        List<RowSorter.SortKey> sortKeys = null;
        if (this.table.getRowSorter() != null) {
            sortKeys = this.table.getRowSorter().getSortKeys();
        }
        if (sortKeys != null && !sortKeys.isEmpty()) {
            for (RowSorter.SortKey sortKey : sortKeys) {
                result.append(sortKey.getColumn());
                result.append(sortKey.getSortOrder().name());
            }
        }
        return result.toString();
    }

    public void setColumnLayout(String layout) {
        TableColumnModel columns = this.table.getColumnModel();
        try {
            StringTokenizer tokens = new StringTokenizer(layout, ",");
            int n = Integer.parseInt(tokens.nextToken());
            for (int i = 0; i < n && i < columns.getColumnCount(); ++i) {
                TableColumn col = columns.getColumn(i);
                int w = Integer.parseInt(tokens.nextToken());
                col.setWidth(w);
                col.setPreferredWidth(w);
            }
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(3);
            while (tokens.hasMoreTokens()) {
                try {
                    int c = Integer.parseInt(tokens.nextToken());
                    SortOrder d = SortOrder.valueOf(tokens.nextToken());
                    if (c >= columns.getColumnCount()) continue;
                    sortKeys.add(new RowSorter.SortKey(c, d));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (sortKeys.isEmpty()) {
                sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            }
            if (this.table.getRowSorter() != null) {
                this.table.getRowSorter().setSortKeys(sortKeys);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private class Table
    extends ATable {
        private PropertyTableModel propertyModel;
        private final int defaultRowHeight;

        Table() {
            this.setPropertyTableModel(null, false);
            Renderer r = new Renderer();
            r.setFont(this.getFont());
            this.defaultRowHeight = r.getPreferredSize().height;
            this.setDefaultRenderer(Object.class, r);
            this.getColumnModel().getSelectionModel().addListSelectionListener(this);
            this.setFocusTraversalKeys(0, null);
            this.setFocusTraversalKeys(1, null);
            this.addMouseListener(new FilteredMouseAdapter(){

                @Override
                public void mouseClickedFiltered(MouseEvent e) {
                    int row = Table.this.rowAtPoint(e.getPoint());
                    int col = Table.this.columnAtPoint(e.getPoint());
                    if (row < 0 || col < 0) {
                        Table.this.clearSelection();
                    } else if (!Table.this.isCellSelected(row, col)) {
                        Table.this.getSelectionModel().setSelectionInterval(row, row);
                        Table.this.getColumnModel().getSelectionModel().setSelectionInterval(col, col);
                    }
                    Object cell = Table.this.getValueAt(row, col);
                    if (cell != null && cell instanceof Property) {
                        SelectionDispatcher.fireSelection(e, new Context((Property)cell));
                    }
                }
            });
        }

        @Override
        public TransferHandler getTransferHandler() {
            if (PropertyTableWidget.this.transferer == null) {
                PropertyTableWidget.this.transferer = new Transferer();
            }
            return PropertyTableWidget.this.transferer;
        }

        @Override
        public int[] getSelectedRows() {
            int[] rows = super.getSelectedRows();
            for (int r = 0; r < rows.length; ++r) {
                rows[r] = this.convertRowIndexToModel(rows[r]);
            }
            return rows;
        }

        void setRowSelection(int set) {
            this.getSelectionModel().setSelectionMode(set);
        }

        void setColSelection(int set) {
            this.getColumnModel().setColumnSelectionAllowed(set >= 0);
            if (set >= 0) {
                this.getColumnModel().getSelectionModel().setSelectionMode(set);
            }
        }

        int getRow(Property prop) {
            PropertyTableModel model = this.getPropertyTableModel();
            for (int i = 0; i < model.getNumRows(); ++i) {
                if (!model.getRowRoot(i).contains(prop)) continue;
                return i;
            }
            return -1;
        }

        Point getCell(Property property) {
            Point p = new Point(-1, -1);
            if (this.propertyModel == null) {
                return p;
            }
            TableModel model = this.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                int r = i;
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    if (model.getValueAt(r, j) != property) continue;
                    return new Point(j, r);
                }
            }
            return p;
        }

        Property getRowRoot(int index) {
            return this.propertyModel.getRowRoot(this.convertRowIndexToModel(index));
        }

        @Override
        public String exportCellValue(Object object, int row, int col) {
            if (object == null) {
                return "";
            }
            if (object instanceof Property) {
                Property property = (Property)object;
                if (this.propertyModel instanceof AbstractPropertyTableModel) {
                    return ((AbstractPropertyTableModel)this.propertyModel).getCellValue(property, row, col);
                }
                return AbstractPropertyTableModel.getDefaultCellValue(property, row, col);
            }
            return object.toString();
        }

        final void setPropertyTableModel(PropertyTableModel propertyModel, boolean reset) {
            Model model;
            this.propertyModel = propertyModel;
            if (propertyModel == null) {
                PropertyTableWidget.this.eraseAll();
                PropertyTableWidget.this.tableModels = null;
                System.gc();
                return;
            }
            if (PropertyTableWidget.this.tableModels == null) {
                PropertyTableWidget.this.tableModels = new HashMap();
            }
            if ((model = (Model)PropertyTableWidget.this.tableModels.get(propertyModel)) == null) {
                model = new Model(propertyModel);
                PropertyTableWidget.this.tableModels.put(propertyModel, model);
            }
            if (reset) {
                model.eraseCells();
                this.tableChanged(new TableModelEvent(model, -1));
            }
            this.setModel(model);
            System.gc();
        }

        PropertyTableModel getPropertyTableModel() {
            return this.propertyModel;
        }

        @Override
        public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
            List<? extends Property> before = this.getContext().getProperties();
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
            if (PropertyTableWidget.this.ignoreSelection) {
                return;
            }
            ArrayList<Property> properties = new ArrayList<Property>();
            ListSelectionModel rows = this.getSelectionModel();
            ListSelectionModel cols = this.getColumnModel().getSelectionModel();
            for (int r = rows.getMinSelectionIndex(); r <= rows.getMaxSelectionIndex(); ++r) {
                for (int c = cols.getMinSelectionIndex(); c <= cols.getMaxSelectionIndex(); ++c) {
                    if (!rows.isSelectedIndex(r) || !cols.isSelectedIndex(c)) continue;
                    TableModel model = this.getModel();
                    if (r < 0 || r >= model.getRowCount() || c < 0 || c >= model.getColumnCount()) continue;
                    Property prop = (Property)this.getValueAt(r, c);
                    if (prop == null) {
                        prop = this.propertyModel.getRowRoot(this.convertRowIndexToModel(r));
                    }
                    if (before.contains(prop)) {
                        properties.add(prop);
                        continue;
                    }
                    properties.add(0, prop);
                }
            }
            if (!properties.isEmpty()) {
                PropertyTableWidget.this.ignoreSelection = true;
                SelectionDispatcher.fireSelection(new Context(((Property)properties.get(0)).getGedcom(), new ArrayList(), properties));
                PropertyTableWidget.this.ignoreSelection = false;
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension d = super.getPreferredScrollableViewportSize();
            if (PropertyTableWidget.this.visibleRowCount > 0) {
                d.height = 0;
                for (int row = 0; row < PropertyTableWidget.this.visibleRowCount; ++row) {
                    if (row < this.getModel().getRowCount()) {
                        d.height += this.getRowHeight(row);
                        continue;
                    }
                    d.height += this.defaultRowHeight;
                }
            }
            return d;
        }

        private ViewContext getContext() {
            Gedcom ged = this.propertyModel.getGedcom();
            if (ged == null) {
                return null;
            }
            ArrayList<Property> properties = new ArrayList<Property>();
            int[] rows = super.getSelectedRows();
            if (rows.length > 0) {
                int[] cols = this.getSelectedColumns();
                for (int r = 0; r < rows.length; ++r) {
                    boolean rowRepresented = false;
                    for (int c = 0; c < cols.length; ++c) {
                        Property p = (Property)this.getValueAt(rows[r], cols[c]);
                        if (p == null) continue;
                        properties.add(p);
                        rowRepresented = true;
                    }
                    if (rowRepresented) continue;
                    properties.add(this.propertyModel.getRowRoot(this.convertRowIndexToModel(rows[r])));
                }
            }
            return new ViewContext(ged, (List<Entity>)new ArrayList<Entity>(), (List<Property>)properties);
        }

        private class Transferer
        extends TransferHandler {
            private Transferer() {
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                if (c != Table.this) {
                    return null;
                }
                int[] cols = PropertyTableWidget.this.table.getSelectedColumns();
                int[] rows = PropertyTableWidget.this.table.getSelectedRows();
                if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                    return null;
                }
                StringBuilder plainBuf = new StringBuilder();
                StringBuilder htmlBuf = new StringBuilder();
                htmlBuf.append("<html>\n<body>\n<table>\n");
                for (int row = 0; row < rows.length; ++row) {
                    htmlBuf.append("<tr>\n");
                    for (int col = 0; col < cols.length; ++col) {
                        Property obj = (Property)PropertyTableWidget.this.table.getValueAt(Table.this.convertRowIndexToView(rows[row]), cols[col]);
                        String val = AbstractPropertyTableModel.getDefaultCellValue(obj, row, col);
                        plainBuf.append(val).append("\t");
                        htmlBuf.append("  <td>").append(val).append("</td>\n");
                    }
                    plainBuf.deleteCharAt(plainBuf.length() - 1).append("\n");
                    htmlBuf.append("</tr>\n");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1);
                htmlBuf.append("</table>\n</body>\n</html>");
                return new BasicTransferable(plainBuf.toString(), htmlBuf.toString());
            }

            @Override
            public int getSourceActions(JComponent c) {
                return c == Table.this ? 1 : 0;
            }
        }

        private class Renderer
        extends HeadlessLabel
        implements TableCellRenderer {
            Renderer() {
                this.setPadding(2);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focs, int row, int col) {
                this.setFont(table.getFont());
                if (Table.this.getRowHeight() != this.getPreferredSize().height) {
                    Table.this.setRowHeight(this.getPreferredSize().height);
                }
                if (Table.this.propertyModel instanceof AbstractPropertyTableModel) {
                    AbstractPropertyTableModel m = (AbstractPropertyTableModel)Table.this.propertyModel;
                    this.setText(m.getCellValue((Property)value, row, col));
                    this.setHorizontalAlignment(m.getCellAlignment((Property)value, row, col));
                } else {
                    this.setText(AbstractPropertyTableModel.getDefaultCellValue((Property)value, row, col));
                    this.setHorizontalAlignment(AbstractPropertyTableModel.getDefaultCellAlignment((Property)value, row, col));
                }
                if (selected) {
                    this.setBackground(table.getSelectionBackground());
                    this.setForeground(table.getSelectionForeground());
                    this.setOpaque(true);
                } else {
                    this.setForeground(table.getForeground());
                    this.setOpaque(false);
                }
                return this;
            }
        }

        private class Model
        extends AbstractTableModel
        implements PropertyTableModelListener {
            private PropertyTableModel model;
            private Property[][] cells = null;

            private Model(PropertyTableModel set) {
                this.model = set;
            }

            public void eraseCells() {
                if (this.cells == null) {
                    return;
                }
                for (int r = 0; r < this.cells.length; ++r) {
                    for (int c = 0; c < this.cells[r].length; ++c) {
                        this.cells[r][c] = null;
                    }
                    this.cells[r] = null;
                }
                this.cells = null;
            }

            @Override
            public void handleRowsAdded(PropertyTableModel model, int rowStart, int rowEnd) {
                int rows = model.getNumRows();
                int cols = model.getNumCols();
                this.cells = new Property[rows][cols];
                this.fireTableRowsInserted(rowStart, rowEnd);
            }

            @Override
            public void handleRowsDeleted(PropertyTableModel model, int rowStart, int rowEnd) {
                int rows = model.getNumRows();
                int cols = model.getNumCols();
                this.cells = new Property[rows][cols];
                this.fireTableRowsDeleted(rowStart, rowEnd);
            }

            @Override
            public void handleRowsChanged(PropertyTableModel model, int rowStart, int rowEnd, int col) {
                if (this.cells == null) {
                    return;
                }
                for (int i = rowStart; i <= rowEnd; ++i) {
                    this.cells[i][col] = null;
                }
                this.fireTableChanged(new TableModelEvent(this, rowStart, rowEnd, col));
            }

            @Override
            public void addTableModelListener(TableModelListener l) {
                super.addTableModelListener(l);
                if (this.model != null && ((TableModelListener[])this.getListeners(TableModelListener.class)).length == 1) {
                    this.model.addListener(this);
                }
            }

            @Override
            public void removeTableModelListener(TableModelListener l) {
                super.removeTableModelListener(l);
                if (this.model != null && ((TableModelListener[])this.getListeners(TableModelListener.class)).length == 0) {
                    this.model.removeListener(this);
                }
            }

            @Override
            public String getColumnName(int col) {
                return this.model != null ? this.model.getColName(col) : "";
            }

            @Override
            public int getColumnCount() {
                return this.model != null ? this.model.getNumCols() : 0;
            }

            @Override
            public int getRowCount() {
                return this.model != null ? this.model.getNumRows() : 0;
            }

            private Property getPropertyAt(int row, int col) {
                Property prop;
                if (this.cells == null) {
                    this.cells = new Property[this.model.getNumRows()][this.model.getNumCols()];
                }
                if ((prop = this.cells[row][col]) == null) {
                    this.cells[row][col] = prop = this.model.getRowRoot(row).getProperty(this.model.getColPath(col));
                }
                return prop;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return this.getPropertyAt(row, col);
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return Property.class;
            }
        }
    }
}

