/*
 * Decompiled with CFR 0.152.
 */
package genj.common;

import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.TagPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PathTreeWidget
extends JScrollPane {
    private List<Listener> listeners = new ArrayList<Listener>();
    private Grammar grammar = Grammar.V55;
    private JTree tree;
    private Model model = new Model();

    public PathTreeWidget() {
        Callback callback = new Callback();
        this.tree = new JTree(this.model);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new Renderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(callback);
        this.tree.addTreeWillExpandListener(callback);
        this.setMinimumSize(new Dimension(160, 160));
        this.setPreferredSize(new Dimension(160, 160));
        this.getViewport().setView(this.tree);
    }

    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void fireSelectionChanged(TagPath path, boolean on) {
        Listener[] ls = this.listeners.toArray(new Listener[this.listeners.size()]);
        for (int l = 0; l < ls.length; ++l) {
            ls[l].handleSelection(path, on);
        }
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setPaths(TagPath[] paths, TagPath[] selection) {
        Object[] treepath;
        this.model.setPaths(paths, selection);
        for (TagPath path : paths) {
            treepath = new Object[]{this.model, new TagPath(path.get(0))};
            this.tree.expandPath(new TreePath(treepath));
        }
        for (TagPath path : selection) {
            treepath = new Object[path.length()];
            treepath[0] = this.model;
            for (int i = 1; i < path.length(); ++i) {
                treepath[i] = new TagPath(path, i);
            }
            this.tree.expandPath(new TreePath(treepath));
        }
    }

    public void setSelected(TagPath path, boolean set) {
        this.model.setSelected(path, set);
    }

    public TagPath[] getSelection() {
        return this.model.getSelection().toArray(new TagPath[0]);
    }

    private class Callback
    extends MouseAdapter
    implements TreeWillExpandListener {
        private Callback() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            TreePath path = PathTreeWidget.this.tree.getPathForLocation(me.getX(), me.getY());
            if (path == null) {
                return;
            }
            PathTreeWidget.this.model.toggleSelection((TagPath)path.getLastPathComponent());
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            if (event.getPath().getPathCount() < 3) {
                throw new ExpandVetoException(event);
            }
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        }
    }

    public static interface Listener {
        public void handleSelection(TagPath var1, boolean var2);
    }

    private class Model
    implements TreeModel {
        private TreeSet<TagPath> paths = new TreeSet();
        private Set<TagPath> selection = new HashSet<TagPath>();
        private Map<TagPath, TagPath[]> path2childen = new HashMap<TagPath, TagPath[]>();
        private List<TreeModelListener> tmlisteners = new CopyOnWriteArrayList<TreeModelListener>();

        private Model() {
        }

        public void setPaths(TagPath[] ps, TagPath[] ss) {
            this.selection = new HashSet<TagPath>(Arrays.asList(ss));
            this.paths = new TreeSet();
            this.paths.addAll(Arrays.asList(ps));
            this.paths.addAll(Arrays.asList(ss));
            TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this});
            for (TreeModelListener listener : this.tmlisteners) {
                listener.treeStructureChanged(e);
            }
        }

        private void setSelected(TagPath path, boolean set) {
            if (!this.paths.contains(path)) {
                throw new IllegalArgumentException("path not a choice");
            }
            if (set) {
                this.selection.add(path);
            } else {
                this.selection.remove(path);
            }
            TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{this});
            for (TreeModelListener listener : this.tmlisteners) {
                listener.treeNodesChanged(e);
            }
            PathTreeWidget.this.fireSelectionChanged(path, set);
        }

        private void toggleSelection(TagPath path) {
            if (this.selection.contains(path)) {
                this.setSelected(path, false);
            } else {
                this.setSelected(path, true);
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.tmlisteners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.tmlisteners.remove(l);
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.getChildren(parent)[index];
        }

        @Override
        public int getChildCount(Object parent) {
            return this.getChildren(parent).length;
        }

        private TagPath[] getChildren(Object node) {
            TagPath[] result = this.path2childen.get(node);
            if (result == null) {
                result = node == this ? this.getChildrenOfRoot() : this.getChildrenOfNode((TagPath)node);
            }
            return result;
        }

        private TagPath[] getChildrenOfNode(TagPath path) {
            ArrayList<TagPath> children = new ArrayList<TagPath>(8);
            for (TagPath p : this.paths) {
                if (p.length() <= path.length() || !p.startsWith(path)) continue;
                this.add(new TagPath(p, path.length() + 1), children);
            }
            for (TagPath sel : this.selection) {
                if (sel.length() <= path.length() || !sel.startsWith(path)) continue;
                this.add(new TagPath(sel, path.length() + 1), children);
            }
            return TagPath.toArray(children);
        }

        private TagPath[] getChildrenOfRoot() {
            ArrayList<TagPath> children = new ArrayList<TagPath>(8);
            for (TagPath path : this.paths) {
                this.add(new TagPath(path, 1), children);
            }
            for (TagPath path : this.selection) {
                this.add(new TagPath(path, 1), children);
            }
            return TagPath.toArray(children);
        }

        private void add(TagPath path, List<TagPath> list) {
            if (!list.contains(path)) {
                list.add(path);
            }
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return 0;
        }

        @Override
        public Object getRoot() {
            return this;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getChildren(node).length == 0;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public Collection<TagPath> getSelection() {
            return this.selection;
        }
    }

    private class Renderer
    extends DefaultTreeCellRenderer {
        private JPanel panel = new JPanel();
        private JCheckBox checkbox = new JCheckBox();

        private Renderer() {
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.checkbox, "West");
            this.panel.add((Component)this, "Center");
            this.checkbox.setOpaque(false);
            this.panel.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof TagPath) {
                TagPath path = (TagPath)value;
                this.setText(Gedcom.getName(path.getLast()) + " (" + path.getLast() + ")");
                this.setIcon(PathTreeWidget.this.grammar.getMeta(path).getImage());
                this.checkbox.setSelected(PathTreeWidget.this.model.getSelection().contains(value));
                this.panel.invalidate();
            }
            return this.panel;
        }
    }
}

