/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.MediaWrapper;
import ancestris.modules.editors.standard.tools.Utils;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyXRef;
import genj.util.Registry;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class MediaChooser
extends JPanel {
    private static int THUMB_WIDTH = 50;
    private static int THUMB_HEIGHT = 70;
    private static Map<String, ImageIcon> cacheIcon = new HashMap<String, ImageIcon>();
    private Registry registry = null;
    private ThumbComparator thumbComparator = new ThumbComparator();
    private TreeSet<MediaThumb> allMedia = new TreeSet<MediaThumb>(this.thumbComparator);
    private DefaultListModel filteredModel = new DefaultListModel();
    private Gedcom gedcom = null;
    private File mainFile = null;
    private MediaWrapper mainMedia = null;
    private Image mainImage = null;
    private Image scaledImage = null;
    private String mainTitle = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel filterLabel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPaneMedia;
    private JSplitPane jSplitPane;
    private JLabel labelPhoto;
    private JList mediaList;
    private JLabel photoTitle;
    private JTextField textFilter;

    public MediaChooser(Gedcom gedcom, File file, Image image, String title, MediaWrapper media, JButton okButton, JButton cancelButton, boolean sourceImages) {
        this.gedcom = gedcom;
        this.mainFile = file;
        this.mainMedia = media;
        this.mainImage = image;
        this.mainTitle = title;
        this.okButton = okButton;
        this.cancelButton = cancelButton;
        this.createMediaThumbs(sourceImages);
        Thread mediaThread = new Thread(){

            public void run() {
                MediaChooser.this.displayMediaThumbs();
                MediaChooser.this.selectMedia(MediaChooser.this.mainMedia);
            }
        };
        mediaThread.setName("Media reading thread");
        mediaThread.start();
        this.registry = Registry.get(this.getClass());
        this.initComponents();
        this.setPreferredSize(new Dimension(this.registry.get("mediaWindowWidth", this.getPreferredSize().width), this.registry.get("mediaWindowHeight", this.getPreferredSize().height)));
        this.jSplitPane.setDividerLocation(this.registry.get("mediaSplitDividerLocation", this.jSplitPane.getDividerLocation()));
        this.labelPhoto.setText("");
        this.displayIconAndTitle();
        this.mediaList.setCellRenderer(new ListEntryCellRenderer());
        okButton.setEnabled(false);
        this.textFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            public void changedUpdate(DocumentEvent e) {
            }

            private void filter() {
                MediaChooser.this.filterModel(MediaChooser.this.textFilter.getText());
            }
        });
    }

    private void selectMedia(MediaWrapper media) {
        MediaThumb selectedMedia = null;
        for (MediaThumb mediai : this.allMedia) {
            if (mediai.entity == null && media == null) {
                selectedMedia = mediai;
                break;
            }
            if (mediai.entity == null || media == null || !mediai.entity.equals(media.getTargetMedia())) continue;
            selectedMedia = mediai;
            break;
        }
        if (selectedMedia != null) {
            final MediaThumb mediai = selectedMedia;
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                public void run() {
                    MediaChooser.this.mediaList.setSelectedValue(mediai, true);
                    MediaChooser.this.mediaList.scrollRectToVisible(MediaChooser.this.mediaList.getCellBounds(MediaChooser.this.mediaList.getMinSelectionIndex(), MediaChooser.this.mediaList.getMaxSelectionIndex()));
                }
            });
        }
    }

    private void displayIconAndTitle() {
        this.displayIconAndTitle(this.labelPhoto.getPreferredSize().width, this.labelPhoto.getPreferredSize().height);
    }

    private void displayIconAndTitle(int width, int height) {
        if (this.mainImage != null) {
            double targetRatio = (double)width / (double)height;
            double imageRatio = (double)this.mainImage.getWidth(null) / (double)this.mainImage.getHeight(null);
            this.scaledImage = targetRatio < imageRatio ? this.mainImage.getScaledInstance(width, -1, 1) : this.mainImage.getScaledInstance(-1, height, 1);
        }
        this.labelPhoto.repaint();
        this.photoTitle.setText("<html><center>" + this.mainTitle + "</center></html>");
        this.photoTitle.setPreferredSize(new Dimension(width, -1));
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.labelPhoto = new JLabel(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (MediaChooser.this.scaledImage != null) {
                    ((Graphics2D)g).drawImage(MediaChooser.this.scaledImage, 0 + (this.getWidth() - MediaChooser.this.scaledImage.getWidth(this)) / 2, (this.getHeight() - MediaChooser.this.scaledImage.getHeight(this)) / 2, null);
                }
            }
        };
        this.photoTitle = new JLabel();
        this.jPanel2 = new JPanel();
        this.filterLabel = new JLabel();
        this.textFilter = new JTextField();
        this.jScrollPaneMedia = new JScrollPane();
        this.mediaList = new JList(this.filteredModel);
        this.jLabel1 = new JLabel();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                MediaChooser.this.formComponentResized(evt);
            }
        });
        this.jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MediaChooser.this.jSplitPanePropertyChange(evt);
            }
        });
        this.jPanel1.setPreferredSize(new Dimension(200, 383));
        this.labelPhoto.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.labelPhoto, (String)NbBundle.getMessage(MediaChooser.class, (String)"MediaChooser.labelPhoto.text"));
        this.labelPhoto.setToolTipText(NbBundle.getMessage(MediaChooser.class, (String)"MediaChooser.labelPhoto.toolTipText"));
        this.labelPhoto.setBorder(BorderFactory.createEtchedBorder());
        this.labelPhoto.setPreferredSize(new Dimension(232, 352));
        this.labelPhoto.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MediaChooser.this.labelPhotoMouseClicked(evt);
            }
        });
        this.labelPhoto.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                MediaChooser.this.labelPhotoComponentResized(evt);
            }
        });
        this.photoTitle.setFont(new Font("DejaVu Sans", 1, 12));
        this.photoTitle.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.photoTitle, (String)NbBundle.getMessage(MediaChooser.class, (String)"MediaChooser.photoTitle.text"));
        this.photoTitle.setVerticalAlignment(1);
        this.photoTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelPhoto, -2, 0, Short.MAX_VALUE).addComponent(this.photoTitle, -1, 188, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.labelPhoto, -1, 356, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.photoTitle)));
        this.jSplitPane.setLeftComponent(this.jPanel1);
        this.jPanel2.setPreferredSize(new Dimension(200, 58));
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getMessage(MediaChooser.class, (String)"MediaChooser.filterLabel.text"));
        this.textFilter.setText(NbBundle.getMessage(MediaChooser.class, (String)"MediaChooser.textFilter.text"));
        this.mediaList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.mediaList.setFont(new Font("DejaVu Sans Condensed", 0, 10));
        this.mediaList.setSelectionMode(0);
        this.mediaList.setLayoutOrientation(2);
        this.mediaList.setVisibleRowCount(-1);
        this.mediaList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MediaChooser.this.mediaListMouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                MediaChooser.this.mediaListMousePressed(evt);
            }
        });
        this.mediaList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MediaChooser.this.mediaListValueChanged(evt);
            }
        });
        this.jScrollPaneMedia.setViewportView(this.mediaList);
        this.jLabel1.setFont(new Font("DejaVu Sans", 0, 10));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MediaChooser.class, (String)"MediaChooser.jLabel1.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneMedia).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFilter, -1, 106, Short.MAX_VALUE)))).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterLabel).addComponent(this.textFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneMedia, -1, 331, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel1)));
        this.jSplitPane.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING));
    }

    private void mediaListValueChanged(ListSelectionEvent evt) {
        if (!this.mediaList.isSelectionEmpty()) {
            MediaThumb media = (MediaThumb)this.filteredModel.get(this.mediaList.getSelectedIndex());
            this.mainImage = media.getImage();
            this.mainTitle = media.title;
            this.mainFile = media.file;
            this.displayIconAndTitle(this.labelPhoto.getWidth(), this.labelPhoto.getHeight());
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    private void labelPhotoComponentResized(ComponentEvent evt) {
        this.displayIconAndTitle(this.labelPhoto.getWidth(), this.labelPhoto.getHeight());
    }

    private void mediaListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.okButton.doClick();
        }
    }

    private void labelPhotoMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && this.mainFile != null) {
            try {
                Desktop.getDesktop().open(this.mainFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        int h;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = evt.getComponent().getWidth();
        if (w > dim.width * 8 / 10) {
            w = dim.width * 8 / 10;
        }
        if ((h = evt.getComponent().getHeight()) > dim.height * 8 / 10) {
            h = dim.height * 8 / 10;
        }
        this.registry.put("mediaWindowWidth", w);
        this.registry.put("mediaWindowHeight", h);
    }

    private void jSplitPanePropertyChange(PropertyChangeEvent evt) {
        this.registry.put("mediaSplitDividerLocation", this.jSplitPane.getDividerLocation());
    }

    private void mediaListMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.mediaList.setSelectedIndex(this.mediaList.locationToIndex(evt.getPoint()));
            JPopupMenu menu = new JPopupMenu();
            MediaThumb media = this.getSelectedThumb();
            final Entity entity = media.entity;
            Entity[] ents = PropertyXRef.getReferences((Entity)media.entity);
            if (media.isMedia && ents.length > 0) {
                for (Entity ent : ents) {
                    JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)"EditEntity", (Object)ent.toString(true)));
                    menu.add(menuItem);
                    final Entity finalEntity = ent;
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            MediaChooser.this.edit(finalEntity);
                        }
                    });
                }
            } else if (!media.isMedia) {
                JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)"EditEntity", (Object)entity.toString(true)));
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        MediaChooser.this.edit(entity);
                    }
                });
            }
            menu.show(this.mediaList, evt.getX(), evt.getY());
        }
    }

    private void edit(Entity entity) {
        this.cancelButton.doClick();
        SelectionDispatcher.fireSelection((Context)new Context(entity));
    }

    private void createMediaThumbs(boolean sourceImages) {
        String[] ENTITIES;
        this.allMedia.clear();
        for (String type : ENTITIES = new String[]{"INDI", "FAM", "SOUR", "SUBM"}) {
            Collection entities = this.gedcom.getEntities(type);
            for (Entity entity : entities) {
                List properties = entity.getProperties(PropertyFile.class);
                for (PropertyFile mediaFile : properties) {
                    boolean isSourceMedia = this.isSourceOnly((Property)mediaFile);
                    if ((!isSourceMedia || !sourceImages) && (isSourceMedia || sourceImages)) continue;
                    String title = "";
                    File file = mediaFile.getFile();
                    Property mediaTitle = mediaFile.getParent().getProperty("TITL");
                    boolean flag = false;
                    if (mediaTitle != null && !mediaTitle.getDisplayValue().trim().isEmpty()) {
                        title = mediaTitle.getDisplayValue().trim();
                        flag = true;
                    } else {
                        title = entity.toString(false).trim();
                        flag = false;
                    }
                    MediaThumb media = new MediaThumb(entity, file, title);
                    media.setTrueTitle(flag);
                    this.allMedia.add(media);
                }
            }
        }
        if (this.gedcom.getGrammar().equals(Grammar.V551)) {
            Collection entities = this.gedcom.getEntities("OBJE");
            for (Media entity : entities) {
                Entity[] ents;
                boolean isSourceMedia = this.isSourceOnly(entity);
                if ((!isSourceMedia || !sourceImages) && (isSourceMedia || sourceImages)) continue;
                File file = null;
                String title = "";
                Property mediaFile = entity.getProperty("FILE", true);
                boolean flag = false;
                if (mediaFile != null && mediaFile instanceof PropertyFile) {
                    file = ((PropertyFile)mediaFile).getFile();
                    Property mediaTitle = mediaFile.getProperty("TITL");
                    if (mediaTitle != null && !mediaTitle.getDisplayValue().trim().isEmpty()) {
                        title = mediaTitle.getDisplayValue().trim();
                        flag = true;
                    } else {
                        ents = PropertyXRef.getReferences((Entity)entity);
                        if (ents.length > 0) {
                            title = ents[0].toString(false).trim();
                            flag = false;
                        } else {
                            title = entity.toString(false).trim();
                            flag = false;
                        }
                    }
                }
                MediaThumb media = new MediaThumb(entity, file, title);
                media.setTrueTitle(flag);
                ents = PropertyXRef.getReferences((Entity)entity);
                media.setUnused(ents.length == 0);
                this.allMedia.add(media);
            }
        }
    }

    private void displayMediaThumbs() {
        this.filteredModel.clear();
        for (MediaThumb item : this.allMedia) {
            item.setIcon();
            this.filteredModel.addElement(item);
        }
    }

    private MediaThumb getSelectedThumb() {
        return (MediaThumb)this.filteredModel.get(this.mediaList.getSelectedIndex());
    }

    public boolean isSelectedEntityMedia() {
        MediaThumb media = this.getSelectedThumb();
        return media == null ? false : media.isMedia;
    }

    public Entity getSelectedEntity() {
        MediaThumb media = this.getSelectedThumb();
        return media == null ? null : media.entity;
    }

    public File getSelectedFile() {
        MediaThumb media = this.getSelectedThumb();
        return media == null ? null : media.file;
    }

    public String getSelectedTitle() {
        MediaThumb media = this.getSelectedThumb();
        return media == null ? "" : media.title;
    }

    public void filterModel(String filter) {
        this.mediaList.clearSelection();
        this.mediaList.setModel(new DefaultListModel());
        this.filteredModel.clear();
        for (MediaThumb item : this.allMedia) {
            if (!item.title.toLowerCase().contains(filter.toLowerCase())) continue;
            this.filteredModel.addElement(item);
        }
        this.mediaList.setModel(this.filteredModel);
    }

    private boolean isSourceOnly(Property property) {
        return Utils.parentTagsContains(property, "SOUR");
    }

    private boolean isSourceOnly(Media entity) {
        boolean ret = false;
        List references = entity.getProperties(PropertyXRef.class);
        for (PropertyXRef refProp : references) {
            if (Utils.parentTagsContains((Property)refProp, "SOUR")) {
                ret = true;
                continue;
            }
            return false;
        }
        return ret;
    }

    public int getNbMedia() {
        return this.allMedia.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThumbComparator
    implements Comparator<MediaThumb> {
        private ThumbComparator() {
        }

        @Override
        public int compare(MediaThumb o1, MediaThumb o2) {
            File file1 = o1.file;
            File file2 = o2.file;
            String str1 = file1 != null ? file1.getAbsolutePath() : "";
            String str2 = file2 != null ? file2.getAbsolutePath() : "";
            String id1 = o1.entity.getId();
            String id2 = o2.entity.getId();
            String total1 = o1.title.toLowerCase() + str1 + id1;
            String total2 = o2.title.toLowerCase() + str2 + id2;
            return total1.compareTo(total2);
        }
    }

    private class MediaThumb {
        public boolean isMedia = false;
        public Entity entity = null;
        public File file = null;
        public ImageIcon icon = null;
        public String title = "";
        public boolean isTrueTitle = true;
        public boolean isUnused = false;

        public MediaThumb(Media entity, File file, String title) {
            this.isMedia = true;
            this.entity = entity;
            this.file = file;
            this.title = title;
        }

        private MediaThumb(Entity entity, File file, String title) {
            this.isMedia = entity instanceof Media;
            this.entity = entity;
            this.file = file;
            this.title = title;
        }

        public Image getImage() {
            return Utils.getImageFromFile(this.file, this.getClass());
        }

        public void setIcon() {
            ImageIcon imageIcon = this.icon = this.file == null ? null : (ImageIcon)cacheIcon.get(this.file.getAbsolutePath());
            if (this.icon == null) {
                this.icon = new ImageIcon(Utils.scaleImage(this.file, this.getClass(), THUMB_WIDTH, THUMB_HEIGHT));
                if (this.file != null) {
                    cacheIcon.put(this.file.getAbsolutePath(), this.icon);
                }
            }
        }

        private void setTrueTitle(boolean flag) {
            this.isTrueTitle = flag;
        }

        private void setUnused(boolean b) {
            this.isUnused = b;
        }
    }

    private static class ListEntryCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private ListEntryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MediaThumb entry = (MediaThumb)value;
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(1);
            int labelWidth = THUMB_WIDTH + 30;
            int nbLines = this.getFontMetrics(this.getFont()).stringWidth(entry.title) / labelWidth + 3;
            int labelHeight = THUMB_HEIGHT + 12 * nbLines;
            this.setPreferredSize(new Dimension(labelWidth, labelHeight));
            String color = entry.isTrueTitle && !entry.isUnused ? "black" : (!entry.isTrueTitle && !entry.isUnused ? "blue" : "red");
            this.setText("<html><center><font color=" + color + ">" + entry.title + "</font></center></html>");
            this.setIcon(entry.icon);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                this.setBorder(BorderFactory.createRaisedBevelBorder());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

