/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.AssoWithTableModel;
import ancestris.modules.editors.standard.tools.AssoWrapper;
import ancestris.modules.editors.standard.tools.EventWrapper;
import ancestris.util.swing.DialogManager;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertySex;
import genj.util.ReferenceSet;
import genj.util.Registry;
import genj.util.WordBuffer;
import genj.util.swing.ImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssoManager
extends JPanel
implements TableModelListener {
    private Registry registry = null;
    private boolean hasChanged = false;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private boolean isValid = true;
    private boolean isBusy = false;
    private Gedcom gedcom = null;
    private Indi indi = null;
    private List<EventWrapper> eventSet = null;
    private List<AssoWrapper> assoWithSet = null;
    private AssoWithTableModel awtm = null;
    private int rowHeight = 18;
    private Indi inditobecreated = null;
    private Entity[] arrayIndis = null;
    private JComboBox comboBoxIndis = null;
    private JTextField comboIndiFilter = null;
    private String oldEnteredIndiText = "";
    private String[] arrayRelas = null;
    private JComboBox comboBoxRelas = null;
    private JTextField comboRelaFilter = null;
    private String oldEnteredRelaText = "";
    private String[] arrayOccus = null;
    private JComboBox comboBoxOccus = null;
    private JTextField comboOccuFilter = null;
    private String oldEnteredOccuText = "";
    private DefaultListModel assoOfSet = null;
    private JPanel AssoOfIndiPanel;
    private JButton addLineButton;
    private JScrollPane assoListScrollPane;
    private JLabel assoOfIndoTitle;
    private JList assoOfList;
    private JScrollPane assoOfScrollPane;
    private JSplitPane assoSplitPanel;
    private JPanel assoWithIndiPanel;
    private JLabel assoWithIndiTitle;
    private JTable assoWithTable;
    private JButton removeLineButton;

    public AssoManager(Indi indi, List<EventWrapper> list, List<AssoWrapper> assoSet, AssoWrapper selectedAsso, JButton okButton, JButton cancelButton) {
        this.eventSet = list;
        this.indi = indi;
        this.gedcom = indi.getGedcom();
        this.okButton = okButton;
        this.cancelButton = cancelButton;
        this.registry = Registry.get(this.getClass());
        this.inditobecreated = new Indi("INDI", NbBundle.getMessage(this.getClass(), (String)"AssoManager.inditobecreated"));
        this.assoWithSet = this.clone(assoSet);
        this.assoOfSet = this.getAssociationOf(indi);
        this.initComponents();
        this.setPreferredSize(new Dimension(this.registry.get("assoWindowWidth", this.getPreferredSize().width), this.registry.get("assoWindowHeight", this.getPreferredSize().height)));
        this.assoSplitPanel.setDividerLocation(this.registry.get("assoSplitDividerLocation", this.assoSplitPanel.getDividerLocation()));
        this.assoWithIndiTitle.setText(NbBundle.getMessage(this.getClass(), (String)"AssoManager.assoWithIndiTitle.text", (Object)this.getIndi()));
        this.assoOfIndoTitle.setText(NbBundle.getMessage(this.getClass(), (String)"AssoManager.assoOfIndoTitle.text", (Object)this.getIndi()));
        this.awtm = new AssoWithTableModel(this.assoWithSet);
        this.assoWithTable.setModel(this.awtm);
        this.assoWithTable.setAutoCreateRowSorter(true);
        EventWrapper[] arrayEvents = this.eventSet.toArray(new EventWrapper[this.eventSet.size()]);
        Arrays.sort(arrayEvents, new Comparator(){

            public int compare(Object e1, Object e2) {
                String s1 = ((EventWrapper)e1).eventLabel.getLongLabel().toLowerCase();
                String s2 = ((EventWrapper)e2).eventLabel.getLongLabel().toLowerCase();
                return s1.compareTo(s2);
            }
        });
        JComboBox<EventWrapper> comboBoxEvents = new JComboBox<EventWrapper>(arrayEvents);
        comboBoxEvents.setRenderer(new ComboBoxEventsRenderer());
        comboBoxEvents.setMaximumRowCount(10);
        this.assoWithTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(comboBoxEvents));
        this.assoWithTable.getColumnModel().getColumn(0).setCellRenderer(new EventCellRenderer());
        ReferenceSet relaRefSet = this.gedcom.getReferenceSet("RELA");
        List relaKeys = relaRefSet.getKeys();
        this.arrayRelas = relaKeys.toArray(new String[relaKeys.size()]);
        Arrays.sort(this.arrayRelas);
        this.comboBoxRelas = new JComboBox<String>(new DefaultComboBoxModel<String>(this.arrayRelas));
        this.comboBoxRelas.setMaximumRowCount(20);
        this.assoWithTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.comboBoxRelas));
        this.assoWithTable.getColumnModel().getColumn(1).setCellRenderer(new OtherCellRenderer());
        this.comboBoxRelas.setEditable(true);
        this.comboRelaFilter = (JTextField)this.comboBoxRelas.getEditor().getEditorComponent();
        this.comboRelaFilter.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (AssoManager.this.comboRelaFilter.getSelectedText() == null && !AssoManager.this.oldEnteredRelaText.equals(AssoManager.this.comboRelaFilter.getText())) {
                            AssoManager.this.oldEnteredRelaText = AssoManager.this.comboRelaFilter.getText();
                            AssoManager.this.filterComboRela(AssoManager.this.oldEnteredRelaText);
                        }
                    }
                });
            }
        });
        this.arrayIndis = this.gedcom.getEntities("INDI", "INDI:NAME");
        this.comboBoxIndis = new JComboBox<Entity>(this.arrayIndis);
        this.comboBoxIndis.setMaximumRowCount(20);
        this.assoWithTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.comboBoxIndis));
        this.assoWithTable.getColumnModel().getColumn(2).setCellRenderer(new OtherCellRenderer());
        this.comboBoxIndis.setEditable(true);
        this.comboIndiFilter = (JTextField)this.comboBoxIndis.getEditor().getEditorComponent();
        this.comboIndiFilter.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (AssoManager.this.comboIndiFilter.getSelectedText() == null && !AssoManager.this.oldEnteredIndiText.equals(AssoManager.this.comboIndiFilter.getText())) {
                            AssoManager.this.oldEnteredIndiText = AssoManager.this.comboIndiFilter.getText();
                            AssoManager.this.filterComboIndi(AssoManager.this.oldEnteredIndiText);
                        }
                    }
                });
            }
        });
        this.assoWithTable.getColumnModel().getColumn(3).setCellRenderer(new OtherCellRenderer());
        this.assoWithTable.getColumnModel().getColumn(4).setCellRenderer(new OtherCellRenderer());
        ImageIcon[] arraySexs = new ImageIcon[]{PropertySex.getImage((int)1), PropertySex.getImage((int)2), PropertySex.getImage((int)0)};
        JComboBox<ImageIcon> comboBoxSexs = new JComboBox<ImageIcon>(arraySexs);
        comboBoxSexs.setRenderer(new ComboBoxSexsRenderer());
        comboBoxSexs.setMaximumRowCount(3);
        this.assoWithTable.getColumnModel().getColumn(5).setCellEditor(new DefaultCellEditor(comboBoxSexs));
        ReferenceSet occuRefSet = this.gedcom.getReferenceSet("OCCU");
        List occuKeys = occuRefSet.getKeys();
        this.arrayOccus = occuKeys.toArray(new String[occuKeys.size()]);
        Arrays.sort(this.arrayOccus);
        this.comboBoxOccus = new JComboBox<String>(new DefaultComboBoxModel<String>(this.arrayOccus));
        this.comboBoxOccus.setMaximumRowCount(20);
        this.assoWithTable.getColumnModel().getColumn(6).setCellEditor(new DefaultCellEditor(this.comboBoxOccus));
        this.comboBoxOccus.setEditable(true);
        this.comboOccuFilter = (JTextField)this.comboBoxOccus.getEditor().getEditorComponent();
        this.comboOccuFilter.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (AssoManager.this.comboOccuFilter.getSelectedText() == null && !AssoManager.this.oldEnteredOccuText.equals(AssoManager.this.comboOccuFilter.getText())) {
                            AssoManager.this.oldEnteredOccuText = AssoManager.this.comboOccuFilter.getText();
                            AssoManager.this.filterComboOccu(AssoManager.this.oldEnteredOccuText);
                        }
                    }
                });
            }
        });
        this.resizeColumns();
        this.rowHeight = this.comboBoxOccus.getPreferredSize().height;
        this.assoWithTable.setRowHeight(this.rowHeight);
        this.resizeTable();
        int row = 0;
        boolean selected = false;
        for (AssoWrapper asso : assoSet) {
            if (asso == selectedAsso) {
                this.assoWithTable.setRowSelectionInterval(row, row);
                selected = true;
            }
            ++row;
        }
        if (!selected && this.assoWithTable.getRowCount() != 0) {
            this.assoWithTable.setRowSelectionInterval(0, 0);
        }
        this.updateOK();
        this.awtm.addTableModelListener(this);
    }

    private void resizeTable() {
        Dimension preferredSize = this.assoWithTable.getPreferredSize();
        preferredSize.height = this.rowHeight * this.awtm.getRowCount() + 1;
        this.assoWithTable.setPreferredSize(preferredSize);
        this.assoWithTable.revalidate();
        this.assoWithTable.repaint();
    }

    private void resizeColumns() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        for (int i = 0; i < this.assoWithTable.getColumnCount(); ++i) {
            this.assoWithTable.getColumnModel().getColumn(i).setPreferredWidth(this.awtm.getMaxWidth(fm, i));
        }
    }

    private void initComponents() {
        this.assoSplitPanel = new JSplitPane();
        this.assoWithIndiPanel = new JPanel();
        this.assoWithIndiTitle = new JLabel();
        this.assoListScrollPane = new JScrollPane();
        this.assoWithTable = new JTable();
        this.addLineButton = new JButton();
        this.removeLineButton = new JButton();
        this.AssoOfIndiPanel = new JPanel();
        this.assoOfIndoTitle = new JLabel();
        this.assoOfScrollPane = new JScrollPane();
        this.assoOfList = new JList();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                AssoManager.this.formComponentResized(evt);
            }
        });
        this.assoSplitPanel.setDividerLocation(275);
        this.assoSplitPanel.setOrientation(0);
        this.assoSplitPanel.setResizeWeight(0.5);
        this.assoSplitPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AssoManager.this.assoSplitPanelPropertyChange(evt);
            }
        });
        this.assoWithIndiPanel.setPreferredSize(new Dimension(468, 273));
        this.assoWithIndiTitle.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.assoWithIndiTitle, (String)NbBundle.getMessage(AssoManager.class, (String)"AssoManager.assoWithIndiTitle.text"));
        this.assoWithTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.assoWithTable.setToolTipText(NbBundle.getMessage(AssoManager.class, (String)"AssoManager.assoWithTable.toolTipText"));
        this.assoWithTable.setPreferredSize(new Dimension(300, 10));
        this.assoWithTable.setSelectionMode(0);
        this.assoWithTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AssoManager.this.assoWithTableMousePressed(evt);
            }
        });
        this.assoListScrollPane.setViewportView(this.assoWithTable);
        this.addLineButton.setIcon(new javax.swing.ImageIcon(this.getClass().getResource("/ancestris/modules/editors/standard/images/add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.addLineButton, (String)NbBundle.getMessage(AssoManager.class, (String)"AssoManager.addLineButton.text"));
        this.addLineButton.setToolTipText(NbBundle.getMessage(AssoManager.class, (String)"AssoManager.addLineButton.toolTipText"));
        this.addLineButton.setPreferredSize(new Dimension(24, 24));
        this.addLineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AssoManager.this.addLineButtonActionPerformed(evt);
            }
        });
        this.removeLineButton.setIcon(new javax.swing.ImageIcon(this.getClass().getResource("/ancestris/modules/editors/standard/images/remove.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.removeLineButton, (String)NbBundle.getMessage(AssoManager.class, (String)"AssoManager.removeLineButton.text"));
        this.removeLineButton.setToolTipText(NbBundle.getMessage(AssoManager.class, (String)"AssoManager.removeLineButton.toolTipText"));
        this.removeLineButton.setPreferredSize(new Dimension(24, 24));
        this.removeLineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AssoManager.this.removeLineButtonActionPerformed(evt);
            }
        });
        GroupLayout assoWithIndiPanelLayout = new GroupLayout(this.assoWithIndiPanel);
        this.assoWithIndiPanel.setLayout(assoWithIndiPanelLayout);
        assoWithIndiPanelLayout.setHorizontalGroup(assoWithIndiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(assoWithIndiPanelLayout.createSequentialGroup().addContainerGap().addGroup(assoWithIndiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, assoWithIndiPanelLayout.createSequentialGroup().addComponent(this.assoWithIndiTitle, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.addLineButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeLineButton, -2, -1, -2)).addComponent(this.assoListScrollPane)).addContainerGap()));
        assoWithIndiPanelLayout.setVerticalGroup(assoWithIndiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(assoWithIndiPanelLayout.createSequentialGroup().addContainerGap().addGroup(assoWithIndiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(assoWithIndiPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeLineButton, -2, -1, -2).addComponent(this.addLineButton, -2, -1, -2)).addComponent(this.assoWithIndiTitle, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assoListScrollPane, -1, 232, Short.MAX_VALUE).addContainerGap()));
        this.assoSplitPanel.setTopComponent(this.assoWithIndiPanel);
        this.AssoOfIndiPanel.setPreferredSize(new Dimension(268, 160));
        this.assoOfIndoTitle.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.assoOfIndoTitle, (String)NbBundle.getMessage(AssoManager.class, (String)"AssoManager.assoOfIndoTitle.text"));
        this.assoOfList.setModel(this.assoOfSet);
        this.assoOfList.setSelectionMode(0);
        this.assoOfList.setToolTipText(NbBundle.getMessage(AssoManager.class, (String)"AssoManager.assoOfList.toolTipText"));
        this.assoOfList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AssoManager.this.assoOfListMousePressed(evt);
            }
        });
        this.assoOfScrollPane.setViewportView(this.assoOfList);
        this.assoOfList.setCellRenderer(new ListRenderer());
        GroupLayout AssoOfIndiPanelLayout = new GroupLayout(this.AssoOfIndiPanel);
        this.AssoOfIndiPanel.setLayout(AssoOfIndiPanelLayout);
        AssoOfIndiPanelLayout.setHorizontalGroup(AssoOfIndiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, AssoOfIndiPanelLayout.createSequentialGroup().addContainerGap().addGroup(AssoOfIndiPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.assoOfScrollPane).addComponent(this.assoOfIndoTitle, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        AssoOfIndiPanelLayout.setVerticalGroup(AssoOfIndiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(AssoOfIndiPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.assoOfIndoTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assoOfScrollPane, -1, 145, Short.MAX_VALUE).addContainerGap()));
        this.assoSplitPanel.setRightComponent(this.AssoOfIndiPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.assoSplitPanel));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.assoSplitPanel, -1, 464, Short.MAX_VALUE));
    }

    private void formComponentResized(ComponentEvent evt) {
        int h;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = evt.getComponent().getWidth();
        if (w > dim.width * 8 / 10) {
            w = dim.width * 8 / 10;
        }
        if ((h = evt.getComponent().getHeight()) > dim.height * 8 / 10) {
            h = dim.height * 8 / 10;
        }
        this.registry.put("assoWindowWidth", w);
        this.registry.put("assoWindowHeight", h);
    }

    private void assoSplitPanelPropertyChange(PropertyChangeEvent evt) {
        this.registry.put("assoSplitDividerLocation", this.assoSplitPanel.getDividerLocation());
    }

    private void addLineButtonActionPerformed(ActionEvent evt) {
        int index = this.assoWithTable.getSelectedRow();
        int row = this.assoWithTable.getRowSorter().convertRowIndexToModel(index);
        this.awtm.addRow(row);
        index = this.assoWithTable.getRowCount() > 1 ? this.assoWithTable.getRowSorter().convertRowIndexToView(row + 1) : 0;
        this.assoWithTable.setRowSelectionInterval(index, index);
        this.resizeTable();
        this.assoListScrollPane.repaint();
        this.hasChanged = true;
        this.resizeColumns();
        this.updateOK();
    }

    private void removeLineButtonActionPerformed(ActionEvent evt) {
        int index = this.assoWithTable.getSelectedRow();
        int row = this.assoWithTable.getRowSorter().convertRowIndexToModel(index);
        this.awtm.removeRow(row);
        if (--index < 0) {
            if (this.assoWithTable.getRowCount() == 0) {
                this.awtm.addRow(index);
            }
            index = 0;
        }
        this.assoWithTable.setRowSelectionInterval(index, index);
        this.resizeTable();
        this.assoListScrollPane.repaint();
        this.hasChanged = true;
        this.resizeColumns();
        this.updateOK();
    }

    private void assoWithTableMousePressed(MouseEvent evt) {
        Indi ent;
        int row;
        AssoWrapper asso;
        if (evt.getButton() == 3 && (asso = this.assoWithSet.get(row = this.assoWithTable.rowAtPoint(evt.getPoint()))) != null && (ent = asso.assoIndi) != null) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)(this.hasChanged ? "AssoManager.SaveFirst" : "AssoManager.ShowEntity"), (Object)ent.toString(true)));
            menu.add(menuItem);
            if (!this.hasChanged) {
                menuItem.addActionListener(new ActionListener((Entity)ent){
                    final /* synthetic */ Entity val$ent;
                    {
                        this.val$ent = entity;
                    }

                    public void actionPerformed(ActionEvent ae) {
                        AssoManager.this.cancelButton.doClick();
                        SelectionDispatcher.fireSelection((Context)new Context(this.val$ent));
                    }
                });
            }
            menu.show(this.assoWithTable, evt.getX(), evt.getY());
        }
    }

    private void assoOfListMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3) {
            int index = this.assoOfList.locationToIndex(evt.getPoint());
            AssoWrapper asso = (AssoWrapper)this.assoOfList.getModel().getElementAt(index);
            if (asso != null) {
                Property targetProperty;
                Property property = targetProperty = asso.targetEvent != null ? asso.targetEvent.eventProperty : null;
                if (targetProperty == null) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(this.getClass(), (String)(this.hasChanged ? "AssoManager.SaveFirst" : "AssoManager.ShowEntity"), (Object)targetProperty.getEntity().toString(true)));
                menu.add(menuItem);
                if (!this.hasChanged) {
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            AssoManager.this.cancelButton.doClick();
                            SelectionDispatcher.fireSelection((Context)new Context(targetProperty));
                        }
                    });
                }
                menu.show(this.assoOfList, evt.getX(), evt.getY());
            }
        }
    }

    private DefaultListModel getAssociationOf(Indi indi) {
        DefaultListModel<AssoWrapper> ret = new DefaultListModel<AssoWrapper>();
        List assoList = indi.getProperties(PropertyAssociation.class);
        for (PropertyAssociation assoProp : assoList) {
            ret.addElement(new AssoWrapper(assoProp));
        }
        return ret;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (row >= 0 && row < this.awtm.getRowCount() && column >= 0 && column < this.awtm.getColumnCount()) {
            Object data = this.awtm.getValueAt(row, column);
            if (data != null && !this.isBusy) {
                if (column == 2 && data instanceof Indi) {
                    this.isBusy = true;
                    this.awtm.setIndiValues((Indi)data, row);
                    this.isBusy = false;
                }
                if (column >= 3 && column <= 6) {
                    Indi changedIndi;
                    this.isBusy = true;
                    Object data2 = this.awtm.getValueAt(row, 2);
                    if (this.awtm.isChanged(data, row, column) && data2 instanceof Indi && (changedIndi = (Indi)data2) != null && changedIndi != this.inditobecreated && DialogManager.YES_OPTION == DialogManager.createYesNo((String)NbBundle.getMessage(this.getClass(), (String)"TITL_AssoChangeIndi"), (String)NbBundle.getMessage(this.getClass(), (String)"MSG_AssoChangedIndi", (Object)this.awtm.getColumnName(column), (Object)changedIndi)).setMessageType(3).show()) {
                        this.awtm.setValueAt(this.inditobecreated, row, 2);
                    }
                    this.isBusy = false;
                }
                if (column == 1 && ((DefaultComboBoxModel)this.comboBoxRelas.getModel()).getIndexOf((String)data) == -1) {
                    this.comboBoxRelas.addItem(data);
                }
                if (column == 6 && ((DefaultComboBoxModel)this.comboBoxOccus.getModel()).getIndexOf((String)data) == -1) {
                    this.comboBoxOccus.addItem(data);
                }
            }
            this.awtm.updateList(data, row, column);
            this.updateOK();
            this.hasChanged = true;
        }
    }

    private void updateOK() {
        this.isValid = true;
        for (AssoWrapper asso : this.assoWithSet) {
            if (asso.targetEvent == null || asso.assoTxt.trim().isEmpty()) {
                this.isValid = false;
                break;
            }
            if (asso.assoIndi != null || !asso.assoLastname.trim().isEmpty() && !asso.assoFirstname.trim().isEmpty()) continue;
            this.isValid = false;
            break;
        }
        this.okButton.setEnabled(this.isValid);
    }

    public String getIndi() {
        return this.indi.toString();
    }

    public List<AssoWrapper> getSet() {
        return this.awtm.getSet();
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public List<AssoWrapper> clone(List<AssoWrapper> assoSet) {
        ArrayList<AssoWrapper> ret = new ArrayList<AssoWrapper>();
        for (AssoWrapper asso : assoSet) {
            ret.add(AssoWrapper.clone(asso));
        }
        return ret;
    }

    public boolean contains(AssoWrapper element) {
        for (AssoWrapper asso : this.assoWithSet) {
            if (!asso.equals(element)) continue;
            return true;
        }
        return false;
    }

    private void filterComboRela(String enteredText) {
        ArrayList<String> filterArray = new ArrayList<String>();
        for (String arrayRela : this.arrayRelas) {
            if (!arrayRela.toLowerCase().contains(enteredText.toLowerCase())) continue;
            filterArray.add(arrayRela);
        }
        if (filterArray.isEmpty()) {
            filterArray.add(enteredText);
        }
        this.comboBoxRelas.setModel(new DefaultComboBoxModel<Object>(filterArray.toArray()));
        this.comboRelaFilter.setText(enteredText);
        this.comboRelaFilter.setCaretPosition(enteredText.length());
        if (!this.comboBoxRelas.isPopupVisible()) {
            this.comboBoxRelas.showPopup();
        }
    }

    private void filterComboIndi(String enteredText) {
        ArrayList<Entity> filterArray = new ArrayList<Entity>();
        for (Entity arrayIndi : this.arrayIndis) {
            if (!arrayIndi.toString().toLowerCase().contains(enteredText.toLowerCase())) continue;
            filterArray.add(arrayIndi);
        }
        if (filterArray.size() > 0) {
            this.comboBoxIndis.setModel(new DefaultComboBoxModel<Object>(filterArray.toArray()));
            this.comboIndiFilter.setText(enteredText);
            this.comboIndiFilter.setCaretPosition(enteredText.length());
        }
        if (!this.comboBoxIndis.isPopupVisible()) {
            this.comboBoxIndis.showPopup();
        }
    }

    private void filterComboOccu(String enteredText) {
        ArrayList<String> filterArray = new ArrayList<String>();
        for (String arrayOccu : this.arrayOccus) {
            if (!arrayOccu.toLowerCase().contains(enteredText.toLowerCase())) continue;
            filterArray.add(arrayOccu);
        }
        if (filterArray.isEmpty()) {
            filterArray.add(enteredText);
        }
        this.comboBoxOccus.setModel(new DefaultComboBoxModel<Object>(filterArray.toArray()));
        this.comboOccuFilter.setText(enteredText);
        this.comboOccuFilter.setCaretPosition(enteredText.length());
        if (!this.comboBoxOccus.isPopupVisible()) {
            this.comboBoxOccus.showPopup();
        }
    }

    private class ListRenderer
    extends JLabel
    implements ListCellRenderer {
        private Color backSelectedColor = null;
        private Color foreSelectedColor = null;

        public ListRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Color c = new JList().getSelectionBackground();
            this.backSelectedColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
            c = new JList().getSelectionForeground();
            this.foreSelectedColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                AssoWrapper asso = (AssoWrapper)value;
                this.setHorizontalAlignment(2);
                this.setVerticalAlignment(0);
                this.setIcon((Icon)asso.assoProp.getImage());
                WordBuffer sb = new WordBuffer(" ");
                sb.append(asso.assoTxt + ", ");
                sb.append(NbBundle.getMessage(this.getClass(), (String)"AssoManager.label_event"));
                sb.append(asso.targetEvent.eventLabel.getLongLabel() + ", ");
                sb.append(NbBundle.getMessage(this.getClass(), (String)"AssoManager.label_of"));
                sb.append((Object)asso.targetEvent.eventProperty.getEntity());
                this.setText(sb.toString());
                if (isSelected) {
                    this.setBackground(this.backSelectedColor);
                    this.setForeground(this.foreSelectedColor);
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                this.setOpaque(true);
            }
            return this;
        }
    }

    private class ComboBoxSexsRenderer
    extends JLabel
    implements ListCellRenderer {
        private Color backSelectedColor = null;
        private Color foreSelectedColor = null;

        public ComboBoxSexsRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Color c = new JList().getSelectionBackground();
            this.backSelectedColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
            c = new JList().getSelectionForeground();
            this.foreSelectedColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                ImageIcon icon = (ImageIcon)value;
                if (isSelected) {
                    this.setBackground(this.backSelectedColor);
                    this.setForeground(this.foreSelectedColor);
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setHorizontalAlignment(2);
                this.setIcon((Icon)icon);
                this.setText(icon == PropertySex.getImage((int)1) ? PropertySex.TXT_MALE : (icon == PropertySex.getImage((int)2) ? PropertySex.TXT_FEMALE : PropertySex.TXT_UNKNOWN));
            }
            return this;
        }
    }

    private class ComboBoxEventsRenderer
    extends JLabel
    implements ListCellRenderer {
        private Color backSelectedColor = null;
        private Color foreSelectedColor = null;

        public ComboBoxEventsRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Color c = new JList().getSelectionBackground();
            this.backSelectedColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
            c = new JList().getSelectionForeground();
            this.foreSelectedColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                EventWrapper event = (EventWrapper)value;
                if (isSelected) {
                    this.setBackground(this.backSelectedColor);
                    this.setForeground(this.foreSelectedColor);
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setIcon(event.eventLabel.getIcon());
                this.setText(event.eventLabel.getLongLabel());
            }
            return this;
        }
    }

    private class OtherCellRenderer
    extends DefaultTableCellRenderer {
        private OtherCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object o;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int cRow = AssoManager.this.assoWithTable.getRowSorter().convertRowIndexToModel(row);
            if (column == 0 && value == null) {
                this.setBorder(BorderFactory.createLineBorder(Color.red));
            }
            if (column == 1) {
                this.updateEmptyBorder(value);
            }
            if (column == 2 && (o = AssoManager.this.awtm.getValueAt(cRow, 2)) == null) {
                this.updateIndiBorder(cRow);
            }
            if ((column == 3 || column == 4) && (o = AssoManager.this.awtm.getValueAt(cRow, 2)) == null) {
                this.updateEmptyBorder(value);
            }
            return this;
        }

        private void updateEmptyBorder(Object value) {
            String str = (String)value;
            if (str == null) {
                str = "";
            }
            if (str.trim().isEmpty()) {
                this.setBorder(BorderFactory.createLineBorder(Color.red));
            }
        }

        private void updateIndiBorder(int row) {
            String ln = (String)AssoManager.this.awtm.getValueAt(row, 3);
            String fn = (String)AssoManager.this.awtm.getValueAt(row, 4);
            if (ln.trim().isEmpty() && fn.trim().isEmpty()) {
                this.setBorder(BorderFactory.createLineBorder(Color.red));
            }
        }
    }

    private class EventCellRenderer
    extends DefaultTableCellRenderer {
        private EventCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value != null) {
                EventWrapper event = (EventWrapper)value;
                this.setIcon(event.eventLabel.getIcon());
                this.setText(event.eventLabel.getLongLabel());
            } else {
                this.setBorder(BorderFactory.createLineBorder(Color.red));
            }
            return this;
        }
    }
}

