/*
 * Decompiled with CFR 0.152.
 */
package modules.editors.gedcomproperties.utils;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.util.ReferenceSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import modules.editors.gedcomproperties.utils.PlaceFormatConverterPanel;
import org.openide.util.NbBundle;

public class GedcomPlacesConverter {
    private final String PLACETAG = "PLAC";
    private final Gedcom gedcom;
    private final int fromFormatLength;
    private final String[] toPlaceFormat;
    private final String[] map;
    private int nbOfDifferentFoundPlaces = 0;
    private int nbOfDifferentChangedPlaces = 0;
    private int nbOfFoundPlaces = 0;
    private int nbOfChangedPlaces = 0;
    private Exception error = null;
    private final List<String> listOfIncorrectPlaces = new ArrayList<String>();
    private final List<Property> listOfProperty = new ArrayList<Property>();

    public GedcomPlacesConverter(Gedcom gedcom, String fromFormat, String toFormat, String conversionMap) {
        this.gedcom = gedcom;
        this.fromFormatLength = PropertyPlace.getFormat((String)fromFormat).length;
        this.toPlaceFormat = PropertyPlace.getFormat((String)toFormat);
        this.map = PropertyPlace.getFormat((String)conversionMap);
    }

    public boolean convert() {
        String[] newPlace = new String[this.toPlaceFormat.length];
        ReferenceSet allUniquePlaces = this.gedcom.getReferenceSet("PLAC");
        this.nbOfFoundPlaces = allUniquePlaces.getSize();
        this.nbOfDifferentFoundPlaces = allUniquePlaces.getKeys().size();
        for (String key : allUniquePlaces.getKeys()) {
            String[] currentJurisdictions = PropertyPlace.getFormat((String)key);
            if (currentJurisdictions.length != this.fromFormatLength) {
                this.listOfIncorrectPlaces.add(key);
                continue;
            }
            for (int i = 0; i < newPlace.length; ++i) {
                if (!this.map[i].isEmpty()) {
                    int j = Integer.valueOf(this.map[i]);
                    if (j < 0 || j > currentJurisdictions.length - 1) {
                        newPlace[i] = key;
                        continue;
                    }
                    newPlace[i] = currentJurisdictions[j];
                    continue;
                }
                newPlace[i] = "";
            }
            try {
                Set placeProperties = allUniquePlaces.getReferences((Object)key);
                Property[] places = placeProperties.toArray(new Property[placeProperties.size()]);
                for (int i = 0; i < places.length; ++i) {
                    Property place = places[i];
                    if (this.listOfProperty.contains(place)) continue;
                    this.listOfProperty.add(place);
                    place.setValue(this.getDisplayOfPlace(newPlace));
                    ++this.nbOfChangedPlaces;
                }
                ++this.nbOfDifferentChangedPlaces;
            }
            catch (Exception e) {
                String msg = new Exception(e).getLocalizedMessage();
                this.error = new Exception(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"ERR_Exception") + " " + msg + "!");
                return false;
            }
        }
        if (this.nbOfChangedPlaces < this.nbOfFoundPlaces) {
            this.error = new Exception(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"ERR_WrongFormat"));
            return false;
        }
        return true;
    }

    public boolean isWithError() {
        return this.error != null;
    }

    public String[] getIncorrectPlaces() {
        if (this.listOfIncorrectPlaces == null) {
            return null;
        }
        Collections.sort(this.listOfIncorrectPlaces, null);
        return this.listOfIncorrectPlaces.toArray(new String[this.listOfIncorrectPlaces.size()]);
    }

    private String getDisplayOfPlace(String[] newPlace) {
        String ret = "";
        String sep = ",";
        for (int i = 0; i < newPlace.length; ++i) {
            if (i == newPlace.length - 1) {
                sep = "";
            }
            ret = ret + newPlace[i] + sep;
        }
        return ret;
    }

    public int getNbOfDifferentFoundPlaces() {
        return this.nbOfDifferentFoundPlaces;
    }

    public int getNbOfDifferentChangedPlaces() {
        return this.nbOfDifferentChangedPlaces;
    }

    public int getNbOfFoundPlaces() {
        return this.nbOfFoundPlaces;
    }

    public int getNbOfChangedPlaces() {
        return this.nbOfChangedPlaces;
    }

    public Exception getError() {
        if (this.error == null) {
            this.error = new Exception(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"ERR_Unknown"));
        }
        return this.error;
    }
}

