; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zfh -verify-machineinstrs < %s \
; RUN:   -target-abi=ilp32f | FileCheck -check-prefixes=CHECKIZFH,RV32IZFH %s
; RUN: llc -mtriple=riscv64 -mattr=+zfh -verify-machineinstrs < %s \
; RUN:   -target-abi=lp64f | FileCheck -check-prefixes=CHECKIZFH,RV64IZFH %s

define signext i8 @test_floor_si8(half %x) {
; RV32IZFH-LABEL: test_floor_si8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_si8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptosi half %a to i8
  ret i8 %b
}

define signext i16 @test_floor_si16(half %x) {
; RV32IZFH-LABEL: test_floor_si16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_si16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptosi half %a to i16
  ret i16 %b
}

define signext i32 @test_floor_si32(half %x) {
; CHECKIZFH-LABEL: test_floor_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rdn
; CHECKIZFH-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptosi half %a to i32
  ret i32 %b
}

define i64 @test_floor_si64(half %x) {
; RV32IZFH-LABEL: test_floor_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call floorf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    call __fixhfdi@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptosi half %a to i64
  ret i64 %b
}

define zeroext i8 @test_floor_ui8(half %x) {
; RV32IZFH-LABEL: test_floor_ui8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rdn
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_ui8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptoui half %a to i8
  ret i8 %b
}

define zeroext i16 @test_floor_ui16(half %x) {
; RV32IZFH-LABEL: test_floor_ui16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rdn
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_ui16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptoui half %a to i16
  ret i16 %b
}

define signext i32 @test_floor_ui32(half %x) {
; CHECKIZFH-LABEL: test_floor_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rdn
; CHECKIZFH-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptoui half %a to i32
  ret i32 %b
}

define i64 @test_floor_ui64(half %x) {
; RV32IZFH-LABEL: test_floor_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call floorf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    call __fixunshfdi@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rdn
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  %b = fptoui half %a to i64
  ret i64 %b
}

define signext i8 @test_ceil_si8(half %x) {
; RV32IZFH-LABEL: test_ceil_si8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rup
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_si8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptosi half %a to i8
  ret i8 %b
}

define signext i16 @test_ceil_si16(half %x) {
; RV32IZFH-LABEL: test_ceil_si16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rup
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_si16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptosi half %a to i16
  ret i16 %b
}

define signext i32 @test_ceil_si32(half %x) {
; CHECKIZFH-LABEL: test_ceil_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rup
; CHECKIZFH-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptosi half %a to i32
  ret i32 %b
}

define i64 @test_ceil_si64(half %x) {
; RV32IZFH-LABEL: test_ceil_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call ceilf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    call __fixhfdi@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptosi half %a to i64
  ret i64 %b
}

define zeroext i8 @test_ceil_ui8(half %x) {
; RV32IZFH-LABEL: test_ceil_ui8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rup
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_ui8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptoui half %a to i8
  ret i8 %b
}

define zeroext i16 @test_ceil_ui16(half %x) {
; RV32IZFH-LABEL: test_ceil_ui16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rup
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_ui16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptoui half %a to i16
  ret i16 %b
}

define signext i32 @test_ceil_ui32(half %x) {
; CHECKIZFH-LABEL: test_ceil_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rup
; CHECKIZFH-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptoui half %a to i32
  ret i32 %b
}

define i64 @test_ceil_ui64(half %x) {
; RV32IZFH-LABEL: test_ceil_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call ceilf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    call __fixunshfdi@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rup
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  %b = fptoui half %a to i64
  ret i64 %b
}

define signext i8 @test_trunc_si8(half %x) {
; RV32IZFH-LABEL: test_trunc_si8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_si8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptosi half %a to i8
  ret i8 %b
}

define signext i16 @test_trunc_si16(half %x) {
; RV32IZFH-LABEL: test_trunc_si16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_si16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptosi half %a to i16
  ret i16 %b
}

define signext i32 @test_trunc_si32(half %x) {
; CHECKIZFH-LABEL: test_trunc_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; CHECKIZFH-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptosi half %a to i32
  ret i32 %b
}

define i64 @test_trunc_si64(half %x) {
; RV32IZFH-LABEL: test_trunc_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call truncf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    call __fixhfdi@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptosi half %a to i64
  ret i64 %b
}

define zeroext i8 @test_trunc_ui8(half %x) {
; RV32IZFH-LABEL: test_trunc_ui8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_ui8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptoui half %a to i8
  ret i8 %b
}

define zeroext i16 @test_trunc_ui16(half %x) {
; RV32IZFH-LABEL: test_trunc_ui16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_ui16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptoui half %a to i16
  ret i16 %b
}

define signext i32 @test_trunc_ui32(half %x) {
; CHECKIZFH-LABEL: test_trunc_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; CHECKIZFH-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptoui half %a to i32
  ret i32 %b
}

define i64 @test_trunc_ui64(half %x) {
; RV32IZFH-LABEL: test_trunc_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call truncf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    call __fixunshfdi@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  %b = fptoui half %a to i64
  ret i64 %b
}

define signext i8 @test_round_si8(half %x) {
; RV32IZFH-LABEL: test_round_si8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_si8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptosi half %a to i8
  ret i8 %b
}

define signext i16 @test_round_si16(half %x) {
; RV32IZFH-LABEL: test_round_si16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_si16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptosi half %a to i16
  ret i16 %b
}

define signext i32 @test_round_si32(half %x) {
; CHECKIZFH-LABEL: test_round_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rmm
; CHECKIZFH-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptosi half %a to i32
  ret i32 %b
}

define i64 @test_round_si64(half %x) {
; RV32IZFH-LABEL: test_round_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call roundf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    call __fixhfdi@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptosi half %a to i64
  ret i64 %b
}

define zeroext i8 @test_round_ui8(half %x) {
; RV32IZFH-LABEL: test_round_ui8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rmm
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_ui8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptoui half %a to i8
  ret i8 %b
}

define zeroext i16 @test_round_ui16(half %x) {
; RV32IZFH-LABEL: test_round_ui16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rmm
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_ui16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptoui half %a to i16
  ret i16 %b
}

define signext i32 @test_round_ui32(half %x) {
; CHECKIZFH-LABEL: test_round_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rmm
; CHECKIZFH-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptoui half %a to i32
  ret i32 %b
}

define i64 @test_round_ui64(half %x) {
; RV32IZFH-LABEL: test_round_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call roundf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    call __fixunshfdi@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rmm
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  %b = fptoui half %a to i64
  ret i64 %b
}

define signext i8 @test_roundeven_si8(half %x) {
; RV32IZFH-LABEL: test_roundeven_si8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rne
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_si8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptosi half %a to i8
  ret i8 %b
}

define signext i16 @test_roundeven_si16(half %x) {
; RV32IZFH-LABEL: test_roundeven_si16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rne
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_si16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptosi half %a to i16
  ret i16 %b
}

define signext i32 @test_roundeven_si32(half %x) {
; CHECKIZFH-LABEL: test_roundeven_si32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rne
; CHECKIZFH-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptosi half %a to i32
  ret i32 %b
}

define i64 @test_roundeven_si64(half %x) {
; RV32IZFH-LABEL: test_roundeven_si64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call roundevenf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    call __fixhfdi@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_si64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptosi half %a to i64
  ret i64 %b
}

define zeroext i8 @test_roundeven_ui8(half %x) {
; RV32IZFH-LABEL: test_roundeven_ui8:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rne
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_ui8:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptoui half %a to i8
  ret i8 %b
}

define zeroext i16 @test_roundeven_ui16(half %x) {
; RV32IZFH-LABEL: test_roundeven_ui16:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.wu.h a0, fa0, rne
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_ui16:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptoui half %a to i16
  ret i16 %b
}

define signext i32 @test_roundeven_ui32(half %x) {
; CHECKIZFH-LABEL: test_roundeven_ui32:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rne
; CHECKIZFH-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptoui half %a to i32
  ret i32 %b
}

define i64 @test_roundeven_ui64(half %x) {
; RV32IZFH-LABEL: test_roundeven_ui64:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call roundevenf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    call __fixunshfdi@plt
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_ui64:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rne
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  %b = fptoui half %a to i64
  ret i64 %b
}

define half @test_floor_half(half %x) {
; RV32IFD-LABEL: test_floor_half:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call floor@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_floor_half:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    .cfi_def_cfa_offset 16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    .cfi_offset ra, -8
; RV64IFD-NEXT:    call floor@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; RV32IZFH-LABEL: test_floor_half:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call floorf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_floor_half:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    .cfi_offset ra, -8
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call floorf@plt
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.floor.f16(half %x)
  ret half %a
}

define half @test_ceil_half(half %x) {
; RV32IFD-LABEL: test_ceil_half:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call ceil@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_ceil_half:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    .cfi_def_cfa_offset 16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    .cfi_offset ra, -8
; RV64IFD-NEXT:    call ceil@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; RV32IZFH-LABEL: test_ceil_half:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call ceilf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_ceil_half:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    .cfi_offset ra, -8
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call ceilf@plt
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.ceil.f16(half %x)
  ret half %a
}

define half @test_trunc_half(half %x) {
; RV32IFD-LABEL: test_trunc_half:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call trunc@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_trunc_half:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    .cfi_def_cfa_offset 16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    .cfi_offset ra, -8
; RV64IFD-NEXT:    call trunc@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; RV32IZFH-LABEL: test_trunc_half:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call truncf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_trunc_half:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    .cfi_offset ra, -8
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call truncf@plt
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.trunc.f16(half %x)
  ret half %a
}

define half @test_round_half(half %x) {
; RV32IFD-LABEL: test_round_half:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call round@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_round_half:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    .cfi_def_cfa_offset 16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    .cfi_offset ra, -8
; RV64IFD-NEXT:    call round@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; RV32IZFH-LABEL: test_round_half:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call roundf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_round_half:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    .cfi_offset ra, -8
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call roundf@plt
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.round.f16(half %x)
  ret half %a
}

define half @test_roundeven_half(half %x) {
; RV32IFD-LABEL: test_roundeven_half:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    .cfi_def_cfa_offset 16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    .cfi_offset ra, -4
; RV32IFD-NEXT:    call roundeven@plt
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: test_roundeven_half:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    .cfi_def_cfa_offset 16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    .cfi_offset ra, -8
; RV64IFD-NEXT:    call roundeven@plt
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
; RV32IZFH-LABEL: test_roundeven_half:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    .cfi_offset ra, -4
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call roundevenf@plt
; RV32IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: test_roundeven_half:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    .cfi_def_cfa_offset 16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    .cfi_offset ra, -8
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call roundevenf@plt
; RV64IZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
  %a = call half @llvm.roundeven.f16(half %x)
  ret half %a
}

declare half @llvm.floor.f16(half)
declare half @llvm.ceil.f16(half)
declare half @llvm.trunc.f16(half)
declare half @llvm.round.f16(half)
declare half @llvm.roundeven.f16(half)
