// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +v -disable-O0-optnone -emit-llvm %s -o - \
// RUN:     | opt -S -O2 | FileCheck  %s

#include <riscv_vector.h>

// CHECK-LABEL: @vwrite_csr_vstart(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void asm sideeffect "csrw\09vstart, ${0:z}", "rJ,~{memory}"(i64 [[VALUE:%.*]]) #[[ATTR1:[0-9]+]], !srcloc !4
// CHECK-NEXT:    ret void
//
void vwrite_csr_vstart(unsigned long value) {
  vwrite_csr(RVV_VSTART, value);
}

// CHECK-LABEL: @vwrite_csr_vxsat(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void asm sideeffect "csrw\09vxsat, ${0:z}", "rJ,~{memory}"(i64 [[VALUE:%.*]]) #[[ATTR1]], !srcloc !5
// CHECK-NEXT:    ret void
//
void vwrite_csr_vxsat(unsigned long value) {
  vwrite_csr(RVV_VXSAT, value);
}

// CHECK-LABEL: @vwrite_csr_vxrm(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void asm sideeffect "csrw\09vxrm, ${0:z}", "rJ,~{memory}"(i64 [[VALUE:%.*]]) #[[ATTR1]], !srcloc !6
// CHECK-NEXT:    ret void
//
void vwrite_csr_vxrm(unsigned long value) {
  vwrite_csr(RVV_VXRM, value);
}

// CHECK-LABEL: @vwrite_csr_vcsr(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    tail call void asm sideeffect "csrw\09vcsr, ${0:z}", "rJ,~{memory}"(i64 [[VALUE:%.*]]) #[[ATTR1]], !srcloc !7
// CHECK-NEXT:    ret void
//
void vwrite_csr_vcsr(unsigned long value) {
  vwrite_csr(RVV_VCSR, value);
}
