// RUN: %clang_cc1 %s -triple spir-unknown-unknown -cl-std=clc++ -pedantic -verify -fsyntax-only

void foo(global int *gl, const global int *gl_const, global int &gl_ref) {
  //FIXME: Diagnostics can be improved to be more specific in some cases.
  float *gen_fl = addrspace_cast<float *>(gl); //expected-error{{addrspace_cast from '__global int *__private' to '__generic float *' is not allowed}}

  int i = addrspace_cast<int>(gl); //expected-error{{addrspace_cast from '__global int *__private' to 'int' is not allowed}}

  int *gen = addrspace_cast<int *>(*gl); //expected-error{{addrspace_cast from '__global int' to '__generic int *' is not allowed}}

  local int *loc = addrspace_cast<local int *>(gl); //expected-error{{addrspace_cast from '__global int *__private' to '__local int *' converts between mismatching address spaces}}

  int *gen2 = addrspace_cast<int *>(gl_const); //expected-error{{addrspace_cast from 'const __global int *__private' to '__generic int *' is not allowed}}

  //FIXME: Do we expect this behavior? This will get cast successfully as reinterpret_cast.
  int &gen_ref = addrspace_cast<int &>(gl_ref); //expected-error{{addrspace_cast from '__global int' to '__generic int &' is not allowed}}

  __private int *priv = addrspace_cast<__private int *>(&i);
}

template <class T>
void test_temp(__global int *par) {
  T *var1 = addrspace_cast<T *>(par); //expected-error{{addrspace_cast from '__global int *__private' to '__private int *' converts between mismatching address spaces}}
  __private T *var2 = addrspace_cast<__private T *>(par); //expected-error{{addrspace_cast from '__global int *__private' to '__private int *' converts between mismatching address spaces}}
  T var3 = addrspace_cast<T>(par); //expected-error{{addrspace_cast from '__global int *__private' to '__private int' is not allowed}}
}

void bar() {
  __global int* var;
  test_temp<__private int>(var); //expected-note{{in instantiation of function template specialization 'test_temp<__private int>' requested here}}
}
// We don't give any errors on non-instantiated template as types are not concrete yet.
template <class T>
void test_temp1(__global int *par) {
  T *var1 = addrspace_cast<T *>(par);
  __private T *var2 = addrspace_cast<__private T *>(par);
  T var3 = addrspace_cast<T>(par);
}

