; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=mips -O0 -mcpu=mips32r2 -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MIPS
; RUN: llc -march=mips -O0 -mcpu=mips32r6 -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MIPSR6
; RUN: llc -march=mips -O0 -mcpu=mips32r2 -mattr=+micromips -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MM
; RUN: llc -march=mips -O0 -mcpu=mips32r6 -mattr=+micromips -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MMR6
; RUN: llc -march=mipsel -O0 -mcpu=mips32r2 -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MIPSEL
; RUN: llc -march=mipsel -O0 -mcpu=mips32r6 -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MIPSELR6
; RUN: llc -march=mipsel -O0 -mcpu=mips32r2 -mattr=+micromips -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MMEL
; RUN: llc -march=mipsel -O0 -mcpu=mips32r6 -mattr=+micromips -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MMELR6
; RUN: llc -march=mips64 -O0 -mcpu=mips64r2 -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MIPS64
; RUN: llc -march=mips64 -O0 -mcpu=mips64r6 -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MIPS64R6
; RUN: llc -march=mips64el -O0 -mcpu=mips64r2 -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MIPS64EL
; RUN: llc -march=mips64el -O0 -mcpu=mips64r6 -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=MIPS64ELR6

define i32 @test_max_32(i32* nocapture %ptr, i32 signext %val) {
; MIPS-LABEL: test_max_32:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:  $BB0_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $2, 0($4)
; MIPS-NEXT:    slt $3, $2, $5
; MIPS-NEXT:    move $1, $2
; MIPS-NEXT:    movn $1, $5, $3
; MIPS-NEXT:    sc $1, 0($4)
; MIPS-NEXT:    beqz $1, $BB0_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_max_32:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:  $BB0_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $2, 0($4)
; MIPSR6-NEXT:    slt $3, $2, $5
; MIPSR6-NEXT:    seleqz $1, $2, $3
; MIPSR6-NEXT:    selnez $3, $5, $3
; MIPSR6-NEXT:    or $1, $1, $3
; MIPSR6-NEXT:    sc $1, 0($4)
; MIPSR6-NEXT:    beqzc $1, $BB0_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_max_32:
; MM:       # %bb.0: # %entry
; MM-NEXT:    sync
; MM-NEXT:  $BB0_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $2, 0($4)
; MM-NEXT:    slt $3, $2, $5
; MM-NEXT:    or $1, $2, $zero
; MM-NEXT:    movn $1, $5, $3
; MM-NEXT:    sc $1, 0($4)
; MM-NEXT:    beqzc $1, $BB0_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    sync
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_max_32:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:  $BB0_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $2, 0($4)
; MMR6-NEXT:    slt $3, $2, $5
; MMR6-NEXT:    seleqz $1, $2, $3
; MMR6-NEXT:    selnez $3, $5, $3
; MMR6-NEXT:    or $1, $1, $3
; MMR6-NEXT:    sc $1, 0($4)
; MMR6-NEXT:    beqc $1, $zero, $BB0_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_max_32:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:  $BB0_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $2, 0($4)
; MIPSEL-NEXT:    slt $3, $2, $5
; MIPSEL-NEXT:    move $1, $2
; MIPSEL-NEXT:    movn $1, $5, $3
; MIPSEL-NEXT:    sc $1, 0($4)
; MIPSEL-NEXT:    beqz $1, $BB0_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_max_32:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:  $BB0_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $2, 0($4)
; MIPSELR6-NEXT:    slt $3, $2, $5
; MIPSELR6-NEXT:    seleqz $1, $2, $3
; MIPSELR6-NEXT:    selnez $3, $5, $3
; MIPSELR6-NEXT:    or $1, $1, $3
; MIPSELR6-NEXT:    sc $1, 0($4)
; MIPSELR6-NEXT:    beqzc $1, $BB0_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_max_32:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:  $BB0_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $2, 0($4)
; MMEL-NEXT:    slt $3, $2, $5
; MMEL-NEXT:    or $1, $2, $zero
; MMEL-NEXT:    movn $1, $5, $3
; MMEL-NEXT:    sc $1, 0($4)
; MMEL-NEXT:    beqzc $1, $BB0_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_max_32:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:  $BB0_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $2, 0($4)
; MMELR6-NEXT:    slt $3, $2, $5
; MMELR6-NEXT:    seleqz $1, $2, $3
; MMELR6-NEXT:    selnez $3, $5, $3
; MMELR6-NEXT:    or $1, $1, $3
; MMELR6-NEXT:    sc $1, 0($4)
; MMELR6-NEXT:    beqc $1, $zero, $BB0_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_max_32:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:  .LBB0_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $2, 0($4)
; MIPS64-NEXT:    slt $3, $2, $5
; MIPS64-NEXT:    move $1, $2
; MIPS64-NEXT:    movn $1, $5, $3
; MIPS64-NEXT:    sc $1, 0($4)
; MIPS64-NEXT:    beqz $1, .LBB0_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_max_32:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:  .LBB0_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $2, 0($4)
; MIPS64R6-NEXT:    slt $3, $2, $5
; MIPS64R6-NEXT:    seleqz $1, $2, $3
; MIPS64R6-NEXT:    selnez $3, $5, $3
; MIPS64R6-NEXT:    or $1, $1, $3
; MIPS64R6-NEXT:    sc $1, 0($4)
; MIPS64R6-NEXT:    beqzc $1, .LBB0_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_max_32:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:  .LBB0_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $2, 0($4)
; MIPS64EL-NEXT:    slt $3, $2, $5
; MIPS64EL-NEXT:    move $1, $2
; MIPS64EL-NEXT:    movn $1, $5, $3
; MIPS64EL-NEXT:    sc $1, 0($4)
; MIPS64EL-NEXT:    beqz $1, .LBB0_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_max_32:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:  .LBB0_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $2, 0($4)
; MIPS64ELR6-NEXT:    slt $3, $2, $5
; MIPS64ELR6-NEXT:    seleqz $1, $2, $3
; MIPS64ELR6-NEXT:    selnez $3, $5, $3
; MIPS64ELR6-NEXT:    or $1, $1, $3
; MIPS64ELR6-NEXT:    sc $1, 0($4)
; MIPS64ELR6-NEXT:    beqzc $1, .LBB0_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw max i32* %ptr, i32 %val seq_cst
  ret i32 %0
}

define i32 @test_min_32(i32* nocapture %ptr, i32 signext %val) {
; MIPS-LABEL: test_min_32:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:  $BB1_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $2, 0($4)
; MIPS-NEXT:    slt $3, $2, $5
; MIPS-NEXT:    move $1, $2
; MIPS-NEXT:    movz $1, $5, $3
; MIPS-NEXT:    sc $1, 0($4)
; MIPS-NEXT:    beqz $1, $BB1_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_min_32:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:  $BB1_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $2, 0($4)
; MIPSR6-NEXT:    slt $3, $2, $5
; MIPSR6-NEXT:    selnez $1, $2, $3
; MIPSR6-NEXT:    seleqz $3, $5, $3
; MIPSR6-NEXT:    or $1, $1, $3
; MIPSR6-NEXT:    sc $1, 0($4)
; MIPSR6-NEXT:    beqzc $1, $BB1_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_min_32:
; MM:       # %bb.0: # %entry
; MM-NEXT:    sync
; MM-NEXT:  $BB1_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $2, 0($4)
; MM-NEXT:    slt $3, $2, $5
; MM-NEXT:    or $1, $2, $zero
; MM-NEXT:    movz $1, $5, $3
; MM-NEXT:    sc $1, 0($4)
; MM-NEXT:    beqzc $1, $BB1_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    sync
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_min_32:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:  $BB1_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $2, 0($4)
; MMR6-NEXT:    slt $3, $2, $5
; MMR6-NEXT:    selnez $1, $2, $3
; MMR6-NEXT:    seleqz $3, $5, $3
; MMR6-NEXT:    or $1, $1, $3
; MMR6-NEXT:    sc $1, 0($4)
; MMR6-NEXT:    beqc $1, $zero, $BB1_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_min_32:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:  $BB1_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $2, 0($4)
; MIPSEL-NEXT:    slt $3, $2, $5
; MIPSEL-NEXT:    move $1, $2
; MIPSEL-NEXT:    movz $1, $5, $3
; MIPSEL-NEXT:    sc $1, 0($4)
; MIPSEL-NEXT:    beqz $1, $BB1_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_min_32:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:  $BB1_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $2, 0($4)
; MIPSELR6-NEXT:    slt $3, $2, $5
; MIPSELR6-NEXT:    selnez $1, $2, $3
; MIPSELR6-NEXT:    seleqz $3, $5, $3
; MIPSELR6-NEXT:    or $1, $1, $3
; MIPSELR6-NEXT:    sc $1, 0($4)
; MIPSELR6-NEXT:    beqzc $1, $BB1_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_min_32:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:  $BB1_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $2, 0($4)
; MMEL-NEXT:    slt $3, $2, $5
; MMEL-NEXT:    or $1, $2, $zero
; MMEL-NEXT:    movz $1, $5, $3
; MMEL-NEXT:    sc $1, 0($4)
; MMEL-NEXT:    beqzc $1, $BB1_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_min_32:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:  $BB1_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $2, 0($4)
; MMELR6-NEXT:    slt $3, $2, $5
; MMELR6-NEXT:    selnez $1, $2, $3
; MMELR6-NEXT:    seleqz $3, $5, $3
; MMELR6-NEXT:    or $1, $1, $3
; MMELR6-NEXT:    sc $1, 0($4)
; MMELR6-NEXT:    beqc $1, $zero, $BB1_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_min_32:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:  .LBB1_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $2, 0($4)
; MIPS64-NEXT:    slt $3, $2, $5
; MIPS64-NEXT:    move $1, $2
; MIPS64-NEXT:    movz $1, $5, $3
; MIPS64-NEXT:    sc $1, 0($4)
; MIPS64-NEXT:    beqz $1, .LBB1_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_min_32:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:  .LBB1_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $2, 0($4)
; MIPS64R6-NEXT:    slt $3, $2, $5
; MIPS64R6-NEXT:    selnez $1, $2, $3
; MIPS64R6-NEXT:    seleqz $3, $5, $3
; MIPS64R6-NEXT:    or $1, $1, $3
; MIPS64R6-NEXT:    sc $1, 0($4)
; MIPS64R6-NEXT:    beqzc $1, .LBB1_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_min_32:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:  .LBB1_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $2, 0($4)
; MIPS64EL-NEXT:    slt $3, $2, $5
; MIPS64EL-NEXT:    move $1, $2
; MIPS64EL-NEXT:    movz $1, $5, $3
; MIPS64EL-NEXT:    sc $1, 0($4)
; MIPS64EL-NEXT:    beqz $1, .LBB1_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_min_32:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:  .LBB1_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $2, 0($4)
; MIPS64ELR6-NEXT:    slt $3, $2, $5
; MIPS64ELR6-NEXT:    selnez $1, $2, $3
; MIPS64ELR6-NEXT:    seleqz $3, $5, $3
; MIPS64ELR6-NEXT:    or $1, $1, $3
; MIPS64ELR6-NEXT:    sc $1, 0($4)
; MIPS64ELR6-NEXT:    beqzc $1, .LBB1_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw min i32* %ptr, i32 %val seq_cst
  ret i32 %0
}

define i32 @test_umax_32(i32* nocapture %ptr, i32 signext %val) {
; MIPS-LABEL: test_umax_32:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:  $BB2_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $2, 0($4)
; MIPS-NEXT:    sltu $3, $2, $5
; MIPS-NEXT:    move $1, $2
; MIPS-NEXT:    movn $1, $5, $3
; MIPS-NEXT:    sc $1, 0($4)
; MIPS-NEXT:    beqz $1, $BB2_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_umax_32:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:  $BB2_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $2, 0($4)
; MIPSR6-NEXT:    sltu $3, $2, $5
; MIPSR6-NEXT:    seleqz $1, $2, $3
; MIPSR6-NEXT:    selnez $3, $5, $3
; MIPSR6-NEXT:    or $1, $1, $3
; MIPSR6-NEXT:    sc $1, 0($4)
; MIPSR6-NEXT:    beqzc $1, $BB2_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_umax_32:
; MM:       # %bb.0: # %entry
; MM-NEXT:    sync
; MM-NEXT:  $BB2_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $2, 0($4)
; MM-NEXT:    sltu $3, $2, $5
; MM-NEXT:    or $1, $2, $zero
; MM-NEXT:    movn $1, $5, $3
; MM-NEXT:    sc $1, 0($4)
; MM-NEXT:    beqzc $1, $BB2_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    sync
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_umax_32:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:  $BB2_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $2, 0($4)
; MMR6-NEXT:    sltu $3, $2, $5
; MMR6-NEXT:    seleqz $1, $2, $3
; MMR6-NEXT:    selnez $3, $5, $3
; MMR6-NEXT:    or $1, $1, $3
; MMR6-NEXT:    sc $1, 0($4)
; MMR6-NEXT:    beqc $1, $zero, $BB2_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_umax_32:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:  $BB2_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $2, 0($4)
; MIPSEL-NEXT:    sltu $3, $2, $5
; MIPSEL-NEXT:    move $1, $2
; MIPSEL-NEXT:    movn $1, $5, $3
; MIPSEL-NEXT:    sc $1, 0($4)
; MIPSEL-NEXT:    beqz $1, $BB2_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_umax_32:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:  $BB2_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $2, 0($4)
; MIPSELR6-NEXT:    sltu $3, $2, $5
; MIPSELR6-NEXT:    seleqz $1, $2, $3
; MIPSELR6-NEXT:    selnez $3, $5, $3
; MIPSELR6-NEXT:    or $1, $1, $3
; MIPSELR6-NEXT:    sc $1, 0($4)
; MIPSELR6-NEXT:    beqzc $1, $BB2_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_umax_32:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:  $BB2_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $2, 0($4)
; MMEL-NEXT:    sltu $3, $2, $5
; MMEL-NEXT:    or $1, $2, $zero
; MMEL-NEXT:    movn $1, $5, $3
; MMEL-NEXT:    sc $1, 0($4)
; MMEL-NEXT:    beqzc $1, $BB2_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_umax_32:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:  $BB2_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $2, 0($4)
; MMELR6-NEXT:    sltu $3, $2, $5
; MMELR6-NEXT:    seleqz $1, $2, $3
; MMELR6-NEXT:    selnez $3, $5, $3
; MMELR6-NEXT:    or $1, $1, $3
; MMELR6-NEXT:    sc $1, 0($4)
; MMELR6-NEXT:    beqc $1, $zero, $BB2_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_umax_32:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:  .LBB2_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $2, 0($4)
; MIPS64-NEXT:    sltu $3, $2, $5
; MIPS64-NEXT:    move $1, $2
; MIPS64-NEXT:    movn $1, $5, $3
; MIPS64-NEXT:    sc $1, 0($4)
; MIPS64-NEXT:    beqz $1, .LBB2_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_umax_32:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:  .LBB2_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $2, 0($4)
; MIPS64R6-NEXT:    sltu $3, $2, $5
; MIPS64R6-NEXT:    seleqz $1, $2, $3
; MIPS64R6-NEXT:    selnez $3, $5, $3
; MIPS64R6-NEXT:    or $1, $1, $3
; MIPS64R6-NEXT:    sc $1, 0($4)
; MIPS64R6-NEXT:    beqzc $1, .LBB2_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_umax_32:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:  .LBB2_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $2, 0($4)
; MIPS64EL-NEXT:    sltu $3, $2, $5
; MIPS64EL-NEXT:    move $1, $2
; MIPS64EL-NEXT:    movn $1, $5, $3
; MIPS64EL-NEXT:    sc $1, 0($4)
; MIPS64EL-NEXT:    beqz $1, .LBB2_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_umax_32:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:  .LBB2_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $2, 0($4)
; MIPS64ELR6-NEXT:    sltu $3, $2, $5
; MIPS64ELR6-NEXT:    seleqz $1, $2, $3
; MIPS64ELR6-NEXT:    selnez $3, $5, $3
; MIPS64ELR6-NEXT:    or $1, $1, $3
; MIPS64ELR6-NEXT:    sc $1, 0($4)
; MIPS64ELR6-NEXT:    beqzc $1, .LBB2_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw umax i32* %ptr, i32 %val seq_cst
  ret i32 %0
}

define i32 @test_umin_32(i32* nocapture %ptr, i32 signext %val) {
; MIPS-LABEL: test_umin_32:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:  $BB3_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $2, 0($4)
; MIPS-NEXT:    sltu $3, $2, $5
; MIPS-NEXT:    move $1, $2
; MIPS-NEXT:    movz $1, $5, $3
; MIPS-NEXT:    sc $1, 0($4)
; MIPS-NEXT:    beqz $1, $BB3_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_umin_32:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:  $BB3_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $2, 0($4)
; MIPSR6-NEXT:    sltu $3, $2, $5
; MIPSR6-NEXT:    selnez $1, $2, $3
; MIPSR6-NEXT:    seleqz $3, $5, $3
; MIPSR6-NEXT:    or $1, $1, $3
; MIPSR6-NEXT:    sc $1, 0($4)
; MIPSR6-NEXT:    beqzc $1, $BB3_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_umin_32:
; MM:       # %bb.0: # %entry
; MM-NEXT:    sync
; MM-NEXT:  $BB3_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $2, 0($4)
; MM-NEXT:    sltu $3, $2, $5
; MM-NEXT:    or $1, $2, $zero
; MM-NEXT:    movz $1, $5, $3
; MM-NEXT:    sc $1, 0($4)
; MM-NEXT:    beqzc $1, $BB3_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    sync
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_umin_32:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:  $BB3_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $2, 0($4)
; MMR6-NEXT:    sltu $3, $2, $5
; MMR6-NEXT:    selnez $1, $2, $3
; MMR6-NEXT:    seleqz $3, $5, $3
; MMR6-NEXT:    or $1, $1, $3
; MMR6-NEXT:    sc $1, 0($4)
; MMR6-NEXT:    beqc $1, $zero, $BB3_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_umin_32:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:  $BB3_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $2, 0($4)
; MIPSEL-NEXT:    sltu $3, $2, $5
; MIPSEL-NEXT:    move $1, $2
; MIPSEL-NEXT:    movz $1, $5, $3
; MIPSEL-NEXT:    sc $1, 0($4)
; MIPSEL-NEXT:    beqz $1, $BB3_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_umin_32:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:  $BB3_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $2, 0($4)
; MIPSELR6-NEXT:    sltu $3, $2, $5
; MIPSELR6-NEXT:    selnez $1, $2, $3
; MIPSELR6-NEXT:    seleqz $3, $5, $3
; MIPSELR6-NEXT:    or $1, $1, $3
; MIPSELR6-NEXT:    sc $1, 0($4)
; MIPSELR6-NEXT:    beqzc $1, $BB3_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_umin_32:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:  $BB3_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $2, 0($4)
; MMEL-NEXT:    sltu $3, $2, $5
; MMEL-NEXT:    or $1, $2, $zero
; MMEL-NEXT:    movz $1, $5, $3
; MMEL-NEXT:    sc $1, 0($4)
; MMEL-NEXT:    beqzc $1, $BB3_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_umin_32:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:  $BB3_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $2, 0($4)
; MMELR6-NEXT:    sltu $3, $2, $5
; MMELR6-NEXT:    selnez $1, $2, $3
; MMELR6-NEXT:    seleqz $3, $5, $3
; MMELR6-NEXT:    or $1, $1, $3
; MMELR6-NEXT:    sc $1, 0($4)
; MMELR6-NEXT:    beqc $1, $zero, $BB3_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_umin_32:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:  .LBB3_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $2, 0($4)
; MIPS64-NEXT:    sltu $3, $2, $5
; MIPS64-NEXT:    move $1, $2
; MIPS64-NEXT:    movz $1, $5, $3
; MIPS64-NEXT:    sc $1, 0($4)
; MIPS64-NEXT:    beqz $1, .LBB3_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_umin_32:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:  .LBB3_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $2, 0($4)
; MIPS64R6-NEXT:    sltu $3, $2, $5
; MIPS64R6-NEXT:    selnez $1, $2, $3
; MIPS64R6-NEXT:    seleqz $3, $5, $3
; MIPS64R6-NEXT:    or $1, $1, $3
; MIPS64R6-NEXT:    sc $1, 0($4)
; MIPS64R6-NEXT:    beqzc $1, .LBB3_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_umin_32:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:  .LBB3_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $2, 0($4)
; MIPS64EL-NEXT:    sltu $3, $2, $5
; MIPS64EL-NEXT:    move $1, $2
; MIPS64EL-NEXT:    movz $1, $5, $3
; MIPS64EL-NEXT:    sc $1, 0($4)
; MIPS64EL-NEXT:    beqz $1, .LBB3_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_umin_32:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:  .LBB3_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $2, 0($4)
; MIPS64ELR6-NEXT:    sltu $3, $2, $5
; MIPS64ELR6-NEXT:    selnez $1, $2, $3
; MIPS64ELR6-NEXT:    seleqz $3, $5, $3
; MIPS64ELR6-NEXT:    or $1, $1, $3
; MIPS64ELR6-NEXT:    sc $1, 0($4)
; MIPS64ELR6-NEXT:    beqzc $1, .LBB3_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw umin i32* %ptr, i32 %val seq_cst
  ret i32 %0
}

define i16 @test_max_16(i16* nocapture %ptr, i16 signext %val) {
; MIPS-LABEL: test_max_16:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    addiu $sp, $sp, -8
; MIPS-NEXT:    .cfi_def_cfa_offset 8
; MIPS-NEXT:    move $1, $5
; MIPS-NEXT:    sync
; MIPS-NEXT:    addiu $2, $zero, -4
; MIPS-NEXT:    and $2, $4, $2
; MIPS-NEXT:    andi $3, $4, 3
; MIPS-NEXT:    xori $3, $3, 2
; MIPS-NEXT:    sll $3, $3, 3
; MIPS-NEXT:    ori $4, $zero, 65535
; MIPS-NEXT:    sllv $4, $4, $3
; MIPS-NEXT:    nor $6, $zero, $4
; MIPS-NEXT:    sllv $5, $5, $3
; MIPS-NEXT:  $BB4_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $8, 0($2)
; MIPS-NEXT:    slt $11, $8, $5
; MIPS-NEXT:    move $9, $8
; MIPS-NEXT:    movn $9, $5, $11
; MIPS-NEXT:    and $9, $9, $4
; MIPS-NEXT:    and $10, $8, $6
; MIPS-NEXT:    or $10, $10, $9
; MIPS-NEXT:    sc $10, 0($2)
; MIPS-NEXT:    beqz $10, $BB4_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    and $7, $8, $4
; MIPS-NEXT:    srlv $7, $7, $3
; MIPS-NEXT:    seh $7, $7
; MIPS-NEXT:  # %bb.3: # %entry
; MIPS-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPS-NEXT:  # %bb.4: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPS-NEXT:    addiu $sp, $sp, 8
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_max_16:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    addiu $sp, $sp, -8
; MIPSR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSR6-NEXT:    move $1, $5
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    addiu $2, $zero, -4
; MIPSR6-NEXT:    and $2, $4, $2
; MIPSR6-NEXT:    andi $3, $4, 3
; MIPSR6-NEXT:    xori $3, $3, 2
; MIPSR6-NEXT:    sll $3, $3, 3
; MIPSR6-NEXT:    ori $4, $zero, 65535
; MIPSR6-NEXT:    sllv $4, $4, $3
; MIPSR6-NEXT:    nor $6, $zero, $4
; MIPSR6-NEXT:    sllv $5, $5, $3
; MIPSR6-NEXT:  $BB4_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $8, 0($2)
; MIPSR6-NEXT:    slt $11, $8, $5
; MIPSR6-NEXT:    seleqz $9, $8, $11
; MIPSR6-NEXT:    selnez $11, $5, $11
; MIPSR6-NEXT:    or $9, $9, $11
; MIPSR6-NEXT:    and $9, $9, $4
; MIPSR6-NEXT:    and $10, $8, $6
; MIPSR6-NEXT:    or $10, $10, $9
; MIPSR6-NEXT:    sc $10, 0($2)
; MIPSR6-NEXT:    beqzc $10, $BB4_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    and $7, $8, $4
; MIPSR6-NEXT:    srlv $7, $7, $3
; MIPSR6-NEXT:    seh $7, $7
; MIPSR6-NEXT:  # %bb.3: # %entry
; MIPSR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSR6-NEXT:  # %bb.4: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSR6-NEXT:    addiu $sp, $sp, 8
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_max_16:
; MM:       # %bb.0: # %entry
; MM-NEXT:    addiu $sp, $sp, -8
; MM-NEXT:    .cfi_def_cfa_offset 8
; MM-NEXT:    move $1, $5
; MM-NEXT:    sync
; MM-NEXT:    addiu $2, $zero, -4
; MM-NEXT:    and $2, $4, $2
; MM-NEXT:    andi $3, $4, 3
; MM-NEXT:    xori $3, $3, 2
; MM-NEXT:    sll $3, $3, 3
; MM-NEXT:    ori $4, $zero, 65535
; MM-NEXT:    sllv $4, $4, $3
; MM-NEXT:    nor $6, $zero, $4
; MM-NEXT:    sllv $5, $5, $3
; MM-NEXT:  $BB4_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $8, 0($2)
; MM-NEXT:    slt $11, $8, $5
; MM-NEXT:    or $9, $8, $zero
; MM-NEXT:    movn $9, $5, $11
; MM-NEXT:    and $9, $9, $4
; MM-NEXT:    and $10, $8, $6
; MM-NEXT:    or $10, $10, $9
; MM-NEXT:    sc $10, 0($2)
; MM-NEXT:    beqzc $10, $BB4_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    and $7, $8, $4
; MM-NEXT:    srlv $7, $7, $3
; MM-NEXT:    seh $7, $7
; MM-NEXT:  # %bb.3: # %entry
; MM-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MM-NEXT:  # %bb.4: # %entry
; MM-NEXT:    sync
; MM-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MM-NEXT:    addiusp 8
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_max_16:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    addiu $sp, $sp, -8
; MMR6-NEXT:    .cfi_def_cfa_offset 8
; MMR6-NEXT:    move $1, $5
; MMR6-NEXT:    sync
; MMR6-NEXT:    addiu $2, $zero, -4
; MMR6-NEXT:    and $2, $4, $2
; MMR6-NEXT:    andi $3, $4, 3
; MMR6-NEXT:    xori $3, $3, 2
; MMR6-NEXT:    sll $3, $3, 3
; MMR6-NEXT:    ori $4, $zero, 65535
; MMR6-NEXT:    sllv $4, $4, $3
; MMR6-NEXT:    nor $6, $zero, $4
; MMR6-NEXT:    sllv $5, $5, $3
; MMR6-NEXT:  $BB4_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $8, 0($2)
; MMR6-NEXT:    slt $11, $8, $5
; MMR6-NEXT:    seleqz $9, $8, $11
; MMR6-NEXT:    selnez $11, $5, $11
; MMR6-NEXT:    or $9, $9, $11
; MMR6-NEXT:    and $9, $9, $4
; MMR6-NEXT:    and $10, $8, $6
; MMR6-NEXT:    or $10, $10, $9
; MMR6-NEXT:    sc $10, 0($2)
; MMR6-NEXT:    beqc $10, $zero, $BB4_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    and $7, $8, $4
; MMR6-NEXT:    srlv $7, $7, $3
; MMR6-NEXT:    seh $7, $7
; MMR6-NEXT:  # %bb.3: # %entry
; MMR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMR6-NEXT:  # %bb.4: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMR6-NEXT:    addiu $sp, $sp, 8
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_max_16:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    addiu $sp, $sp, -8
; MIPSEL-NEXT:    .cfi_def_cfa_offset 8
; MIPSEL-NEXT:    move $1, $5
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    addiu $2, $zero, -4
; MIPSEL-NEXT:    and $2, $4, $2
; MIPSEL-NEXT:    andi $3, $4, 3
; MIPSEL-NEXT:    sll $3, $3, 3
; MIPSEL-NEXT:    ori $4, $zero, 65535
; MIPSEL-NEXT:    sllv $4, $4, $3
; MIPSEL-NEXT:    nor $6, $zero, $4
; MIPSEL-NEXT:    sllv $5, $5, $3
; MIPSEL-NEXT:  $BB4_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $8, 0($2)
; MIPSEL-NEXT:    and $8, $8, $4
; MIPSEL-NEXT:    and $5, $5, $4
; MIPSEL-NEXT:    slt $11, $8, $5
; MIPSEL-NEXT:    move $9, $8
; MIPSEL-NEXT:    movn $9, $5, $11
; MIPSEL-NEXT:    and $9, $9, $4
; MIPSEL-NEXT:    and $10, $8, $6
; MIPSEL-NEXT:    or $10, $10, $9
; MIPSEL-NEXT:    sc $10, 0($2)
; MIPSEL-NEXT:    beqz $10, $BB4_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    and $7, $8, $4
; MIPSEL-NEXT:    srlv $7, $7, $3
; MIPSEL-NEXT:    seh $7, $7
; MIPSEL-NEXT:  # %bb.3: # %entry
; MIPSEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:  # %bb.4: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    addiu $sp, $sp, 8
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_max_16:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    addiu $sp, $sp, -8
; MIPSELR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSELR6-NEXT:    move $1, $5
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    addiu $2, $zero, -4
; MIPSELR6-NEXT:    and $2, $4, $2
; MIPSELR6-NEXT:    andi $3, $4, 3
; MIPSELR6-NEXT:    sll $3, $3, 3
; MIPSELR6-NEXT:    ori $4, $zero, 65535
; MIPSELR6-NEXT:    sllv $4, $4, $3
; MIPSELR6-NEXT:    nor $6, $zero, $4
; MIPSELR6-NEXT:    sllv $5, $5, $3
; MIPSELR6-NEXT:  $BB4_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $8, 0($2)
; MIPSELR6-NEXT:    and $8, $8, $4
; MIPSELR6-NEXT:    and $5, $5, $4
; MIPSELR6-NEXT:    slt $11, $8, $5
; MIPSELR6-NEXT:    seleqz $9, $8, $11
; MIPSELR6-NEXT:    selnez $11, $5, $11
; MIPSELR6-NEXT:    or $9, $9, $11
; MIPSELR6-NEXT:    and $9, $9, $4
; MIPSELR6-NEXT:    and $10, $8, $6
; MIPSELR6-NEXT:    or $10, $10, $9
; MIPSELR6-NEXT:    sc $10, 0($2)
; MIPSELR6-NEXT:    beqzc $10, $BB4_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    and $7, $8, $4
; MIPSELR6-NEXT:    srlv $7, $7, $3
; MIPSELR6-NEXT:    seh $7, $7
; MIPSELR6-NEXT:  # %bb.3: # %entry
; MIPSELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSELR6-NEXT:  # %bb.4: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSELR6-NEXT:    addiu $sp, $sp, 8
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_max_16:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    addiu $sp, $sp, -8
; MMEL-NEXT:    .cfi_def_cfa_offset 8
; MMEL-NEXT:    move $1, $5
; MMEL-NEXT:    sync
; MMEL-NEXT:    addiu $2, $zero, -4
; MMEL-NEXT:    and $2, $4, $2
; MMEL-NEXT:    andi $3, $4, 3
; MMEL-NEXT:    sll $3, $3, 3
; MMEL-NEXT:    ori $4, $zero, 65535
; MMEL-NEXT:    sllv $4, $4, $3
; MMEL-NEXT:    nor $6, $zero, $4
; MMEL-NEXT:    sllv $5, $5, $3
; MMEL-NEXT:  $BB4_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $8, 0($2)
; MMEL-NEXT:    and $8, $8, $4
; MMEL-NEXT:    and $5, $5, $4
; MMEL-NEXT:    slt $11, $8, $5
; MMEL-NEXT:    or $9, $8, $zero
; MMEL-NEXT:    movn $9, $5, $11
; MMEL-NEXT:    and $9, $9, $4
; MMEL-NEXT:    and $10, $8, $6
; MMEL-NEXT:    or $10, $10, $9
; MMEL-NEXT:    sc $10, 0($2)
; MMEL-NEXT:    beqzc $10, $BB4_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    and $7, $8, $4
; MMEL-NEXT:    srlv $7, $7, $3
; MMEL-NEXT:    seh $7, $7
; MMEL-NEXT:  # %bb.3: # %entry
; MMEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMEL-NEXT:  # %bb.4: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMEL-NEXT:    addiusp 8
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_max_16:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    addiu $sp, $sp, -8
; MMELR6-NEXT:    .cfi_def_cfa_offset 8
; MMELR6-NEXT:    move $1, $5
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    addiu $2, $zero, -4
; MMELR6-NEXT:    and $2, $4, $2
; MMELR6-NEXT:    andi $3, $4, 3
; MMELR6-NEXT:    sll $3, $3, 3
; MMELR6-NEXT:    ori $4, $zero, 65535
; MMELR6-NEXT:    sllv $4, $4, $3
; MMELR6-NEXT:    nor $6, $zero, $4
; MMELR6-NEXT:    sllv $5, $5, $3
; MMELR6-NEXT:  $BB4_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $8, 0($2)
; MMELR6-NEXT:    and $8, $8, $4
; MMELR6-NEXT:    and $5, $5, $4
; MMELR6-NEXT:    slt $11, $8, $5
; MMELR6-NEXT:    seleqz $9, $8, $11
; MMELR6-NEXT:    selnez $11, $5, $11
; MMELR6-NEXT:    or $9, $9, $11
; MMELR6-NEXT:    and $9, $9, $4
; MMELR6-NEXT:    and $10, $8, $6
; MMELR6-NEXT:    or $10, $10, $9
; MMELR6-NEXT:    sc $10, 0($2)
; MMELR6-NEXT:    beqc $10, $zero, $BB4_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    and $7, $8, $4
; MMELR6-NEXT:    srlv $7, $7, $3
; MMELR6-NEXT:    seh $7, $7
; MMELR6-NEXT:  # %bb.3: # %entry
; MMELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMELR6-NEXT:  # %bb.4: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMELR6-NEXT:    addiu $sp, $sp, 8
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_max_16:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    daddiu $1, $zero, -4
; MIPS64-NEXT:    and $1, $4, $1
; MIPS64-NEXT:    andi $2, $4, 3
; MIPS64-NEXT:    xori $2, $2, 2
; MIPS64-NEXT:    sll $2, $2, 3
; MIPS64-NEXT:    ori $3, $zero, 65535
; MIPS64-NEXT:    sllv $3, $3, $2
; MIPS64-NEXT:    nor $6, $zero, $3
; MIPS64-NEXT:    sllv $5, $5, $2
; MIPS64-NEXT:  .LBB4_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $8, 0($1)
; MIPS64-NEXT:    slt $11, $8, $5
; MIPS64-NEXT:    move $9, $8
; MIPS64-NEXT:    movn $9, $5, $11
; MIPS64-NEXT:    and $9, $9, $3
; MIPS64-NEXT:    and $10, $8, $6
; MIPS64-NEXT:    or $10, $10, $9
; MIPS64-NEXT:    sc $10, 0($1)
; MIPS64-NEXT:    beqz $10, .LBB4_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    and $7, $8, $3
; MIPS64-NEXT:    srlv $7, $7, $2
; MIPS64-NEXT:    seh $7, $7
; MIPS64-NEXT:  # %bb.3: # %entry
; MIPS64-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64-NEXT:  # %bb.4: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_max_16:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    daddiu $sp, $sp, -16
; MIPS64R6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    daddiu $1, $zero, -4
; MIPS64R6-NEXT:    and $1, $4, $1
; MIPS64R6-NEXT:    andi $2, $4, 3
; MIPS64R6-NEXT:    xori $2, $2, 2
; MIPS64R6-NEXT:    sll $2, $2, 3
; MIPS64R6-NEXT:    ori $3, $zero, 65535
; MIPS64R6-NEXT:    sllv $3, $3, $2
; MIPS64R6-NEXT:    nor $6, $zero, $3
; MIPS64R6-NEXT:    sllv $5, $5, $2
; MIPS64R6-NEXT:  .LBB4_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $8, 0($1)
; MIPS64R6-NEXT:    slt $11, $8, $5
; MIPS64R6-NEXT:    seleqz $9, $8, $11
; MIPS64R6-NEXT:    selnez $11, $5, $11
; MIPS64R6-NEXT:    or $9, $9, $11
; MIPS64R6-NEXT:    and $9, $9, $3
; MIPS64R6-NEXT:    and $10, $8, $6
; MIPS64R6-NEXT:    or $10, $10, $9
; MIPS64R6-NEXT:    sc $10, 0($1)
; MIPS64R6-NEXT:    beqzc $10, .LBB4_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    and $7, $8, $3
; MIPS64R6-NEXT:    srlv $7, $7, $2
; MIPS64R6-NEXT:    seh $7, $7
; MIPS64R6-NEXT:  # %bb.3: # %entry
; MIPS64R6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64R6-NEXT:  # %bb.4: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64R6-NEXT:    daddiu $sp, $sp, 16
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_max_16:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    daddiu $sp, $sp, -16
; MIPS64EL-NEXT:    .cfi_def_cfa_offset 16
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    daddiu $1, $zero, -4
; MIPS64EL-NEXT:    and $1, $4, $1
; MIPS64EL-NEXT:    andi $2, $4, 3
; MIPS64EL-NEXT:    sll $2, $2, 3
; MIPS64EL-NEXT:    ori $3, $zero, 65535
; MIPS64EL-NEXT:    sllv $3, $3, $2
; MIPS64EL-NEXT:    nor $6, $zero, $3
; MIPS64EL-NEXT:    sllv $5, $5, $2
; MIPS64EL-NEXT:  .LBB4_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $8, 0($1)
; MIPS64EL-NEXT:    and $8, $8, $3
; MIPS64EL-NEXT:    and $5, $5, $3
; MIPS64EL-NEXT:    slt $11, $8, $5
; MIPS64EL-NEXT:    move $9, $8
; MIPS64EL-NEXT:    movn $9, $5, $11
; MIPS64EL-NEXT:    and $9, $9, $3
; MIPS64EL-NEXT:    and $10, $8, $6
; MIPS64EL-NEXT:    or $10, $10, $9
; MIPS64EL-NEXT:    sc $10, 0($1)
; MIPS64EL-NEXT:    beqz $10, .LBB4_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    and $7, $8, $3
; MIPS64EL-NEXT:    srlv $7, $7, $2
; MIPS64EL-NEXT:    seh $7, $7
; MIPS64EL-NEXT:  # %bb.3: # %entry
; MIPS64EL-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64EL-NEXT:  # %bb.4: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64EL-NEXT:    daddiu $sp, $sp, 16
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_max_16:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, -16
; MIPS64ELR6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    daddiu $1, $zero, -4
; MIPS64ELR6-NEXT:    and $1, $4, $1
; MIPS64ELR6-NEXT:    andi $2, $4, 3
; MIPS64ELR6-NEXT:    sll $2, $2, 3
; MIPS64ELR6-NEXT:    ori $3, $zero, 65535
; MIPS64ELR6-NEXT:    sllv $3, $3, $2
; MIPS64ELR6-NEXT:    nor $6, $zero, $3
; MIPS64ELR6-NEXT:    sllv $5, $5, $2
; MIPS64ELR6-NEXT:  .LBB4_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $8, 0($1)
; MIPS64ELR6-NEXT:    and $8, $8, $3
; MIPS64ELR6-NEXT:    and $5, $5, $3
; MIPS64ELR6-NEXT:    slt $11, $8, $5
; MIPS64ELR6-NEXT:    seleqz $9, $8, $11
; MIPS64ELR6-NEXT:    selnez $11, $5, $11
; MIPS64ELR6-NEXT:    or $9, $9, $11
; MIPS64ELR6-NEXT:    and $9, $9, $3
; MIPS64ELR6-NEXT:    and $10, $8, $6
; MIPS64ELR6-NEXT:    or $10, $10, $9
; MIPS64ELR6-NEXT:    sc $10, 0($1)
; MIPS64ELR6-NEXT:    beqzc $10, .LBB4_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    and $7, $8, $3
; MIPS64ELR6-NEXT:    srlv $7, $7, $2
; MIPS64ELR6-NEXT:    seh $7, $7
; MIPS64ELR6-NEXT:  # %bb.3: # %entry
; MIPS64ELR6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64ELR6-NEXT:  # %bb.4: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, 16
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw max i16* %ptr, i16 %val seq_cst
  ret i16 %0
}

define i16 @test_min_16(i16* nocapture %ptr, i16 signext %val) {
; MIPS-LABEL: test_min_16:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    addiu $sp, $sp, -8
; MIPS-NEXT:    .cfi_def_cfa_offset 8
; MIPS-NEXT:    move $1, $5
; MIPS-NEXT:    sync
; MIPS-NEXT:    addiu $2, $zero, -4
; MIPS-NEXT:    and $2, $4, $2
; MIPS-NEXT:    andi $3, $4, 3
; MIPS-NEXT:    xori $3, $3, 2
; MIPS-NEXT:    sll $3, $3, 3
; MIPS-NEXT:    ori $4, $zero, 65535
; MIPS-NEXT:    sllv $4, $4, $3
; MIPS-NEXT:    nor $6, $zero, $4
; MIPS-NEXT:    sllv $5, $5, $3
; MIPS-NEXT:  $BB5_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $8, 0($2)
; MIPS-NEXT:    slt $11, $8, $5
; MIPS-NEXT:    move $9, $8
; MIPS-NEXT:    movz $9, $5, $11
; MIPS-NEXT:    and $9, $9, $4
; MIPS-NEXT:    and $10, $8, $6
; MIPS-NEXT:    or $10, $10, $9
; MIPS-NEXT:    sc $10, 0($2)
; MIPS-NEXT:    beqz $10, $BB5_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    and $7, $8, $4
; MIPS-NEXT:    srlv $7, $7, $3
; MIPS-NEXT:    seh $7, $7
; MIPS-NEXT:  # %bb.3: # %entry
; MIPS-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPS-NEXT:  # %bb.4: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPS-NEXT:    addiu $sp, $sp, 8
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_min_16:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    addiu $sp, $sp, -8
; MIPSR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSR6-NEXT:    move $1, $5
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    addiu $2, $zero, -4
; MIPSR6-NEXT:    and $2, $4, $2
; MIPSR6-NEXT:    andi $3, $4, 3
; MIPSR6-NEXT:    xori $3, $3, 2
; MIPSR6-NEXT:    sll $3, $3, 3
; MIPSR6-NEXT:    ori $4, $zero, 65535
; MIPSR6-NEXT:    sllv $4, $4, $3
; MIPSR6-NEXT:    nor $6, $zero, $4
; MIPSR6-NEXT:    sllv $5, $5, $3
; MIPSR6-NEXT:  $BB5_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $8, 0($2)
; MIPSR6-NEXT:    slt $11, $8, $5
; MIPSR6-NEXT:    selnez $9, $8, $11
; MIPSR6-NEXT:    seleqz $11, $5, $11
; MIPSR6-NEXT:    or $9, $9, $11
; MIPSR6-NEXT:    and $9, $9, $4
; MIPSR6-NEXT:    and $10, $8, $6
; MIPSR6-NEXT:    or $10, $10, $9
; MIPSR6-NEXT:    sc $10, 0($2)
; MIPSR6-NEXT:    beqzc $10, $BB5_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    and $7, $8, $4
; MIPSR6-NEXT:    srlv $7, $7, $3
; MIPSR6-NEXT:    seh $7, $7
; MIPSR6-NEXT:  # %bb.3: # %entry
; MIPSR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSR6-NEXT:  # %bb.4: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSR6-NEXT:    addiu $sp, $sp, 8
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_min_16:
; MM:       # %bb.0: # %entry
; MM-NEXT:    addiu $sp, $sp, -8
; MM-NEXT:    .cfi_def_cfa_offset 8
; MM-NEXT:    move $1, $5
; MM-NEXT:    sync
; MM-NEXT:    addiu $2, $zero, -4
; MM-NEXT:    and $2, $4, $2
; MM-NEXT:    andi $3, $4, 3
; MM-NEXT:    xori $3, $3, 2
; MM-NEXT:    sll $3, $3, 3
; MM-NEXT:    ori $4, $zero, 65535
; MM-NEXT:    sllv $4, $4, $3
; MM-NEXT:    nor $6, $zero, $4
; MM-NEXT:    sllv $5, $5, $3
; MM-NEXT:  $BB5_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $8, 0($2)
; MM-NEXT:    slt $11, $8, $5
; MM-NEXT:    or $9, $8, $zero
; MM-NEXT:    movz $9, $5, $11
; MM-NEXT:    and $9, $9, $4
; MM-NEXT:    and $10, $8, $6
; MM-NEXT:    or $10, $10, $9
; MM-NEXT:    sc $10, 0($2)
; MM-NEXT:    beqzc $10, $BB5_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    and $7, $8, $4
; MM-NEXT:    srlv $7, $7, $3
; MM-NEXT:    seh $7, $7
; MM-NEXT:  # %bb.3: # %entry
; MM-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MM-NEXT:  # %bb.4: # %entry
; MM-NEXT:    sync
; MM-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MM-NEXT:    addiusp 8
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_min_16:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    addiu $sp, $sp, -8
; MMR6-NEXT:    .cfi_def_cfa_offset 8
; MMR6-NEXT:    move $1, $5
; MMR6-NEXT:    sync
; MMR6-NEXT:    addiu $2, $zero, -4
; MMR6-NEXT:    and $2, $4, $2
; MMR6-NEXT:    andi $3, $4, 3
; MMR6-NEXT:    xori $3, $3, 2
; MMR6-NEXT:    sll $3, $3, 3
; MMR6-NEXT:    ori $4, $zero, 65535
; MMR6-NEXT:    sllv $4, $4, $3
; MMR6-NEXT:    nor $6, $zero, $4
; MMR6-NEXT:    sllv $5, $5, $3
; MMR6-NEXT:  $BB5_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $8, 0($2)
; MMR6-NEXT:    slt $11, $8, $5
; MMR6-NEXT:    selnez $9, $8, $11
; MMR6-NEXT:    seleqz $11, $5, $11
; MMR6-NEXT:    or $9, $9, $11
; MMR6-NEXT:    and $9, $9, $4
; MMR6-NEXT:    and $10, $8, $6
; MMR6-NEXT:    or $10, $10, $9
; MMR6-NEXT:    sc $10, 0($2)
; MMR6-NEXT:    beqc $10, $zero, $BB5_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    and $7, $8, $4
; MMR6-NEXT:    srlv $7, $7, $3
; MMR6-NEXT:    seh $7, $7
; MMR6-NEXT:  # %bb.3: # %entry
; MMR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMR6-NEXT:  # %bb.4: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMR6-NEXT:    addiu $sp, $sp, 8
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_min_16:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    addiu $sp, $sp, -8
; MIPSEL-NEXT:    .cfi_def_cfa_offset 8
; MIPSEL-NEXT:    move $1, $5
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    addiu $2, $zero, -4
; MIPSEL-NEXT:    and $2, $4, $2
; MIPSEL-NEXT:    andi $3, $4, 3
; MIPSEL-NEXT:    sll $3, $3, 3
; MIPSEL-NEXT:    ori $4, $zero, 65535
; MIPSEL-NEXT:    sllv $4, $4, $3
; MIPSEL-NEXT:    nor $6, $zero, $4
; MIPSEL-NEXT:    sllv $5, $5, $3
; MIPSEL-NEXT:  $BB5_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $8, 0($2)
; MIPSEL-NEXT:    and $8, $8, $4
; MIPSEL-NEXT:    and $5, $5, $4
; MIPSEL-NEXT:    slt $11, $8, $5
; MIPSEL-NEXT:    move $9, $8
; MIPSEL-NEXT:    movz $9, $5, $11
; MIPSEL-NEXT:    and $9, $9, $4
; MIPSEL-NEXT:    and $10, $8, $6
; MIPSEL-NEXT:    or $10, $10, $9
; MIPSEL-NEXT:    sc $10, 0($2)
; MIPSEL-NEXT:    beqz $10, $BB5_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    and $7, $8, $4
; MIPSEL-NEXT:    srlv $7, $7, $3
; MIPSEL-NEXT:    seh $7, $7
; MIPSEL-NEXT:  # %bb.3: # %entry
; MIPSEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:  # %bb.4: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    addiu $sp, $sp, 8
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_min_16:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    addiu $sp, $sp, -8
; MIPSELR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSELR6-NEXT:    move $1, $5
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    addiu $2, $zero, -4
; MIPSELR6-NEXT:    and $2, $4, $2
; MIPSELR6-NEXT:    andi $3, $4, 3
; MIPSELR6-NEXT:    sll $3, $3, 3
; MIPSELR6-NEXT:    ori $4, $zero, 65535
; MIPSELR6-NEXT:    sllv $4, $4, $3
; MIPSELR6-NEXT:    nor $6, $zero, $4
; MIPSELR6-NEXT:    sllv $5, $5, $3
; MIPSELR6-NEXT:  $BB5_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $8, 0($2)
; MIPSELR6-NEXT:    and $8, $8, $4
; MIPSELR6-NEXT:    and $5, $5, $4
; MIPSELR6-NEXT:    slt $11, $8, $5
; MIPSELR6-NEXT:    selnez $9, $8, $11
; MIPSELR6-NEXT:    seleqz $11, $5, $11
; MIPSELR6-NEXT:    or $9, $9, $11
; MIPSELR6-NEXT:    and $9, $9, $4
; MIPSELR6-NEXT:    and $10, $8, $6
; MIPSELR6-NEXT:    or $10, $10, $9
; MIPSELR6-NEXT:    sc $10, 0($2)
; MIPSELR6-NEXT:    beqzc $10, $BB5_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    and $7, $8, $4
; MIPSELR6-NEXT:    srlv $7, $7, $3
; MIPSELR6-NEXT:    seh $7, $7
; MIPSELR6-NEXT:  # %bb.3: # %entry
; MIPSELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSELR6-NEXT:  # %bb.4: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSELR6-NEXT:    addiu $sp, $sp, 8
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_min_16:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    addiu $sp, $sp, -8
; MMEL-NEXT:    .cfi_def_cfa_offset 8
; MMEL-NEXT:    move $1, $5
; MMEL-NEXT:    sync
; MMEL-NEXT:    addiu $2, $zero, -4
; MMEL-NEXT:    and $2, $4, $2
; MMEL-NEXT:    andi $3, $4, 3
; MMEL-NEXT:    sll $3, $3, 3
; MMEL-NEXT:    ori $4, $zero, 65535
; MMEL-NEXT:    sllv $4, $4, $3
; MMEL-NEXT:    nor $6, $zero, $4
; MMEL-NEXT:    sllv $5, $5, $3
; MMEL-NEXT:  $BB5_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $8, 0($2)
; MMEL-NEXT:    and $8, $8, $4
; MMEL-NEXT:    and $5, $5, $4
; MMEL-NEXT:    slt $11, $8, $5
; MMEL-NEXT:    or $9, $8, $zero
; MMEL-NEXT:    movz $9, $5, $11
; MMEL-NEXT:    and $9, $9, $4
; MMEL-NEXT:    and $10, $8, $6
; MMEL-NEXT:    or $10, $10, $9
; MMEL-NEXT:    sc $10, 0($2)
; MMEL-NEXT:    beqzc $10, $BB5_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    and $7, $8, $4
; MMEL-NEXT:    srlv $7, $7, $3
; MMEL-NEXT:    seh $7, $7
; MMEL-NEXT:  # %bb.3: # %entry
; MMEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMEL-NEXT:  # %bb.4: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMEL-NEXT:    addiusp 8
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_min_16:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    addiu $sp, $sp, -8
; MMELR6-NEXT:    .cfi_def_cfa_offset 8
; MMELR6-NEXT:    move $1, $5
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    addiu $2, $zero, -4
; MMELR6-NEXT:    and $2, $4, $2
; MMELR6-NEXT:    andi $3, $4, 3
; MMELR6-NEXT:    sll $3, $3, 3
; MMELR6-NEXT:    ori $4, $zero, 65535
; MMELR6-NEXT:    sllv $4, $4, $3
; MMELR6-NEXT:    nor $6, $zero, $4
; MMELR6-NEXT:    sllv $5, $5, $3
; MMELR6-NEXT:  $BB5_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $8, 0($2)
; MMELR6-NEXT:    and $8, $8, $4
; MMELR6-NEXT:    and $5, $5, $4
; MMELR6-NEXT:    slt $11, $8, $5
; MMELR6-NEXT:    selnez $9, $8, $11
; MMELR6-NEXT:    seleqz $11, $5, $11
; MMELR6-NEXT:    or $9, $9, $11
; MMELR6-NEXT:    and $9, $9, $4
; MMELR6-NEXT:    and $10, $8, $6
; MMELR6-NEXT:    or $10, $10, $9
; MMELR6-NEXT:    sc $10, 0($2)
; MMELR6-NEXT:    beqc $10, $zero, $BB5_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    and $7, $8, $4
; MMELR6-NEXT:    srlv $7, $7, $3
; MMELR6-NEXT:    seh $7, $7
; MMELR6-NEXT:  # %bb.3: # %entry
; MMELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMELR6-NEXT:  # %bb.4: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMELR6-NEXT:    addiu $sp, $sp, 8
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_min_16:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    daddiu $1, $zero, -4
; MIPS64-NEXT:    and $1, $4, $1
; MIPS64-NEXT:    andi $2, $4, 3
; MIPS64-NEXT:    xori $2, $2, 2
; MIPS64-NEXT:    sll $2, $2, 3
; MIPS64-NEXT:    ori $3, $zero, 65535
; MIPS64-NEXT:    sllv $3, $3, $2
; MIPS64-NEXT:    nor $6, $zero, $3
; MIPS64-NEXT:    sllv $5, $5, $2
; MIPS64-NEXT:  .LBB5_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $8, 0($1)
; MIPS64-NEXT:    slt $11, $8, $5
; MIPS64-NEXT:    move $9, $8
; MIPS64-NEXT:    movz $9, $5, $11
; MIPS64-NEXT:    and $9, $9, $3
; MIPS64-NEXT:    and $10, $8, $6
; MIPS64-NEXT:    or $10, $10, $9
; MIPS64-NEXT:    sc $10, 0($1)
; MIPS64-NEXT:    beqz $10, .LBB5_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    and $7, $8, $3
; MIPS64-NEXT:    srlv $7, $7, $2
; MIPS64-NEXT:    seh $7, $7
; MIPS64-NEXT:  # %bb.3: # %entry
; MIPS64-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64-NEXT:  # %bb.4: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_min_16:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    daddiu $sp, $sp, -16
; MIPS64R6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    daddiu $1, $zero, -4
; MIPS64R6-NEXT:    and $1, $4, $1
; MIPS64R6-NEXT:    andi $2, $4, 3
; MIPS64R6-NEXT:    xori $2, $2, 2
; MIPS64R6-NEXT:    sll $2, $2, 3
; MIPS64R6-NEXT:    ori $3, $zero, 65535
; MIPS64R6-NEXT:    sllv $3, $3, $2
; MIPS64R6-NEXT:    nor $6, $zero, $3
; MIPS64R6-NEXT:    sllv $5, $5, $2
; MIPS64R6-NEXT:  .LBB5_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $8, 0($1)
; MIPS64R6-NEXT:    slt $11, $8, $5
; MIPS64R6-NEXT:    selnez $9, $8, $11
; MIPS64R6-NEXT:    seleqz $11, $5, $11
; MIPS64R6-NEXT:    or $9, $9, $11
; MIPS64R6-NEXT:    and $9, $9, $3
; MIPS64R6-NEXT:    and $10, $8, $6
; MIPS64R6-NEXT:    or $10, $10, $9
; MIPS64R6-NEXT:    sc $10, 0($1)
; MIPS64R6-NEXT:    beqzc $10, .LBB5_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    and $7, $8, $3
; MIPS64R6-NEXT:    srlv $7, $7, $2
; MIPS64R6-NEXT:    seh $7, $7
; MIPS64R6-NEXT:  # %bb.3: # %entry
; MIPS64R6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64R6-NEXT:  # %bb.4: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64R6-NEXT:    daddiu $sp, $sp, 16
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_min_16:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    daddiu $sp, $sp, -16
; MIPS64EL-NEXT:    .cfi_def_cfa_offset 16
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    daddiu $1, $zero, -4
; MIPS64EL-NEXT:    and $1, $4, $1
; MIPS64EL-NEXT:    andi $2, $4, 3
; MIPS64EL-NEXT:    sll $2, $2, 3
; MIPS64EL-NEXT:    ori $3, $zero, 65535
; MIPS64EL-NEXT:    sllv $3, $3, $2
; MIPS64EL-NEXT:    nor $6, $zero, $3
; MIPS64EL-NEXT:    sllv $5, $5, $2
; MIPS64EL-NEXT:  .LBB5_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $8, 0($1)
; MIPS64EL-NEXT:    and $8, $8, $3
; MIPS64EL-NEXT:    and $5, $5, $3
; MIPS64EL-NEXT:    slt $11, $8, $5
; MIPS64EL-NEXT:    move $9, $8
; MIPS64EL-NEXT:    movz $9, $5, $11
; MIPS64EL-NEXT:    and $9, $9, $3
; MIPS64EL-NEXT:    and $10, $8, $6
; MIPS64EL-NEXT:    or $10, $10, $9
; MIPS64EL-NEXT:    sc $10, 0($1)
; MIPS64EL-NEXT:    beqz $10, .LBB5_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    and $7, $8, $3
; MIPS64EL-NEXT:    srlv $7, $7, $2
; MIPS64EL-NEXT:    seh $7, $7
; MIPS64EL-NEXT:  # %bb.3: # %entry
; MIPS64EL-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64EL-NEXT:  # %bb.4: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64EL-NEXT:    daddiu $sp, $sp, 16
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_min_16:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, -16
; MIPS64ELR6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    daddiu $1, $zero, -4
; MIPS64ELR6-NEXT:    and $1, $4, $1
; MIPS64ELR6-NEXT:    andi $2, $4, 3
; MIPS64ELR6-NEXT:    sll $2, $2, 3
; MIPS64ELR6-NEXT:    ori $3, $zero, 65535
; MIPS64ELR6-NEXT:    sllv $3, $3, $2
; MIPS64ELR6-NEXT:    nor $6, $zero, $3
; MIPS64ELR6-NEXT:    sllv $5, $5, $2
; MIPS64ELR6-NEXT:  .LBB5_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $8, 0($1)
; MIPS64ELR6-NEXT:    and $8, $8, $3
; MIPS64ELR6-NEXT:    and $5, $5, $3
; MIPS64ELR6-NEXT:    slt $11, $8, $5
; MIPS64ELR6-NEXT:    selnez $9, $8, $11
; MIPS64ELR6-NEXT:    seleqz $11, $5, $11
; MIPS64ELR6-NEXT:    or $9, $9, $11
; MIPS64ELR6-NEXT:    and $9, $9, $3
; MIPS64ELR6-NEXT:    and $10, $8, $6
; MIPS64ELR6-NEXT:    or $10, $10, $9
; MIPS64ELR6-NEXT:    sc $10, 0($1)
; MIPS64ELR6-NEXT:    beqzc $10, .LBB5_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    and $7, $8, $3
; MIPS64ELR6-NEXT:    srlv $7, $7, $2
; MIPS64ELR6-NEXT:    seh $7, $7
; MIPS64ELR6-NEXT:  # %bb.3: # %entry
; MIPS64ELR6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64ELR6-NEXT:  # %bb.4: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, 16
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw min i16* %ptr, i16 %val seq_cst
  ret i16 %0
}

define i16 @test_umax_16(i16* nocapture %ptr, i16 signext %val) {
; MIPS-LABEL: test_umax_16:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    addiu $sp, $sp, -8
; MIPS-NEXT:    .cfi_def_cfa_offset 8
; MIPS-NEXT:    move $1, $5
; MIPS-NEXT:    sync
; MIPS-NEXT:    addiu $2, $zero, -4
; MIPS-NEXT:    and $2, $4, $2
; MIPS-NEXT:    andi $3, $4, 3
; MIPS-NEXT:    xori $3, $3, 2
; MIPS-NEXT:    sll $3, $3, 3
; MIPS-NEXT:    ori $4, $zero, 65535
; MIPS-NEXT:    sllv $4, $4, $3
; MIPS-NEXT:    nor $6, $zero, $4
; MIPS-NEXT:    sllv $5, $5, $3
; MIPS-NEXT:  $BB6_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $8, 0($2)
; MIPS-NEXT:    sltu $11, $8, $5
; MIPS-NEXT:    move $9, $8
; MIPS-NEXT:    movn $9, $5, $11
; MIPS-NEXT:    and $9, $9, $4
; MIPS-NEXT:    and $10, $8, $6
; MIPS-NEXT:    or $10, $10, $9
; MIPS-NEXT:    sc $10, 0($2)
; MIPS-NEXT:    beqz $10, $BB6_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    and $7, $8, $4
; MIPS-NEXT:    srlv $7, $7, $3
; MIPS-NEXT:    seh $7, $7
; MIPS-NEXT:  # %bb.3: # %entry
; MIPS-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPS-NEXT:  # %bb.4: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPS-NEXT:    addiu $sp, $sp, 8
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_umax_16:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    addiu $sp, $sp, -8
; MIPSR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSR6-NEXT:    move $1, $5
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    addiu $2, $zero, -4
; MIPSR6-NEXT:    and $2, $4, $2
; MIPSR6-NEXT:    andi $3, $4, 3
; MIPSR6-NEXT:    xori $3, $3, 2
; MIPSR6-NEXT:    sll $3, $3, 3
; MIPSR6-NEXT:    ori $4, $zero, 65535
; MIPSR6-NEXT:    sllv $4, $4, $3
; MIPSR6-NEXT:    nor $6, $zero, $4
; MIPSR6-NEXT:    sllv $5, $5, $3
; MIPSR6-NEXT:  $BB6_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $8, 0($2)
; MIPSR6-NEXT:    sltu $11, $8, $5
; MIPSR6-NEXT:    seleqz $9, $8, $11
; MIPSR6-NEXT:    selnez $11, $5, $11
; MIPSR6-NEXT:    or $9, $9, $11
; MIPSR6-NEXT:    and $9, $9, $4
; MIPSR6-NEXT:    and $10, $8, $6
; MIPSR6-NEXT:    or $10, $10, $9
; MIPSR6-NEXT:    sc $10, 0($2)
; MIPSR6-NEXT:    beqzc $10, $BB6_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    and $7, $8, $4
; MIPSR6-NEXT:    srlv $7, $7, $3
; MIPSR6-NEXT:    seh $7, $7
; MIPSR6-NEXT:  # %bb.3: # %entry
; MIPSR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSR6-NEXT:  # %bb.4: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSR6-NEXT:    addiu $sp, $sp, 8
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_umax_16:
; MM:       # %bb.0: # %entry
; MM-NEXT:    addiu $sp, $sp, -8
; MM-NEXT:    .cfi_def_cfa_offset 8
; MM-NEXT:    move $1, $5
; MM-NEXT:    sync
; MM-NEXT:    addiu $2, $zero, -4
; MM-NEXT:    and $2, $4, $2
; MM-NEXT:    andi $3, $4, 3
; MM-NEXT:    xori $3, $3, 2
; MM-NEXT:    sll $3, $3, 3
; MM-NEXT:    ori $4, $zero, 65535
; MM-NEXT:    sllv $4, $4, $3
; MM-NEXT:    nor $6, $zero, $4
; MM-NEXT:    sllv $5, $5, $3
; MM-NEXT:  $BB6_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $8, 0($2)
; MM-NEXT:    sltu $11, $8, $5
; MM-NEXT:    or $9, $8, $zero
; MM-NEXT:    movn $9, $5, $11
; MM-NEXT:    and $9, $9, $4
; MM-NEXT:    and $10, $8, $6
; MM-NEXT:    or $10, $10, $9
; MM-NEXT:    sc $10, 0($2)
; MM-NEXT:    beqzc $10, $BB6_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    and $7, $8, $4
; MM-NEXT:    srlv $7, $7, $3
; MM-NEXT:    seh $7, $7
; MM-NEXT:  # %bb.3: # %entry
; MM-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MM-NEXT:  # %bb.4: # %entry
; MM-NEXT:    sync
; MM-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MM-NEXT:    addiusp 8
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_umax_16:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    addiu $sp, $sp, -8
; MMR6-NEXT:    .cfi_def_cfa_offset 8
; MMR6-NEXT:    move $1, $5
; MMR6-NEXT:    sync
; MMR6-NEXT:    addiu $2, $zero, -4
; MMR6-NEXT:    and $2, $4, $2
; MMR6-NEXT:    andi $3, $4, 3
; MMR6-NEXT:    xori $3, $3, 2
; MMR6-NEXT:    sll $3, $3, 3
; MMR6-NEXT:    ori $4, $zero, 65535
; MMR6-NEXT:    sllv $4, $4, $3
; MMR6-NEXT:    nor $6, $zero, $4
; MMR6-NEXT:    sllv $5, $5, $3
; MMR6-NEXT:  $BB6_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $8, 0($2)
; MMR6-NEXT:    sltu $11, $8, $5
; MMR6-NEXT:    seleqz $9, $8, $11
; MMR6-NEXT:    selnez $11, $5, $11
; MMR6-NEXT:    or $9, $9, $11
; MMR6-NEXT:    and $9, $9, $4
; MMR6-NEXT:    and $10, $8, $6
; MMR6-NEXT:    or $10, $10, $9
; MMR6-NEXT:    sc $10, 0($2)
; MMR6-NEXT:    beqc $10, $zero, $BB6_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    and $7, $8, $4
; MMR6-NEXT:    srlv $7, $7, $3
; MMR6-NEXT:    seh $7, $7
; MMR6-NEXT:  # %bb.3: # %entry
; MMR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMR6-NEXT:  # %bb.4: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMR6-NEXT:    addiu $sp, $sp, 8
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_umax_16:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    addiu $sp, $sp, -8
; MIPSEL-NEXT:    .cfi_def_cfa_offset 8
; MIPSEL-NEXT:    move $1, $5
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    addiu $2, $zero, -4
; MIPSEL-NEXT:    and $2, $4, $2
; MIPSEL-NEXT:    andi $3, $4, 3
; MIPSEL-NEXT:    sll $3, $3, 3
; MIPSEL-NEXT:    ori $4, $zero, 65535
; MIPSEL-NEXT:    sllv $4, $4, $3
; MIPSEL-NEXT:    nor $6, $zero, $4
; MIPSEL-NEXT:    sllv $5, $5, $3
; MIPSEL-NEXT:  $BB6_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $8, 0($2)
; MIPSEL-NEXT:    and $8, $8, $4
; MIPSEL-NEXT:    and $5, $5, $4
; MIPSEL-NEXT:    sltu $11, $8, $5
; MIPSEL-NEXT:    move $9, $8
; MIPSEL-NEXT:    movn $9, $5, $11
; MIPSEL-NEXT:    and $9, $9, $4
; MIPSEL-NEXT:    and $10, $8, $6
; MIPSEL-NEXT:    or $10, $10, $9
; MIPSEL-NEXT:    sc $10, 0($2)
; MIPSEL-NEXT:    beqz $10, $BB6_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    and $7, $8, $4
; MIPSEL-NEXT:    srlv $7, $7, $3
; MIPSEL-NEXT:    seh $7, $7
; MIPSEL-NEXT:  # %bb.3: # %entry
; MIPSEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:  # %bb.4: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    addiu $sp, $sp, 8
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_umax_16:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    addiu $sp, $sp, -8
; MIPSELR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSELR6-NEXT:    move $1, $5
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    addiu $2, $zero, -4
; MIPSELR6-NEXT:    and $2, $4, $2
; MIPSELR6-NEXT:    andi $3, $4, 3
; MIPSELR6-NEXT:    sll $3, $3, 3
; MIPSELR6-NEXT:    ori $4, $zero, 65535
; MIPSELR6-NEXT:    sllv $4, $4, $3
; MIPSELR6-NEXT:    nor $6, $zero, $4
; MIPSELR6-NEXT:    sllv $5, $5, $3
; MIPSELR6-NEXT:  $BB6_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $8, 0($2)
; MIPSELR6-NEXT:    and $8, $8, $4
; MIPSELR6-NEXT:    and $5, $5, $4
; MIPSELR6-NEXT:    sltu $11, $8, $5
; MIPSELR6-NEXT:    seleqz $9, $8, $11
; MIPSELR6-NEXT:    selnez $11, $5, $11
; MIPSELR6-NEXT:    or $9, $9, $11
; MIPSELR6-NEXT:    and $9, $9, $4
; MIPSELR6-NEXT:    and $10, $8, $6
; MIPSELR6-NEXT:    or $10, $10, $9
; MIPSELR6-NEXT:    sc $10, 0($2)
; MIPSELR6-NEXT:    beqzc $10, $BB6_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    and $7, $8, $4
; MIPSELR6-NEXT:    srlv $7, $7, $3
; MIPSELR6-NEXT:    seh $7, $7
; MIPSELR6-NEXT:  # %bb.3: # %entry
; MIPSELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSELR6-NEXT:  # %bb.4: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSELR6-NEXT:    addiu $sp, $sp, 8
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_umax_16:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    addiu $sp, $sp, -8
; MMEL-NEXT:    .cfi_def_cfa_offset 8
; MMEL-NEXT:    move $1, $5
; MMEL-NEXT:    sync
; MMEL-NEXT:    addiu $2, $zero, -4
; MMEL-NEXT:    and $2, $4, $2
; MMEL-NEXT:    andi $3, $4, 3
; MMEL-NEXT:    sll $3, $3, 3
; MMEL-NEXT:    ori $4, $zero, 65535
; MMEL-NEXT:    sllv $4, $4, $3
; MMEL-NEXT:    nor $6, $zero, $4
; MMEL-NEXT:    sllv $5, $5, $3
; MMEL-NEXT:  $BB6_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $8, 0($2)
; MMEL-NEXT:    and $8, $8, $4
; MMEL-NEXT:    and $5, $5, $4
; MMEL-NEXT:    sltu $11, $8, $5
; MMEL-NEXT:    or $9, $8, $zero
; MMEL-NEXT:    movn $9, $5, $11
; MMEL-NEXT:    and $9, $9, $4
; MMEL-NEXT:    and $10, $8, $6
; MMEL-NEXT:    or $10, $10, $9
; MMEL-NEXT:    sc $10, 0($2)
; MMEL-NEXT:    beqzc $10, $BB6_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    and $7, $8, $4
; MMEL-NEXT:    srlv $7, $7, $3
; MMEL-NEXT:    seh $7, $7
; MMEL-NEXT:  # %bb.3: # %entry
; MMEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMEL-NEXT:  # %bb.4: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMEL-NEXT:    addiusp 8
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_umax_16:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    addiu $sp, $sp, -8
; MMELR6-NEXT:    .cfi_def_cfa_offset 8
; MMELR6-NEXT:    move $1, $5
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    addiu $2, $zero, -4
; MMELR6-NEXT:    and $2, $4, $2
; MMELR6-NEXT:    andi $3, $4, 3
; MMELR6-NEXT:    sll $3, $3, 3
; MMELR6-NEXT:    ori $4, $zero, 65535
; MMELR6-NEXT:    sllv $4, $4, $3
; MMELR6-NEXT:    nor $6, $zero, $4
; MMELR6-NEXT:    sllv $5, $5, $3
; MMELR6-NEXT:  $BB6_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $8, 0($2)
; MMELR6-NEXT:    and $8, $8, $4
; MMELR6-NEXT:    and $5, $5, $4
; MMELR6-NEXT:    sltu $11, $8, $5
; MMELR6-NEXT:    seleqz $9, $8, $11
; MMELR6-NEXT:    selnez $11, $5, $11
; MMELR6-NEXT:    or $9, $9, $11
; MMELR6-NEXT:    and $9, $9, $4
; MMELR6-NEXT:    and $10, $8, $6
; MMELR6-NEXT:    or $10, $10, $9
; MMELR6-NEXT:    sc $10, 0($2)
; MMELR6-NEXT:    beqc $10, $zero, $BB6_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    and $7, $8, $4
; MMELR6-NEXT:    srlv $7, $7, $3
; MMELR6-NEXT:    seh $7, $7
; MMELR6-NEXT:  # %bb.3: # %entry
; MMELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMELR6-NEXT:  # %bb.4: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMELR6-NEXT:    addiu $sp, $sp, 8
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_umax_16:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    daddiu $1, $zero, -4
; MIPS64-NEXT:    and $1, $4, $1
; MIPS64-NEXT:    andi $2, $4, 3
; MIPS64-NEXT:    xori $2, $2, 2
; MIPS64-NEXT:    sll $2, $2, 3
; MIPS64-NEXT:    ori $3, $zero, 65535
; MIPS64-NEXT:    sllv $3, $3, $2
; MIPS64-NEXT:    nor $6, $zero, $3
; MIPS64-NEXT:    sllv $5, $5, $2
; MIPS64-NEXT:  .LBB6_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $8, 0($1)
; MIPS64-NEXT:    sltu $11, $8, $5
; MIPS64-NEXT:    move $9, $8
; MIPS64-NEXT:    movn $9, $5, $11
; MIPS64-NEXT:    and $9, $9, $3
; MIPS64-NEXT:    and $10, $8, $6
; MIPS64-NEXT:    or $10, $10, $9
; MIPS64-NEXT:    sc $10, 0($1)
; MIPS64-NEXT:    beqz $10, .LBB6_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    and $7, $8, $3
; MIPS64-NEXT:    srlv $7, $7, $2
; MIPS64-NEXT:    seh $7, $7
; MIPS64-NEXT:  # %bb.3: # %entry
; MIPS64-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64-NEXT:  # %bb.4: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_umax_16:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    daddiu $sp, $sp, -16
; MIPS64R6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    daddiu $1, $zero, -4
; MIPS64R6-NEXT:    and $1, $4, $1
; MIPS64R6-NEXT:    andi $2, $4, 3
; MIPS64R6-NEXT:    xori $2, $2, 2
; MIPS64R6-NEXT:    sll $2, $2, 3
; MIPS64R6-NEXT:    ori $3, $zero, 65535
; MIPS64R6-NEXT:    sllv $3, $3, $2
; MIPS64R6-NEXT:    nor $6, $zero, $3
; MIPS64R6-NEXT:    sllv $5, $5, $2
; MIPS64R6-NEXT:  .LBB6_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $8, 0($1)
; MIPS64R6-NEXT:    sltu $11, $8, $5
; MIPS64R6-NEXT:    seleqz $9, $8, $11
; MIPS64R6-NEXT:    selnez $11, $5, $11
; MIPS64R6-NEXT:    or $9, $9, $11
; MIPS64R6-NEXT:    and $9, $9, $3
; MIPS64R6-NEXT:    and $10, $8, $6
; MIPS64R6-NEXT:    or $10, $10, $9
; MIPS64R6-NEXT:    sc $10, 0($1)
; MIPS64R6-NEXT:    beqzc $10, .LBB6_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    and $7, $8, $3
; MIPS64R6-NEXT:    srlv $7, $7, $2
; MIPS64R6-NEXT:    seh $7, $7
; MIPS64R6-NEXT:  # %bb.3: # %entry
; MIPS64R6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64R6-NEXT:  # %bb.4: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64R6-NEXT:    daddiu $sp, $sp, 16
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_umax_16:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    daddiu $sp, $sp, -16
; MIPS64EL-NEXT:    .cfi_def_cfa_offset 16
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    daddiu $1, $zero, -4
; MIPS64EL-NEXT:    and $1, $4, $1
; MIPS64EL-NEXT:    andi $2, $4, 3
; MIPS64EL-NEXT:    sll $2, $2, 3
; MIPS64EL-NEXT:    ori $3, $zero, 65535
; MIPS64EL-NEXT:    sllv $3, $3, $2
; MIPS64EL-NEXT:    nor $6, $zero, $3
; MIPS64EL-NEXT:    sllv $5, $5, $2
; MIPS64EL-NEXT:  .LBB6_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $8, 0($1)
; MIPS64EL-NEXT:    and $8, $8, $3
; MIPS64EL-NEXT:    and $5, $5, $3
; MIPS64EL-NEXT:    sltu $11, $8, $5
; MIPS64EL-NEXT:    move $9, $8
; MIPS64EL-NEXT:    movn $9, $5, $11
; MIPS64EL-NEXT:    and $9, $9, $3
; MIPS64EL-NEXT:    and $10, $8, $6
; MIPS64EL-NEXT:    or $10, $10, $9
; MIPS64EL-NEXT:    sc $10, 0($1)
; MIPS64EL-NEXT:    beqz $10, .LBB6_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    and $7, $8, $3
; MIPS64EL-NEXT:    srlv $7, $7, $2
; MIPS64EL-NEXT:    seh $7, $7
; MIPS64EL-NEXT:  # %bb.3: # %entry
; MIPS64EL-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64EL-NEXT:  # %bb.4: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64EL-NEXT:    daddiu $sp, $sp, 16
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_umax_16:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, -16
; MIPS64ELR6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    daddiu $1, $zero, -4
; MIPS64ELR6-NEXT:    and $1, $4, $1
; MIPS64ELR6-NEXT:    andi $2, $4, 3
; MIPS64ELR6-NEXT:    sll $2, $2, 3
; MIPS64ELR6-NEXT:    ori $3, $zero, 65535
; MIPS64ELR6-NEXT:    sllv $3, $3, $2
; MIPS64ELR6-NEXT:    nor $6, $zero, $3
; MIPS64ELR6-NEXT:    sllv $5, $5, $2
; MIPS64ELR6-NEXT:  .LBB6_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $8, 0($1)
; MIPS64ELR6-NEXT:    and $8, $8, $3
; MIPS64ELR6-NEXT:    and $5, $5, $3
; MIPS64ELR6-NEXT:    sltu $11, $8, $5
; MIPS64ELR6-NEXT:    seleqz $9, $8, $11
; MIPS64ELR6-NEXT:    selnez $11, $5, $11
; MIPS64ELR6-NEXT:    or $9, $9, $11
; MIPS64ELR6-NEXT:    and $9, $9, $3
; MIPS64ELR6-NEXT:    and $10, $8, $6
; MIPS64ELR6-NEXT:    or $10, $10, $9
; MIPS64ELR6-NEXT:    sc $10, 0($1)
; MIPS64ELR6-NEXT:    beqzc $10, .LBB6_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    and $7, $8, $3
; MIPS64ELR6-NEXT:    srlv $7, $7, $2
; MIPS64ELR6-NEXT:    seh $7, $7
; MIPS64ELR6-NEXT:  # %bb.3: # %entry
; MIPS64ELR6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64ELR6-NEXT:  # %bb.4: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, 16
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw umax i16* %ptr, i16 %val seq_cst
  ret i16 %0
}

define i16 @test_umin_16(i16* nocapture %ptr, i16 signext %val) {
; MIPS-LABEL: test_umin_16:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    addiu $sp, $sp, -8
; MIPS-NEXT:    .cfi_def_cfa_offset 8
; MIPS-NEXT:    move $1, $5
; MIPS-NEXT:    sync
; MIPS-NEXT:    addiu $2, $zero, -4
; MIPS-NEXT:    and $2, $4, $2
; MIPS-NEXT:    andi $3, $4, 3
; MIPS-NEXT:    xori $3, $3, 2
; MIPS-NEXT:    sll $3, $3, 3
; MIPS-NEXT:    ori $4, $zero, 65535
; MIPS-NEXT:    sllv $4, $4, $3
; MIPS-NEXT:    nor $6, $zero, $4
; MIPS-NEXT:    sllv $5, $5, $3
; MIPS-NEXT:  $BB7_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $8, 0($2)
; MIPS-NEXT:    sltu $11, $8, $5
; MIPS-NEXT:    move $9, $8
; MIPS-NEXT:    movz $9, $5, $11
; MIPS-NEXT:    and $9, $9, $4
; MIPS-NEXT:    and $10, $8, $6
; MIPS-NEXT:    or $10, $10, $9
; MIPS-NEXT:    sc $10, 0($2)
; MIPS-NEXT:    beqz $10, $BB7_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    and $7, $8, $4
; MIPS-NEXT:    srlv $7, $7, $3
; MIPS-NEXT:    seh $7, $7
; MIPS-NEXT:  # %bb.3: # %entry
; MIPS-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPS-NEXT:  # %bb.4: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPS-NEXT:    addiu $sp, $sp, 8
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_umin_16:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    addiu $sp, $sp, -8
; MIPSR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSR6-NEXT:    move $1, $5
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    addiu $2, $zero, -4
; MIPSR6-NEXT:    and $2, $4, $2
; MIPSR6-NEXT:    andi $3, $4, 3
; MIPSR6-NEXT:    xori $3, $3, 2
; MIPSR6-NEXT:    sll $3, $3, 3
; MIPSR6-NEXT:    ori $4, $zero, 65535
; MIPSR6-NEXT:    sllv $4, $4, $3
; MIPSR6-NEXT:    nor $6, $zero, $4
; MIPSR6-NEXT:    sllv $5, $5, $3
; MIPSR6-NEXT:  $BB7_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $8, 0($2)
; MIPSR6-NEXT:    sltu $11, $8, $5
; MIPSR6-NEXT:    selnez $9, $8, $11
; MIPSR6-NEXT:    seleqz $11, $5, $11
; MIPSR6-NEXT:    or $9, $9, $11
; MIPSR6-NEXT:    and $9, $9, $4
; MIPSR6-NEXT:    and $10, $8, $6
; MIPSR6-NEXT:    or $10, $10, $9
; MIPSR6-NEXT:    sc $10, 0($2)
; MIPSR6-NEXT:    beqzc $10, $BB7_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    and $7, $8, $4
; MIPSR6-NEXT:    srlv $7, $7, $3
; MIPSR6-NEXT:    seh $7, $7
; MIPSR6-NEXT:  # %bb.3: # %entry
; MIPSR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSR6-NEXT:  # %bb.4: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSR6-NEXT:    addiu $sp, $sp, 8
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_umin_16:
; MM:       # %bb.0: # %entry
; MM-NEXT:    addiu $sp, $sp, -8
; MM-NEXT:    .cfi_def_cfa_offset 8
; MM-NEXT:    move $1, $5
; MM-NEXT:    sync
; MM-NEXT:    addiu $2, $zero, -4
; MM-NEXT:    and $2, $4, $2
; MM-NEXT:    andi $3, $4, 3
; MM-NEXT:    xori $3, $3, 2
; MM-NEXT:    sll $3, $3, 3
; MM-NEXT:    ori $4, $zero, 65535
; MM-NEXT:    sllv $4, $4, $3
; MM-NEXT:    nor $6, $zero, $4
; MM-NEXT:    sllv $5, $5, $3
; MM-NEXT:  $BB7_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $8, 0($2)
; MM-NEXT:    sltu $11, $8, $5
; MM-NEXT:    or $9, $8, $zero
; MM-NEXT:    movz $9, $5, $11
; MM-NEXT:    and $9, $9, $4
; MM-NEXT:    and $10, $8, $6
; MM-NEXT:    or $10, $10, $9
; MM-NEXT:    sc $10, 0($2)
; MM-NEXT:    beqzc $10, $BB7_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    and $7, $8, $4
; MM-NEXT:    srlv $7, $7, $3
; MM-NEXT:    seh $7, $7
; MM-NEXT:  # %bb.3: # %entry
; MM-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MM-NEXT:  # %bb.4: # %entry
; MM-NEXT:    sync
; MM-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MM-NEXT:    addiusp 8
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_umin_16:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    addiu $sp, $sp, -8
; MMR6-NEXT:    .cfi_def_cfa_offset 8
; MMR6-NEXT:    move $1, $5
; MMR6-NEXT:    sync
; MMR6-NEXT:    addiu $2, $zero, -4
; MMR6-NEXT:    and $2, $4, $2
; MMR6-NEXT:    andi $3, $4, 3
; MMR6-NEXT:    xori $3, $3, 2
; MMR6-NEXT:    sll $3, $3, 3
; MMR6-NEXT:    ori $4, $zero, 65535
; MMR6-NEXT:    sllv $4, $4, $3
; MMR6-NEXT:    nor $6, $zero, $4
; MMR6-NEXT:    sllv $5, $5, $3
; MMR6-NEXT:  $BB7_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $8, 0($2)
; MMR6-NEXT:    sltu $11, $8, $5
; MMR6-NEXT:    selnez $9, $8, $11
; MMR6-NEXT:    seleqz $11, $5, $11
; MMR6-NEXT:    or $9, $9, $11
; MMR6-NEXT:    and $9, $9, $4
; MMR6-NEXT:    and $10, $8, $6
; MMR6-NEXT:    or $10, $10, $9
; MMR6-NEXT:    sc $10, 0($2)
; MMR6-NEXT:    beqc $10, $zero, $BB7_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    and $7, $8, $4
; MMR6-NEXT:    srlv $7, $7, $3
; MMR6-NEXT:    seh $7, $7
; MMR6-NEXT:  # %bb.3: # %entry
; MMR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMR6-NEXT:  # %bb.4: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMR6-NEXT:    addiu $sp, $sp, 8
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_umin_16:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    addiu $sp, $sp, -8
; MIPSEL-NEXT:    .cfi_def_cfa_offset 8
; MIPSEL-NEXT:    move $1, $5
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    addiu $2, $zero, -4
; MIPSEL-NEXT:    and $2, $4, $2
; MIPSEL-NEXT:    andi $3, $4, 3
; MIPSEL-NEXT:    sll $3, $3, 3
; MIPSEL-NEXT:    ori $4, $zero, 65535
; MIPSEL-NEXT:    sllv $4, $4, $3
; MIPSEL-NEXT:    nor $6, $zero, $4
; MIPSEL-NEXT:    sllv $5, $5, $3
; MIPSEL-NEXT:  $BB7_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $8, 0($2)
; MIPSEL-NEXT:    and $8, $8, $4
; MIPSEL-NEXT:    and $5, $5, $4
; MIPSEL-NEXT:    sltu $11, $8, $5
; MIPSEL-NEXT:    move $9, $8
; MIPSEL-NEXT:    movz $9, $5, $11
; MIPSEL-NEXT:    and $9, $9, $4
; MIPSEL-NEXT:    and $10, $8, $6
; MIPSEL-NEXT:    or $10, $10, $9
; MIPSEL-NEXT:    sc $10, 0($2)
; MIPSEL-NEXT:    beqz $10, $BB7_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    and $7, $8, $4
; MIPSEL-NEXT:    srlv $7, $7, $3
; MIPSEL-NEXT:    seh $7, $7
; MIPSEL-NEXT:  # %bb.3: # %entry
; MIPSEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:  # %bb.4: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    addiu $sp, $sp, 8
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_umin_16:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    addiu $sp, $sp, -8
; MIPSELR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSELR6-NEXT:    move $1, $5
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    addiu $2, $zero, -4
; MIPSELR6-NEXT:    and $2, $4, $2
; MIPSELR6-NEXT:    andi $3, $4, 3
; MIPSELR6-NEXT:    sll $3, $3, 3
; MIPSELR6-NEXT:    ori $4, $zero, 65535
; MIPSELR6-NEXT:    sllv $4, $4, $3
; MIPSELR6-NEXT:    nor $6, $zero, $4
; MIPSELR6-NEXT:    sllv $5, $5, $3
; MIPSELR6-NEXT:  $BB7_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $8, 0($2)
; MIPSELR6-NEXT:    and $8, $8, $4
; MIPSELR6-NEXT:    and $5, $5, $4
; MIPSELR6-NEXT:    sltu $11, $8, $5
; MIPSELR6-NEXT:    selnez $9, $8, $11
; MIPSELR6-NEXT:    seleqz $11, $5, $11
; MIPSELR6-NEXT:    or $9, $9, $11
; MIPSELR6-NEXT:    and $9, $9, $4
; MIPSELR6-NEXT:    and $10, $8, $6
; MIPSELR6-NEXT:    or $10, $10, $9
; MIPSELR6-NEXT:    sc $10, 0($2)
; MIPSELR6-NEXT:    beqzc $10, $BB7_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    and $7, $8, $4
; MIPSELR6-NEXT:    srlv $7, $7, $3
; MIPSELR6-NEXT:    seh $7, $7
; MIPSELR6-NEXT:  # %bb.3: # %entry
; MIPSELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSELR6-NEXT:  # %bb.4: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSELR6-NEXT:    addiu $sp, $sp, 8
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_umin_16:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    addiu $sp, $sp, -8
; MMEL-NEXT:    .cfi_def_cfa_offset 8
; MMEL-NEXT:    move $1, $5
; MMEL-NEXT:    sync
; MMEL-NEXT:    addiu $2, $zero, -4
; MMEL-NEXT:    and $2, $4, $2
; MMEL-NEXT:    andi $3, $4, 3
; MMEL-NEXT:    sll $3, $3, 3
; MMEL-NEXT:    ori $4, $zero, 65535
; MMEL-NEXT:    sllv $4, $4, $3
; MMEL-NEXT:    nor $6, $zero, $4
; MMEL-NEXT:    sllv $5, $5, $3
; MMEL-NEXT:  $BB7_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $8, 0($2)
; MMEL-NEXT:    and $8, $8, $4
; MMEL-NEXT:    and $5, $5, $4
; MMEL-NEXT:    sltu $11, $8, $5
; MMEL-NEXT:    or $9, $8, $zero
; MMEL-NEXT:    movz $9, $5, $11
; MMEL-NEXT:    and $9, $9, $4
; MMEL-NEXT:    and $10, $8, $6
; MMEL-NEXT:    or $10, $10, $9
; MMEL-NEXT:    sc $10, 0($2)
; MMEL-NEXT:    beqzc $10, $BB7_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    and $7, $8, $4
; MMEL-NEXT:    srlv $7, $7, $3
; MMEL-NEXT:    seh $7, $7
; MMEL-NEXT:  # %bb.3: # %entry
; MMEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMEL-NEXT:  # %bb.4: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMEL-NEXT:    addiusp 8
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_umin_16:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    addiu $sp, $sp, -8
; MMELR6-NEXT:    .cfi_def_cfa_offset 8
; MMELR6-NEXT:    move $1, $5
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    addiu $2, $zero, -4
; MMELR6-NEXT:    and $2, $4, $2
; MMELR6-NEXT:    andi $3, $4, 3
; MMELR6-NEXT:    sll $3, $3, 3
; MMELR6-NEXT:    ori $4, $zero, 65535
; MMELR6-NEXT:    sllv $4, $4, $3
; MMELR6-NEXT:    nor $6, $zero, $4
; MMELR6-NEXT:    sllv $5, $5, $3
; MMELR6-NEXT:  $BB7_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $8, 0($2)
; MMELR6-NEXT:    and $8, $8, $4
; MMELR6-NEXT:    and $5, $5, $4
; MMELR6-NEXT:    sltu $11, $8, $5
; MMELR6-NEXT:    selnez $9, $8, $11
; MMELR6-NEXT:    seleqz $11, $5, $11
; MMELR6-NEXT:    or $9, $9, $11
; MMELR6-NEXT:    and $9, $9, $4
; MMELR6-NEXT:    and $10, $8, $6
; MMELR6-NEXT:    or $10, $10, $9
; MMELR6-NEXT:    sc $10, 0($2)
; MMELR6-NEXT:    beqc $10, $zero, $BB7_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    and $7, $8, $4
; MMELR6-NEXT:    srlv $7, $7, $3
; MMELR6-NEXT:    seh $7, $7
; MMELR6-NEXT:  # %bb.3: # %entry
; MMELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMELR6-NEXT:  # %bb.4: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMELR6-NEXT:    addiu $sp, $sp, 8
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_umin_16:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    daddiu $1, $zero, -4
; MIPS64-NEXT:    and $1, $4, $1
; MIPS64-NEXT:    andi $2, $4, 3
; MIPS64-NEXT:    xori $2, $2, 2
; MIPS64-NEXT:    sll $2, $2, 3
; MIPS64-NEXT:    ori $3, $zero, 65535
; MIPS64-NEXT:    sllv $3, $3, $2
; MIPS64-NEXT:    nor $6, $zero, $3
; MIPS64-NEXT:    sllv $5, $5, $2
; MIPS64-NEXT:  .LBB7_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $8, 0($1)
; MIPS64-NEXT:    sltu $11, $8, $5
; MIPS64-NEXT:    move $9, $8
; MIPS64-NEXT:    movz $9, $5, $11
; MIPS64-NEXT:    and $9, $9, $3
; MIPS64-NEXT:    and $10, $8, $6
; MIPS64-NEXT:    or $10, $10, $9
; MIPS64-NEXT:    sc $10, 0($1)
; MIPS64-NEXT:    beqz $10, .LBB7_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    and $7, $8, $3
; MIPS64-NEXT:    srlv $7, $7, $2
; MIPS64-NEXT:    seh $7, $7
; MIPS64-NEXT:  # %bb.3: # %entry
; MIPS64-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64-NEXT:  # %bb.4: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_umin_16:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    daddiu $sp, $sp, -16
; MIPS64R6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    daddiu $1, $zero, -4
; MIPS64R6-NEXT:    and $1, $4, $1
; MIPS64R6-NEXT:    andi $2, $4, 3
; MIPS64R6-NEXT:    xori $2, $2, 2
; MIPS64R6-NEXT:    sll $2, $2, 3
; MIPS64R6-NEXT:    ori $3, $zero, 65535
; MIPS64R6-NEXT:    sllv $3, $3, $2
; MIPS64R6-NEXT:    nor $6, $zero, $3
; MIPS64R6-NEXT:    sllv $5, $5, $2
; MIPS64R6-NEXT:  .LBB7_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $8, 0($1)
; MIPS64R6-NEXT:    sltu $11, $8, $5
; MIPS64R6-NEXT:    selnez $9, $8, $11
; MIPS64R6-NEXT:    seleqz $11, $5, $11
; MIPS64R6-NEXT:    or $9, $9, $11
; MIPS64R6-NEXT:    and $9, $9, $3
; MIPS64R6-NEXT:    and $10, $8, $6
; MIPS64R6-NEXT:    or $10, $10, $9
; MIPS64R6-NEXT:    sc $10, 0($1)
; MIPS64R6-NEXT:    beqzc $10, .LBB7_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    and $7, $8, $3
; MIPS64R6-NEXT:    srlv $7, $7, $2
; MIPS64R6-NEXT:    seh $7, $7
; MIPS64R6-NEXT:  # %bb.3: # %entry
; MIPS64R6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64R6-NEXT:  # %bb.4: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64R6-NEXT:    daddiu $sp, $sp, 16
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_umin_16:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    daddiu $sp, $sp, -16
; MIPS64EL-NEXT:    .cfi_def_cfa_offset 16
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    daddiu $1, $zero, -4
; MIPS64EL-NEXT:    and $1, $4, $1
; MIPS64EL-NEXT:    andi $2, $4, 3
; MIPS64EL-NEXT:    sll $2, $2, 3
; MIPS64EL-NEXT:    ori $3, $zero, 65535
; MIPS64EL-NEXT:    sllv $3, $3, $2
; MIPS64EL-NEXT:    nor $6, $zero, $3
; MIPS64EL-NEXT:    sllv $5, $5, $2
; MIPS64EL-NEXT:  .LBB7_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $8, 0($1)
; MIPS64EL-NEXT:    and $8, $8, $3
; MIPS64EL-NEXT:    and $5, $5, $3
; MIPS64EL-NEXT:    sltu $11, $8, $5
; MIPS64EL-NEXT:    move $9, $8
; MIPS64EL-NEXT:    movz $9, $5, $11
; MIPS64EL-NEXT:    and $9, $9, $3
; MIPS64EL-NEXT:    and $10, $8, $6
; MIPS64EL-NEXT:    or $10, $10, $9
; MIPS64EL-NEXT:    sc $10, 0($1)
; MIPS64EL-NEXT:    beqz $10, .LBB7_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    and $7, $8, $3
; MIPS64EL-NEXT:    srlv $7, $7, $2
; MIPS64EL-NEXT:    seh $7, $7
; MIPS64EL-NEXT:  # %bb.3: # %entry
; MIPS64EL-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64EL-NEXT:  # %bb.4: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64EL-NEXT:    daddiu $sp, $sp, 16
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_umin_16:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, -16
; MIPS64ELR6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    daddiu $1, $zero, -4
; MIPS64ELR6-NEXT:    and $1, $4, $1
; MIPS64ELR6-NEXT:    andi $2, $4, 3
; MIPS64ELR6-NEXT:    sll $2, $2, 3
; MIPS64ELR6-NEXT:    ori $3, $zero, 65535
; MIPS64ELR6-NEXT:    sllv $3, $3, $2
; MIPS64ELR6-NEXT:    nor $6, $zero, $3
; MIPS64ELR6-NEXT:    sllv $5, $5, $2
; MIPS64ELR6-NEXT:  .LBB7_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $8, 0($1)
; MIPS64ELR6-NEXT:    and $8, $8, $3
; MIPS64ELR6-NEXT:    and $5, $5, $3
; MIPS64ELR6-NEXT:    sltu $11, $8, $5
; MIPS64ELR6-NEXT:    selnez $9, $8, $11
; MIPS64ELR6-NEXT:    seleqz $11, $5, $11
; MIPS64ELR6-NEXT:    or $9, $9, $11
; MIPS64ELR6-NEXT:    and $9, $9, $3
; MIPS64ELR6-NEXT:    and $10, $8, $6
; MIPS64ELR6-NEXT:    or $10, $10, $9
; MIPS64ELR6-NEXT:    sc $10, 0($1)
; MIPS64ELR6-NEXT:    beqzc $10, .LBB7_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    and $7, $8, $3
; MIPS64ELR6-NEXT:    srlv $7, $7, $2
; MIPS64ELR6-NEXT:    seh $7, $7
; MIPS64ELR6-NEXT:  # %bb.3: # %entry
; MIPS64ELR6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64ELR6-NEXT:  # %bb.4: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, 16
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw umin i16* %ptr, i16 %val seq_cst
  ret i16 %0
}


define i8 @test_max_8(i8* nocapture %ptr, i8 signext %val) {
; MIPS-LABEL: test_max_8:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    addiu $sp, $sp, -8
; MIPS-NEXT:    .cfi_def_cfa_offset 8
; MIPS-NEXT:    move $1, $5
; MIPS-NEXT:    sync
; MIPS-NEXT:    addiu $2, $zero, -4
; MIPS-NEXT:    and $2, $4, $2
; MIPS-NEXT:    andi $3, $4, 3
; MIPS-NEXT:    xori $3, $3, 3
; MIPS-NEXT:    sll $3, $3, 3
; MIPS-NEXT:    ori $4, $zero, 255
; MIPS-NEXT:    sllv $4, $4, $3
; MIPS-NEXT:    nor $6, $zero, $4
; MIPS-NEXT:    sllv $5, $5, $3
; MIPS-NEXT:  $BB8_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $8, 0($2)
; MIPS-NEXT:    slt $11, $8, $5
; MIPS-NEXT:    move $9, $8
; MIPS-NEXT:    movn $9, $5, $11
; MIPS-NEXT:    and $9, $9, $4
; MIPS-NEXT:    and $10, $8, $6
; MIPS-NEXT:    or $10, $10, $9
; MIPS-NEXT:    sc $10, 0($2)
; MIPS-NEXT:    beqz $10, $BB8_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    and $7, $8, $4
; MIPS-NEXT:    srlv $7, $7, $3
; MIPS-NEXT:    seh $7, $7
; MIPS-NEXT:  # %bb.3: # %entry
; MIPS-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPS-NEXT:  # %bb.4: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPS-NEXT:    addiu $sp, $sp, 8
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_max_8:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    addiu $sp, $sp, -8
; MIPSR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSR6-NEXT:    move $1, $5
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    addiu $2, $zero, -4
; MIPSR6-NEXT:    and $2, $4, $2
; MIPSR6-NEXT:    andi $3, $4, 3
; MIPSR6-NEXT:    xori $3, $3, 3
; MIPSR6-NEXT:    sll $3, $3, 3
; MIPSR6-NEXT:    ori $4, $zero, 255
; MIPSR6-NEXT:    sllv $4, $4, $3
; MIPSR6-NEXT:    nor $6, $zero, $4
; MIPSR6-NEXT:    sllv $5, $5, $3
; MIPSR6-NEXT:  $BB8_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $8, 0($2)
; MIPSR6-NEXT:    slt $11, $8, $5
; MIPSR6-NEXT:    seleqz $9, $8, $11
; MIPSR6-NEXT:    selnez $11, $5, $11
; MIPSR6-NEXT:    or $9, $9, $11
; MIPSR6-NEXT:    and $9, $9, $4
; MIPSR6-NEXT:    and $10, $8, $6
; MIPSR6-NEXT:    or $10, $10, $9
; MIPSR6-NEXT:    sc $10, 0($2)
; MIPSR6-NEXT:    beqzc $10, $BB8_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    and $7, $8, $4
; MIPSR6-NEXT:    srlv $7, $7, $3
; MIPSR6-NEXT:    seh $7, $7
; MIPSR6-NEXT:  # %bb.3: # %entry
; MIPSR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSR6-NEXT:  # %bb.4: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSR6-NEXT:    addiu $sp, $sp, 8
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_max_8:
; MM:       # %bb.0: # %entry
; MM-NEXT:    addiu $sp, $sp, -8
; MM-NEXT:    .cfi_def_cfa_offset 8
; MM-NEXT:    move $1, $5
; MM-NEXT:    sync
; MM-NEXT:    addiu $2, $zero, -4
; MM-NEXT:    and $2, $4, $2
; MM-NEXT:    andi $3, $4, 3
; MM-NEXT:    xori $3, $3, 3
; MM-NEXT:    sll $3, $3, 3
; MM-NEXT:    ori $4, $zero, 255
; MM-NEXT:    sllv $4, $4, $3
; MM-NEXT:    nor $6, $zero, $4
; MM-NEXT:    sllv $5, $5, $3
; MM-NEXT:  $BB8_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $8, 0($2)
; MM-NEXT:    slt $11, $8, $5
; MM-NEXT:    or $9, $8, $zero
; MM-NEXT:    movn $9, $5, $11
; MM-NEXT:    and $9, $9, $4
; MM-NEXT:    and $10, $8, $6
; MM-NEXT:    or $10, $10, $9
; MM-NEXT:    sc $10, 0($2)
; MM-NEXT:    beqzc $10, $BB8_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    and $7, $8, $4
; MM-NEXT:    srlv $7, $7, $3
; MM-NEXT:    seh $7, $7
; MM-NEXT:  # %bb.3: # %entry
; MM-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MM-NEXT:  # %bb.4: # %entry
; MM-NEXT:    sync
; MM-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MM-NEXT:    addiusp 8
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_max_8:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    addiu $sp, $sp, -8
; MMR6-NEXT:    .cfi_def_cfa_offset 8
; MMR6-NEXT:    move $1, $5
; MMR6-NEXT:    sync
; MMR6-NEXT:    addiu $2, $zero, -4
; MMR6-NEXT:    and $2, $4, $2
; MMR6-NEXT:    andi $3, $4, 3
; MMR6-NEXT:    xori $3, $3, 3
; MMR6-NEXT:    sll $3, $3, 3
; MMR6-NEXT:    ori $4, $zero, 255
; MMR6-NEXT:    sllv $4, $4, $3
; MMR6-NEXT:    nor $6, $zero, $4
; MMR6-NEXT:    sllv $5, $5, $3
; MMR6-NEXT:  $BB8_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $8, 0($2)
; MMR6-NEXT:    slt $11, $8, $5
; MMR6-NEXT:    seleqz $9, $8, $11
; MMR6-NEXT:    selnez $11, $5, $11
; MMR6-NEXT:    or $9, $9, $11
; MMR6-NEXT:    and $9, $9, $4
; MMR6-NEXT:    and $10, $8, $6
; MMR6-NEXT:    or $10, $10, $9
; MMR6-NEXT:    sc $10, 0($2)
; MMR6-NEXT:    beqc $10, $zero, $BB8_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    and $7, $8, $4
; MMR6-NEXT:    srlv $7, $7, $3
; MMR6-NEXT:    seh $7, $7
; MMR6-NEXT:  # %bb.3: # %entry
; MMR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMR6-NEXT:  # %bb.4: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMR6-NEXT:    addiu $sp, $sp, 8
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_max_8:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    addiu $sp, $sp, -8
; MIPSEL-NEXT:    .cfi_def_cfa_offset 8
; MIPSEL-NEXT:    move $1, $5
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    addiu $2, $zero, -4
; MIPSEL-NEXT:    and $2, $4, $2
; MIPSEL-NEXT:    andi $3, $4, 3
; MIPSEL-NEXT:    sll $3, $3, 3
; MIPSEL-NEXT:    ori $4, $zero, 255
; MIPSEL-NEXT:    sllv $4, $4, $3
; MIPSEL-NEXT:    nor $6, $zero, $4
; MIPSEL-NEXT:    sllv $5, $5, $3
; MIPSEL-NEXT:  $BB8_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $8, 0($2)
; MIPSEL-NEXT:    and $8, $8, $4
; MIPSEL-NEXT:    and $5, $5, $4
; MIPSEL-NEXT:    slt $11, $8, $5
; MIPSEL-NEXT:    move $9, $8
; MIPSEL-NEXT:    movn $9, $5, $11
; MIPSEL-NEXT:    and $9, $9, $4
; MIPSEL-NEXT:    and $10, $8, $6
; MIPSEL-NEXT:    or $10, $10, $9
; MIPSEL-NEXT:    sc $10, 0($2)
; MIPSEL-NEXT:    beqz $10, $BB8_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    and $7, $8, $4
; MIPSEL-NEXT:    srlv $7, $7, $3
; MIPSEL-NEXT:    seh $7, $7
; MIPSEL-NEXT:  # %bb.3: # %entry
; MIPSEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:  # %bb.4: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    addiu $sp, $sp, 8
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_max_8:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    addiu $sp, $sp, -8
; MIPSELR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSELR6-NEXT:    move $1, $5
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    addiu $2, $zero, -4
; MIPSELR6-NEXT:    and $2, $4, $2
; MIPSELR6-NEXT:    andi $3, $4, 3
; MIPSELR6-NEXT:    sll $3, $3, 3
; MIPSELR6-NEXT:    ori $4, $zero, 255
; MIPSELR6-NEXT:    sllv $4, $4, $3
; MIPSELR6-NEXT:    nor $6, $zero, $4
; MIPSELR6-NEXT:    sllv $5, $5, $3
; MIPSELR6-NEXT:  $BB8_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $8, 0($2)
; MIPSELR6-NEXT:    and $8, $8, $4
; MIPSELR6-NEXT:    and $5, $5, $4
; MIPSELR6-NEXT:    slt $11, $8, $5
; MIPSELR6-NEXT:    seleqz $9, $8, $11
; MIPSELR6-NEXT:    selnez $11, $5, $11
; MIPSELR6-NEXT:    or $9, $9, $11
; MIPSELR6-NEXT:    and $9, $9, $4
; MIPSELR6-NEXT:    and $10, $8, $6
; MIPSELR6-NEXT:    or $10, $10, $9
; MIPSELR6-NEXT:    sc $10, 0($2)
; MIPSELR6-NEXT:    beqzc $10, $BB8_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    and $7, $8, $4
; MIPSELR6-NEXT:    srlv $7, $7, $3
; MIPSELR6-NEXT:    seh $7, $7
; MIPSELR6-NEXT:  # %bb.3: # %entry
; MIPSELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSELR6-NEXT:  # %bb.4: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSELR6-NEXT:    addiu $sp, $sp, 8
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_max_8:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    addiu $sp, $sp, -8
; MMEL-NEXT:    .cfi_def_cfa_offset 8
; MMEL-NEXT:    move $1, $5
; MMEL-NEXT:    sync
; MMEL-NEXT:    addiu $2, $zero, -4
; MMEL-NEXT:    and $2, $4, $2
; MMEL-NEXT:    andi $3, $4, 3
; MMEL-NEXT:    sll $3, $3, 3
; MMEL-NEXT:    ori $4, $zero, 255
; MMEL-NEXT:    sllv $4, $4, $3
; MMEL-NEXT:    nor $6, $zero, $4
; MMEL-NEXT:    sllv $5, $5, $3
; MMEL-NEXT:  $BB8_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $8, 0($2)
; MMEL-NEXT:    and $8, $8, $4
; MMEL-NEXT:    and $5, $5, $4
; MMEL-NEXT:    slt $11, $8, $5
; MMEL-NEXT:    or $9, $8, $zero
; MMEL-NEXT:    movn $9, $5, $11
; MMEL-NEXT:    and $9, $9, $4
; MMEL-NEXT:    and $10, $8, $6
; MMEL-NEXT:    or $10, $10, $9
; MMEL-NEXT:    sc $10, 0($2)
; MMEL-NEXT:    beqzc $10, $BB8_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    and $7, $8, $4
; MMEL-NEXT:    srlv $7, $7, $3
; MMEL-NEXT:    seh $7, $7
; MMEL-NEXT:  # %bb.3: # %entry
; MMEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMEL-NEXT:  # %bb.4: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMEL-NEXT:    addiusp 8
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_max_8:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    addiu $sp, $sp, -8
; MMELR6-NEXT:    .cfi_def_cfa_offset 8
; MMELR6-NEXT:    move $1, $5
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    addiu $2, $zero, -4
; MMELR6-NEXT:    and $2, $4, $2
; MMELR6-NEXT:    andi $3, $4, 3
; MMELR6-NEXT:    sll $3, $3, 3
; MMELR6-NEXT:    ori $4, $zero, 255
; MMELR6-NEXT:    sllv $4, $4, $3
; MMELR6-NEXT:    nor $6, $zero, $4
; MMELR6-NEXT:    sllv $5, $5, $3
; MMELR6-NEXT:  $BB8_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $8, 0($2)
; MMELR6-NEXT:    and $8, $8, $4
; MMELR6-NEXT:    and $5, $5, $4
; MMELR6-NEXT:    slt $11, $8, $5
; MMELR6-NEXT:    seleqz $9, $8, $11
; MMELR6-NEXT:    selnez $11, $5, $11
; MMELR6-NEXT:    or $9, $9, $11
; MMELR6-NEXT:    and $9, $9, $4
; MMELR6-NEXT:    and $10, $8, $6
; MMELR6-NEXT:    or $10, $10, $9
; MMELR6-NEXT:    sc $10, 0($2)
; MMELR6-NEXT:    beqc $10, $zero, $BB8_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    and $7, $8, $4
; MMELR6-NEXT:    srlv $7, $7, $3
; MMELR6-NEXT:    seh $7, $7
; MMELR6-NEXT:  # %bb.3: # %entry
; MMELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMELR6-NEXT:  # %bb.4: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMELR6-NEXT:    addiu $sp, $sp, 8
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_max_8:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    daddiu $1, $zero, -4
; MIPS64-NEXT:    and $1, $4, $1
; MIPS64-NEXT:    andi $2, $4, 3
; MIPS64-NEXT:    xori $2, $2, 3
; MIPS64-NEXT:    sll $2, $2, 3
; MIPS64-NEXT:    ori $3, $zero, 255
; MIPS64-NEXT:    sllv $3, $3, $2
; MIPS64-NEXT:    nor $6, $zero, $3
; MIPS64-NEXT:    sllv $5, $5, $2
; MIPS64-NEXT:  .LBB8_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $8, 0($1)
; MIPS64-NEXT:    slt $11, $8, $5
; MIPS64-NEXT:    move $9, $8
; MIPS64-NEXT:    movn $9, $5, $11
; MIPS64-NEXT:    and $9, $9, $3
; MIPS64-NEXT:    and $10, $8, $6
; MIPS64-NEXT:    or $10, $10, $9
; MIPS64-NEXT:    sc $10, 0($1)
; MIPS64-NEXT:    beqz $10, .LBB8_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    and $7, $8, $3
; MIPS64-NEXT:    srlv $7, $7, $2
; MIPS64-NEXT:    seh $7, $7
; MIPS64-NEXT:  # %bb.3: # %entry
; MIPS64-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64-NEXT:  # %bb.4: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_max_8:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    daddiu $sp, $sp, -16
; MIPS64R6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    daddiu $1, $zero, -4
; MIPS64R6-NEXT:    and $1, $4, $1
; MIPS64R6-NEXT:    andi $2, $4, 3
; MIPS64R6-NEXT:    xori $2, $2, 3
; MIPS64R6-NEXT:    sll $2, $2, 3
; MIPS64R6-NEXT:    ori $3, $zero, 255
; MIPS64R6-NEXT:    sllv $3, $3, $2
; MIPS64R6-NEXT:    nor $6, $zero, $3
; MIPS64R6-NEXT:    sllv $5, $5, $2
; MIPS64R6-NEXT:  .LBB8_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $8, 0($1)
; MIPS64R6-NEXT:    slt $11, $8, $5
; MIPS64R6-NEXT:    seleqz $9, $8, $11
; MIPS64R6-NEXT:    selnez $11, $5, $11
; MIPS64R6-NEXT:    or $9, $9, $11
; MIPS64R6-NEXT:    and $9, $9, $3
; MIPS64R6-NEXT:    and $10, $8, $6
; MIPS64R6-NEXT:    or $10, $10, $9
; MIPS64R6-NEXT:    sc $10, 0($1)
; MIPS64R6-NEXT:    beqzc $10, .LBB8_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    and $7, $8, $3
; MIPS64R6-NEXT:    srlv $7, $7, $2
; MIPS64R6-NEXT:    seh $7, $7
; MIPS64R6-NEXT:  # %bb.3: # %entry
; MIPS64R6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64R6-NEXT:  # %bb.4: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64R6-NEXT:    daddiu $sp, $sp, 16
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_max_8:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    daddiu $sp, $sp, -16
; MIPS64EL-NEXT:    .cfi_def_cfa_offset 16
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    daddiu $1, $zero, -4
; MIPS64EL-NEXT:    and $1, $4, $1
; MIPS64EL-NEXT:    andi $2, $4, 3
; MIPS64EL-NEXT:    sll $2, $2, 3
; MIPS64EL-NEXT:    ori $3, $zero, 255
; MIPS64EL-NEXT:    sllv $3, $3, $2
; MIPS64EL-NEXT:    nor $6, $zero, $3
; MIPS64EL-NEXT:    sllv $5, $5, $2
; MIPS64EL-NEXT:  .LBB8_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $8, 0($1)
; MIPS64EL-NEXT:    and $8, $8, $3
; MIPS64EL-NEXT:    and $5, $5, $3
; MIPS64EL-NEXT:    slt $11, $8, $5
; MIPS64EL-NEXT:    move $9, $8
; MIPS64EL-NEXT:    movn $9, $5, $11
; MIPS64EL-NEXT:    and $9, $9, $3
; MIPS64EL-NEXT:    and $10, $8, $6
; MIPS64EL-NEXT:    or $10, $10, $9
; MIPS64EL-NEXT:    sc $10, 0($1)
; MIPS64EL-NEXT:    beqz $10, .LBB8_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    and $7, $8, $3
; MIPS64EL-NEXT:    srlv $7, $7, $2
; MIPS64EL-NEXT:    seh $7, $7
; MIPS64EL-NEXT:  # %bb.3: # %entry
; MIPS64EL-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64EL-NEXT:  # %bb.4: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64EL-NEXT:    daddiu $sp, $sp, 16
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_max_8:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, -16
; MIPS64ELR6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    daddiu $1, $zero, -4
; MIPS64ELR6-NEXT:    and $1, $4, $1
; MIPS64ELR6-NEXT:    andi $2, $4, 3
; MIPS64ELR6-NEXT:    sll $2, $2, 3
; MIPS64ELR6-NEXT:    ori $3, $zero, 255
; MIPS64ELR6-NEXT:    sllv $3, $3, $2
; MIPS64ELR6-NEXT:    nor $6, $zero, $3
; MIPS64ELR6-NEXT:    sllv $5, $5, $2
; MIPS64ELR6-NEXT:  .LBB8_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $8, 0($1)
; MIPS64ELR6-NEXT:    and $8, $8, $3
; MIPS64ELR6-NEXT:    and $5, $5, $3
; MIPS64ELR6-NEXT:    slt $11, $8, $5
; MIPS64ELR6-NEXT:    seleqz $9, $8, $11
; MIPS64ELR6-NEXT:    selnez $11, $5, $11
; MIPS64ELR6-NEXT:    or $9, $9, $11
; MIPS64ELR6-NEXT:    and $9, $9, $3
; MIPS64ELR6-NEXT:    and $10, $8, $6
; MIPS64ELR6-NEXT:    or $10, $10, $9
; MIPS64ELR6-NEXT:    sc $10, 0($1)
; MIPS64ELR6-NEXT:    beqzc $10, .LBB8_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    and $7, $8, $3
; MIPS64ELR6-NEXT:    srlv $7, $7, $2
; MIPS64ELR6-NEXT:    seh $7, $7
; MIPS64ELR6-NEXT:  # %bb.3: # %entry
; MIPS64ELR6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64ELR6-NEXT:  # %bb.4: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, 16
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw max i8* %ptr, i8 %val seq_cst
  ret i8 %0
}

define i8 @test_min_8(i8* nocapture %ptr, i8 signext %val) {
; MIPS-LABEL: test_min_8:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    addiu $sp, $sp, -8
; MIPS-NEXT:    .cfi_def_cfa_offset 8
; MIPS-NEXT:    move $1, $5
; MIPS-NEXT:    sync
; MIPS-NEXT:    addiu $2, $zero, -4
; MIPS-NEXT:    and $2, $4, $2
; MIPS-NEXT:    andi $3, $4, 3
; MIPS-NEXT:    xori $3, $3, 3
; MIPS-NEXT:    sll $3, $3, 3
; MIPS-NEXT:    ori $4, $zero, 255
; MIPS-NEXT:    sllv $4, $4, $3
; MIPS-NEXT:    nor $6, $zero, $4
; MIPS-NEXT:    sllv $5, $5, $3
; MIPS-NEXT:  $BB9_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $8, 0($2)
; MIPS-NEXT:    slt $11, $8, $5
; MIPS-NEXT:    move $9, $8
; MIPS-NEXT:    movz $9, $5, $11
; MIPS-NEXT:    and $9, $9, $4
; MIPS-NEXT:    and $10, $8, $6
; MIPS-NEXT:    or $10, $10, $9
; MIPS-NEXT:    sc $10, 0($2)
; MIPS-NEXT:    beqz $10, $BB9_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    and $7, $8, $4
; MIPS-NEXT:    srlv $7, $7, $3
; MIPS-NEXT:    seh $7, $7
; MIPS-NEXT:  # %bb.3: # %entry
; MIPS-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPS-NEXT:  # %bb.4: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPS-NEXT:    addiu $sp, $sp, 8
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_min_8:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    addiu $sp, $sp, -8
; MIPSR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSR6-NEXT:    move $1, $5
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    addiu $2, $zero, -4
; MIPSR6-NEXT:    and $2, $4, $2
; MIPSR6-NEXT:    andi $3, $4, 3
; MIPSR6-NEXT:    xori $3, $3, 3
; MIPSR6-NEXT:    sll $3, $3, 3
; MIPSR6-NEXT:    ori $4, $zero, 255
; MIPSR6-NEXT:    sllv $4, $4, $3
; MIPSR6-NEXT:    nor $6, $zero, $4
; MIPSR6-NEXT:    sllv $5, $5, $3
; MIPSR6-NEXT:  $BB9_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $8, 0($2)
; MIPSR6-NEXT:    slt $11, $8, $5
; MIPSR6-NEXT:    selnez $9, $8, $11
; MIPSR6-NEXT:    seleqz $11, $5, $11
; MIPSR6-NEXT:    or $9, $9, $11
; MIPSR6-NEXT:    and $9, $9, $4
; MIPSR6-NEXT:    and $10, $8, $6
; MIPSR6-NEXT:    or $10, $10, $9
; MIPSR6-NEXT:    sc $10, 0($2)
; MIPSR6-NEXT:    beqzc $10, $BB9_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    and $7, $8, $4
; MIPSR6-NEXT:    srlv $7, $7, $3
; MIPSR6-NEXT:    seh $7, $7
; MIPSR6-NEXT:  # %bb.3: # %entry
; MIPSR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSR6-NEXT:  # %bb.4: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSR6-NEXT:    addiu $sp, $sp, 8
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_min_8:
; MM:       # %bb.0: # %entry
; MM-NEXT:    addiu $sp, $sp, -8
; MM-NEXT:    .cfi_def_cfa_offset 8
; MM-NEXT:    move $1, $5
; MM-NEXT:    sync
; MM-NEXT:    addiu $2, $zero, -4
; MM-NEXT:    and $2, $4, $2
; MM-NEXT:    andi $3, $4, 3
; MM-NEXT:    xori $3, $3, 3
; MM-NEXT:    sll $3, $3, 3
; MM-NEXT:    ori $4, $zero, 255
; MM-NEXT:    sllv $4, $4, $3
; MM-NEXT:    nor $6, $zero, $4
; MM-NEXT:    sllv $5, $5, $3
; MM-NEXT:  $BB9_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $8, 0($2)
; MM-NEXT:    slt $11, $8, $5
; MM-NEXT:    or $9, $8, $zero
; MM-NEXT:    movz $9, $5, $11
; MM-NEXT:    and $9, $9, $4
; MM-NEXT:    and $10, $8, $6
; MM-NEXT:    or $10, $10, $9
; MM-NEXT:    sc $10, 0($2)
; MM-NEXT:    beqzc $10, $BB9_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    and $7, $8, $4
; MM-NEXT:    srlv $7, $7, $3
; MM-NEXT:    seh $7, $7
; MM-NEXT:  # %bb.3: # %entry
; MM-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MM-NEXT:  # %bb.4: # %entry
; MM-NEXT:    sync
; MM-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MM-NEXT:    addiusp 8
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_min_8:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    addiu $sp, $sp, -8
; MMR6-NEXT:    .cfi_def_cfa_offset 8
; MMR6-NEXT:    move $1, $5
; MMR6-NEXT:    sync
; MMR6-NEXT:    addiu $2, $zero, -4
; MMR6-NEXT:    and $2, $4, $2
; MMR6-NEXT:    andi $3, $4, 3
; MMR6-NEXT:    xori $3, $3, 3
; MMR6-NEXT:    sll $3, $3, 3
; MMR6-NEXT:    ori $4, $zero, 255
; MMR6-NEXT:    sllv $4, $4, $3
; MMR6-NEXT:    nor $6, $zero, $4
; MMR6-NEXT:    sllv $5, $5, $3
; MMR6-NEXT:  $BB9_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $8, 0($2)
; MMR6-NEXT:    slt $11, $8, $5
; MMR6-NEXT:    selnez $9, $8, $11
; MMR6-NEXT:    seleqz $11, $5, $11
; MMR6-NEXT:    or $9, $9, $11
; MMR6-NEXT:    and $9, $9, $4
; MMR6-NEXT:    and $10, $8, $6
; MMR6-NEXT:    or $10, $10, $9
; MMR6-NEXT:    sc $10, 0($2)
; MMR6-NEXT:    beqc $10, $zero, $BB9_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    and $7, $8, $4
; MMR6-NEXT:    srlv $7, $7, $3
; MMR6-NEXT:    seh $7, $7
; MMR6-NEXT:  # %bb.3: # %entry
; MMR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMR6-NEXT:  # %bb.4: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMR6-NEXT:    addiu $sp, $sp, 8
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_min_8:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    addiu $sp, $sp, -8
; MIPSEL-NEXT:    .cfi_def_cfa_offset 8
; MIPSEL-NEXT:    move $1, $5
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    addiu $2, $zero, -4
; MIPSEL-NEXT:    and $2, $4, $2
; MIPSEL-NEXT:    andi $3, $4, 3
; MIPSEL-NEXT:    sll $3, $3, 3
; MIPSEL-NEXT:    ori $4, $zero, 255
; MIPSEL-NEXT:    sllv $4, $4, $3
; MIPSEL-NEXT:    nor $6, $zero, $4
; MIPSEL-NEXT:    sllv $5, $5, $3
; MIPSEL-NEXT:  $BB9_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $8, 0($2)
; MIPSEL-NEXT:    and $8, $8, $4
; MIPSEL-NEXT:    and $5, $5, $4
; MIPSEL-NEXT:    slt $11, $8, $5
; MIPSEL-NEXT:    move $9, $8
; MIPSEL-NEXT:    movz $9, $5, $11
; MIPSEL-NEXT:    and $9, $9, $4
; MIPSEL-NEXT:    and $10, $8, $6
; MIPSEL-NEXT:    or $10, $10, $9
; MIPSEL-NEXT:    sc $10, 0($2)
; MIPSEL-NEXT:    beqz $10, $BB9_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    and $7, $8, $4
; MIPSEL-NEXT:    srlv $7, $7, $3
; MIPSEL-NEXT:    seh $7, $7
; MIPSEL-NEXT:  # %bb.3: # %entry
; MIPSEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:  # %bb.4: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    addiu $sp, $sp, 8
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_min_8:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    addiu $sp, $sp, -8
; MIPSELR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSELR6-NEXT:    move $1, $5
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    addiu $2, $zero, -4
; MIPSELR6-NEXT:    and $2, $4, $2
; MIPSELR6-NEXT:    andi $3, $4, 3
; MIPSELR6-NEXT:    sll $3, $3, 3
; MIPSELR6-NEXT:    ori $4, $zero, 255
; MIPSELR6-NEXT:    sllv $4, $4, $3
; MIPSELR6-NEXT:    nor $6, $zero, $4
; MIPSELR6-NEXT:    sllv $5, $5, $3
; MIPSELR6-NEXT:  $BB9_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $8, 0($2)
; MIPSELR6-NEXT:    and $8, $8, $4
; MIPSELR6-NEXT:    and $5, $5, $4
; MIPSELR6-NEXT:    slt $11, $8, $5
; MIPSELR6-NEXT:    selnez $9, $8, $11
; MIPSELR6-NEXT:    seleqz $11, $5, $11
; MIPSELR6-NEXT:    or $9, $9, $11
; MIPSELR6-NEXT:    and $9, $9, $4
; MIPSELR6-NEXT:    and $10, $8, $6
; MIPSELR6-NEXT:    or $10, $10, $9
; MIPSELR6-NEXT:    sc $10, 0($2)
; MIPSELR6-NEXT:    beqzc $10, $BB9_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    and $7, $8, $4
; MIPSELR6-NEXT:    srlv $7, $7, $3
; MIPSELR6-NEXT:    seh $7, $7
; MIPSELR6-NEXT:  # %bb.3: # %entry
; MIPSELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSELR6-NEXT:  # %bb.4: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSELR6-NEXT:    addiu $sp, $sp, 8
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_min_8:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    addiu $sp, $sp, -8
; MMEL-NEXT:    .cfi_def_cfa_offset 8
; MMEL-NEXT:    move $1, $5
; MMEL-NEXT:    sync
; MMEL-NEXT:    addiu $2, $zero, -4
; MMEL-NEXT:    and $2, $4, $2
; MMEL-NEXT:    andi $3, $4, 3
; MMEL-NEXT:    sll $3, $3, 3
; MMEL-NEXT:    ori $4, $zero, 255
; MMEL-NEXT:    sllv $4, $4, $3
; MMEL-NEXT:    nor $6, $zero, $4
; MMEL-NEXT:    sllv $5, $5, $3
; MMEL-NEXT:  $BB9_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $8, 0($2)
; MMEL-NEXT:    and $8, $8, $4
; MMEL-NEXT:    and $5, $5, $4
; MMEL-NEXT:    slt $11, $8, $5
; MMEL-NEXT:    or $9, $8, $zero
; MMEL-NEXT:    movz $9, $5, $11
; MMEL-NEXT:    and $9, $9, $4
; MMEL-NEXT:    and $10, $8, $6
; MMEL-NEXT:    or $10, $10, $9
; MMEL-NEXT:    sc $10, 0($2)
; MMEL-NEXT:    beqzc $10, $BB9_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    and $7, $8, $4
; MMEL-NEXT:    srlv $7, $7, $3
; MMEL-NEXT:    seh $7, $7
; MMEL-NEXT:  # %bb.3: # %entry
; MMEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMEL-NEXT:  # %bb.4: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMEL-NEXT:    addiusp 8
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_min_8:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    addiu $sp, $sp, -8
; MMELR6-NEXT:    .cfi_def_cfa_offset 8
; MMELR6-NEXT:    move $1, $5
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    addiu $2, $zero, -4
; MMELR6-NEXT:    and $2, $4, $2
; MMELR6-NEXT:    andi $3, $4, 3
; MMELR6-NEXT:    sll $3, $3, 3
; MMELR6-NEXT:    ori $4, $zero, 255
; MMELR6-NEXT:    sllv $4, $4, $3
; MMELR6-NEXT:    nor $6, $zero, $4
; MMELR6-NEXT:    sllv $5, $5, $3
; MMELR6-NEXT:  $BB9_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $8, 0($2)
; MMELR6-NEXT:    and $8, $8, $4
; MMELR6-NEXT:    and $5, $5, $4
; MMELR6-NEXT:    slt $11, $8, $5
; MMELR6-NEXT:    selnez $9, $8, $11
; MMELR6-NEXT:    seleqz $11, $5, $11
; MMELR6-NEXT:    or $9, $9, $11
; MMELR6-NEXT:    and $9, $9, $4
; MMELR6-NEXT:    and $10, $8, $6
; MMELR6-NEXT:    or $10, $10, $9
; MMELR6-NEXT:    sc $10, 0($2)
; MMELR6-NEXT:    beqc $10, $zero, $BB9_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    and $7, $8, $4
; MMELR6-NEXT:    srlv $7, $7, $3
; MMELR6-NEXT:    seh $7, $7
; MMELR6-NEXT:  # %bb.3: # %entry
; MMELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMELR6-NEXT:  # %bb.4: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMELR6-NEXT:    addiu $sp, $sp, 8
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_min_8:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    daddiu $1, $zero, -4
; MIPS64-NEXT:    and $1, $4, $1
; MIPS64-NEXT:    andi $2, $4, 3
; MIPS64-NEXT:    xori $2, $2, 3
; MIPS64-NEXT:    sll $2, $2, 3
; MIPS64-NEXT:    ori $3, $zero, 255
; MIPS64-NEXT:    sllv $3, $3, $2
; MIPS64-NEXT:    nor $6, $zero, $3
; MIPS64-NEXT:    sllv $5, $5, $2
; MIPS64-NEXT:  .LBB9_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $8, 0($1)
; MIPS64-NEXT:    slt $11, $8, $5
; MIPS64-NEXT:    move $9, $8
; MIPS64-NEXT:    movz $9, $5, $11
; MIPS64-NEXT:    and $9, $9, $3
; MIPS64-NEXT:    and $10, $8, $6
; MIPS64-NEXT:    or $10, $10, $9
; MIPS64-NEXT:    sc $10, 0($1)
; MIPS64-NEXT:    beqz $10, .LBB9_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    and $7, $8, $3
; MIPS64-NEXT:    srlv $7, $7, $2
; MIPS64-NEXT:    seh $7, $7
; MIPS64-NEXT:  # %bb.3: # %entry
; MIPS64-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64-NEXT:  # %bb.4: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_min_8:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    daddiu $sp, $sp, -16
; MIPS64R6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    daddiu $1, $zero, -4
; MIPS64R6-NEXT:    and $1, $4, $1
; MIPS64R6-NEXT:    andi $2, $4, 3
; MIPS64R6-NEXT:    xori $2, $2, 3
; MIPS64R6-NEXT:    sll $2, $2, 3
; MIPS64R6-NEXT:    ori $3, $zero, 255
; MIPS64R6-NEXT:    sllv $3, $3, $2
; MIPS64R6-NEXT:    nor $6, $zero, $3
; MIPS64R6-NEXT:    sllv $5, $5, $2
; MIPS64R6-NEXT:  .LBB9_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $8, 0($1)
; MIPS64R6-NEXT:    slt $11, $8, $5
; MIPS64R6-NEXT:    selnez $9, $8, $11
; MIPS64R6-NEXT:    seleqz $11, $5, $11
; MIPS64R6-NEXT:    or $9, $9, $11
; MIPS64R6-NEXT:    and $9, $9, $3
; MIPS64R6-NEXT:    and $10, $8, $6
; MIPS64R6-NEXT:    or $10, $10, $9
; MIPS64R6-NEXT:    sc $10, 0($1)
; MIPS64R6-NEXT:    beqzc $10, .LBB9_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    and $7, $8, $3
; MIPS64R6-NEXT:    srlv $7, $7, $2
; MIPS64R6-NEXT:    seh $7, $7
; MIPS64R6-NEXT:  # %bb.3: # %entry
; MIPS64R6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64R6-NEXT:  # %bb.4: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64R6-NEXT:    daddiu $sp, $sp, 16
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_min_8:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    daddiu $sp, $sp, -16
; MIPS64EL-NEXT:    .cfi_def_cfa_offset 16
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    daddiu $1, $zero, -4
; MIPS64EL-NEXT:    and $1, $4, $1
; MIPS64EL-NEXT:    andi $2, $4, 3
; MIPS64EL-NEXT:    sll $2, $2, 3
; MIPS64EL-NEXT:    ori $3, $zero, 255
; MIPS64EL-NEXT:    sllv $3, $3, $2
; MIPS64EL-NEXT:    nor $6, $zero, $3
; MIPS64EL-NEXT:    sllv $5, $5, $2
; MIPS64EL-NEXT:  .LBB9_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $8, 0($1)
; MIPS64EL-NEXT:    and $8, $8, $3
; MIPS64EL-NEXT:    and $5, $5, $3
; MIPS64EL-NEXT:    slt $11, $8, $5
; MIPS64EL-NEXT:    move $9, $8
; MIPS64EL-NEXT:    movz $9, $5, $11
; MIPS64EL-NEXT:    and $9, $9, $3
; MIPS64EL-NEXT:    and $10, $8, $6
; MIPS64EL-NEXT:    or $10, $10, $9
; MIPS64EL-NEXT:    sc $10, 0($1)
; MIPS64EL-NEXT:    beqz $10, .LBB9_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    and $7, $8, $3
; MIPS64EL-NEXT:    srlv $7, $7, $2
; MIPS64EL-NEXT:    seh $7, $7
; MIPS64EL-NEXT:  # %bb.3: # %entry
; MIPS64EL-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64EL-NEXT:  # %bb.4: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64EL-NEXT:    daddiu $sp, $sp, 16
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_min_8:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, -16
; MIPS64ELR6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    daddiu $1, $zero, -4
; MIPS64ELR6-NEXT:    and $1, $4, $1
; MIPS64ELR6-NEXT:    andi $2, $4, 3
; MIPS64ELR6-NEXT:    sll $2, $2, 3
; MIPS64ELR6-NEXT:    ori $3, $zero, 255
; MIPS64ELR6-NEXT:    sllv $3, $3, $2
; MIPS64ELR6-NEXT:    nor $6, $zero, $3
; MIPS64ELR6-NEXT:    sllv $5, $5, $2
; MIPS64ELR6-NEXT:  .LBB9_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $8, 0($1)
; MIPS64ELR6-NEXT:    and $8, $8, $3
; MIPS64ELR6-NEXT:    and $5, $5, $3
; MIPS64ELR6-NEXT:    slt $11, $8, $5
; MIPS64ELR6-NEXT:    selnez $9, $8, $11
; MIPS64ELR6-NEXT:    seleqz $11, $5, $11
; MIPS64ELR6-NEXT:    or $9, $9, $11
; MIPS64ELR6-NEXT:    and $9, $9, $3
; MIPS64ELR6-NEXT:    and $10, $8, $6
; MIPS64ELR6-NEXT:    or $10, $10, $9
; MIPS64ELR6-NEXT:    sc $10, 0($1)
; MIPS64ELR6-NEXT:    beqzc $10, .LBB9_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    and $7, $8, $3
; MIPS64ELR6-NEXT:    srlv $7, $7, $2
; MIPS64ELR6-NEXT:    seh $7, $7
; MIPS64ELR6-NEXT:  # %bb.3: # %entry
; MIPS64ELR6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64ELR6-NEXT:  # %bb.4: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, 16
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw min i8* %ptr, i8 %val seq_cst
  ret i8 %0
}

define i8 @test_umax_8(i8* nocapture %ptr, i8 signext %val) {
; MIPS-LABEL: test_umax_8:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    addiu $sp, $sp, -8
; MIPS-NEXT:    .cfi_def_cfa_offset 8
; MIPS-NEXT:    move $1, $5
; MIPS-NEXT:    sync
; MIPS-NEXT:    addiu $2, $zero, -4
; MIPS-NEXT:    and $2, $4, $2
; MIPS-NEXT:    andi $3, $4, 3
; MIPS-NEXT:    xori $3, $3, 3
; MIPS-NEXT:    sll $3, $3, 3
; MIPS-NEXT:    ori $4, $zero, 255
; MIPS-NEXT:    sllv $4, $4, $3
; MIPS-NEXT:    nor $6, $zero, $4
; MIPS-NEXT:    sllv $5, $5, $3
; MIPS-NEXT:  $BB10_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $8, 0($2)
; MIPS-NEXT:    sltu $11, $8, $5
; MIPS-NEXT:    move $9, $8
; MIPS-NEXT:    movn $9, $5, $11
; MIPS-NEXT:    and $9, $9, $4
; MIPS-NEXT:    and $10, $8, $6
; MIPS-NEXT:    or $10, $10, $9
; MIPS-NEXT:    sc $10, 0($2)
; MIPS-NEXT:    beqz $10, $BB10_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    and $7, $8, $4
; MIPS-NEXT:    srlv $7, $7, $3
; MIPS-NEXT:    seh $7, $7
; MIPS-NEXT:  # %bb.3: # %entry
; MIPS-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPS-NEXT:  # %bb.4: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPS-NEXT:    addiu $sp, $sp, 8
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_umax_8:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    addiu $sp, $sp, -8
; MIPSR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSR6-NEXT:    move $1, $5
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    addiu $2, $zero, -4
; MIPSR6-NEXT:    and $2, $4, $2
; MIPSR6-NEXT:    andi $3, $4, 3
; MIPSR6-NEXT:    xori $3, $3, 3
; MIPSR6-NEXT:    sll $3, $3, 3
; MIPSR6-NEXT:    ori $4, $zero, 255
; MIPSR6-NEXT:    sllv $4, $4, $3
; MIPSR6-NEXT:    nor $6, $zero, $4
; MIPSR6-NEXT:    sllv $5, $5, $3
; MIPSR6-NEXT:  $BB10_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $8, 0($2)
; MIPSR6-NEXT:    sltu $11, $8, $5
; MIPSR6-NEXT:    seleqz $9, $8, $11
; MIPSR6-NEXT:    selnez $11, $5, $11
; MIPSR6-NEXT:    or $9, $9, $11
; MIPSR6-NEXT:    and $9, $9, $4
; MIPSR6-NEXT:    and $10, $8, $6
; MIPSR6-NEXT:    or $10, $10, $9
; MIPSR6-NEXT:    sc $10, 0($2)
; MIPSR6-NEXT:    beqzc $10, $BB10_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    and $7, $8, $4
; MIPSR6-NEXT:    srlv $7, $7, $3
; MIPSR6-NEXT:    seh $7, $7
; MIPSR6-NEXT:  # %bb.3: # %entry
; MIPSR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSR6-NEXT:  # %bb.4: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSR6-NEXT:    addiu $sp, $sp, 8
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_umax_8:
; MM:       # %bb.0: # %entry
; MM-NEXT:    addiu $sp, $sp, -8
; MM-NEXT:    .cfi_def_cfa_offset 8
; MM-NEXT:    move $1, $5
; MM-NEXT:    sync
; MM-NEXT:    addiu $2, $zero, -4
; MM-NEXT:    and $2, $4, $2
; MM-NEXT:    andi $3, $4, 3
; MM-NEXT:    xori $3, $3, 3
; MM-NEXT:    sll $3, $3, 3
; MM-NEXT:    ori $4, $zero, 255
; MM-NEXT:    sllv $4, $4, $3
; MM-NEXT:    nor $6, $zero, $4
; MM-NEXT:    sllv $5, $5, $3
; MM-NEXT:  $BB10_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $8, 0($2)
; MM-NEXT:    sltu $11, $8, $5
; MM-NEXT:    or $9, $8, $zero
; MM-NEXT:    movn $9, $5, $11
; MM-NEXT:    and $9, $9, $4
; MM-NEXT:    and $10, $8, $6
; MM-NEXT:    or $10, $10, $9
; MM-NEXT:    sc $10, 0($2)
; MM-NEXT:    beqzc $10, $BB10_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    and $7, $8, $4
; MM-NEXT:    srlv $7, $7, $3
; MM-NEXT:    seh $7, $7
; MM-NEXT:  # %bb.3: # %entry
; MM-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MM-NEXT:  # %bb.4: # %entry
; MM-NEXT:    sync
; MM-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MM-NEXT:    addiusp 8
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_umax_8:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    addiu $sp, $sp, -8
; MMR6-NEXT:    .cfi_def_cfa_offset 8
; MMR6-NEXT:    move $1, $5
; MMR6-NEXT:    sync
; MMR6-NEXT:    addiu $2, $zero, -4
; MMR6-NEXT:    and $2, $4, $2
; MMR6-NEXT:    andi $3, $4, 3
; MMR6-NEXT:    xori $3, $3, 3
; MMR6-NEXT:    sll $3, $3, 3
; MMR6-NEXT:    ori $4, $zero, 255
; MMR6-NEXT:    sllv $4, $4, $3
; MMR6-NEXT:    nor $6, $zero, $4
; MMR6-NEXT:    sllv $5, $5, $3
; MMR6-NEXT:  $BB10_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $8, 0($2)
; MMR6-NEXT:    sltu $11, $8, $5
; MMR6-NEXT:    seleqz $9, $8, $11
; MMR6-NEXT:    selnez $11, $5, $11
; MMR6-NEXT:    or $9, $9, $11
; MMR6-NEXT:    and $9, $9, $4
; MMR6-NEXT:    and $10, $8, $6
; MMR6-NEXT:    or $10, $10, $9
; MMR6-NEXT:    sc $10, 0($2)
; MMR6-NEXT:    beqc $10, $zero, $BB10_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    and $7, $8, $4
; MMR6-NEXT:    srlv $7, $7, $3
; MMR6-NEXT:    seh $7, $7
; MMR6-NEXT:  # %bb.3: # %entry
; MMR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMR6-NEXT:  # %bb.4: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMR6-NEXT:    addiu $sp, $sp, 8
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_umax_8:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    addiu $sp, $sp, -8
; MIPSEL-NEXT:    .cfi_def_cfa_offset 8
; MIPSEL-NEXT:    move $1, $5
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    addiu $2, $zero, -4
; MIPSEL-NEXT:    and $2, $4, $2
; MIPSEL-NEXT:    andi $3, $4, 3
; MIPSEL-NEXT:    sll $3, $3, 3
; MIPSEL-NEXT:    ori $4, $zero, 255
; MIPSEL-NEXT:    sllv $4, $4, $3
; MIPSEL-NEXT:    nor $6, $zero, $4
; MIPSEL-NEXT:    sllv $5, $5, $3
; MIPSEL-NEXT:  $BB10_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $8, 0($2)
; MIPSEL-NEXT:    and $8, $8, $4
; MIPSEL-NEXT:    and $5, $5, $4
; MIPSEL-NEXT:    sltu $11, $8, $5
; MIPSEL-NEXT:    move $9, $8
; MIPSEL-NEXT:    movn $9, $5, $11
; MIPSEL-NEXT:    and $9, $9, $4
; MIPSEL-NEXT:    and $10, $8, $6
; MIPSEL-NEXT:    or $10, $10, $9
; MIPSEL-NEXT:    sc $10, 0($2)
; MIPSEL-NEXT:    beqz $10, $BB10_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    and $7, $8, $4
; MIPSEL-NEXT:    srlv $7, $7, $3
; MIPSEL-NEXT:    seh $7, $7
; MIPSEL-NEXT:  # %bb.3: # %entry
; MIPSEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:  # %bb.4: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    addiu $sp, $sp, 8
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_umax_8:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    addiu $sp, $sp, -8
; MIPSELR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSELR6-NEXT:    move $1, $5
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    addiu $2, $zero, -4
; MIPSELR6-NEXT:    and $2, $4, $2
; MIPSELR6-NEXT:    andi $3, $4, 3
; MIPSELR6-NEXT:    sll $3, $3, 3
; MIPSELR6-NEXT:    ori $4, $zero, 255
; MIPSELR6-NEXT:    sllv $4, $4, $3
; MIPSELR6-NEXT:    nor $6, $zero, $4
; MIPSELR6-NEXT:    sllv $5, $5, $3
; MIPSELR6-NEXT:  $BB10_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $8, 0($2)
; MIPSELR6-NEXT:    and $8, $8, $4
; MIPSELR6-NEXT:    and $5, $5, $4
; MIPSELR6-NEXT:    sltu $11, $8, $5
; MIPSELR6-NEXT:    seleqz $9, $8, $11
; MIPSELR6-NEXT:    selnez $11, $5, $11
; MIPSELR6-NEXT:    or $9, $9, $11
; MIPSELR6-NEXT:    and $9, $9, $4
; MIPSELR6-NEXT:    and $10, $8, $6
; MIPSELR6-NEXT:    or $10, $10, $9
; MIPSELR6-NEXT:    sc $10, 0($2)
; MIPSELR6-NEXT:    beqzc $10, $BB10_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    and $7, $8, $4
; MIPSELR6-NEXT:    srlv $7, $7, $3
; MIPSELR6-NEXT:    seh $7, $7
; MIPSELR6-NEXT:  # %bb.3: # %entry
; MIPSELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSELR6-NEXT:  # %bb.4: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSELR6-NEXT:    addiu $sp, $sp, 8
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_umax_8:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    addiu $sp, $sp, -8
; MMEL-NEXT:    .cfi_def_cfa_offset 8
; MMEL-NEXT:    move $1, $5
; MMEL-NEXT:    sync
; MMEL-NEXT:    addiu $2, $zero, -4
; MMEL-NEXT:    and $2, $4, $2
; MMEL-NEXT:    andi $3, $4, 3
; MMEL-NEXT:    sll $3, $3, 3
; MMEL-NEXT:    ori $4, $zero, 255
; MMEL-NEXT:    sllv $4, $4, $3
; MMEL-NEXT:    nor $6, $zero, $4
; MMEL-NEXT:    sllv $5, $5, $3
; MMEL-NEXT:  $BB10_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $8, 0($2)
; MMEL-NEXT:    and $8, $8, $4
; MMEL-NEXT:    and $5, $5, $4
; MMEL-NEXT:    sltu $11, $8, $5
; MMEL-NEXT:    or $9, $8, $zero
; MMEL-NEXT:    movn $9, $5, $11
; MMEL-NEXT:    and $9, $9, $4
; MMEL-NEXT:    and $10, $8, $6
; MMEL-NEXT:    or $10, $10, $9
; MMEL-NEXT:    sc $10, 0($2)
; MMEL-NEXT:    beqzc $10, $BB10_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    and $7, $8, $4
; MMEL-NEXT:    srlv $7, $7, $3
; MMEL-NEXT:    seh $7, $7
; MMEL-NEXT:  # %bb.3: # %entry
; MMEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMEL-NEXT:  # %bb.4: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMEL-NEXT:    addiusp 8
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_umax_8:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    addiu $sp, $sp, -8
; MMELR6-NEXT:    .cfi_def_cfa_offset 8
; MMELR6-NEXT:    move $1, $5
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    addiu $2, $zero, -4
; MMELR6-NEXT:    and $2, $4, $2
; MMELR6-NEXT:    andi $3, $4, 3
; MMELR6-NEXT:    sll $3, $3, 3
; MMELR6-NEXT:    ori $4, $zero, 255
; MMELR6-NEXT:    sllv $4, $4, $3
; MMELR6-NEXT:    nor $6, $zero, $4
; MMELR6-NEXT:    sllv $5, $5, $3
; MMELR6-NEXT:  $BB10_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $8, 0($2)
; MMELR6-NEXT:    and $8, $8, $4
; MMELR6-NEXT:    and $5, $5, $4
; MMELR6-NEXT:    sltu $11, $8, $5
; MMELR6-NEXT:    seleqz $9, $8, $11
; MMELR6-NEXT:    selnez $11, $5, $11
; MMELR6-NEXT:    or $9, $9, $11
; MMELR6-NEXT:    and $9, $9, $4
; MMELR6-NEXT:    and $10, $8, $6
; MMELR6-NEXT:    or $10, $10, $9
; MMELR6-NEXT:    sc $10, 0($2)
; MMELR6-NEXT:    beqc $10, $zero, $BB10_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    and $7, $8, $4
; MMELR6-NEXT:    srlv $7, $7, $3
; MMELR6-NEXT:    seh $7, $7
; MMELR6-NEXT:  # %bb.3: # %entry
; MMELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMELR6-NEXT:  # %bb.4: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMELR6-NEXT:    addiu $sp, $sp, 8
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_umax_8:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    daddiu $1, $zero, -4
; MIPS64-NEXT:    and $1, $4, $1
; MIPS64-NEXT:    andi $2, $4, 3
; MIPS64-NEXT:    xori $2, $2, 3
; MIPS64-NEXT:    sll $2, $2, 3
; MIPS64-NEXT:    ori $3, $zero, 255
; MIPS64-NEXT:    sllv $3, $3, $2
; MIPS64-NEXT:    nor $6, $zero, $3
; MIPS64-NEXT:    sllv $5, $5, $2
; MIPS64-NEXT:  .LBB10_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $8, 0($1)
; MIPS64-NEXT:    sltu $11, $8, $5
; MIPS64-NEXT:    move $9, $8
; MIPS64-NEXT:    movn $9, $5, $11
; MIPS64-NEXT:    and $9, $9, $3
; MIPS64-NEXT:    and $10, $8, $6
; MIPS64-NEXT:    or $10, $10, $9
; MIPS64-NEXT:    sc $10, 0($1)
; MIPS64-NEXT:    beqz $10, .LBB10_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    and $7, $8, $3
; MIPS64-NEXT:    srlv $7, $7, $2
; MIPS64-NEXT:    seh $7, $7
; MIPS64-NEXT:  # %bb.3: # %entry
; MIPS64-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64-NEXT:  # %bb.4: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_umax_8:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    daddiu $sp, $sp, -16
; MIPS64R6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    daddiu $1, $zero, -4
; MIPS64R6-NEXT:    and $1, $4, $1
; MIPS64R6-NEXT:    andi $2, $4, 3
; MIPS64R6-NEXT:    xori $2, $2, 3
; MIPS64R6-NEXT:    sll $2, $2, 3
; MIPS64R6-NEXT:    ori $3, $zero, 255
; MIPS64R6-NEXT:    sllv $3, $3, $2
; MIPS64R6-NEXT:    nor $6, $zero, $3
; MIPS64R6-NEXT:    sllv $5, $5, $2
; MIPS64R6-NEXT:  .LBB10_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $8, 0($1)
; MIPS64R6-NEXT:    sltu $11, $8, $5
; MIPS64R6-NEXT:    seleqz $9, $8, $11
; MIPS64R6-NEXT:    selnez $11, $5, $11
; MIPS64R6-NEXT:    or $9, $9, $11
; MIPS64R6-NEXT:    and $9, $9, $3
; MIPS64R6-NEXT:    and $10, $8, $6
; MIPS64R6-NEXT:    or $10, $10, $9
; MIPS64R6-NEXT:    sc $10, 0($1)
; MIPS64R6-NEXT:    beqzc $10, .LBB10_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    and $7, $8, $3
; MIPS64R6-NEXT:    srlv $7, $7, $2
; MIPS64R6-NEXT:    seh $7, $7
; MIPS64R6-NEXT:  # %bb.3: # %entry
; MIPS64R6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64R6-NEXT:  # %bb.4: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64R6-NEXT:    daddiu $sp, $sp, 16
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_umax_8:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    daddiu $sp, $sp, -16
; MIPS64EL-NEXT:    .cfi_def_cfa_offset 16
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    daddiu $1, $zero, -4
; MIPS64EL-NEXT:    and $1, $4, $1
; MIPS64EL-NEXT:    andi $2, $4, 3
; MIPS64EL-NEXT:    sll $2, $2, 3
; MIPS64EL-NEXT:    ori $3, $zero, 255
; MIPS64EL-NEXT:    sllv $3, $3, $2
; MIPS64EL-NEXT:    nor $6, $zero, $3
; MIPS64EL-NEXT:    sllv $5, $5, $2
; MIPS64EL-NEXT:  .LBB10_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $8, 0($1)
; MIPS64EL-NEXT:    and $8, $8, $3
; MIPS64EL-NEXT:    and $5, $5, $3
; MIPS64EL-NEXT:    sltu $11, $8, $5
; MIPS64EL-NEXT:    move $9, $8
; MIPS64EL-NEXT:    movn $9, $5, $11
; MIPS64EL-NEXT:    and $9, $9, $3
; MIPS64EL-NEXT:    and $10, $8, $6
; MIPS64EL-NEXT:    or $10, $10, $9
; MIPS64EL-NEXT:    sc $10, 0($1)
; MIPS64EL-NEXT:    beqz $10, .LBB10_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    and $7, $8, $3
; MIPS64EL-NEXT:    srlv $7, $7, $2
; MIPS64EL-NEXT:    seh $7, $7
; MIPS64EL-NEXT:  # %bb.3: # %entry
; MIPS64EL-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64EL-NEXT:  # %bb.4: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64EL-NEXT:    daddiu $sp, $sp, 16
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_umax_8:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, -16
; MIPS64ELR6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    daddiu $1, $zero, -4
; MIPS64ELR6-NEXT:    and $1, $4, $1
; MIPS64ELR6-NEXT:    andi $2, $4, 3
; MIPS64ELR6-NEXT:    sll $2, $2, 3
; MIPS64ELR6-NEXT:    ori $3, $zero, 255
; MIPS64ELR6-NEXT:    sllv $3, $3, $2
; MIPS64ELR6-NEXT:    nor $6, $zero, $3
; MIPS64ELR6-NEXT:    sllv $5, $5, $2
; MIPS64ELR6-NEXT:  .LBB10_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $8, 0($1)
; MIPS64ELR6-NEXT:    and $8, $8, $3
; MIPS64ELR6-NEXT:    and $5, $5, $3
; MIPS64ELR6-NEXT:    sltu $11, $8, $5
; MIPS64ELR6-NEXT:    seleqz $9, $8, $11
; MIPS64ELR6-NEXT:    selnez $11, $5, $11
; MIPS64ELR6-NEXT:    or $9, $9, $11
; MIPS64ELR6-NEXT:    and $9, $9, $3
; MIPS64ELR6-NEXT:    and $10, $8, $6
; MIPS64ELR6-NEXT:    or $10, $10, $9
; MIPS64ELR6-NEXT:    sc $10, 0($1)
; MIPS64ELR6-NEXT:    beqzc $10, .LBB10_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    and $7, $8, $3
; MIPS64ELR6-NEXT:    srlv $7, $7, $2
; MIPS64ELR6-NEXT:    seh $7, $7
; MIPS64ELR6-NEXT:  # %bb.3: # %entry
; MIPS64ELR6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64ELR6-NEXT:  # %bb.4: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, 16
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw umax i8* %ptr, i8 %val seq_cst
  ret i8 %0
}

define i8 @test_umin_8(i8* nocapture %ptr, i8 signext %val) {
; MIPS-LABEL: test_umin_8:
; MIPS:       # %bb.0: # %entry
; MIPS-NEXT:    addiu $sp, $sp, -8
; MIPS-NEXT:    .cfi_def_cfa_offset 8
; MIPS-NEXT:    move $1, $5
; MIPS-NEXT:    sync
; MIPS-NEXT:    addiu $2, $zero, -4
; MIPS-NEXT:    and $2, $4, $2
; MIPS-NEXT:    andi $3, $4, 3
; MIPS-NEXT:    xori $3, $3, 3
; MIPS-NEXT:    sll $3, $3, 3
; MIPS-NEXT:    ori $4, $zero, 255
; MIPS-NEXT:    sllv $4, $4, $3
; MIPS-NEXT:    nor $6, $zero, $4
; MIPS-NEXT:    sllv $5, $5, $3
; MIPS-NEXT:  $BB11_1: # %entry
; MIPS-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS-NEXT:    ll $8, 0($2)
; MIPS-NEXT:    sltu $11, $8, $5
; MIPS-NEXT:    move $9, $8
; MIPS-NEXT:    movz $9, $5, $11
; MIPS-NEXT:    and $9, $9, $4
; MIPS-NEXT:    and $10, $8, $6
; MIPS-NEXT:    or $10, $10, $9
; MIPS-NEXT:    sc $10, 0($2)
; MIPS-NEXT:    beqz $10, $BB11_1
; MIPS-NEXT:    nop
; MIPS-NEXT:  # %bb.2: # %entry
; MIPS-NEXT:    and $7, $8, $4
; MIPS-NEXT:    srlv $7, $7, $3
; MIPS-NEXT:    seh $7, $7
; MIPS-NEXT:  # %bb.3: # %entry
; MIPS-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPS-NEXT:  # %bb.4: # %entry
; MIPS-NEXT:    sync
; MIPS-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPS-NEXT:    addiu $sp, $sp, 8
; MIPS-NEXT:    jr $ra
; MIPS-NEXT:    nop
;
; MIPSR6-LABEL: test_umin_8:
; MIPSR6:       # %bb.0: # %entry
; MIPSR6-NEXT:    addiu $sp, $sp, -8
; MIPSR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSR6-NEXT:    move $1, $5
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    addiu $2, $zero, -4
; MIPSR6-NEXT:    and $2, $4, $2
; MIPSR6-NEXT:    andi $3, $4, 3
; MIPSR6-NEXT:    xori $3, $3, 3
; MIPSR6-NEXT:    sll $3, $3, 3
; MIPSR6-NEXT:    ori $4, $zero, 255
; MIPSR6-NEXT:    sllv $4, $4, $3
; MIPSR6-NEXT:    nor $6, $zero, $4
; MIPSR6-NEXT:    sllv $5, $5, $3
; MIPSR6-NEXT:  $BB11_1: # %entry
; MIPSR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSR6-NEXT:    ll $8, 0($2)
; MIPSR6-NEXT:    sltu $11, $8, $5
; MIPSR6-NEXT:    selnez $9, $8, $11
; MIPSR6-NEXT:    seleqz $11, $5, $11
; MIPSR6-NEXT:    or $9, $9, $11
; MIPSR6-NEXT:    and $9, $9, $4
; MIPSR6-NEXT:    and $10, $8, $6
; MIPSR6-NEXT:    or $10, $10, $9
; MIPSR6-NEXT:    sc $10, 0($2)
; MIPSR6-NEXT:    beqzc $10, $BB11_1
; MIPSR6-NEXT:  # %bb.2: # %entry
; MIPSR6-NEXT:    and $7, $8, $4
; MIPSR6-NEXT:    srlv $7, $7, $3
; MIPSR6-NEXT:    seh $7, $7
; MIPSR6-NEXT:  # %bb.3: # %entry
; MIPSR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSR6-NEXT:  # %bb.4: # %entry
; MIPSR6-NEXT:    sync
; MIPSR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSR6-NEXT:    addiu $sp, $sp, 8
; MIPSR6-NEXT:    jrc $ra
;
; MM-LABEL: test_umin_8:
; MM:       # %bb.0: # %entry
; MM-NEXT:    addiu $sp, $sp, -8
; MM-NEXT:    .cfi_def_cfa_offset 8
; MM-NEXT:    move $1, $5
; MM-NEXT:    sync
; MM-NEXT:    addiu $2, $zero, -4
; MM-NEXT:    and $2, $4, $2
; MM-NEXT:    andi $3, $4, 3
; MM-NEXT:    xori $3, $3, 3
; MM-NEXT:    sll $3, $3, 3
; MM-NEXT:    ori $4, $zero, 255
; MM-NEXT:    sllv $4, $4, $3
; MM-NEXT:    nor $6, $zero, $4
; MM-NEXT:    sllv $5, $5, $3
; MM-NEXT:  $BB11_1: # %entry
; MM-NEXT:    # =>This Inner Loop Header: Depth=1
; MM-NEXT:    ll $8, 0($2)
; MM-NEXT:    sltu $11, $8, $5
; MM-NEXT:    or $9, $8, $zero
; MM-NEXT:    movz $9, $5, $11
; MM-NEXT:    and $9, $9, $4
; MM-NEXT:    and $10, $8, $6
; MM-NEXT:    or $10, $10, $9
; MM-NEXT:    sc $10, 0($2)
; MM-NEXT:    beqzc $10, $BB11_1
; MM-NEXT:  # %bb.2: # %entry
; MM-NEXT:    and $7, $8, $4
; MM-NEXT:    srlv $7, $7, $3
; MM-NEXT:    seh $7, $7
; MM-NEXT:  # %bb.3: # %entry
; MM-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MM-NEXT:  # %bb.4: # %entry
; MM-NEXT:    sync
; MM-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MM-NEXT:    addiusp 8
; MM-NEXT:    jrc $ra
;
; MMR6-LABEL: test_umin_8:
; MMR6:       # %bb.0: # %entry
; MMR6-NEXT:    addiu $sp, $sp, -8
; MMR6-NEXT:    .cfi_def_cfa_offset 8
; MMR6-NEXT:    move $1, $5
; MMR6-NEXT:    sync
; MMR6-NEXT:    addiu $2, $zero, -4
; MMR6-NEXT:    and $2, $4, $2
; MMR6-NEXT:    andi $3, $4, 3
; MMR6-NEXT:    xori $3, $3, 3
; MMR6-NEXT:    sll $3, $3, 3
; MMR6-NEXT:    ori $4, $zero, 255
; MMR6-NEXT:    sllv $4, $4, $3
; MMR6-NEXT:    nor $6, $zero, $4
; MMR6-NEXT:    sllv $5, $5, $3
; MMR6-NEXT:  $BB11_1: # %entry
; MMR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMR6-NEXT:    ll $8, 0($2)
; MMR6-NEXT:    sltu $11, $8, $5
; MMR6-NEXT:    selnez $9, $8, $11
; MMR6-NEXT:    seleqz $11, $5, $11
; MMR6-NEXT:    or $9, $9, $11
; MMR6-NEXT:    and $9, $9, $4
; MMR6-NEXT:    and $10, $8, $6
; MMR6-NEXT:    or $10, $10, $9
; MMR6-NEXT:    sc $10, 0($2)
; MMR6-NEXT:    beqc $10, $zero, $BB11_1
; MMR6-NEXT:  # %bb.2: # %entry
; MMR6-NEXT:    and $7, $8, $4
; MMR6-NEXT:    srlv $7, $7, $3
; MMR6-NEXT:    seh $7, $7
; MMR6-NEXT:  # %bb.3: # %entry
; MMR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMR6-NEXT:  # %bb.4: # %entry
; MMR6-NEXT:    sync
; MMR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMR6-NEXT:    addiu $sp, $sp, 8
; MMR6-NEXT:    jrc $ra
;
; MIPSEL-LABEL: test_umin_8:
; MIPSEL:       # %bb.0: # %entry
; MIPSEL-NEXT:    addiu $sp, $sp, -8
; MIPSEL-NEXT:    .cfi_def_cfa_offset 8
; MIPSEL-NEXT:    move $1, $5
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    addiu $2, $zero, -4
; MIPSEL-NEXT:    and $2, $4, $2
; MIPSEL-NEXT:    andi $3, $4, 3
; MIPSEL-NEXT:    sll $3, $3, 3
; MIPSEL-NEXT:    ori $4, $zero, 255
; MIPSEL-NEXT:    sllv $4, $4, $3
; MIPSEL-NEXT:    nor $6, $zero, $4
; MIPSEL-NEXT:    sllv $5, $5, $3
; MIPSEL-NEXT:  $BB11_1: # %entry
; MIPSEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSEL-NEXT:    ll $8, 0($2)
; MIPSEL-NEXT:    and $8, $8, $4
; MIPSEL-NEXT:    and $5, $5, $4
; MIPSEL-NEXT:    sltu $11, $8, $5
; MIPSEL-NEXT:    move $9, $8
; MIPSEL-NEXT:    movz $9, $5, $11
; MIPSEL-NEXT:    and $9, $9, $4
; MIPSEL-NEXT:    and $10, $8, $6
; MIPSEL-NEXT:    or $10, $10, $9
; MIPSEL-NEXT:    sc $10, 0($2)
; MIPSEL-NEXT:    beqz $10, $BB11_1
; MIPSEL-NEXT:    nop
; MIPSEL-NEXT:  # %bb.2: # %entry
; MIPSEL-NEXT:    and $7, $8, $4
; MIPSEL-NEXT:    srlv $7, $7, $3
; MIPSEL-NEXT:    seh $7, $7
; MIPSEL-NEXT:  # %bb.3: # %entry
; MIPSEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSEL-NEXT:  # %bb.4: # %entry
; MIPSEL-NEXT:    sync
; MIPSEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSEL-NEXT:    addiu $sp, $sp, 8
; MIPSEL-NEXT:    jr $ra
; MIPSEL-NEXT:    nop
;
; MIPSELR6-LABEL: test_umin_8:
; MIPSELR6:       # %bb.0: # %entry
; MIPSELR6-NEXT:    addiu $sp, $sp, -8
; MIPSELR6-NEXT:    .cfi_def_cfa_offset 8
; MIPSELR6-NEXT:    move $1, $5
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    addiu $2, $zero, -4
; MIPSELR6-NEXT:    and $2, $4, $2
; MIPSELR6-NEXT:    andi $3, $4, 3
; MIPSELR6-NEXT:    sll $3, $3, 3
; MIPSELR6-NEXT:    ori $4, $zero, 255
; MIPSELR6-NEXT:    sllv $4, $4, $3
; MIPSELR6-NEXT:    nor $6, $zero, $4
; MIPSELR6-NEXT:    sllv $5, $5, $3
; MIPSELR6-NEXT:  $BB11_1: # %entry
; MIPSELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPSELR6-NEXT:    ll $8, 0($2)
; MIPSELR6-NEXT:    and $8, $8, $4
; MIPSELR6-NEXT:    and $5, $5, $4
; MIPSELR6-NEXT:    sltu $11, $8, $5
; MIPSELR6-NEXT:    selnez $9, $8, $11
; MIPSELR6-NEXT:    seleqz $11, $5, $11
; MIPSELR6-NEXT:    or $9, $9, $11
; MIPSELR6-NEXT:    and $9, $9, $4
; MIPSELR6-NEXT:    and $10, $8, $6
; MIPSELR6-NEXT:    or $10, $10, $9
; MIPSELR6-NEXT:    sc $10, 0($2)
; MIPSELR6-NEXT:    beqzc $10, $BB11_1
; MIPSELR6-NEXT:  # %bb.2: # %entry
; MIPSELR6-NEXT:    and $7, $8, $4
; MIPSELR6-NEXT:    srlv $7, $7, $3
; MIPSELR6-NEXT:    seh $7, $7
; MIPSELR6-NEXT:  # %bb.3: # %entry
; MIPSELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MIPSELR6-NEXT:  # %bb.4: # %entry
; MIPSELR6-NEXT:    sync
; MIPSELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MIPSELR6-NEXT:    addiu $sp, $sp, 8
; MIPSELR6-NEXT:    jrc $ra
;
; MMEL-LABEL: test_umin_8:
; MMEL:       # %bb.0: # %entry
; MMEL-NEXT:    addiu $sp, $sp, -8
; MMEL-NEXT:    .cfi_def_cfa_offset 8
; MMEL-NEXT:    move $1, $5
; MMEL-NEXT:    sync
; MMEL-NEXT:    addiu $2, $zero, -4
; MMEL-NEXT:    and $2, $4, $2
; MMEL-NEXT:    andi $3, $4, 3
; MMEL-NEXT:    sll $3, $3, 3
; MMEL-NEXT:    ori $4, $zero, 255
; MMEL-NEXT:    sllv $4, $4, $3
; MMEL-NEXT:    nor $6, $zero, $4
; MMEL-NEXT:    sllv $5, $5, $3
; MMEL-NEXT:  $BB11_1: # %entry
; MMEL-NEXT:    # =>This Inner Loop Header: Depth=1
; MMEL-NEXT:    ll $8, 0($2)
; MMEL-NEXT:    and $8, $8, $4
; MMEL-NEXT:    and $5, $5, $4
; MMEL-NEXT:    sltu $11, $8, $5
; MMEL-NEXT:    or $9, $8, $zero
; MMEL-NEXT:    movz $9, $5, $11
; MMEL-NEXT:    and $9, $9, $4
; MMEL-NEXT:    and $10, $8, $6
; MMEL-NEXT:    or $10, $10, $9
; MMEL-NEXT:    sc $10, 0($2)
; MMEL-NEXT:    beqzc $10, $BB11_1
; MMEL-NEXT:  # %bb.2: # %entry
; MMEL-NEXT:    and $7, $8, $4
; MMEL-NEXT:    srlv $7, $7, $3
; MMEL-NEXT:    seh $7, $7
; MMEL-NEXT:  # %bb.3: # %entry
; MMEL-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMEL-NEXT:  # %bb.4: # %entry
; MMEL-NEXT:    sync
; MMEL-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMEL-NEXT:    addiusp 8
; MMEL-NEXT:    jrc $ra
;
; MMELR6-LABEL: test_umin_8:
; MMELR6:       # %bb.0: # %entry
; MMELR6-NEXT:    addiu $sp, $sp, -8
; MMELR6-NEXT:    .cfi_def_cfa_offset 8
; MMELR6-NEXT:    move $1, $5
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    addiu $2, $zero, -4
; MMELR6-NEXT:    and $2, $4, $2
; MMELR6-NEXT:    andi $3, $4, 3
; MMELR6-NEXT:    sll $3, $3, 3
; MMELR6-NEXT:    ori $4, $zero, 255
; MMELR6-NEXT:    sllv $4, $4, $3
; MMELR6-NEXT:    nor $6, $zero, $4
; MMELR6-NEXT:    sllv $5, $5, $3
; MMELR6-NEXT:  $BB11_1: # %entry
; MMELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MMELR6-NEXT:    ll $8, 0($2)
; MMELR6-NEXT:    and $8, $8, $4
; MMELR6-NEXT:    and $5, $5, $4
; MMELR6-NEXT:    sltu $11, $8, $5
; MMELR6-NEXT:    selnez $9, $8, $11
; MMELR6-NEXT:    seleqz $11, $5, $11
; MMELR6-NEXT:    or $9, $9, $11
; MMELR6-NEXT:    and $9, $9, $4
; MMELR6-NEXT:    and $10, $8, $6
; MMELR6-NEXT:    or $10, $10, $9
; MMELR6-NEXT:    sc $10, 0($2)
; MMELR6-NEXT:    beqc $10, $zero, $BB11_1
; MMELR6-NEXT:  # %bb.2: # %entry
; MMELR6-NEXT:    and $7, $8, $4
; MMELR6-NEXT:    srlv $7, $7, $3
; MMELR6-NEXT:    seh $7, $7
; MMELR6-NEXT:  # %bb.3: # %entry
; MMELR6-NEXT:    sw $7, 4($sp) # 4-byte Folded Spill
; MMELR6-NEXT:  # %bb.4: # %entry
; MMELR6-NEXT:    sync
; MMELR6-NEXT:    lw $2, 4($sp) # 4-byte Folded Reload
; MMELR6-NEXT:    addiu $sp, $sp, 8
; MMELR6-NEXT:    jrc $ra
;
; MIPS64-LABEL: test_umin_8:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    daddiu $1, $zero, -4
; MIPS64-NEXT:    and $1, $4, $1
; MIPS64-NEXT:    andi $2, $4, 3
; MIPS64-NEXT:    xori $2, $2, 3
; MIPS64-NEXT:    sll $2, $2, 3
; MIPS64-NEXT:    ori $3, $zero, 255
; MIPS64-NEXT:    sllv $3, $3, $2
; MIPS64-NEXT:    nor $6, $zero, $3
; MIPS64-NEXT:    sllv $5, $5, $2
; MIPS64-NEXT:  .LBB11_1: # %entry
; MIPS64-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64-NEXT:    ll $8, 0($1)
; MIPS64-NEXT:    sltu $11, $8, $5
; MIPS64-NEXT:    move $9, $8
; MIPS64-NEXT:    movz $9, $5, $11
; MIPS64-NEXT:    and $9, $9, $3
; MIPS64-NEXT:    and $10, $8, $6
; MIPS64-NEXT:    or $10, $10, $9
; MIPS64-NEXT:    sc $10, 0($1)
; MIPS64-NEXT:    beqz $10, .LBB11_1
; MIPS64-NEXT:    nop
; MIPS64-NEXT:  # %bb.2: # %entry
; MIPS64-NEXT:    and $7, $8, $3
; MIPS64-NEXT:    srlv $7, $7, $2
; MIPS64-NEXT:    seh $7, $7
; MIPS64-NEXT:  # %bb.3: # %entry
; MIPS64-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64-NEXT:  # %bb.4: # %entry
; MIPS64-NEXT:    sync
; MIPS64-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64-NEXT:    daddiu $sp, $sp, 16
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    nop
;
; MIPS64R6-LABEL: test_umin_8:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    daddiu $sp, $sp, -16
; MIPS64R6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64R6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    daddiu $1, $zero, -4
; MIPS64R6-NEXT:    and $1, $4, $1
; MIPS64R6-NEXT:    andi $2, $4, 3
; MIPS64R6-NEXT:    xori $2, $2, 3
; MIPS64R6-NEXT:    sll $2, $2, 3
; MIPS64R6-NEXT:    ori $3, $zero, 255
; MIPS64R6-NEXT:    sllv $3, $3, $2
; MIPS64R6-NEXT:    nor $6, $zero, $3
; MIPS64R6-NEXT:    sllv $5, $5, $2
; MIPS64R6-NEXT:  .LBB11_1: # %entry
; MIPS64R6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64R6-NEXT:    ll $8, 0($1)
; MIPS64R6-NEXT:    sltu $11, $8, $5
; MIPS64R6-NEXT:    selnez $9, $8, $11
; MIPS64R6-NEXT:    seleqz $11, $5, $11
; MIPS64R6-NEXT:    or $9, $9, $11
; MIPS64R6-NEXT:    and $9, $9, $3
; MIPS64R6-NEXT:    and $10, $8, $6
; MIPS64R6-NEXT:    or $10, $10, $9
; MIPS64R6-NEXT:    sc $10, 0($1)
; MIPS64R6-NEXT:    beqzc $10, .LBB11_1
; MIPS64R6-NEXT:  # %bb.2: # %entry
; MIPS64R6-NEXT:    and $7, $8, $3
; MIPS64R6-NEXT:    srlv $7, $7, $2
; MIPS64R6-NEXT:    seh $7, $7
; MIPS64R6-NEXT:  # %bb.3: # %entry
; MIPS64R6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64R6-NEXT:  # %bb.4: # %entry
; MIPS64R6-NEXT:    sync
; MIPS64R6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64R6-NEXT:    daddiu $sp, $sp, 16
; MIPS64R6-NEXT:    jrc $ra
;
; MIPS64EL-LABEL: test_umin_8:
; MIPS64EL:       # %bb.0: # %entry
; MIPS64EL-NEXT:    daddiu $sp, $sp, -16
; MIPS64EL-NEXT:    .cfi_def_cfa_offset 16
; MIPS64EL-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    daddiu $1, $zero, -4
; MIPS64EL-NEXT:    and $1, $4, $1
; MIPS64EL-NEXT:    andi $2, $4, 3
; MIPS64EL-NEXT:    sll $2, $2, 3
; MIPS64EL-NEXT:    ori $3, $zero, 255
; MIPS64EL-NEXT:    sllv $3, $3, $2
; MIPS64EL-NEXT:    nor $6, $zero, $3
; MIPS64EL-NEXT:    sllv $5, $5, $2
; MIPS64EL-NEXT:  .LBB11_1: # %entry
; MIPS64EL-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64EL-NEXT:    ll $8, 0($1)
; MIPS64EL-NEXT:    and $8, $8, $3
; MIPS64EL-NEXT:    and $5, $5, $3
; MIPS64EL-NEXT:    sltu $11, $8, $5
; MIPS64EL-NEXT:    move $9, $8
; MIPS64EL-NEXT:    movz $9, $5, $11
; MIPS64EL-NEXT:    and $9, $9, $3
; MIPS64EL-NEXT:    and $10, $8, $6
; MIPS64EL-NEXT:    or $10, $10, $9
; MIPS64EL-NEXT:    sc $10, 0($1)
; MIPS64EL-NEXT:    beqz $10, .LBB11_1
; MIPS64EL-NEXT:    nop
; MIPS64EL-NEXT:  # %bb.2: # %entry
; MIPS64EL-NEXT:    and $7, $8, $3
; MIPS64EL-NEXT:    srlv $7, $7, $2
; MIPS64EL-NEXT:    seh $7, $7
; MIPS64EL-NEXT:  # %bb.3: # %entry
; MIPS64EL-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64EL-NEXT:  # %bb.4: # %entry
; MIPS64EL-NEXT:    sync
; MIPS64EL-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64EL-NEXT:    daddiu $sp, $sp, 16
; MIPS64EL-NEXT:    jr $ra
; MIPS64EL-NEXT:    nop
;
; MIPS64ELR6-LABEL: test_umin_8:
; MIPS64ELR6:       # %bb.0: # %entry
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, -16
; MIPS64ELR6-NEXT:    .cfi_def_cfa_offset 16
; MIPS64ELR6-NEXT:    # kill: def $a1 killed $a1 killed $a1_64
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    daddiu $1, $zero, -4
; MIPS64ELR6-NEXT:    and $1, $4, $1
; MIPS64ELR6-NEXT:    andi $2, $4, 3
; MIPS64ELR6-NEXT:    sll $2, $2, 3
; MIPS64ELR6-NEXT:    ori $3, $zero, 255
; MIPS64ELR6-NEXT:    sllv $3, $3, $2
; MIPS64ELR6-NEXT:    nor $6, $zero, $3
; MIPS64ELR6-NEXT:    sllv $5, $5, $2
; MIPS64ELR6-NEXT:  .LBB11_1: # %entry
; MIPS64ELR6-NEXT:    # =>This Inner Loop Header: Depth=1
; MIPS64ELR6-NEXT:    ll $8, 0($1)
; MIPS64ELR6-NEXT:    and $8, $8, $3
; MIPS64ELR6-NEXT:    and $5, $5, $3
; MIPS64ELR6-NEXT:    sltu $11, $8, $5
; MIPS64ELR6-NEXT:    selnez $9, $8, $11
; MIPS64ELR6-NEXT:    seleqz $11, $5, $11
; MIPS64ELR6-NEXT:    or $9, $9, $11
; MIPS64ELR6-NEXT:    and $9, $9, $3
; MIPS64ELR6-NEXT:    and $10, $8, $6
; MIPS64ELR6-NEXT:    or $10, $10, $9
; MIPS64ELR6-NEXT:    sc $10, 0($1)
; MIPS64ELR6-NEXT:    beqzc $10, .LBB11_1
; MIPS64ELR6-NEXT:  # %bb.2: # %entry
; MIPS64ELR6-NEXT:    and $7, $8, $3
; MIPS64ELR6-NEXT:    srlv $7, $7, $2
; MIPS64ELR6-NEXT:    seh $7, $7
; MIPS64ELR6-NEXT:  # %bb.3: # %entry
; MIPS64ELR6-NEXT:    sw $7, 12($sp) # 4-byte Folded Spill
; MIPS64ELR6-NEXT:  # %bb.4: # %entry
; MIPS64ELR6-NEXT:    sync
; MIPS64ELR6-NEXT:    lw $2, 12($sp) # 4-byte Folded Reload
; MIPS64ELR6-NEXT:    daddiu $sp, $sp, 16
; MIPS64ELR6-NEXT:    jrc $ra
entry:
  %0 = atomicrmw umin i8* %ptr, i8 %val seq_cst
  ret i8 %0
}
