; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vbmi2 | FileCheck %s --check-prefixes=AVX512,AVX512VBMI2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VLBW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vbmi2,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VLVBMI2

declare <8 x i64> @llvm.fshl.v8i64(<8 x i64>, <8 x i64>, <8 x i64>)
declare <16 x i32> @llvm.fshl.v16i32(<16 x i32>, <16 x i32>, <16 x i32>)
declare <32 x i16> @llvm.fshl.v32i16(<32 x i16>, <32 x i16>, <32 x i16>)
declare <64 x i8> @llvm.fshl.v64i8(<64 x i8>, <64 x i8>, <64 x i8>)

;
; Variable Shifts
;

define <8 x i64> @var_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512F-NEXT:    vpsllvq %zmm2, %zmm0, %zmm3
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} zmm4 = [64,64,64,64,64,64,64,64]
; AVX512F-NEXT:    vpsubq %zmm2, %zmm4, %zmm4
; AVX512F-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512VL-NEXT:    vpsllvq %zmm2, %zmm0, %zmm3
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} zmm4 = [64,64,64,64,64,64,64,64]
; AVX512VL-NEXT:    vpsubq %zmm2, %zmm4, %zmm4
; AVX512VL-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512VL-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllvq %zmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vpbroadcastq {{.*#+}} zmm4 = [64,64,64,64,64,64,64,64]
; AVX512BW-NEXT:    vpsubq %zmm2, %zmm4, %zmm4
; AVX512BW-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllvq %zmm2, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpbroadcastq {{.*#+}} zmm4 = [64,64,64,64,64,64,64,64]
; AVX512VLBW-NEXT:    vpsubq %zmm2, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpsrlvq %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %amt)
  ret <8 x i64> %res
}

define <16 x i32> @var_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512F-NEXT:    vpsllvd %zmm2, %zmm0, %zmm3
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} zmm4 = [32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32]
; AVX512F-NEXT:    vpsubd %zmm2, %zmm4, %zmm4
; AVX512F-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512VL-NEXT:    vpsllvd %zmm2, %zmm0, %zmm3
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} zmm4 = [32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32]
; AVX512VL-NEXT:    vpsubd %zmm2, %zmm4, %zmm4
; AVX512VL-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512VL-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllvd %zmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} zmm4 = [32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32]
; AVX512BW-NEXT:    vpsubd %zmm2, %zmm4, %zmm4
; AVX512BW-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllvd %zmm2, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpbroadcastd {{.*#+}} zmm4 = [32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32]
; AVX512VLBW-NEXT:    vpsubd %zmm2, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpsrlvd %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %amt)
  ret <16 x i32> %res
}

define <32 x i16> @var_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512F-NEXT:    vextracti64x4 $1, %zmm2, %ymm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm7 = ymm5[0],zero,ymm5[1],zero,ymm5[2],zero,ymm5[3],zero,ymm5[4],zero,ymm5[5],zero,ymm5[6],zero,ymm5[7],zero,ymm5[8],zero,ymm5[9],zero,ymm5[10],zero,ymm5[11],zero,ymm5[12],zero,ymm5[13],zero,ymm5[14],zero,ymm5[15],zero
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm8 = ymm4[0],zero,ymm4[1],zero,ymm4[2],zero,ymm4[3],zero,ymm4[4],zero,ymm4[5],zero,ymm4[6],zero,ymm4[7],zero,ymm4[8],zero,ymm4[9],zero,ymm4[10],zero,ymm4[11],zero,ymm4[12],zero,ymm4[13],zero,ymm4[14],zero,ymm4[15],zero
; AVX512F-NEXT:    vpsllvd %zmm7, %zmm8, %zmm7
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm8 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512F-NEXT:    vpsubw %ymm5, %ymm8, %ymm9
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm9 = ymm9[0],zero,ymm9[1],zero,ymm9[2],zero,ymm9[3],zero,ymm9[4],zero,ymm9[5],zero,ymm9[6],zero,ymm9[7],zero,ymm9[8],zero,ymm9[9],zero,ymm9[10],zero,ymm9[11],zero,ymm9[12],zero,ymm9[13],zero,ymm9[14],zero,ymm9[15],zero
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm3 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm9, %zmm3, %zmm3
; AVX512F-NEXT:    vpord %zmm3, %zmm7, %zmm3
; AVX512F-NEXT:    vpmovdw %zmm3, %ymm3
; AVX512F-NEXT:    vpxor %xmm7, %xmm7, %xmm7
; AVX512F-NEXT:    vpcmpeqw %ymm7, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpand %ymm6, %ymm2, %ymm2
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm5 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512F-NEXT:    vpsllvd %zmm4, %zmm5, %zmm4
; AVX512F-NEXT:    vpsubw %ymm2, %ymm8, %ymm5
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm5 = ymm5[0],zero,ymm5[1],zero,ymm5[2],zero,ymm5[3],zero,ymm5[4],zero,ymm5[5],zero,ymm5[6],zero,ymm5[7],zero,ymm5[8],zero,ymm5[9],zero,ymm5[10],zero,ymm5[11],zero,ymm5[12],zero,ymm5[13],zero,ymm5[14],zero,ymm5[15],zero
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512F-NEXT:    vpsrlvd %zmm5, %zmm1, %zmm1
; AVX512F-NEXT:    vpord %zmm1, %zmm4, %zmm1
; AVX512F-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512F-NEXT:    vpcmpeqw %ymm7, %ymm2, %ymm2
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm2, %ymm5
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm6 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm6, %ymm5, %ymm5
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm7 = ymm5[0],zero,ymm5[1],zero,ymm5[2],zero,ymm5[3],zero,ymm5[4],zero,ymm5[5],zero,ymm5[6],zero,ymm5[7],zero,ymm5[8],zero,ymm5[9],zero,ymm5[10],zero,ymm5[11],zero,ymm5[12],zero,ymm5[13],zero,ymm5[14],zero,ymm5[15],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm8 = ymm4[0],zero,ymm4[1],zero,ymm4[2],zero,ymm4[3],zero,ymm4[4],zero,ymm4[5],zero,ymm4[6],zero,ymm4[7],zero,ymm4[8],zero,ymm4[9],zero,ymm4[10],zero,ymm4[11],zero,ymm4[12],zero,ymm4[13],zero,ymm4[14],zero,ymm4[15],zero
; AVX512VL-NEXT:    vpsllvd %zmm7, %zmm8, %zmm7
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm8 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512VL-NEXT:    vpsubw %ymm5, %ymm8, %ymm9
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm9 = ymm9[0],zero,ymm9[1],zero,ymm9[2],zero,ymm9[3],zero,ymm9[4],zero,ymm9[5],zero,ymm9[6],zero,ymm9[7],zero,ymm9[8],zero,ymm9[9],zero,ymm9[10],zero,ymm9[11],zero,ymm9[12],zero,ymm9[13],zero,ymm9[14],zero,ymm9[15],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm3 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm9, %zmm3, %zmm3
; AVX512VL-NEXT:    vpord %zmm3, %zmm7, %zmm3
; AVX512VL-NEXT:    vpmovdw %zmm3, %ymm3
; AVX512VL-NEXT:    vpxor %xmm7, %xmm7, %xmm7
; AVX512VL-NEXT:    vpcmpeqw %ymm7, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpand %ymm6, %ymm2, %ymm2
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm4 = ymm2[0],zero,ymm2[1],zero,ymm2[2],zero,ymm2[3],zero,ymm2[4],zero,ymm2[5],zero,ymm2[6],zero,ymm2[7],zero,ymm2[8],zero,ymm2[9],zero,ymm2[10],zero,ymm2[11],zero,ymm2[12],zero,ymm2[13],zero,ymm2[14],zero,ymm2[15],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm5 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; AVX512VL-NEXT:    vpsllvd %zmm4, %zmm5, %zmm4
; AVX512VL-NEXT:    vpsubw %ymm2, %ymm8, %ymm5
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm5 = ymm5[0],zero,ymm5[1],zero,ymm5[2],zero,ymm5[3],zero,ymm5[4],zero,ymm5[5],zero,ymm5[6],zero,ymm5[7],zero,ymm5[8],zero,ymm5[9],zero,ymm5[10],zero,ymm5[11],zero,ymm5[12],zero,ymm5[13],zero,ymm5[14],zero,ymm5[15],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero
; AVX512VL-NEXT:    vpsrlvd %zmm5, %zmm1, %zmm1
; AVX512VL-NEXT:    vpord %zmm1, %zmm4, %zmm1
; AVX512VL-NEXT:    vpmovdw %zmm1, %ymm1
; AVX512VL-NEXT:    vpcmpeqw %ymm7, %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllvw %zmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512BW-NEXT:    vpsubw %zmm2, %zmm4, %zmm4
; AVX512BW-NEXT:    vpsrlvw %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllvw %zmm2, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16]
; AVX512VLBW-NEXT:    vpsubw %zmm2, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpsrlvw %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %amt)
  ret <32 x i16> %res
}

define <64 x i8> @var_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %amt) nounwind {
; AVX512F-LABEL: var_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm8
; AVX512F-NEXT:    vextracti64x4 $1, %zmm2, %ymm6
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpsllw $4, %ymm3, %ymm5
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %ymm4, %ymm5, %ymm7
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm5 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512F-NEXT:    vpand %ymm5, %ymm6, %ymm9
; AVX512F-NEXT:    vpsllw $5, %ymm9, %ymm10
; AVX512F-NEXT:    vpblendvb %ymm10, %ymm7, %ymm3, %ymm7
; AVX512F-NEXT:    vpsllw $2, %ymm7, %ymm11
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm6 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512F-NEXT:    vpand %ymm6, %ymm11, %ymm11
; AVX512F-NEXT:    vpaddb %ymm10, %ymm10, %ymm10
; AVX512F-NEXT:    vpblendvb %ymm10, %ymm11, %ymm7, %ymm7
; AVX512F-NEXT:    vpaddb %ymm7, %ymm7, %ymm11
; AVX512F-NEXT:    vpaddb %ymm10, %ymm10, %ymm10
; AVX512F-NEXT:    vpblendvb %ymm10, %ymm11, %ymm7, %ymm10
; AVX512F-NEXT:    vpsrlw $4, %ymm8, %ymm11
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm7 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512F-NEXT:    vpand %ymm7, %ymm11, %ymm11
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm12 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512F-NEXT:    vpsubb %ymm9, %ymm12, %ymm13
; AVX512F-NEXT:    vpsllw $5, %ymm13, %ymm13
; AVX512F-NEXT:    vpblendvb %ymm13, %ymm11, %ymm8, %ymm8
; AVX512F-NEXT:    vpsrlw $2, %ymm8, %ymm11
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm14 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512F-NEXT:    vpand %ymm14, %ymm11, %ymm11
; AVX512F-NEXT:    vpaddb %ymm13, %ymm13, %ymm13
; AVX512F-NEXT:    vpblendvb %ymm13, %ymm11, %ymm8, %ymm8
; AVX512F-NEXT:    vpsrlw $1, %ymm8, %ymm11
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm15 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512F-NEXT:    vpand %ymm15, %ymm11, %ymm11
; AVX512F-NEXT:    vpaddb %ymm13, %ymm13, %ymm13
; AVX512F-NEXT:    vpblendvb %ymm13, %ymm11, %ymm8, %ymm8
; AVX512F-NEXT:    vpor %ymm8, %ymm10, %ymm8
; AVX512F-NEXT:    vpxor %xmm10, %xmm10, %xmm10
; AVX512F-NEXT:    vpcmpeqb %ymm10, %ymm9, %ymm9
; AVX512F-NEXT:    vpblendvb %ymm9, %ymm3, %ymm8, %ymm3
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm8
; AVX512F-NEXT:    vpand %ymm4, %ymm8, %ymm4
; AVX512F-NEXT:    vpand %ymm5, %ymm2, %ymm2
; AVX512F-NEXT:    vpsllw $5, %ymm2, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm4, %ymm0, %ymm4
; AVX512F-NEXT:    vpsllw $2, %ymm4, %ymm8
; AVX512F-NEXT:    vpand %ymm6, %ymm8, %ymm6
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm6, %ymm4, %ymm4
; AVX512F-NEXT:    vpaddb %ymm4, %ymm4, %ymm6
; AVX512F-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm5, %ymm6, %ymm4, %ymm4
; AVX512F-NEXT:    vpsrlw $4, %ymm1, %ymm5
; AVX512F-NEXT:    vpand %ymm7, %ymm5, %ymm5
; AVX512F-NEXT:    vpsubb %ymm2, %ymm12, %ymm6
; AVX512F-NEXT:    vpsllw $5, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $2, %ymm1, %ymm5
; AVX512F-NEXT:    vpand %ymm5, %ymm14, %ymm5
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm5
; AVX512F-NEXT:    vpand %ymm5, %ymm15, %ymm5
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm6
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm10, %ymm2
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm4
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm2, %ymm5
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512VL-NEXT:    vpsllw $4, %ymm3, %ymm6
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm7 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpand %ymm7, %ymm6, %ymm6
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm8 = [7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7]
; AVX512VL-NEXT:    vpand %ymm5, %ymm8, %ymm5
; AVX512VL-NEXT:    vpsllw $5, %ymm5, %ymm9
; AVX512VL-NEXT:    vpblendvb %ymm9, %ymm6, %ymm3, %ymm6
; AVX512VL-NEXT:    vpsllw $2, %ymm6, %ymm10
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm11 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512VL-NEXT:    vpand %ymm11, %ymm10, %ymm10
; AVX512VL-NEXT:    vpaddb %ymm9, %ymm9, %ymm9
; AVX512VL-NEXT:    vpblendvb %ymm9, %ymm10, %ymm6, %ymm6
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm10
; AVX512VL-NEXT:    vpaddb %ymm9, %ymm9, %ymm9
; AVX512VL-NEXT:    vpblendvb %ymm9, %ymm10, %ymm6, %ymm6
; AVX512VL-NEXT:    vpsrlw $4, %ymm4, %ymm9
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm10 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; AVX512VL-NEXT:    vpand %ymm10, %ymm9, %ymm9
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm12 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VL-NEXT:    vpsubb %ymm5, %ymm12, %ymm13
; AVX512VL-NEXT:    vpsllw $5, %ymm13, %ymm13
; AVX512VL-NEXT:    vpblendvb %ymm13, %ymm9, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsrlw $2, %ymm4, %ymm9
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm14 = [63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63]
; AVX512VL-NEXT:    vpand %ymm14, %ymm9, %ymm9
; AVX512VL-NEXT:    vpaddb %ymm13, %ymm13, %ymm13
; AVX512VL-NEXT:    vpblendvb %ymm13, %ymm9, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsrlw $1, %ymm4, %ymm9
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm15 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX512VL-NEXT:    vpand %ymm15, %ymm9, %ymm9
; AVX512VL-NEXT:    vpaddb %ymm13, %ymm13, %ymm13
; AVX512VL-NEXT:    vpblendvb %ymm13, %ymm9, %ymm4, %ymm4
; AVX512VL-NEXT:    vpor %ymm4, %ymm6, %ymm4
; AVX512VL-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX512VL-NEXT:    vpcmpeqb %ymm6, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm3, %ymm4, %ymm3
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm4
; AVX512VL-NEXT:    vpand %ymm7, %ymm4, %ymm4
; AVX512VL-NEXT:    vpand %ymm2, %ymm8, %ymm2
; AVX512VL-NEXT:    vpsllw $5, %ymm2, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm4, %ymm0, %ymm4
; AVX512VL-NEXT:    vpsllw $2, %ymm4, %ymm7
; AVX512VL-NEXT:    vpand %ymm7, %ymm11, %ymm7
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm7, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm4, %ymm4, %ymm7
; AVX512VL-NEXT:    vpaddb %ymm5, %ymm5, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm5, %ymm7, %ymm4, %ymm4
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm10, %ymm5
; AVX512VL-NEXT:    vpsubb %ymm2, %ymm12, %ymm7
; AVX512VL-NEXT:    vpsllw $5, %ymm7, %ymm7
; AVX512VL-NEXT:    vpblendvb %ymm7, %ymm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $2, %ymm1, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm14, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm7, %ymm7, %ymm7
; AVX512VL-NEXT:    vpblendvb %ymm7, %ymm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlw $1, %ymm1, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm15, %ymm5
; AVX512VL-NEXT:    vpaddb %ymm7, %ymm7, %ymm7
; AVX512VL-NEXT:    vpblendvb %ymm7, %ymm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX512VL-NEXT:    vpcmpeqb %ymm6, %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512BW-NEXT:    vpsubb %zmm2, %zmm3, %zmm3
; AVX512BW-NEXT:    vpsllw $5, %zmm3, %zmm3
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm3, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vpmovb2m %zmm3, %k2
; AVX512BW-NEXT:    vpsrlw $4, %zmm1, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k2}
; AVX512BW-NEXT:    vpsrlw $2, %zmm1, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsrlw $1, %zmm1, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vpsllw $5, %zmm2, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vpsllw $2, %zmm3, %zmm5
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512BW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm5, %zmm3 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512BW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VBMI2-NEXT:    vpsubb %zmm2, %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpsllw $5, %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vpmovb2m %zmm3, %k2
; AVX512VBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k2}
; AVX512VBMI2-NEXT:    vpsrlw $2, %zmm1, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpsllw $5, %zmm2, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vpsllw $2, %zmm3, %zmm5
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512VBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm5, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VBMI2-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLBW-NEXT:    vpsubb %zmm2, %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpsllw $5, %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpaddb %zmm3, %zmm3, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vpmovb2m %zmm3, %k2
; AVX512VLBW-NEXT:    vpsrlw $4, %zmm1, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k2}
; AVX512VLBW-NEXT:    vpsrlw $2, %zmm1, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vpsrlw $1, %zmm1, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpsllw $5, %zmm2, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vpsllw $2, %zmm3, %zmm5
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512VLBW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm5, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLBW-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLVBMI2-NEXT:    vpsubb %zmm2, %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpsllw $5, %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm3, %k2
; AVX512VLVBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k2}
; AVX512VLVBMI2-NEXT:    vpsrlw $2, %zmm1, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vpsrlw $1, %zmm1, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm3, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpsllw $5, %zmm2, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vpsllw $2, %zmm3, %zmm5
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm5, %zmm5
; AVX512VLVBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm5, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vpaddb %zmm4, %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm4, %k1
; AVX512VLVBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLVBMI2-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %amt)
  ret <64 x i8> %res
}

;
; Uniform Variable Shifts
;

define <8 x i64> @splatvar_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512F-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512F-NEXT:    vpsllq %xmm2, %zmm0, %zmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512F-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512VL-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512VL-NEXT:    vpsllq %xmm2, %zmm0, %zmm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512VL-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512VL-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512BW-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllq %xmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512BW-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip){1to8}, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllq %xmm2, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512VLBW-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpsrlq %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa64 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastq %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpshldvq %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <8 x i64> %amt, <8 x i64> undef, <8 x i32> zeroinitializer
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> %splat)
  ret <8 x i64> %res
}

define <16 x i32> @splatvar_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512F-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512F-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512F-NEXT:    vpslld %xmm3, %zmm0, %zmm3
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512F-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512F-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512F-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512F-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512VL-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512VL-NEXT:    vpslld %xmm3, %zmm0, %zmm3
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512VL-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512VL-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512VL-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512VL-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512VL-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512BW-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512BW-NEXT:    vpslld %xmm3, %zmm0, %zmm3
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512BW-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512BW-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512VLBW-NEXT:    vpandd {{.*}}(%rip){1to16}, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512VLBW-NEXT:    vpslld %xmm3, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512VLBW-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512VLBW-NEXT:    vpsrld %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa32 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastd %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpshldvd %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <16 x i32> %amt, <16 x i32> undef, <16 x i32> zeroinitializer
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> %splat)
  ret <16 x i32> %res
}

define <32 x i16> @splatvar_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512F-NEXT:    vpbroadcastw %xmm2, %ymm2
; AVX512F-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} xmm5 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512F-NEXT:    vpsllw %xmm5, %ymm4, %ymm6
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm7 = [16,16,16,16,16,16,16,16]
; AVX512F-NEXT:    vpsubw %xmm2, %xmm7, %xmm7
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero
; AVX512F-NEXT:    vpsrlw %xmm7, %ymm3, %ymm3
; AVX512F-NEXT:    vpor %ymm3, %ymm6, %ymm3
; AVX512F-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX512F-NEXT:    vpcmpeqw %ymm6, %ymm2, %ymm2
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpsllw %xmm5, %ymm0, %ymm4
; AVX512F-NEXT:    vpsrlw %xmm7, %ymm1, %ymm1
; AVX512F-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512VL-NEXT:    vpbroadcastw %xmm2, %ymm2
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm5 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512VL-NEXT:    vpsllw %xmm5, %ymm4, %ymm6
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm7 = [16,16,16,16,16,16,16,16]
; AVX512VL-NEXT:    vpsubw %xmm2, %xmm7, %xmm7
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero
; AVX512VL-NEXT:    vpsrlw %xmm7, %ymm3, %ymm3
; AVX512VL-NEXT:    vpor %ymm3, %ymm6, %ymm3
; AVX512VL-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX512VL-NEXT:    vpcmpeqw %ymm6, %ymm2, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsllw %xmm5, %ymm0, %ymm4
; AVX512VL-NEXT:    vpsrlw %xmm7, %ymm1, %ymm1
; AVX512VL-NEXT:    vpor %ymm1, %ymm4, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm3, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw %xmm2, %zmm2
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm3, %zmm0, %zmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512BW-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512BW-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastw %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastw %xmm2, %zmm2
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512VLBW-NEXT:    vpsllw %xmm3, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512VLBW-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512VLBW-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastw %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpshldvw %zmm2, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <32 x i16> %amt, <32 x i16> undef, <32 x i32> zeroinitializer
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> %splat)
  ret <32 x i16> %res
}

define <64 x i8> @splatvar_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %amt) nounwind {
; AVX512F-LABEL: splatvar_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm9
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512F-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX512F-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpmovzxbq {{.*#+}} xmm5 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vpsllw %xmm5, %ymm4, %ymm6
; AVX512F-NEXT:    vpcmpeqd %xmm8, %xmm8, %xmm8
; AVX512F-NEXT:    vpsllw %xmm5, %xmm8, %xmm7
; AVX512F-NEXT:    vpbroadcastb %xmm7, %ymm7
; AVX512F-NEXT:    vpand %ymm7, %ymm6, %ymm10
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm3 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512F-NEXT:    vpsubb %xmm2, %xmm3, %xmm3
; AVX512F-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,zero,zero,zero,zero,xmm3[1],zero,zero,zero,zero,zero,zero,zero
; AVX512F-NEXT:    vpsrlw %xmm3, %ymm9, %ymm9
; AVX512F-NEXT:    vpsrlw %xmm3, %xmm8, %xmm6
; AVX512F-NEXT:    vpsrlw $8, %xmm6, %xmm6
; AVX512F-NEXT:    vpbroadcastb %xmm6, %ymm6
; AVX512F-NEXT:    vpand %ymm6, %ymm9, %ymm8
; AVX512F-NEXT:    vpor %ymm8, %ymm10, %ymm8
; AVX512F-NEXT:    vpxor %xmm9, %xmm9, %xmm9
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm9, %ymm2
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm4, %ymm8, %ymm4
; AVX512F-NEXT:    vpsllw %xmm5, %ymm0, %ymm5
; AVX512F-NEXT:    vpand %ymm7, %ymm5, %ymm5
; AVX512F-NEXT:    vpsrlw %xmm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm6, %ymm1, %ymm1
; AVX512F-NEXT:    vpor %ymm1, %ymm5, %ymm1
; AVX512F-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm9
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm4
; AVX512VL-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm5 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    vpsllw %xmm5, %ymm4, %ymm6
; AVX512VL-NEXT:    vpcmpeqd %xmm8, %xmm8, %xmm8
; AVX512VL-NEXT:    vpsllw %xmm5, %xmm8, %xmm7
; AVX512VL-NEXT:    vpbroadcastb %xmm7, %ymm7
; AVX512VL-NEXT:    vpand %ymm7, %ymm6, %ymm10
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm3 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VL-NEXT:    vpsubb %xmm2, %xmm3, %xmm3
; AVX512VL-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,zero,zero,zero,zero,xmm3[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VL-NEXT:    vpsrlw %xmm3, %ymm9, %ymm9
; AVX512VL-NEXT:    vpsrlw %xmm3, %xmm8, %xmm6
; AVX512VL-NEXT:    vpsrlw $8, %xmm6, %xmm6
; AVX512VL-NEXT:    vpbroadcastb %xmm6, %ymm6
; AVX512VL-NEXT:    vpand %ymm6, %ymm9, %ymm8
; AVX512VL-NEXT:    vpor %ymm8, %ymm10, %ymm8
; AVX512VL-NEXT:    vpxor %xmm9, %xmm9, %xmm9
; AVX512VL-NEXT:    vpcmpeqb %ymm2, %ymm9, %ymm2
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm4, %ymm8, %ymm4
; AVX512VL-NEXT:    vpsllw %xmm5, %ymm0, %ymm5
; AVX512VL-NEXT:    vpand %ymm7, %ymm5, %ymm5
; AVX512VL-NEXT:    vpsrlw %xmm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpand %ymm6, %ymm1, %ymm1
; AVX512VL-NEXT:    vpor %ymm1, %ymm5, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm2, %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm4, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb %xmm2, %zmm2
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm3, %zmm0, %zmm4
; AVX512BW-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512BW-NEXT:    vpsllw %xmm3, %xmm5, %xmm3
; AVX512BW-NEXT:    vpbroadcastb %xmm3, %zmm3
; AVX512BW-NEXT:    vpandq %zmm3, %zmm4, %zmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512BW-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512BW-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlw %xmm4, %xmm5, %xmm4
; AVX512BW-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX512BW-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512BW-NEXT:    vpandq %zmm4, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpbroadcastb %xmm2, %zmm2
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VBMI2-NEXT:    vpsllw %xmm3, %zmm0, %zmm4
; AVX512VBMI2-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VBMI2-NEXT:    vpsllw %xmm3, %xmm5, %xmm3
; AVX512VBMI2-NEXT:    vpbroadcastb %xmm3, %zmm3
; AVX512VBMI2-NEXT:    vpandq %zmm3, %zmm4, %zmm3
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VBMI2-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VBMI2-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpsrlw %xmm4, %xmm5, %xmm4
; AVX512VBMI2-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512VBMI2-NEXT:    vpandq %zmm4, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VBMI2-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastb %xmm2, %zmm2
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLBW-NEXT:    vpsllw %xmm3, %zmm0, %zmm4
; AVX512VLBW-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VLBW-NEXT:    vpsllw %xmm3, %xmm5, %xmm3
; AVX512VLBW-NEXT:    vpbroadcastb %xmm3, %zmm3
; AVX512VLBW-NEXT:    vpandq %zmm3, %zmm4, %zmm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLBW-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLBW-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlw %xmm4, %xmm5, %xmm4
; AVX512VLBW-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512VLBW-NEXT:    vpandq %zmm4, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastb %xmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLVBMI2-NEXT:    vpsllw %xmm3, %zmm0, %zmm4
; AVX512VLVBMI2-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX512VLVBMI2-NEXT:    vpsllw %xmm3, %xmm5, %xmm3
; AVX512VLVBMI2-NEXT:    vpbroadcastb %xmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq %zmm3, %zmm4, %zmm3
; AVX512VLVBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLVBMI2-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VLVBMI2-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX512VLVBMI2-NEXT:    vpsrlw %xmm4, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpsrlw %xmm4, %xmm5, %xmm4
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX512VLVBMI2-NEXT:    vpbroadcastb %xmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpandq %zmm4, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLVBMI2-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %splat = shufflevector <64 x i8> %amt, <64 x i8> undef, <64 x i32> zeroinitializer
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> %splat)
  ret <64 x i8> %res
}

;
; Constant Shifts
;

define <8 x i64> @constant_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512F-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VL-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvq {{.*}}(%rip), %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvq {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllvq {{.*}}(%rip), %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvq {{.*}}(%rip), %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> <i64 4, i64 14, i64 50, i64 60, i64 4, i64 14, i64 50, i64 60>)
  ret <8 x i64> %res
}

define <16 x i32> @constant_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512F-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512VL-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvd {{.*}}(%rip), %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvd {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvd {{.*}}(%rip), %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> <i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>)
  ret <16 x i32> %res
}

define <32 x i16> @constant_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768>
; AVX512F-NEXT:    vpmulhuw %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpmullw %ymm4, %ymm2, %ymm5
; AVX512F-NEXT:    vpor %ymm3, %ymm5, %ymm3
; AVX512F-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm3[1,2,3,4,5,6,7],ymm2[8],ymm3[9,10,11,12,13,14,15]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX512F-NEXT:    vpmulhuw %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm4, %ymm0, %ymm3
; AVX512F-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX512F-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6,7],ymm0[8],ymm1[9,10,11,12,13,14,15]
; AVX512F-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm4 = <u,2,4,8,16,32,64,128,256,512,1024,2048,4096,8192,16384,32768>
; AVX512VL-NEXT:    vpmulhuw %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpmullw %ymm4, %ymm2, %ymm5
; AVX512VL-NEXT:    vpor %ymm3, %ymm5, %ymm3
; AVX512VL-NEXT:    vpblendw {{.*#+}} ymm2 = ymm2[0],ymm3[1,2,3,4,5,6,7],ymm2[8],ymm3[9,10,11,12,13,14,15]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX512VL-NEXT:    vpmulhuw %ymm4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpmullw %ymm4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX512VL-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3,4,5,6,7],ymm0[8],ymm1[9,10,11,12,13,14,15]
; AVX512VL-NEXT:    vpblendd {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm0, %zmm2
; AVX512BW-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512BW-NEXT:    movl $65537, %eax # imm = 0x10001
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldvw {{.*}}(%rip), %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm0, %zmm2
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm2, %zmm1
; AVX512VLBW-NEXT:    movl $65537, %eax # imm = 0x10001
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovdqu16 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldvw {{.*}}(%rip), %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15, i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>)
  ret <32 x i16> %res
}

define <64 x i8> @constant_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; AVX512F-LABEL: constant_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpsllw $4, %ymm3, %ymm4
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm5 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512F-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm4
; AVX512F-NEXT:    vpsllw $2, %ymm4, %ymm7
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm8 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512F-NEXT:    vpand %ymm7, %ymm8, %ymm7
; AVX512F-NEXT:    vpaddb %ymm6, %ymm6, %ymm9
; AVX512F-NEXT:    vpblendvb %ymm9, %ymm7, %ymm4, %ymm4
; AVX512F-NEXT:    vpaddb %ymm4, %ymm4, %ymm7
; AVX512F-NEXT:    vpaddb %ymm9, %ymm9, %ymm10
; AVX512F-NEXT:    vpblendvb %ymm10, %ymm7, %ymm4, %ymm4
; AVX512F-NEXT:    vpxor %xmm7, %xmm7, %xmm7
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm11 = ymm2[8],ymm7[8],ymm2[9],ymm7[9],ymm2[10],ymm7[10],ymm2[11],ymm7[11],ymm2[12],ymm7[12],ymm2[13],ymm7[13],ymm2[14],ymm7[14],ymm2[15],ymm7[15],ymm2[24],ymm7[24],ymm2[25],ymm7[25],ymm2[26],ymm7[26],ymm2[27],ymm7[27],ymm2[28],ymm7[28],ymm2[29],ymm7[29],ymm2[30],ymm7[30],ymm2[31],ymm7[31]
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; AVX512F-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX512F-NEXT:    vpmullw %ymm12, %ymm11, %ymm11
; AVX512F-NEXT:    vpsrlw $8, %ymm11, %ymm11
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm7[0],ymm2[1],ymm7[1],ymm2[2],ymm7[2],ymm2[3],ymm7[3],ymm2[4],ymm7[4],ymm2[5],ymm7[5],ymm2[6],ymm7[6],ymm2[7],ymm7[7],ymm2[16],ymm7[16],ymm2[17],ymm7[17],ymm2[18],ymm7[18],ymm2[19],ymm7[19],ymm2[20],ymm7[20],ymm2[21],ymm7[21],ymm2[22],ymm7[22],ymm2[23],ymm7[23]
; AVX512F-NEXT:    vbroadcasti128 {{.*#+}} ymm13 = [256,2,4,8,16,32,64,128,256,2,4,8,16,32,64,128]
; AVX512F-NEXT:    # ymm13 = mem[0,1,0,1]
; AVX512F-NEXT:    vpmullw %ymm2, %ymm13, %ymm2
; AVX512F-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512F-NEXT:    vpackuswb %ymm11, %ymm2, %ymm2
; AVX512F-NEXT:    vpor %ymm2, %ymm4, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [18446744073709551360,18446744073709551360,18446744073709551360,18446744073709551360]
; AVX512F-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm3
; AVX512F-NEXT:    vpand %ymm5, %ymm3, %ymm3
; AVX512F-NEXT:    vpblendvb %ymm6, %ymm3, %ymm0, %ymm3
; AVX512F-NEXT:    vpsllw $2, %ymm3, %ymm5
; AVX512F-NEXT:    vpand %ymm5, %ymm8, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm9, %ymm5, %ymm3, %ymm3
; AVX512F-NEXT:    vpaddb %ymm3, %ymm3, %ymm5
; AVX512F-NEXT:    vpblendvb %ymm10, %ymm5, %ymm3, %ymm3
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm1[8],ymm7[8],ymm1[9],ymm7[9],ymm1[10],ymm7[10],ymm1[11],ymm7[11],ymm1[12],ymm7[12],ymm1[13],ymm7[13],ymm1[14],ymm7[14],ymm1[15],ymm7[15],ymm1[24],ymm7[24],ymm1[25],ymm7[25],ymm1[26],ymm7[26],ymm1[27],ymm7[27],ymm1[28],ymm7[28],ymm1[29],ymm7[29],ymm1[30],ymm7[30],ymm1[31],ymm7[31]
; AVX512F-NEXT:    vpmullw %ymm5, %ymm12, %ymm5
; AVX512F-NEXT:    vpsrlw $8, %ymm5, %ymm5
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm7[0],ymm1[1],ymm7[1],ymm1[2],ymm7[2],ymm1[3],ymm7[3],ymm1[4],ymm7[4],ymm1[5],ymm7[5],ymm1[6],ymm7[6],ymm1[7],ymm7[7],ymm1[16],ymm7[16],ymm1[17],ymm7[17],ymm1[18],ymm7[18],ymm1[19],ymm7[19],ymm1[20],ymm7[20],ymm1[21],ymm7[21],ymm1[22],ymm7[22],ymm1[23],ymm7[23]
; AVX512F-NEXT:    vpmullw %ymm1, %ymm13, %ymm1
; AVX512F-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512F-NEXT:    vpackuswb %ymm5, %ymm1, %ymm1
; AVX512F-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX512F-NEXT:    vpblendvb %ymm4, %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512VL-NEXT:    vpsllw $4, %ymm3, %ymm4
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm5 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm6 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VL-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm4, %ymm3, %ymm4
; AVX512VL-NEXT:    vpsllw $2, %ymm4, %ymm7
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm8 = [252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252]
; AVX512VL-NEXT:    vpand %ymm7, %ymm8, %ymm7
; AVX512VL-NEXT:    vpaddb %ymm6, %ymm6, %ymm9
; AVX512VL-NEXT:    vpblendvb %ymm9, %ymm7, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddb %ymm4, %ymm4, %ymm7
; AVX512VL-NEXT:    vpaddb %ymm9, %ymm9, %ymm10
; AVX512VL-NEXT:    vpblendvb %ymm10, %ymm7, %ymm4, %ymm4
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm7 = ymm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX512VL-NEXT:    vpsrlw $8, %ymm7, %ymm7
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm11 = [256,128,64,32,16,8,4,2,256,128,64,32,16,8,4,2]
; AVX512VL-NEXT:    # ymm11 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpmullw %ymm7, %ymm11, %ymm7
; AVX512VL-NEXT:    vpsrlw $8, %ymm7, %ymm7
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VL-NEXT:    vbroadcasti128 {{.*#+}} ymm12 = [256,2,4,8,16,32,64,128,256,2,4,8,16,32,64,128]
; AVX512VL-NEXT:    # ymm12 = mem[0,1,0,1]
; AVX512VL-NEXT:    vpmullw %ymm2, %ymm12, %ymm2
; AVX512VL-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX512VL-NEXT:    vpackuswb %ymm7, %ymm2, %ymm2
; AVX512VL-NEXT:    vpor %ymm2, %ymm4, %ymm2
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [18446744073709551360,18446744073709551360,18446744073709551360,18446744073709551360]
; AVX512VL-NEXT:    vpblendvb %ymm4, %ymm2, %ymm3, %ymm2
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm3
; AVX512VL-NEXT:    vpand %ymm5, %ymm3, %ymm3
; AVX512VL-NEXT:    vpblendvb %ymm6, %ymm3, %ymm0, %ymm3
; AVX512VL-NEXT:    vpsllw $2, %ymm3, %ymm5
; AVX512VL-NEXT:    vpand %ymm5, %ymm8, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm9, %ymm5, %ymm3, %ymm3
; AVX512VL-NEXT:    vpaddb %ymm3, %ymm3, %ymm5
; AVX512VL-NEXT:    vpblendvb %ymm10, %ymm5, %ymm3, %ymm3
; AVX512VL-NEXT:    vpunpckhbw {{.*#+}} ymm5 = ymm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX512VL-NEXT:    vpsrlw $8, %ymm5, %ymm5
; AVX512VL-NEXT:    vpmullw %ymm5, %ymm11, %ymm5
; AVX512VL-NEXT:    vpsrlw $8, %ymm5, %ymm5
; AVX512VL-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpmullw %ymm1, %ymm12, %ymm1
; AVX512VL-NEXT:    vpsrlw $8, %ymm1, %ymm1
; AVX512VL-NEXT:    vpackuswb %ymm5, %ymm1, %ymm1
; AVX512VL-NEXT:    vpor %ymm1, %ymm3, %ymm1
; AVX512VL-NEXT:    vpblendvb %ymm4, %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512BW-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512BW-NEXT:    vpsllw $2, %zmm3, %zmm4
; AVX512BW-NEXT:    vpandq {{.*}}(%rip), %zmm4, %zmm4
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm4, %zmm3 {%k1}
; AVX512BW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512BW-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512BW-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; AVX512BW-NEXT:    vpsrlw $8, %zmm2, %zmm2
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm2, %zmm2
; AVX512BW-NEXT:    vpsrlw $8, %zmm2, %zmm2
; AVX512BW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; AVX512BW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512BW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512BW-NEXT:    vpackuswb %zmm2, %zmm1, %zmm1
; AVX512BW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512BW-NEXT:    movabsq $72340172838076673, %rax # imm = 0x101010101010101
; AVX512BW-NEXT:    kmovq %rax, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VBMI2-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VBMI2-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vpsllw $2, %zmm3, %zmm4
; AVX512VBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm4, %zmm4
; AVX512VBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm4, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VBMI2-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; AVX512VBMI2-NEXT:    vpsrlw $8, %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpsrlw $8, %zmm2, %zmm2
; AVX512VBMI2-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; AVX512VBMI2-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vpackuswb %zmm2, %zmm1, %zmm1
; AVX512VBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VBMI2-NEXT:    movabsq $72340172838076673, %rax # imm = 0x101010101010101
; AVX512VBMI2-NEXT:    kmovq %rax, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VLBW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLBW-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vpsllw $2, %zmm3, %zmm4
; AVX512VLBW-NEXT:    vpandq {{.*}}(%rip), %zmm4, %zmm4
; AVX512VLBW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm4, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLBW-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VLBW-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; AVX512VLBW-NEXT:    vpsrlw $8, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpsrlw $8, %zmm2, %zmm2
; AVX512VLBW-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; AVX512VLBW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpackuswb %zmm2, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLBW-NEXT:    movabsq $72340172838076673, %rax # imm = 0x101010101010101
; AVX512VLBW-NEXT:    kmovq %rax, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLBW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256,8192,24640,41088,57536,57344,41152,24704,8256]
; AVX512VLVBMI2-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vpsllw $4, %zmm0, %zmm3
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm3, %zmm3
; AVX512VLVBMI2-NEXT:    vpblendmb %zmm3, %zmm0, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vpsllw $2, %zmm3, %zmm4
; AVX512VLVBMI2-NEXT:    vpandq {{.*}}(%rip), %zmm4, %zmm4
; AVX512VLVBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm4, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vpaddb %zmm2, %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpmovb2m %zmm2, %k1
; AVX512VLVBMI2-NEXT:    vpaddb %zmm3, %zmm3, %zmm3 {%k1}
; AVX512VLVBMI2-NEXT:    vpunpckhbw {{.*#+}} zmm2 = zmm1[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31,40,40,41,41,42,42,43,43,44,44,45,45,46,46,47,47,56,56,57,57,58,58,59,59,60,60,61,61,62,62,63,63]
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %zmm2, %zmm2
; AVX512VLVBMI2-NEXT:    vpunpcklbw {{.*#+}} zmm1 = zmm1[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,32,32,33,33,34,34,35,35,36,36,37,37,38,38,39,39,48,48,49,49,50,50,51,51,52,52,53,53,54,54,55,55]
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpsllvw {{.*}}(%rip), %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpsrlw $8, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vpackuswb %zmm2, %zmm1, %zmm1
; AVX512VLVBMI2-NEXT:    vporq %zmm1, %zmm3, %zmm1
; AVX512VLVBMI2-NEXT:    movabsq $72340172838076673, %rax # imm = 0x101010101010101
; AVX512VLVBMI2-NEXT:    kmovq %rax, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %zmm0, %zmm1 {%k1}
; AVX512VLVBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1, i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <64 x i8> %res
}

;
; Uniform Constant Shifts
;

define <8 x i64> @splatconstant_funnnel_v8i64(<8 x i64> %x, <8 x i64> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512F-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512F-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512VL-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512VL-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v8i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v8i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldq $14, %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v8i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlq $50, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllq $14, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v8i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldq $14, %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <8 x i64> @llvm.fshl.v8i64(<8 x i64> %x, <8 x i64> %y, <8 x i64> <i64 14, i64 14, i64 14, i64 14, i64 14, i64 14, i64 14, i64 14>)
  ret <8 x i64> %res
}

define <16 x i32> @splatconstant_funnnel_v16i32(<16 x i32> %x, <16 x i32> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v16i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512F-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v16i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512VL-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v16i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512BW-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v16i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldd $4, %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v16i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrld $28, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpslld $4, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v16i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldd $4, %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <16 x i32> @llvm.fshl.v16i32(<16 x i32> %x, <16 x i32> %y, <16 x i32> <i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4, i32 4>)
  ret <16 x i32> %res
}

define <32 x i16> @splatconstant_funnnel_v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v32i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512F-NEXT:    vpsrlw $9, %ymm3, %ymm3
; AVX512F-NEXT:    vpsllw $7, %ymm2, %ymm2
; AVX512F-NEXT:    vpor %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlw $9, %ymm1, %ymm1
; AVX512F-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v32i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512VL-NEXT:    vpsrlw $9, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsllw $7, %ymm2, %ymm2
; AVX512VL-NEXT:    vpor %ymm3, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsrlw $9, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v32i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlw $9, %zmm1, %zmm1
; AVX512BW-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512BW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v32i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpshldw $7, %zmm1, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v32i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlw $9, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vporq %zmm1, %zmm0, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v32i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshldw $7, %zmm1, %zmm0, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <32 x i16> @llvm.fshl.v32i16(<32 x i16> %x, <32 x i16> %y, <32 x i16> <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>)
  ret <32 x i16> %res
}

define <64 x i8> @splatconstant_funnnel_v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; AVX512F-LABEL: splatconstant_funnnel_v64i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512F-NEXT:    vpsrlw $4, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512F-NEXT:    vpandn %ymm3, %ymm4, %ymm3
; AVX512F-NEXT:    vpsllw $4, %ymm2, %ymm2
; AVX512F-NEXT:    vpand %ymm4, %ymm2, %ymm2
; AVX512F-NEXT:    vpor %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512F-NEXT:    vpandn %ymm1, %ymm4, %ymm1
; AVX512F-NEXT:    vpsllw $4, %ymm0, %ymm0
; AVX512F-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v64i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm0, %ymm2
; AVX512VL-NEXT:    vextracti64x4 $1, %zmm1, %ymm3
; AVX512VL-NEXT:    vpsrlw $4, %ymm3, %ymm3
; AVX512VL-NEXT:    vpsllw $4, %ymm2, %ymm2
; AVX512VL-NEXT:    vmovdqa {{.*#+}} ymm4 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX512VL-NEXT:    vpternlogq $226, %ymm3, %ymm4, %ymm2
; AVX512VL-NEXT:    vpsrlw $4, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsllw $4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpternlogq $226, %ymm1, %ymm4, %ymm0
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm2, %zmm0, %zmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v64i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512BW-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512BW-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v64i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512VBMI2-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v64i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VLBW-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512VLBW-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v64i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpsllw $4, %zmm0, %zmm2
; AVX512VLVBMI2-NEXT:    vpsrlw $4, %zmm1, %zmm0
; AVX512VLVBMI2-NEXT:    vpternlogq $216, {{.*}}(%rip), %zmm2, %zmm0
; AVX512VLVBMI2-NEXT:    retq
  %res = call <64 x i8> @llvm.fshl.v64i8(<64 x i8> %x, <64 x i8> %y, <64 x i8> <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>)
  ret <64 x i8> %res
}
