#!/usr/bin/env python3
from datetime import datetime
import sys
import subprocess


with open('yt_dlp/version.py', 'rt') as f:
    exec(compile(f.read(), 'yt_dlp/version.py', 'exec'))
old_version = locals()['__version__']

old_version_list = old_version.split('.')

old_ver = '.'.join(old_version_list[:3])
old_rev = old_version_list[3] if len(old_version_list) > 3 else ''

ver = datetime.utcnow().strftime("%Y.%m.%d")

rev = (sys.argv[1:] or [''])[0]  # Use first argument, if present as revision number
if not rev:
    rev = str(int(old_rev or 0) + 1) if old_ver == ver else ''

VERSION = '.'.join((ver, rev)) if rev else ver

try:
    sp = subprocess.Popen(['git', 'rev-parse', '--short', 'HEAD'], stdout=subprocess.PIPE)
    GIT_HEAD = sp.communicate()[0].decode().strip() or None
except Exception:
    GIT_HEAD = None

VERSION_FILE = f'''
# Autogenerated by devscripts/update-version.py

__version__ = {VERSION!r}

RELEASE_GIT_HEAD = {GIT_HEAD!r}
'''.lstrip()

with open('yt_dlp/version.py', 'wt') as f:
    f.write(VERSION_FILE)

print('::set-output name=ytdlp_version::' + VERSION)
print(f'\nVersion = {VERSION}, Git HEAD = {GIT_HEAD}')
