#!/bin/bash
# Adds/Removes icons to the IceWM desktop toolbar- antiX 19(adding icons is done usinf the info from the app's .desktop file) 
# By PPC, 30/7/2019 - 11/9/2019 adapted from many, many on-line examples
# No licence what so ever- feel free to improve/adapt this script
# To do: 1- allow to list/move/delete icons from the toolbar (it implies a huge re-write)

DADOS=$(yad --window-icon=gtk-add --length=800 --width=800 --center --paned --splitter="200" --title="Toolbar Icon Manager for IceWM v.851" \
--form --field="   App's .desktop file:    ":FL '/usr/share/applications/antix' \
--button="EXIT !/usr/share/icons/papirus-antix/22x22/actions/exit.png":1 \
--button="HELP !/usr/share/icons/papirus-antix/22x22/actions/help.png":5 \
--button="ADVANCED !/usr/share/icons/papirus-antix/22x22/actions/view-pim-journal.png":4 \
--button="REMOVE icon!/usr/share/icons/papirus-antix/22x22/actions/xml-attribute-delete.png":2 \
--button="UNDO !/usr/share/icons/papirus-antix/22x22/actions/undo.png":3 \
--button="ADD icon!/usr/share/icons/papirus-antix/22x22/actions/add.png":0 \
--wrap --text="  \n  Please select any option from the buttons below. \n  To add a new icon to the toolbar choose (or drag and drop to the field below) your applications's .desktop file \n   then click the 'ADD icon' button. \n ")

### wait for a button to be pressed then perform the selected funtion
foo=$?

[[ $foo -eq 1 ]] && exit 0

		###Function to display help
		if [[ $foo -eq 5 ]]; then   yad --window-icon=gtk-add --title='Help - IceWM Toolbar Icon Manager' --wrap --text=" \n What is this? \n This utility allows basic icon adding and delection functionality to IceWm's toolbar. \n The toolbar application icons are created from an application's .desktop file.  \n  What are .desktop files? \n Usually a .desktop file is created during an application's instalation process, to allow the system easy access to relevant information, like the app's full name, commands to be executed, icon to be used, where it should be placed in the OS menu, etc. \n A .desktop file name usualy referes to the app's name, wich usually makes it very easy to find the intended .desktop file (ex: Firefox ESR's .desktop file is 'firefox-esr.desktop').\n When adding a new icon to the toolbar, the user can click the field presented in the main window and a list of all the .desktop files of the installed applications will be show. \n That, in fact, is a list of (almost) all installed applications, that can be added to the toolbar. \n Note: some of antiX's applications are found on the sub-fold 'antiX'. \n \n  TIM button's: \n 'ADD icon' - after selecting the .desktop file of the application you want to add to your toolbar, click this button and it instantly shows up on the toolbar. \n If, for some reason, TIM fails to find the correct icon for your application, it will still create a toolbar icon- using the default 'gears' picture, that you can still click to access the application.\n You can click the 'Advanced' button to manually edit the relevant entry and change the application's icon. \n  'UNDO' - every time a icon is added or removed from the toolbar, TIM creates a backup file. If you click this button, the toolbar is instantly restored from that backup file, without any confirmation. \n 'REMOVE icon' - this removes the icon that is on the further right side of the toolbar, it always asks for confirmation before doing this. As a safe guard this button can't delete below a certain number of icons. \n 'ADVANCED' - this option allows the edition of the text configuration file that has all of your desktop's toolbar icon's configurations. Manually editing this file allows the user to rearange the order of the icons and delete or add any icon. A brief explanation about the inner workings of the text configuration file is displayed before the file is open for edition. \n Warnings: only manually edit a configuration file if you are sure of what you are doing! Always make a back up copy before editing a configuration file! " --center --length=50 --width=600 --button=gtk-quit:1;
    # now instead of exiting, TIM is reopen to allow for adding/deleting multiple icons sequentially without having to start TIM each time!  
icewm-toolbar-icon-manager.sh
		fi 
		###END of Function to display help

		###Function to manually manage icons (ADVANCED management)
		if [[ $foo -eq 4 ]]; then   cp ~/.icewm/toolbar ~/.icewm/toolbar.bak &&	yad --center --form --title="Toolbar Icon manager" --field="Warning::TXT" " TIM has no 'graphical' way to allow users to move icons around or delete arbitrary icons.\n If you click OK, the toolbar configuration file will be open for edition.\n \n How-to: \n Each toolbar icon is identified by a line starting with 'prog' followed by the application name, icon location and the application executable file. \n Move or delete the intire line refering to each toolbar icon entry.\n Note: Lines starting with # are comments only and will be ignored.\n There can be empty lines.\n Save any changes and then restart iceWM.\n You can undo the last change from TIMs "Restore" button." --width=400 --height=360 --button=gtk-no:1 --button=gtk-yes:0 && geany ~/.icewm/toolbar
		fi 
		###END of Function to manually arrange icons
		
		###Function to delete last icon
	
if [[ $foo -eq 2 ]]; then
			### Does not allow to remove the first $mininumlines "toolbar" file lines  -> meant to not allow delete the show desktop, eject usb and the TIM icons from the toolbar 
			mininumlines=5
			a=($(wc ~/.icewm/toolbar))
			existinglines=${a[0]}
			if [ "$mininumlines" -gt "$existinglines" ]; then  yad --title='Warning' --text='  TIM is programmed to always keep 5 lines in the "toolbar" file! ' --timeout=3 --no-buttons --center; exit
			fi
			###

yad --window-icon=gtk-add --title='Warning' --text='  This will the delete the last icon to the right of your toolbar! Are you sure?  ' --center --button=gtk-cancel:1 \ --button=gtk-cancel:1 --button=gtk-yes:0 
  confirm=$?
  if [[ $confirm -eq 1 ]]; then exit
  fi

#create backup file before changes
cp ~/.icewm/toolbar ~/.icewm/toolbar.bak
#TRY to Remove last icon on the toolbar
BADLINESCOUNT=1
ORIGINALFILE=~/.icewm/toolbar
truncate -s $(printf "$(stat --format=%s ${ORIGINALFILE}) - $(tail -n${BADLINESCOUNT} ${ORIGINALFILE} | wc -c)\n" | bc ) ${ORIGINALFILE}
#Restart icewm to the change is instantly available
icewm --restart
	exit
fi
		###END of Function to delete last icon

		###Function to restore last backup
if [[ $foo -eq 3 ]]; then
cp ~/.icewm/toolbar.bak ~/.icewm/toolbar
icewm --restart
exit 
fi 
		###END Function to restore last backup

if [[ $foo -eq 0 ]]; then

		###Function to add a new icon

COMANDO0=$(echo "$DADOS" | cut -d'|' -f1)
#this strips any existing path from the name:
EXEC0=$(grep Exec= $COMANDO0 | cut -d '=' -f2)
EXEC=$(echo "$EXEC0" | cut -f1 -d" ")
#this strips any existing path from the name:
COMANDO00=$(basename $COMANDO0)
#this strips any existing .desktop from the name:
REMOVE=".desktop"
NOME=${COMANDO00//$REMOVE/}
 #try to find app icon:
	ICON0=$(grep Icon= $COMANDO0 | cut -d '=' -f2)
	ICON00=$(echo "$ICON0" | cut -f1 -d" ")
	ICONwithoutpath=$(basename $ICON00)

# By default set the icon as the gears icon, then look if the icon exist in several paths...
ICONE="/usr/share/icons/papirus-antix/24x24/apps/yast-runlevel.png"

# if a icon with a full path exists on the .desktop, use that icon
if [[ -f "$ICON00" ]]; then  ICONE=$ICON00
fi

#...Also check if the icon's name exists in several possible default paths, if a existing icon is found, use that instead!
#We can add as many paths as we want for the system to look for icons, also, we can look for icons with extensions other than .png (ex: svg), adding new "extension" and path's, and repeating the if-fi cicle
extension=".png"

path="/usr/share/pixmaps/"
if [[ -f "$path$ICONwithoutpath$extension" ]]; then  ICONE=$path$ICONwithoutpath$extension
fi

path="/usr/share/icons/papirus-antix/24x24/apps/"
if [[ -f "$path$ICONwithoutpath$extension" ]]; then  ICONE=$path$ICONwithoutpath$extension
fi

path="/usr/share/icons/papirus-antix/24x24/places/"
if [[ -f "$path$ICONwithoutpath$extension" ]]; then  ICONE=$path$ICONwithoutpath$extension
fi
    
# error if no application selected- avoids creating empty icon on toolbar:
if [ -z "$EXEC" ]; then yad --window-icon=gtk-add --title='Warning' --text="No changes were made! \n Please choose an  application's .desktop file to add it's icon the the toolbar." --timeout=3 --no-buttons --center
	exit
fi

#create backup file before changes
cp ~/.icewm/toolbar ~/.icewm/toolbar.bak

#open .desktop file and get EXEC= contents
EXEC0=$(grep Exec= $COMANDO0 | cut -d '=' -f2)
#in case EXEC has more than one line, use only the first
readarray -t lines < <(echo "$EXEC0")
EXECperc="${lines[0]}"

#add line to toolbar - the | cut -f1 -d"%"   part removes any %x option from the exec command.
echo "prog "\"${NOME}"\" "${ICONE}" "${EXECperc}""| cut -f1 -d"%"  >> ~/.icewm/toolbar
#instantly restart IceWm so the new icon appears
icewm --restart
		###END of Function to add a new icon

exit

fi
