#!/bin/bash

### icewm-menu-Desktop.sh - dynamic menu of ~/Desktop files to open via dynamic menu

### BobC 09/04/19 - bcurrey99 at yahoo.com

### --- example output ---
### prog "  1440x900-Screen" - xdg-open /home/bobc/Desktop/1440x900-Screen
### prog "  IceWM_Toolbar_Icon_Manager.desktop" - /usr/local/bin/icewm-toolbar-icon-manager.sh
### prog "  antiX-docs.desktop" - dillo /usr/share/antiX/FAQ/index.html 
### prog "  arandr.desktop" - arandr
### prog "  ddm-nvidia.desktop" - desktop-defaults-run -t su-to-root -c "/usr/local/bin/ddm-mx -i nvidia"
### prog "  file-manager.desktop" - desktop-defaults-run -fm
### prog "  index.html" - xdg-open /home/bobc/Desktop/index.html
### prog "  mc-screen.jpg" - xdg-open /home/bobc/Desktop/mc-screen.jpg
### menu "test_stuff entries" - {
### prog "  ceni.desktop" - desktop-defaults-run -t sudo ceni
### prog "  ddm-nvidia.desktop" - desktop-defaults-run -t su-to-root -c "/usr/local/bin/ddm-mx -i nvidia"
### prog "  mps-youtube.desktop" - desktop-defaults-run -t mpsyt 
### prog "  pppoeconf.desktop" - desktop-defaults-run -t /usr/sbin/pppoeconf
### }

walk_dir () {
	for pathname in "$1"/*; do
	    basename="${pathname##*/}"
        # echo "Pathname: ${pathname}   Basename: ${basename}"
        if [ -d "$pathname" ]; then
            basename="${pathname##*/}"
            printf "menu \"${basename} entries\" - {\n"
            # printf "menu \"${basename} entries\" - {\n" >> $LOGFILE
            walk_dir "$pathname"
            printf "}\n"
            # printf "}\n" >> $LOGFILE
        elif [ -e "$pathname" ]; then
            entry_fileext=${basename##*.}
            # printf "entry_fileext: ${entry_fileext}\n"
            ### if .desktop need to figure out what to run, otherwise use xdg-open
            if [[ "$entry_fileext" != "desktop" ]]; then
                printf "prog \"  ${basename}\" - xdg-open $pathname\n"
                # printf "prog \"  ${basename}\" - xdg-open $pathname\n" >> $LOGFILE
            else
                ### this entry is a .desktop, so get execution string, and whether to run in terminal or not
                entry_exec=$( grep '^Exec' $pathname | tail -1 | sed 's/^Exec=//' | sed 's/%.//' )
                #### copied code was wrong, if 1st char of exec string is " then both 1st and last char (matching double quote) need to be removed
                #### | sed 's/^"//g' | sed 's/" *$//g' )
                # printf "Entry_exec: ${entry_exec}\n"
                if grep -q '^Terminal=true' $pathname; then
                    ### use terminal to execute
                    # printf "Termcmd: ${TERMCMD}\n"
                    entry_exec="$TERMCMD $entry_exec"
                    # printf "Terminal based Entry_exec: ${entry_exec}\n"
                fi
                printf "prog \"  ${basename}\" - $entry_exec\n"
                # printf "prog \"  ${basename}\" - $entry_exec\n" >> $LOGFILE
            fi
        fi
    done
}

TOP_DIR=~/Desktop
export TERMCMD='desktop-defaults-run -t'
# printf "Termcmd: ${TERMCMD}\n"
# export LOGFILE=~/bin/icewm-menu-Desktop.log
# touch $LOGFILE
walk_dir "$TOP_DIR"
# printf "}\n"
# printf "}\n" >> $LOGFILE
