// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_variables.json and
// builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_autogen.cpp: Wrapper for static or pool allocated char arrays, that are
// guaranteed to be valid and unchanged for the duration of the compilation. Implements
// mangledNameHash using perfect hash function from gen_builtin_symbols.py

#include "compiler/translator/ImmutableString.h"

std::ostream &operator<<(std::ostream &os, const sh::ImmutableString &str)
{
    return os.write(str.data(), str.length());
}

#if defined(_MSC_VER)
#    pragma warning(disable : 4309)  // truncation of constant value
#endif

namespace
{

constexpr int mangledkT1[] = {1174, 759,  1024, 415,  2390, 1613, 2961, 1985, 678,  1826,
                              3546, 1293, 21,   1365, 406,  1852, 4066, 2091, 2556, 3068,
                              1744, 804,  1150, 749,  3552, 3239, 115,  1038, 2453, 411,
                              3752, 2026, 3216, 2094, 2188, 3704, 3659, 3569, 55,   888};
constexpr int mangledkT2[] = {2600, 2348, 169,  532,  3775, 2253, 3125, 1751, 1314, 3710,
                              89,   752,  3029, 444,  1838, 2568, 4072, 409,  1997, 1064,
                              1901, 864,  340,  3712, 3685, 2611, 1726, 2407, 3292, 2161,
                              2519, 991,  2572, 845,  2548, 2643, 624,  2792, 2695, 863};
constexpr int mangledkG[]  = {
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    3910, 0,    0,    0,    0,    0,    0,    0,    2445, 0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    2911, 0,    0,    854,  0,    0,    1352, 0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    18,   0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    2373, 2668, 0,    2152, 0,    1609, 0,    1601, 3748, 0,
    0,    0,    0,    765,  0,    0,    0,    2684, 0,    0,    1691, 0,    0,    0,    0,    0,
    1327, 0,    2017, 2416, 0,    1913, 0,    0,    3457, 0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    4080, 4046, 0,    0,    175,  158,  0,    0,    0,    805,  3780, 0,    0,
    1014, 0,    0,    0,    0,    744,  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    2927, 0,    0,    630,  109,  3486, 0,    3491, 0,    3878, 0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    2968,
    3161, 620,  0,    0,    0,    2682, 0,    1641, 0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    2687, 3148, 0,    0,    2888, 3180, 0,    0,    0,    0,    2052,
    0,    0,    1158, 789,  0,    0,    0,    3498, 0,    0,    0,    191,  2603, 0,    2557, 3000,
    0,    0,    3452, 1047, 0,    0,    1553, 3747, 1793, 0,    0,    2065, 0,    0,    0,    3766,
    0,    3831, 2200, 0,    1613, 0,    0,    0,    0,    2457, 0,    0,    0,    0,    1127, 3835,
    2278, 0,    744,  117,  0,    2989, 1791, 0,    0,    16,   0,    0,    3210, 3227, 2711, 0,
    3624, 0,    0,    0,    0,    0,    317,  0,    0,    0,    3732, 3594, 2816, 0,    0,    351,
    753,  0,    0,    0,    234,  0,    0,    0,    614,  0,    0,    1556, 0,    0,    0,    1397,
    493,  1134, 0,    0,    3133, 0,    0,    2223, 0,    2595, 3720, 3365, 0,    162,  0,    0,
    3048, 0,    1978, 2526, 0,    0,    3599, 4118, 372,  0,    3722, 2318, 1902, 0,    0,    0,
    0,    0,    0,    0,    0,    578,  1710, 0,    0,    2984, 0,    0,    2039, 0,    0,    1406,
    0,    0,    2720, 3000, 151,  0,    0,    0,    3912, 1071, 359,  0,    0,    0,    2620, 0,
    0,    0,    0,    0,    1082, 1158, 2353, 2166, 3120, 0,    1013, 0,    4027, 0,    0,    0,
    2966, 101,  3790, 0,    2270, 3737, 3806, 0,    649,  3807, 686,  1069, 0,    1058, 0,    0,
    3631, 0,    0,    3618, 0,    853,  0,    0,    0,    0,    0,    0,    0,    1428, 0,    3292,
    3617, 2929, 0,    0,    587,  4010, 0,    286,  1481, 0,    3968, 0,    2530, 2874, 0,    1242,
    0,    0,    550,  0,    0,    2826, 0,    2029, 0,    0,    0,    0,    0,    0,    0,    1436,
    1898, 3514, 0,    3661, 0,    0,    0,    3749, 1606, 943,  0,    0,    491,  0,    0,    0,
    554,  3649, 0,    434,  0,    0,    0,    0,    572,  0,    3600, 0,    1711, 0,    2294, 0,
    0,    3022, 1426, 3415, 4003, 0,    3632, 1477, 0,    2104, 0,    3907, 0,    3650, 0,    0,
    0,    3766, 0,    272,  0,    0,    1686, 0,    499,  0,    0,    850,  2368, 0,    0,    56,
    0,    499,  0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    1242, 473,
    176,  0,    29,   0,    0,    0,    0,    601,  0,    1950, 1653, 2145, 0,    0,    1785, 0,
    814,  0,    0,    3431, 0,    0,    4061, 0,    1394, 3253, 0,    0,    0,    0,    0,    2487,
    0,    0,    0,    0,    846,  0,    1554, 0,    2863, 3781, 599,  0,    2440, 0,    0,    0,
    0,    0,    0,    2519, 1428, 0,    0,    2883, 0,    1164, 0,    0,    0,    0,    0,    0,
    0,    0,    1811, 0,    4066, 938,  3307, 2709, 0,    3134, 0,    3318, 537,  0,    0,    0,
    3848, 3906, 0,    2811, 0,    1348, 0,    1564, 327,  0,    0,    0,    0,    469,  3202, 2803,
    396,  0,    1895, 3052, 645,  0,    0,    0,    0,    0,    644,  0,    0,    0,    0,    758,
    2718, 0,    0,    0,    0,    0,    1113, 3246, 270,  1430, 0,    0,    660,  1496, 0,    3826,
    0,    0,    0,    0,    0,    1210, 906,  2466, 3848, 2046, 2550, 2161, 0,    0,    0,    3747,
    0,    1182, 0,    0,    0,    1454, 1992, 1828, 0,    3869, 1498, 1397, 0,    0,    0,    3928,
    0,    0,    1347, 0,    3760, 0,    0,    0,    0,    0,    996,  0,    2136, 0,    0,    0,
    0,    2427, 0,    2743, 0,    1977, 0,    2428, 276,  0,    0,    0,    0,    0,    4114, 0,
    0,    0,    2342, 1860, 0,    0,    0,    3171, 3951, 0,    3777, 0,    1974, 0,    0,    0,
    0,    0,    0,    0,    0,    0,    1044, 0,    3921, 0,    0,    410,  1991, 1992, 1580, 0,
    244,  0,    0,    0,    2611, 0,    0,    3287, 87,   555,  1494, 0,    2761, 0,    0,    0,
    2380, 815,  0,    2321, 3048, 0,    0,    0,    0,    0,    3114, 0,    0,    0,    1025, 0,
    872,  0,    1886, 953,  0,    0,    3329, 0,    0,    0,    0,    0,    4006, 814,  1359, 2223,
    21,   0,    1438, 1549, 0,    3195, 3631, 0,    0,    0,    0,    3659, 0,    0,    3353, 658,
    3142, 1204, 0,    4044, 0,    0,    1576, 0,    4103, 0,    0,    3726, 2744, 3950, 0,    0,
    1245, 2238, 0,    0,    0,    0,    0,    0,    2618, 3399, 0,    0,    578,  3809, 3888, 0,
    12,   3150, 1899, 0,    0,    2962, 0,    0,    0,    1221, 0,    0,    0,    507,  3285, 87,
    61,   1398, 3045, 0,    2725, 0,    2703, 0,    3713, 0,    2734, 0,    1108, 898,  2165, 1081,
    0,    0,    0,    0,    560,  0,    3335, 1141, 0,    1237, 43,   3048, 502,  0,    0,    645,
    1337, 0,    0,    1463, 0,    1391, 0,    3712, 2608, 1785, 0,    0,    2877, 3016, 0,    0,
    2757, 0,    602,  0,    0,    622,  179,  0,    0,    2020, 0,    0,    0,    677,  458,  0,
    42,   0,    0,    2975, 1593, 307,  0,    0,    0,    0,    0,    0,    1011, 0,    0,    0,
    3241, 1694, 0,    0,    2621, 0,    2135, 3008, 0,    3051, 0,    1041, 2350, 0,    1549, 0,
    0,    0,    3869, 0,    0,    0,    0,    0,    0,    324,  0,    0,    0,    500,  0,    640,
    3443, 912,  0,    3351, 0,    0,    0,    3919, 0,    0,    0,    0,    2470, 2122, 0,    0,
    1338, 0,    0,    0,    0,    566,  3330, 2035, 0,    118,  0,    3749, 0,    1811, 0,    447,
    0,    0,    1965, 0,    0,    0,    2152, 101,  0,    0,    520,  139,  0,    0,    0,    0,
    0,    0,    0,    1095, 0,    1823, 3268, 0,    0,    0,    3170, 0,    0,    0,    0,    4089,
    2936, 505,  3463, 0,    0,    2158, 0,    0,    0,    3805, 1680, 0,    1196, 0,    0,    0,
    2071, 2007, 393,  0,    3694, 0,    0,    0,    0,    0,    3529, 3943, 1384, 0,    1226, 0,
    0,    0,    0,    0,    3419, 533,  995,  0,    1310, 3301, 3718, 0,    0,    0,    0,    1855,
    1208, 0,    0,    1000, 0,    2449, 0,    0,    0,    2581, 0,    0,    0,    0,    0,    0,
    0,    684,  0,    490,  0,    2946, 0,    1383, 2792, 3435, 0,    109,  992,  1161, 0,    0,
    0,    133,  0,    0,    1353, 2266, 3239, 0,    0,    0,    0,    1445, 0,    0,    2443, 1717,
    0,    4052, 201,  0,    1756, 0,    379,  536,  1150, 0,    3230, 0,    2059, 560,  0,    3230,
    3904, 0,    0,    2275, 1315, 2080, 0,    981,  0,    0,    0,    0,    1774, 504,  0,    2606,
    0,    0,    3937, 0,    3797, 0,    0,    0,    1222, 0,    1160, 0,    0,    2062, 2261, 1090,
    2911, 0,    3979, 4072, 0,    0,    590,  1094, 3630, 0,    3267, 0,    3251, 0,    936,  0,
    0,    1547, 0,    1053, 478,  0,    1816, 980,  1751, 1691, 0,    0,    140,  1110, 2598, 1320,
    2218, 0,    456,  3971, 0,    3979, 0,    1636, 0,    0,    0,    0,    0,    1422, 0,    0,
    0,    0,    1916, 1669, 232,  3910, 0,    288,  0,    987,  3979, 0,    606,  0,    0,    0,
    1903, 808,  3695, 1009, 0,    0,    0,    0,    224,  172,  2991, 1383, 149,  0,    728,  0,
    0,    476,  0,    842,  951,  0,    3378, 2357, 196,  0,    1130, 128,  1984, 0,    1969, 1954,
    300,  0,    0,    264,  2236, 0,    1553, 3486, 0,    2568, 3373, 0,    3237, 0,    2515, 832,
    2888, 0,    0,    0,    0,    3504, 298,  310,  0,    0,    0,    0,    2001, 0,    0,    0,
    3722, 2590, 877,  3466, 987,  227,  0,    0,    3490, 804,  0,    3552, 1009, 2489, 1113, 0,
    2040, 1321, 624,  2712, 0,    0,    2519, 810,  2132, 3851, 0,    0,    0,    0,    0,    3403,
    0,    23,   219,  0,    0,    296,  0,    517,  1820, 0,    0,    0,    0,    1825, 0,    491,
    936,  0,    812,  0,    0,    2373, 2407, 0,    3177, 1763, 0,    0,    1915, 0,    0,    0,
    668,  1383, 3286, 3356, 0,    0,    0,    863,  1139, 1617, 140,  243,  0,    4122, 671,  0,
    0,    0,    0,    1453, 924,  1623, 0,    0,    2056, 26,   1826, 3837, 0,    0,    0,    3696,
    299,  8,    0,    0,    1228, 922,  0,    0,    835,  0,    3899, 0,    1737, 0,    0,    0,
    1187, 0,    0,    0,    0,    0,    1112, 0,    0,    0,    0,    0,    0,    0,    3098, 639,
    3431, 102,  827,  0,    3512, 3625, 0,    0,    0,    2685, 907,  3252, 3375, 0,    0,    0,
    0,    0,    1059, 0,    541,  0,    0,    4035, 1986, 2835, 0,    0,    3399, 861,  2028, 0,
    928,  3521, 0,    2690, 0,    0,    0,    0,    0,    0,    2245, 1211, 1755, 1465, 3868, 0,
    0,    0,    2957, 0,    2011, 0,    1741, 0,    0,    0,    1489, 0,    0,    83,   0,    3481,
    0,    1876, 0,    0,    0,    0,    3883, 0,    0,    534,  1676, 0,    966,  0,    0,    3501,
    0,    489,  348,  1910, 967,  0,    942,  3059, 0,    0,    1734, 558,  561,  0,    0,    0,
    1057, 0,    3914, 982,  0,    2045, 0,    0,    1051, 0,    0,    0,    0,    414,  1435, 2193,
    0,    1071, 0,    4025, 1506, 0,    0,    0,    3143, 1595, 0,    683,  0,    0,    2361, 397,
    0,    0,    0,    0,    305,  0,    0,    117,  0,    0,    1063, 0,    0,    1596, 0,    0,
    0,    0,    0,    1607, 0,    2030, 743,  0,    858,  575,  0,    0,    1893, 0,    0,    2319,
    63,   65,   793,  0,    2542, 0,    1969, 1020, 280,  128,  0,    0,    0,    294,  971,  0,
    0,    0,    3437, 2648, 0,    0,    3724, 1243, 2924, 0,    2860, 0,    0,    0,    3797, 3279,
    0,    4115, 2056, 0,    800,  3343, 0,    0,    0,    0,    568,  0,    2392, 0,    577,  2167,
    0,    0,    2346, 0,    3334, 0,    0,    2142, 2136, 358,  591,  680,  0,    3205, 3155, 2464,
    1163, 0,    0,    3507, 0,    0,    3373, 0,    2100, 0,    1692, 0,    2005, 0,    0,    1809,
    1013, 535,  4102, 0,    0,    3619, 0,    2329, 14,   1732, 1915, 0,    1616, 0,    939,  0,
    0,    1061, 0,    0,    592,  241,  135,  3868, 810,  1231, 0,    3755, 0,    2906, 0,    3859,
    3741, 0,    0,    1386, 0,    1838, 0,    3667, 0,    0,    0,    0,    313,  3098, 0,    1857,
    0,    1259, 2574, 0,    1827, 0,    0,    0,    0,    1449, 0,    3379, 0,    1114, 1694, 520,
    0,    1529, 3844, 824,  0,    0,    679,  0,    3394, 0,    1617, 0,    3669, 3557, 1179, 0,
    0,    0,    3434, 0,    0,    0,    1431, 2796, 0,    3839, 0,    0,    2862, 0,    0,    2177,
    4089, 3791, 0,    519,  0,    1296, 0,    2526, 1701, 532,  1797, 1618, 0,    2341, 1247, 451,
    1792, 1351, 2832, 541,  3967, 386,  845,  2887, 1650, 0,    0,    0,    469,  129,  2755, 182,
    0,    3584, 0,    2013, 1649, 1229, 2117, 3563, 183,  2779, 0,    956,  0,    0,    388,  0,
    0,    0,    0,    443,  0,    3345, 1221, 1513, 977,  0,    0,    1487, 1822, 1505, 3459, 0,
    2522, 148,  196,  927,  0,    0,    0,    2358, 0,    212,  0,    1417, 0,    563,  2051, 1088,
    1086, 0,    0,    2835, 3260, 3164, 451,  0,    0,    0,    2009, 2761, 1055, 0,    3688, 0,
    0,    0,    0,    0,    323,  0,    0,    0,    1940, 403,  1106, 15,   1147, 0,    0,    0,
    426,  0,    0,    1799, 2363, 0,    0,    2172, 1732, 2628, 1181, 0,    2338, 0,    0,    1532,
    0,    0,    2147, 0,    0,    206,  0,    0,    614,  985,  2293, 2712, 3138, 0,    0,    0,
    3540, 0,    3677, 4070, 0,    0,    253,  4104, 406,  0,    711,  0,    1341, 0,    884,  0,
    2811, 1532, 2407, 109,  2960, 0,    1079, 0,    0,    0,    0,    1104, 85,   476,  3994, 2056,
    12,   238,  0,    0,    0,    0,    3568, 775,  0,    1481, 0,    1085, 0,    0,    0,    3111,
    273,  2157, 2320, 222,  545,  514,  0,    0,    2557, 3111, 1285, 0,    0,    1275, 1656, 0,
    1907, 4068, 0,    0,    1942, 0,    0,    2864, 0,    0,    0,    0,    88,   0,    4014, 0,
    0,    926,  840,  1144, 0,    0,    0,    1712, 2961, 0,    1270, 0,    3852, 144,  1148, 3618,
    3983, 105,  0,    3333, 2514, 138,  1976, 2222, 0,    1675, 2052, 286,  2898, 2034, 0,    218,
    950,  280,  1172, 0,    0,    3101, 0,    0,    381,  274,  3014, 620,  0,    993,  52,   0,
    0,    0,    0,    1672, 820,  1672, 2382, 361,  0,    455,  3991, 1437, 3490, 0,    1295, 1061,
    0,    2688, 1623, 2537, 0,    1966, 0,    0,    0,    0,    0,    3612, 910,  0,    627,  0,
    2490, 3658, 0,    0,    0,    0,    1185, 3983, 0,    0,    3414, 0,    3971, 0,    0,    0,
    273,  2281, 0,    1254, 0,    2895, 3984, 967,  4093, 0,    1036, 779,  2259, 0,    4000, 966,
    0,    75,   0,    0,    0,    3800, 2352, 0,    309,  2956, 0,    480,  0,    0,    0,    0,
    423,  3831, 3346, 0,    0,    0,    120,  2889, 2745, 3388, 884,  1882, 0,    100,  1780, 0,
    1890, 0,    0,    1730, 160,  0,    1896, 1583, 3262, 0,    50,   0,    0,    0,    846,  0,
    255,  869,  0,    1980, 938,  1846, 2043, 1625, 0,    0,    2491, 0,    3429, 0,    0,    1335,
    1099, 0,    0,    881,  0,    1247, 0,    633,  1059, 0,    481,  2035, 0,    4103, 1918, 146,
    105,  2064, 0,    2361, 0,    2902, 4038, 0,    0,    1142, 0,    641,  1188, 0,    2051, 0,
    79,   2999, 0,    0,    1386, 566,  0,    2997, 0,    1026, 1848, 1971, 3889, 3835, 386,  1644,
    1636, 0,    0,    0,    1246, 3191, 0,    4069, 0,    0,    1383, 1327, 0,    0,    2342, 0,
    1104, 0,    0,    1404, 0,    1626, 0,    2960, 0,    0,    2744, 3906, 0,    39,   0,    0,
    0,    0,    0,    0,    0,    3963, 2560, 2807, 984,  79,   3385, 0,    0,    0,    0,    3976,
    0,    0,    0,    506,  1363, 0,    0,    4116, 2673, 293,  3100, 3662, 1733, 1466, 87,   132,
    80,   0,    0,    9,    0,    2840, 0,    0,    0,    1366, 0,    1490, 0,    1134, 453,  1718,
    0,    1473, 1990, 0,    0,    1044, 0,    1482, 0,    2774, 0,    245,  3854, 0,    3049, 0,
    0,    0,    0,    3637, 2661, 1482, 0,    87,   0,    1973, 0,    2131, 0,    401,  0,    1492,
    3565, 57,   0,    965,  262,  0,    1502, 1918, 0,    0,    0,    1287, 0,    743,  0,    2960,
    2730, 0,    345,  0,    54,   0,    0,    553,  2729, 0,    0,    0,    1065, 2038, 440,  1081,
    686,  2050, 0,    0,    0,    3462, 1634, 0,    828,  632,  0,    2156, 3080, 1387, 0,    1327,
    2349, 1739, 392,  3910, 1938, 1086, 0,    2471, 0,    0,    3897, 0,    2091, 1293, 0,    400,
    0,    652,  2588, 3937, 0,    1833, 0,    0,    2759, 2305, 0,    3483, 0,    0,    0,    371,
    0,    1135, 2007, 0,    0,    0,    2975, 697,  0,    2108, 702,  0,    0,    1141, 0,    1712,
    0,    0,    3664, 674,  101,  441,  0,    0,    0,    2317, 0,    0,    1375, 0,    3750, 1771,
    1648, 0,    3966, 0,    0,    3916, 0,    0,    1176, 0,    2914, 3715, 1581, 992,  1632, 2747,
    1733, 1384, 204,  0,    1705, 2192, 1410, 0,    3251, 1167, 0,    0,    0,    463,  1395, 0,
    0,    0,    503,  0,    362,  545,  120,  442,  993,  580,  3058, 1128, 0,    0,    83,   0,
    2426, 691,  411,  0,    1289, 1797, 0,    0,    3375, 1924, 4049, 3752, 1748, 0,    2759, 0,
    0,    0,    0,    1136, 0,    0,    0,    0,    0,    3134, 0,    894,  618,  0,    1283, 3282,
    2008, 0,    470,  3265, 0,    1633, 0,    3365, 0,    0,    1034, 0,    3594, 1973, 195,  593,
    2976, 1197, 0,    0,    1825, 1370, 2016, 0,    1056, 162,  0,    1813, 752,  830,  607,  0,
    0,    785,  0,    3831, 0,    418,  1288, 427,  348,  604,  4077, 0,    250,  0,    2365, 0,
    4066, 0,    1942, 0,    1480, 0,    0,    1702, 0,    0,    694,  415,  3503, 0,    1747, 1073,
    917,  2002, 0,    2551, 0,    362,  583,  0,    0,    415,  823,  3432, 0,    2726, 4093, 0,
    0,    0,    2162, 0,    3239, 2057, 79,   0,    4007, 0,    460,  0,    0,    3504, 0,    0,
    722,  1932, 0,    2745, 0,    0,    2455, 1131, 841,  2897, 0,    233,  353,  152,  2432, 2132,
    2007, 0,    3172, 0,    0,    101,  0,    860,  0,    35,   696,  0,    188,  1819, 2490, 2454,
    0,    0,    0,    0,    0,    1976, 1735, 3906, 0,    0,    525,  2190, 0,    0,    0,    0,
    0,    3725, 2408, 3518, 0,    4009, 0,    1497, 0,    0,    713,  0,    101,  2156, 0,    1539,
    2179, 68,   1242, 2791, 0,    3205, 0,    0,    2642, 4079, 2479, 0,    3711, 1807, 1586, 3772,
    0,    1437, 0,    1419, 73,   0,    2585, 0,    0,    0,    0,    854,  0,    3495, 0,    1798,
    1939, 0,    0,    1115, 1131, 0,    3996, 0,    0,    0,    930,  853,  459,  3278, 0,    2792,
    2658, 0,    3336, 503,  0,    3885, 1076, 696,  512,  1531, 0,    988,  0,    575,  0,    0,
    114,  3291, 0,    0,    1871, 0,    0,    648,  673,  709,  431,  1296, 2418, 4035, 2554, 0,
    3473, 2101, 299,  2362, 0,    4020, 0,    0,    0,    0,    0,    0,    1394, 0,    0,    3892,
    0,    2790, 0,    52,   0,    3889, 3413, 1525, 0,    0,    1763, 2669, 1974, 1191, 0,    0,
    1128, 3822, 2715, 0,    1115, 1646, 0,    917,  750,  1442, 1184, 2609, 0,    2711, 0,    0,
    0,    2788, 1011, 2026, 420,  259,  688,  2807, 998,  0,    0,    2633, 1337, 0,    3799, 1175,
    1582, 297,  0,    3751, 0,    0,    3804, 0,    1706, 0,    3338, 3017, 0,    3921, 729,  550,
    1854, 0,    3421, 0,    1446, 777,  1103, 1472, 0,    0,    0,    0,    3558, 1235, 1167, 0,
    0,    0,    0,    3656, 3049, 1006, 0,    0,    3411, 0,    0,    3896, 0,    1581, 0,    2032,
    0,    247,  480,  2819, 0,    0,    0,    3042, 1163, 738,  613,  0,    31,   0,    3547, 504,
    1111, 0,    1202, 1955, 1661, 0,    1700, 1831, 2120, 4036, 2142, 0,    2159, 193,  1475, 0,
    0,    478,  3561, 407,  2437, 0,    57,   0,    1726, 0,    0,    0,    48,   609,  581,  1303,
    352,  0,    2680, 1316, 0,    1076, 1601, 0,    2691, 3068, 0,    0,    777,  480,  1842, 0,
    835,  3699, 0,    741,  1554, 0,    0,    0,    0,    497,  0,    3466, 1666, 1280, 0,    0,
    864,  0,    1967, 1528, 0,    856,  1056, 3396, 2229, 0,    0,    0,    0,    0,    0,    1047,
    1513, 2534, 2842, 0,    2001, 0,    0,    0,    1635, 440,  3258, 1729, 1823, 2758, 1188, 0,
    0,    0,    0,    0,    1575, 1066, 1166, 2931, 83,   2308, 3857, 0,    0,    4046, 2732, 3927,
    396,  3626, 334,  3159, 0,    3110, 1801, 3936, 0,    4009, 2987, 1566, 0,    0,    0,    2772,
    682,  1489, 0,    0,    0,    2955, 3686, 0,    4023, 978,  0,    0,    0,    1707, 270,  2774,
    0,    0,    773,  3096, 1584, 0,    2545, 325,  2815, 1970, 1092, 3584, 3502, 1055, 0,    0,
    2070, 3953, 0,    1277, 0,    3472, 1266, 3886, 1927, 650,  0,    769,  940,  1725, 0,    3715,
    3108, 0,    2719, 2098, 302,  0,    0,    537,  1438, 2354, 0,    881,  1233, 924,  3128, 161,
    89,   848,  0,    0,    0,    3312, 0,    0,    0,    3069, 420,  0,    0,    295,  5,    0,
    0,    1362, 1748, 0,    1227, 0,    0,    390,  1428, 1109, 98,   3819, 2765, 0,    460,  2021,
    3692, 180,  573,  1576, 1784, 1093, 0,    414,  1495, 2125, 152,  0,    3960, 2188, 541,  0,
    1968, 1816, 0,    309,  0,    0,    0,    0,    0,    0,    1727, 0,    2030, 0,    600,  3264,
    0,    2405, 0,    1571, 0,    0,    1674, 170,  860,  1389, 0,    457,  785,  0,    0,    3592,
    0,    2395, 2264, 975,  0,    0,    0,    0,    0,    0,    1328, 59,   1377, 3603, 1216, 643,
    0,    0,    0,    1155, 283,  3396, 0,    3396, 0,    369,  0,    0,    0,    0,    0,    0,
    0,    0,    2443, 656,  1862, 0,    2025, 0,    2456, 1666, 1004, 40,   1715, 0,    174,  3813,
    385,  0,    1423, 0,    634,  866,  3854, 2805, 0,    0,    0,    3861, 576,  2675, 0,    3234,
    1322, 1374, 0,    1812, 2907, 2440, 129,  0,    1177, 197,  1721, 230,  0,    0,    1985, 0,
    486,  0,    3293, 0,    3237, 3563, 739,  1934, 2189, 1352, 2363, 0,    3829, 832,  1437, 330,
    1335, 0,    3609, 245,  1757, 4047, 508,  0,    1928, 3923, 3118, 635,  1084, 3781, 1765, 1458,
    1910, 0,    0,    369,  1412, 662,  1183, 2388, 0,    3220, 0,    0,    1747, 0,    0,    3007,
    846,  0,    1609, 0,    0,    1314, 767,  2339, 0,    826,  0,    2181, 3053, 695,  3283, 0,
    0,    494,  1793, 0,    0,    350,  1979, 0,    499,  0,    4,    0,    3884, 2719, 0,    0,
    470,  2181, 1029, 192,  985,  396,  0,    1911, 0,    1841, 1641, 0,    0,    0,    0,    0,
    2652, 0,    421,  3308, 1699, 0,    0,    23,   0,    697,  0,    1195, 1204, 1047, 1248, 1610,
    0,    0,    1633, 0,    677,  872,  3939, 3783, 2768, 0,    2883, 96,   86,   0,    455,  3169,
    1272, 110,  4082, 0,    841,  3469, 1879, 4001, 546,  903,  2446, 1207, 3723, 3981, 3066, 0,
    1097, 1100, 0,    3167, 3273, 63,   1279, 1774, 413,  0,    0,    4024, 130,  1008, 402,  0,
    0,    2027, 0,    4036, 0,    0,    0,    2041, 0,    2866, 0,    0,    1664, 0,    3809, 3192,
    0,    0,    1203, 0,    0,    2769, 506,  3099, 0,    0,    2980, 0,    2251, 0,    0,    556,
    392,  0,    0,    515,  1607, 1389, 0,    4122, 1345, 286,  0,    3679, 0,    1824, 0,    860,
    1727, 0,    161,  771,  2766, 0,    164,  2795, 567,  365,  3939, 0,    0,    2065, 0,    935,
    1263, 262,  0,    0,    0,    3966, 1679, 3671, 0,    0,    4113, 1258, 699,  1563, 0,    1525,
    1754, 0,    238,  0,    1089, 0,    0,    0,    272,  0,    0,    0,    3228, 0,    1560, 307,
    43,   2933, 2818, 0,    3184, 0,    1561, 0,    0,    0,    0,    0,    550,  3869, 818,  566,
    192,  1681, 53,   0,    3545, 0,    574,  0,    1050, 0,    443,  0,    175,  3169, 3899, 2984,
    0,    0,    548,  0,    405,  374,  0,    1926, 268,  4002, 0,    3828, 1764, 2045, 2563, 0,
    0,    0,    1420, 0,    0,    1603, 0,    0,    2127, 0,    0,    3885, 1587, 2123, 45,   2780,
    0,    280,  0,    0,    1817, 793,  3565, 0,    392,  0,    1059, 1678, 0,    0,    2207, 0,
    0,    0,    0,    0,    0,    2853, 2370, 0,    1512, 0,    2368, 837,  3473, 1080, 0,    0,
    3125, 0,    0,    610,  0,    0,    1219, 0,    2357, 1660, 1929, 1040, 1069, 0,    1630, 0,
    498,  0,    1959, 3152, 3867, 39,   1643, 1873, 3206, 0,    3484, 3929, 0,    678,  1147, 0,
    2102, 1421, 1018, 0,    301,  2149, 0,    1046, 0,    1772, 1174, 305,  800,  0,    0,    0,
    2041, 1345, 0,    2799, 2077, 1621, 1940, 2157, 0,    0,    3168, 828,  1273, 0,    0,    1244,
    1550, 934,  2143, 826,  3133, 0,    2909, 2054, 3277, 0,    2004, 2104, 0,    1300, 1238, 1733,
    0,    1537, 0,    262,  1941, 0,    394,  510,  943,  0,    0,    3003, 1761, 3526, 0,    893,
    756,  3069, 1697, 0,    816,  3737, 0,    2057, 0,    0,    0,    0,    0,    3425, 1512, 0,
    3930, 0,    0,    0,    0,    0,    1606, 1058, 0,    0,    0,    0,    1554, 0,    1680, 0,
    0,    3779, 0,    0,    1748, 3284, 2299, 1588, 0,    0,    0,    2049, 0,    1788, 960,  1860,
    0,    690,  3823, 1029, 2929, 0,    60,   216,  0,    1079, 3298, 0,    847,  1515, 424,  0,
    2857, 1159, 1791, 3651, 371,  0,    391,  837,  3952, 3839, 0,    0,    3924, 683,  20,   0,
    611,  0,    0,    2516, 6,    645,  2884, 1576, 2165, 0,    1740, 1344, 1605, 0,    1164, 2261,
    2613, 3893, 2049, 3772, 0,    169,  1863, 3813, 0,    2807, 3508, 0,    0,    2947, 0,    1709,
    0,    757,  588,  0,    3406, 4035, 3615, 0,    0,    0,    2670, 0,    0,    0,    84,   535,
    0,    1724, 0,    1314, 0,    1690, 0,    0,    1804, 0,    0,    0,    851,  0,    1600, 15,
    3247, 589,  2031, 0,    1984, 1342, 3407, 3441, 970,  0,    733,  0,    702,  894,  1191, 0,
    538,  8,    1696, 340,  1867, 0,    209,  0,    0,    673,  361,  3174, 1328, 1291, 0,    1598,
    3813, 0,    190,  3171, 1584, 74,   3633, 0,    0,    0,    0,    0,    1861, 0,    0,    1589,
    0,    1835, 0,    790,  1902, 0,    0,    0,    0,    2352, 606,  0,    24,   1521, 3879, 2205,
    2109, 0,    1739, 0,    0,    4016, 2055, 0,    4060, 0,    4006, 3566, 408,  741,  649,  1981,
    56,   0,    1691, 0,    2075, 1183, 2155, 495,  0,    0,    176,  912,  3262, 1001, 432,  1493,
    0,    1045, 0,    3862, 0,    0,    2887, 0,    0,    1321, 2124, 450,  0,    0,    0,    2,
    1523, 1110, 0,    0,    839,  0,    4094, 1991, 106,  3494, 0,    1746, 231,  0,    1302, 1713,
    233,  0,    2253, 0,    3835, 461,  1578, 3392, 1159, 0,    1415, 1074, 3859, 0,    624,  1212,
    20,   0,    1998, 2056, 0,    2098, 2158, 0,    2126, 807,  915,  687,  1919, 1810, 1479, 874,
    544,  1433, 2546, 935,  1420, 790,  2448, 0,    3267, 1207, 1872, 2640, 0,    2447, 509,  1522,
    3253, 0,    0,    3891, 0,    0,    0,    2028, 0,    136,  303,  0,    0,    0,    3329, 0,
    1145, 4057, 1819, 0,    0,    3047, 1885, 0,    312,  1491, 0,    361,  1359, 1708, 1198, 167,
    0,    3229, 2994, 2011, 273,  3225, 226,  0,    477,  1914, 0,    500,  2128, 2094, 2653, 2108,
    671,  698,  3921, 1399, 0,    1750, 1430, 0,    1121, 1129, 779,  504,  361,  3483, 2022, 316,
    3811, 0,    1698, 1786, 590,  1886, 0,    0,    1948, 1897, 3706, 1772, 1471, 1213, 410,  0,
    1570, 3280, 2342, 0,    0,    0,    3062, 0,    0,    198,  1517, 588,  0,    394,  1804, 28,
    0,    0,    0,    1721, 0,    1789, 2033, 0,    410,  0,    2977, 0,    1408, 2100, 0};

int MangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 4127;
    }
    return mangledkG[sum];
}

int MangledPerfectHash(const char *key)
{
    if (strlen(key) > 40)
        return 0;

    return (MangledHashG(key, mangledkT1) + MangledHashG(key, mangledkT2)) % 4127;
}

constexpr int unmangledkT1[] = {297, 214, 414, 360, 431, 9,   162, 18, 357, 416, 396,
                                15,  6,   126, 105, 21,  330, 300, 95, 177, 214, 52,
                                252, 352, 77,  217, 300, 244, 170, 3,  0,   136};
constexpr int unmangledkT2[] = {93,  204, 371, 354, 269, 365, 153, 165, 347, 381, 6,
                                187, 103, 38,  433, 110, 304, 281, 277, 142, 408, 355,
                                308, 3,   183, 90,  107, 269, 294, 280, 385, 90};
constexpr int unmangledkG[]  = {
    0,   0,   0,   0,   39,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   101, 31,  0,   0,
    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   105, 146, 135, 0,   66,  21,  2,   81,  0,
    0,   183, 64,  0,   0,   0,   113, 122, 253, 70,  0,   52,  1,   0,   0,   0,   1,   35,  0,
    142, 0,   325, 290, 0,   0,   0,   97,  0,   366, 102, 98,  172, 385, 0,   0,   0,   0,   0,
    0,   0,   202, 115, 408, 0,   0,   43,  0,   93,  4,   196, 0,   258, 337, 0,   0,   11,  349,
    201, 0,   0,   251, 0,   0,   0,   0,   0,   0,   0,   0,   0,   241, 0,   0,   0,   0,   0,
    0,   127, 0,   0,   0,   119, 0,   143, 0,   0,   0,   396, 9,   77,  0,   0,   0,   0,   0,
    398, 144, 0,   301, 152, 0,   0,   163, 348, 0,   0,   74,  83,  79,  0,   34,  0,   399, 21,
    0,   0,   131, 0,   0,   0,   104, 0,   325, 0,   0,   0,   199, 0,   0,   0,   0,   436, 92,
    42,  0,   0,   247, 0,   0,   0,   0,   0,   0,   441, 0,   0,   268, 0,   0,   192, 0,   51,
    0,   84,  0,   0,   0,   333, 0,   0,   113, 0,   0,   266, 0,   2,   26,  214, 22,  155, 431,
    0,   0,   33,  79,  76,  150, 191, 342, 0,   85,  0,   60,  360, 179, 0,   199, 0,   194, 0,
    35,  128, 0,   400, 0,   0,   0,   154, 0,   0,   253, 0,   0,   100, 0,   32,  80,  50,  157,
    196, 0,   174, 0,   258, 0,   0,   107, 0,   0,   0,   0,   76,  160, 20,  132, 104, 415, 0,
    0,   422, 0,   48,  0,   0,   0,   103, 42,  0,   0,   123, 0,   0,   0,   401, 342, 1,   58,
    0,   100, 349, 55,  18,  0,   317, 84,  220, 111, 0,   282, 126, 240, 82,  0,   430, 162, 291,
    133, 355, 0,   208, 35,  0,   0,   430, 438, 161, 261, 120, 45,  142, 0,   389, 0,   420, 0,
    216, 0,   6,   0,   56,  221, 6,   419, 112, 0,   161, 0,   23,  197, 62,  0,   115, 0,   299,
    118, 0,   59,  0,   0,   172, 17,  427, 293, 58,  0,   5,   352, 0,   99,  0,   434, 75,  0,
    0,   396, 0,   0,   151, 0,   30,  0,   172, 0,   0,   0,   119, 0,   54,  0,   0,   0,   24,
    95,  0,   425, 0,   0,   15,  151, 192, 0,   78,  160, 0,   0,   0,   0,   0,   39,  0,   0,
    0,   0,   398, 72,  87,  0,   0,   0,   411, 0,   234, 0,   137, 130, 154, 0,   0,   247, 19,
    0,   33,  291, 0,   0,   88,  22,  222, 207, 114, 0,   82,  0,   434, 0,   285, 0,   408, 41,
    2,   293, 0,   0,   49};

int UnmangledHashG(const char *key, const int *T)
{
    int sum = 0;

    for (int i = 0; key[i] != '\0'; i++)
    {
        sum += T[i] * key[i];
        sum %= 442;
    }
    return unmangledkG[sum];
}

int UnmangledPerfectHash(const char *key)
{
    if (strlen(key) > 32)
        return 0;

    return (UnmangledHashG(key, unmangledkT1) + UnmangledHashG(key, unmangledkT2)) % 442;
}

}  // namespace

namespace sh
{

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvPrime = 16777619u;

template <>
const size_t ImmutableString::FowlerNollVoHash<4>::kFnvOffsetBasis = 0x811c9dc5u;

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvPrime =
    static_cast<size_t>(1099511628211ull);

template <>
const size_t ImmutableString::FowlerNollVoHash<8>::kFnvOffsetBasis =
    static_cast<size_t>(0xcbf29ce484222325ull);

uint32_t ImmutableString::mangledNameHash() const
{
    return MangledPerfectHash(data());
}

uint32_t ImmutableString::unmangledNameHash() const
{
    return UnmangledPerfectHash(data());
}

}  // namespace sh
