/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_ImageCaptureError_h
#define mozilla_dom_ImageCaptureError_h

#include "mozilla/Attributes.h"
#include "nsCOMPtr.h"
#include "nsString.h"
#include "nsWrapperCache.h"

namespace mozilla {
namespace dom {

/**
 * This is the implementation of ImageCaptureError on W3C specification
 * https://dvcs.w3.org/hg/dap/raw-file/default/media-stream-capture/ImageCapture.html#idl-def-ImageCaptureError.
 * This object should be generated by ImageCapture object only.
 */
class ImageCaptureError final : public nsISupports,
                                public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(ImageCaptureError)

  ImageCaptureError(nsISupports* aParent, uint16_t aCode, const nsAString& aMessage);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto) override;

  uint16_t Code() const;

  enum {
    FRAME_GRAB_ERROR = 1,
    SETTINGS_ERROR = 2,
    PHOTO_ERROR = 3,
    ERROR_UNKNOWN = 4,
  };

  void GetMessage(nsAString& retval) const;

private:
  ~ImageCaptureError();

  nsCOMPtr<nsISupports> mParent;
  nsString mMessage;
  uint16_t mCode;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_ImageCaptureError_h
