/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import com.robotium.solo.PressurePoint;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Illustration {
    private final int toolType;
    private final ArrayList<PressurePoint> points;

    private Illustration(Builder builder) {
        this.toolType = builder.builderToolType;
        this.points = builder.builderPoints;
    }

    public ArrayList<PressurePoint> getPoints() {
        return this.points;
    }

    public int getToolType() {
        return this.toolType;
    }

    public static class Builder {
        private int builderToolType = 1;
        private ArrayList<PressurePoint> builderPoints = new ArrayList();

        public Builder setToolType(int toolType) {
            this.builderToolType = toolType;
            return this;
        }

        public Builder addPoint(float x, float y, float pressure) {
            this.builderPoints.add(new PressurePoint(x, y, pressure));
            return this;
        }

        public Illustration build() {
            return new Illustration(this);
        }
    }
}

