/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.ClassAttributes;
import classycle.GraphBuilder;
import classycle.PackageVertex;
import classycle.graph.AtomicVertex;
import classycle.graph.GraphProcessor;
import classycle.graph.Vertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PackageProcessor
extends GraphProcessor {
    private final Map<String, PackageVertex> _packageVertices = new HashMap<String, PackageVertex>();
    private final List<Arc> _arcs = new ArrayList<Arc>();
    private AtomicVertex[] _packageGraph;

    public AtomicVertex[] getGraph() {
        return this._packageGraph;
    }

    @Override
    protected void initializeProcessing(Vertex[] graph) {
        this._packageVertices.clear();
    }

    @Override
    protected void processBefore(Vertex vertex) {
    }

    @Override
    protected void processArc(Vertex tail, Vertex head) {
        PackageVertex tailPackage = this.getPackageVertex(tail);
        PackageVertex headPackage = this.getPackageVertex(head);
        boolean internalHeadClass = ((AtomicVertex)head).isGraphVertex();
        this._arcs.add(new Arc(tailPackage, headPackage, internalHeadClass));
    }

    private PackageVertex getPackageVertex(Vertex vertex) {
        ClassAttributes classAttributes = (ClassAttributes)vertex.getAttributes();
        String className = classAttributes.getName();
        int index = className.lastIndexOf(46);
        String packageName = index < 0 ? "(default package)" : className.substring(0, index);
        PackageVertex result = this._packageVertices.get(packageName);
        if (result == null) {
            result = new PackageVertex(packageName);
            this._packageVertices.put(packageName, result);
        }
        if (this.isVertexFromGraph(vertex)) {
            result.reset();
        }
        result.addClass(classAttributes);
        return result;
    }

    private boolean isVertexFromGraph(Vertex vertex) {
        return vertex instanceof AtomicVertex && ((AtomicVertex)vertex).isGraphVertex();
    }

    @Override
    protected void processAfter(Vertex vertex) {
    }

    @Override
    protected void finishProcessing(Vertex[] graph) {
        for (int i = 0; i < this._arcs.size(); ++i) {
            this._arcs.get(i).create();
        }
        ArrayList<PackageVertex> list = new ArrayList<PackageVertex>();
        for (PackageVertex vertex : this._packageVertices.values()) {
            if (!vertex.isGraphVertex()) continue;
            list.add(vertex);
        }
        this._packageGraph = list.toArray(new AtomicVertex[list.size()]);
        GraphBuilder.sort(this._packageGraph);
    }

    private static final class Arc {
        final AtomicVertex tail;
        final AtomicVertex head;
        final boolean internalHeadClass;

        Arc(AtomicVertex tail, AtomicVertex head, boolean internalHeadClass) {
            this.tail = tail;
            this.head = head;
            this.internalHeadClass = internalHeadClass;
        }

        void create() {
            if (this.internalHeadClass || !this.head.isGraphVertex()) {
                this.tail.addOutgoingArcTo(this.head);
            }
        }
    }
}

