#!/bin/bash
# Pesquisar fusos horários disponíveis para inserir no Relógio Mundial
        TEXTDOMAINDIR=/usr/share/locale
        TEXTDOMAIN=ft10-clock
   
add_tz_text=$"ADD Time zone"
delete_tz_text=$"REMOVE Time zone"

delete_tz()
{
#process, line by line timezone list in the config file ~/.world-clock.zones 
cat ~/.world-clock.zones | while read line; do
# remove empty lines:
sed -i '/^[[:space:]]*$/d' ~/.world-clock.zones

##Get selection

selection=$(yad --window-icon=/usr/share/icons/numix-square-antix/48x48/apps/clock.png --center --height=600 --width=450 --title=$"FT10-clock" --list --column="" --button="-" < ~/.world-clock.zones)	
selection_to_delete=$(echo $selection|cut -d\| -f1)	

# if nothing was selected, exit
if [ -z "$selection" ]; then exit
fi

#delete selected tz
grep -v $selection_to_delete ~/.world-clock.zones > temp && mv temp ~/.world-clock.zones 

#restart world-clock GUI
pkill ft10-clock.sh 
bash -c /usr/local/lib/ft10/ft10-clock.sh

#end initial infine loop (so window is always open after selection)
done
}		

add_tz()
{
#Search available Timezones	
search_tz_text=$"Insert Time Zone to be added to the World Clock \n (Enter nothing to search trough all available timezones)"
#search=$(yad --center --text-align=center --title=$"FT10-clock" --window-icon=/usr/share/icons/numix-square-antix/48x48/apps/clock.png --text="$search_tz_text" --button="OK" --entry)
echo "" > ~/tz-list.txt 
find -L /usr/share/zoneinfo/posix/ -type f | grep -i "$search" | while read z
      do
          d=$(TZ=$z)
          printf "%-34s %23s\n" ${z#/usr/share/zoneinfo/posix/} "$d" >> ~/tz-list.txt
      done
      # remove empty lines:
sed -i '/^[[:space:]]*$/d' ~/tz-list.txt
      #alfabetize results:
sort ~/tz-list.txt > temp && mv temp ~/tz-list.txt 

results=$(cat ~/tz-list.txt)

##Get selection
selection=$(yad --window-icon=/usr/share/icons/numix-square-antix/48x48/apps/clock.png --center --height=600 --width=450 --title=$"FT10-clock" --list --column=$"" --button="+" < ~/tz-list.txt)	
selection_to_add=$(echo $selection|cut -d\| -f1)	

# if nothing was selected, exit
if [ -z "$selection" ]; then exit
fi

# add selection to world-clock
echo $selection_to_add >> ~/.world-clock.zones	

#restart world-clock GUI
pkill ft10-clock.sh 
bash -c /usr/local/lib/ft10/ft10-clock.sh

}


export -f add_tz delete_tz

#display main window
DADOS=$(yad --window-icon=/usr/share/icons/numix-square-antix/48x48/apps/clock.png --width=300 --paned --mouse --splitter="200" --title=$"FT10-clock" \
--form  \
--center \
--field=$"$add_tz_text!add:FBTN" "bash -c add_tz" \
--field=$"$delete_tz_text!remove:FBTN" "bash -c delete_tz" \
--wrap --no-buttons)

### wait for a button to be pressed then perform the selected function
foo=$?

[[ $foo -eq 1 ]] && exit 0

