title: The 66 Suite: 66
author: Eric Vidal <eric@obarun.org>

[66](index.html)

[Software](https://web.obarun.org/software)

[obarun.org](https://web.obarun.org)

# 66

Program to control the state of the system and service manager.

## Interface

```
66 [ -h ] [ -z ] [ -v verbosity ] [ -l live ] [ -T timeout ] [ -t tree ] start|stop|reload|restart|free|reconfigure|enable|disable|configure|status|resolve|state|remove|signal|tree|parse|scandir|boot|poweroff|reboot|halt|version [<command options> or subcommand <subcommand options>] service...|tree
```

Invocation of `66` can be made as `root` or `regular account`.

## Options

These options are available all commands except the `-t` options. In such cases, the help of the specific command provides clarification.

- **-h**: prints this help.

- **-z**: use color.

- **-v** *verbosity*: increases/decreases the verbosity of the command.
    * *0*: only print error messages.
    * *1*: also, print informative messages. This is the default.
    * *2*: also, print warning messages.
    * *3*: also, print tracing messages.
    * *4*: also, print function name and line code of the messages.
    * *5*: also, display the sequence of the current process function by function.

- **-l** *live*: changes the supervision directory of *service* to *live*. By default this will be `%%livedir%%`. The default can also be changed at compile time by passing the `--livedir=` option to `./configure`. An existing absolute path is expected and should be within a writable and executable filesystem - likely a RAM filesystem—see [scandir](scandir.html) command.

- **-T** *timeout*: specifies a general timeout (in milliseconds) passed to command. By default the timeout is set to 0 (infinite).

- **-t** *tree*: set *tree* as tree to use.

## Commands

### Debug command

- [parse](parse.html): parse the service frontend file.
- [resolve](resolve.html): display the service's resolve file contents.
- [state](state.html): display service's state file contents.

### Admin command

- [boot](boot.html): boot the system.
- [scandir](scandir.html): manage scandir.
- [init](init.html): initiate service of a tree.
- [signal](signal.html): send a signal to services.

### User command

- [start](start.html): bring up services.
- [stop](stop.html): bring down services.
- [enable](enable.html): activate services for the next boot.
- [disable](disable.html): deactivate services for the next boot.
- [reload](reload.html): send a SIGHUP signal to services.
- [restart](restart.html): bring down then bring up services.
- [status](status.html): display service information.
- [configure](configure.html): manage service environment variables.
- [reconfigure](reconfigure.html): bring down, unsupervise, parse it again and bring up service.
- [remove](remove.html): remove service and cleanup all files belong to it within the system.
- [free](free.html): bring down services and remove it from scandir.
- [tree](tree.html): manage or see information of trees.
- [poweroff](poweroff.html): poweroff the system.
- [reboot](reboot.html): reboot the system.
- [halt](halt.html): halt the system.
- [version](version.html): display 66 version.

## Exit codes

- *0* success
- *100* wrong usage
- *111* system call failed

Furthermore, all commands receive the same exit code.

## Instanced service

An instanced *service* name from a service template can be passed as service argument where the name of the *service* must end with a `@` (commercial at).—see [frontend service file](frontend.html).

**(!)** The name of the template must be declared first immediately followed by the instance name.

For example, to enable a intanced service, you can do:

```
66 enable foo@foobar
```

## Handling dependencies

Any dependency or required-by dependency of a service or a tree chain will be automatically resolved. Manually defining chains of interdependencies is unnecessary.

For instance, during the `stop` command, if the `FooA` service has a declared required-by dependency on `FooB`, `FooB` will be considered and automatically stopped first when `FooA` is stopped. This process will run recursively until all required-by dependencies are stopped. This is also valuable for the opposite process, meaning start.

This applies to all `66` commands when it's necessary.
