#include "alternatives.ih"

// static
bool Alternatives::dotPattern(string const &dirEntry, 
                              GlobContext const &context)
{
    if (dirEntry.find("/./") != string::npos   // ignore */./* patterns
        or
            find_if(
                context.ignore.begin(), context.ignore.end(),
                [&](string const &ignore)
                {
                    return matchIgnore(ignore, dirEntry);
                }
            )
            != context.ignore.end()
    )
    {
        imsg << "ignored" << endl;
        return true;
    }

    return false;
}
