#!/bin/sh -e
#
# Copyright (c) 2002-2024 Martin A. Godisch <martin@godisch.de>

test -e wmpuzzle.c
umask 022
aclocal
autoheader -Wall
autoconf -Wall
./configure
make distclean
rm -rf autom4te.cache *~ *.log
cd ..
chmod -R go=u-w .
version="`pwd`"
version="${version##*-}"
tarname="wmpuzzle-${version}.tar.gz"
cd ..
fakeroot tar cvzf $tarname --exclude .git --exclude .gitignore --exclude .pc --exclude debian wmpuzzle-$version
ln -sf $tarname wmpuzzle_$version.orig.tar.gz
echo -n "Sign $tarname? [y/N] "
read sign
if test "$sign" = y; then
	gpg -ab $tarname
else
	echo "No."
fi
cd wmpuzzle-$version
if ! grep -iq "AC_INIT.*[${version}]" src/configure.ac; then
	echo "*** WARNING: version in configure.ac out of date  ***"
fi
if grep -iq "not yet released" CHANGES; then
	echo "*** WARNING: release date in CHANGES file missing ***"
fi
