/*
 * Decompiled with CFR 0.152.
 */
import edu.hws.jcm.awt.DisplayLabel;
import edu.hws.jcm.awt.ExpressionInput;
import edu.hws.jcm.awt.JCMPanel;
import edu.hws.jcm.awt.VariableSlider;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.ParseError;
import edu.hws.jcm.data.Parser;
import edu.hws.jcm.data.SimpleFunction;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.draw.CoordinateRect;
import edu.hws.jcm.draw.Graph1D;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiGraph
extends GenericGraphApplet {
    private Vector sliders;
    private ExprIn[] inputs;
    private Graph1D[] graphs;
    private int functionCt;
    private Color[] graphColors = new Color[]{Color.magenta, new Color(0, 180, 0), Color.red, new Color(0, 200, 200), Color.orange, Color.gray, Color.blue, Color.pink};

    @Override
    protected void setUpParser() {
        this.sliders = new Vector();
        int n = 0;
        String string = this.getParameter("Parameter");
        if (string == null) {
            string = this.getParameter("Parameter" + ++n);
        }
        while (string != null) {
            this.addParameter(string);
            string = this.getParameter("Parameter" + ++n);
        }
        super.setUpParser();
    }

    private void addParameter(String string) {
        Object object;
        String string2;
        double d = -5.0;
        double d2 = 5.0;
        double d3 = 0.0;
        int n = (string = string.trim()).indexOf(59);
        if (n < 0) {
            n = string.indexOf(32);
        }
        if (n < 0) {
            string2 = string;
        } else {
            object = string.substring(n + 1);
            string2 = string.substring(0, n).trim();
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ,\t");
            try {
                if (stringTokenizer.hasMoreElements()) {
                    d = new Double(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreElements()) {
                    d2 = new Double(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreElements()) {
                    d3 = new Double(stringTokenizer.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {
                d = -5.0;
                d2 = 5.0;
                d3 = 0.0;
            }
        }
        object = new VariableSlider(string2, new Constant(d), new Constant(d2), this.parser);
        ((VariableSlider)object).setVal(d3);
        this.sliders.addElement(object);
    }

    private void getColors() {
        Vector<Color> vector = new Vector<Color>();
        int n = 0;
        Color color = this.getColorParam("GraphColor");
        if (color == null) {
            color = this.getColorParam("GraphColor" + ++n);
        }
        while (color != null) {
            vector.addElement(color);
            color = this.getColorParam("GraphColor" + ++n);
        }
        if (vector.size() > 0) {
            this.graphColors = new Color[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.graphColors[i] = (Color)vector.elementAt(i);
            }
        }
    }

    private Vector getFunctions() {
        double[] dArray;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        String string = this.getParameter("Function");
        if (string == null) {
            string = this.getParameter("Function" + ++n);
        }
        while (string != null) {
            vector.addElement(string);
            string = this.getParameter("Function" + ++n);
        }
        if (vector.size() == 0) {
            vector.addElement(" abs( " + this.xVar.getName() + ") ^ " + this.xVar.getName());
        }
        if ((dArray = this.getNumericParam("FunctionCount")) == null || dArray.length == 0 || dArray[0] <= 0.5) {
            this.functionCt = vector.size();
        } else {
            this.functionCt = (int)Math.round(dArray[0]);
            if (this.functionCt < vector.size()) {
                this.functionCt = vector.size();
            } else {
                int n2 = this.functionCt - vector.size();
                for (int i = 0; i < n2; ++i) {
                    vector.addElement("");
                }
            }
        }
        return vector;
    }

    private Panel makeFunctionInput(Vector vector, int n) {
        Graph1D graph1D = new Graph1D();
        graph1D.setColor(this.graphColors[n % this.graphColors.length]);
        ExprIn exprIn = new ExprIn((String)vector.elementAt(n), this.parser, graph1D, this.xVar);
        exprIn.setOnUserAction(this.mainController);
        JCMPanel jCMPanel = new JCMPanel();
        jCMPanel.add((Component)exprIn, "Center");
        String string = vector.size() > 1 ? " " + this.getParameter("FunctionName", "f") + (n + 1) + "(" + this.xVar.getName() + ") = " : " " + this.getParameter("FunctionName", "f") + "(" + this.xVar.getName() + ") = ";
        jCMPanel.add((Component)new Label(string), "West");
        if (this.graphColors.length > 1 && vector.size() > 1) {
            jCMPanel.add((Component)new ColorPatch(this.graphColors[n % this.graphColors.length]), "East");
        }
        this.inputs[n] = exprIn;
        return jCMPanel;
    }

    @Override
    protected void setUpBottomPanel() {
        Serializable serializable;
        Object object;
        int n;
        Object object2;
        boolean bl = "yes".equalsIgnoreCase(this.getParameter("UseFunctionInput", "yes"));
        if (bl && "yes".equalsIgnoreCase(this.getParameter("UseComputeButton", "yes"))) {
            object2 = this.getParameter("ComputeButtonName", "New Functions");
            this.computeButton = new Button((String)object2);
            this.computeButton.addActionListener(this);
        }
        object2 = null;
        this.getColors();
        Vector vector = this.getFunctions();
        if (!bl && this.sliders.size() == 0) {
            return;
        }
        JCMPanel jCMPanel = new JCMPanel();
        if (!"no".equalsIgnoreCase(this.getParameter("TwoInputColumns", "no"))) {
            jCMPanel.setLayout(new GridLayout(0, 2, 12, 3));
        } else {
            jCMPanel.setLayout(new GridLayout(0, 1, 3, 3));
        }
        jCMPanel.setBackground(this.getColorParam("PanelBackground", Color.lightGray));
        if (bl) {
            this.inputs = new ExprIn[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                object = this.makeFunctionInput(vector, n);
                if (object2 == null) {
                    object2 = object;
                }
                jCMPanel.add((Component)object);
            }
        } else {
            this.graphs = new Graph1D[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                this.graphs[n] = new Graph1D();
                this.graphs[n].setColor(this.graphColors[n % this.graphColors.length]);
                object = ((String)vector.elementAt(n)).trim();
                if (((String)object).length() <= 0) continue;
                serializable = new SimpleFunction((Expression)this.parser.parse((String)object), this.xVar);
                this.graphs[n].setFunction((Function)serializable);
            }
        }
        for (n = 0; n < this.sliders.size(); ++n) {
            object = new JCMPanel();
            serializable = (VariableSlider)this.sliders.elementAt(n);
            ((Container)object).add((Component)serializable, "Center");
            ((Container)object).add((Component)new DisplayLabel("  " + ((Component)serializable).getName() + " = # ", new Value[]{((VariableSlider)serializable).getVariable()}), "East");
            jCMPanel.add((Component)object);
            ((VariableSlider)serializable).setOnUserAction(this.mainController);
        }
        if (this.computeButton != null) {
            if (vector.size() == 1) {
                ((Container)object2).add((Component)this.computeButton, "East");
            } else if (this.limitsPanel == null) {
                Panel panel = new Panel();
                panel.add(this.computeButton);
                jCMPanel.add(panel);
            }
        }
        this.mainPanel.add((Component)jCMPanel, "South");
    }

    @Override
    protected void setUpLimitsPanel() {
        super.setUpLimitsPanel();
        if (this.limitsPanel != null && this.computeButton != null && this.functionCt != 1) {
            this.limitsPanel.addComponent(this.computeButton);
        }
    }

    @Override
    protected void setUpCanvas() {
        super.setUpCanvas();
        if (this.graphs != null) {
            for (int i = 0; i < this.graphs.length; ++i) {
                this.canvas.add(this.graphs[i]);
            }
        } else {
            for (int i = 0; i < this.inputs.length; ++i) {
                this.canvas.add(this.inputs[i].graph);
            }
        }
    }

    @Override
    protected void doLoadExample(String string) {
        Object object;
        int n = string.indexOf(";");
        double[] dArray = new double[]{-5.0, 5.0, -5.0, 5.0};
        if (n > 0) {
            int n2;
            object = string.substring(0, n);
            string = string.substring(n + 1);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, " ,");
            if (stringTokenizer.countTokens() >= 4) {
                for (n2 = 0; n2 < 4; ++n2) {
                    try {
                        Double d = new Double(stringTokenizer.nextToken());
                        dArray[n2] = d;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            for (n2 = 0; n2 < this.sliders.size() && stringTokenizer.hasMoreElements(); ++n2) {
                try {
                    double d = new Double(stringTokenizer.nextToken());
                    double d2 = new Double(stringTokenizer.nextToken());
                    double d3 = new Double(stringTokenizer.nextToken());
                    VariableSlider variableSlider = (VariableSlider)this.sliders.elementAt(n2);
                    variableSlider.setMin(new Constant(d));
                    variableSlider.setMax(new Constant(d2));
                    variableSlider.setVal(d3);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        object = new StringTokenizer(string, ";");
        for (int i = 0; i < this.functionCt; ++i) {
            if (((StringTokenizer)object).hasMoreElements()) {
                String string2 = ((StringTokenizer)object).nextToken();
                if (this.graphs != null) {
                    try {
                        this.graphs[i].setFunction(new SimpleFunction((Expression)this.parser.parse(string2), this.xVar));
                    }
                    catch (ParseError parseError) {
                        this.graphs[i].setFunction(null);
                    }
                    continue;
                }
                this.inputs[i].setText(string2);
                continue;
            }
            if (this.graphs != null) {
                this.graphs[i].setFunction(null);
                continue;
            }
            this.inputs[i].setText("");
        }
        CoordinateRect coordinateRect = this.canvas.getCoordinateRect(0);
        coordinateRect.setLimits(dArray);
        coordinateRect.setRestoreBuffer();
        this.mainController.compute();
    }

    private static class ExprIn
    extends ExpressionInput {
        Graph1D graph;
        Function func;

        ExprIn(String string, Parser parser, Graph1D graph1D, Variable variable) {
            super(string, parser);
            this.graph = graph1D;
            this.func = this.getFunction(variable);
            if (string.trim().length() > 0) {
                this.graph.setFunction(this.func);
            }
        }

        @Override
        public void checkInput() {
            if (!this.hasChanged) {
                return;
            }
            String string = this.getText().trim();
            if (string.length() == 0) {
                if (this.graph != null) {
                    this.graph.setFunction(null);
                }
                this.hasChanged = false;
            } else {
                super.checkInput();
                if (this.graph != null) {
                    this.graph.setFunction(this.func);
                }
            }
        }
    }

    private static class ColorPatch
    extends Canvas {
        ColorPatch(Color color) {
            this.setBackground(color);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(25, 10);
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
    }
}

