/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.io.InputStream;
import java.net.URL;

public class LatticeViewer
extends Applet
implements Runnable {
    XYZLatModel md;
    boolean painted = true;
    float xfac;
    int prevx;
    int prevy;
    float xtheta;
    float ytheta;
    float scalefudge = 1.0f;
    Matrix3D amat = new Matrix3D();
    Matrix3D tmat = new Matrix3D();
    String mdname = null;
    String message = null;
    boolean label = false;
    boolean box = false;
    boolean bonds = false;
    Image backBuffer;
    Graphics backGC;
    Dimension backSize;
    String param;
    Color bgcolor;
    Color bondcolor;
    Color boxcolor;

    private synchronized void newBackBuffer() {
        this.backBuffer = this.createImage(this.size().width, this.size().height);
        this.backGC = this.backBuffer.getGraphics();
        this.backSize = this.size();
    }

    public void init() {
        Integer n;
        this.mdname = this.getParameter("model");
        try {
            this.scalefudge = Float.valueOf(this.getParameter("scale")).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.label = Boolean.valueOf(this.getParameter("label"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.box = Boolean.valueOf(this.getParameter("box"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.bonds = Boolean.valueOf(this.getParameter("bonds"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.param = this.getParameter("bgcolor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n = Integer.valueOf(this.param, 16);
            this.bgcolor = new Color(n);
        }
        catch (NumberFormatException numberFormatException) {
            this.bgcolor = Color.lightGray;
        }
        try {
            this.param = this.getParameter("bondcolor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n = Integer.valueOf(this.param, 16);
            this.bondcolor = new Color(n);
        }
        catch (NumberFormatException numberFormatException) {
            this.bondcolor = Color.black;
        }
        try {
            this.param = this.getParameter("boxcolor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            n = Integer.valueOf(this.param, 16);
            this.boxcolor = new Color(n);
        }
        catch (NumberFormatException numberFormatException) {
            this.boxcolor = Color.red;
        }
        this.amat.yrot(20.0);
        this.amat.xrot(20.0);
        if (this.mdname == null) {
            this.mdname = "model.obj";
        }
        this.resize(this.size().width <= 20 ? 400 : this.size().width, this.size().height <= 20 ? 400 : this.size().height);
        this.newBackBuffer();
    }

    public void run() {
        InputStream inputStream = null;
        try {
            float f;
            float f2;
            Thread.currentThread().setPriority(1);
            inputStream = new URL(this.getDocumentBase(), this.mdname).openStream();
            XYZLatModel xYZLatModel = new XYZLatModel(inputStream, this.label, this.box, this.bonds, this.bgcolor, this.bondcolor, this.boxcolor);
            ScaleableAtom.setApplet(this);
            this.md = xYZLatModel;
            xYZLatModel.findBB();
            float f3 = xYZLatModel.xmax - xYZLatModel.xmin;
            float f4 = xYZLatModel.ymax - xYZLatModel.ymin;
            float f5 = xYZLatModel.zmax - xYZLatModel.zmin;
            if (f4 > f3) {
                f3 = f4;
            }
            if (f5 > f3) {
                f3 = f5;
            }
            this.xfac = 0.7f * ((f2 = (float)this.size().width / f3) < (f = (float)this.size().height / f3) ? f2 : f) * this.scalefudge;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.md = null;
            this.message = exception.toString();
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    public void start() {
        if (this.md == null && this.message == null) {
            new Thread(this).start();
        }
    }

    public void stop() {
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.prevx = n;
        this.prevy = n2;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.tmat.unit();
        float f = (float)(this.prevy - n2) * (360.0f / (float)this.size().width);
        float f2 = (float)(n - this.prevx) * (360.0f / (float)this.size().height);
        this.tmat.xrot(f);
        this.tmat.yrot(f2);
        this.amat.mult(this.tmat);
        if (this.painted) {
            this.painted = false;
            this.repaint();
        }
        this.prevx = n;
        this.prevy = n2;
        return true;
    }

    public void update(Graphics graphics) {
        if (this.backBuffer == null) {
            graphics.clearRect(0, 0, this.size().width, this.size().height);
        }
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.md != null) {
            this.md.mat.unit();
            this.md.mat.translate(-(this.md.xmin + this.md.xmax) / 2.0f, -(this.md.ymin + this.md.ymax) / 2.0f, -(this.md.zmin + this.md.zmax) / 2.0f);
            this.md.mat.mult(this.amat);
            this.md.mat.scale(this.xfac, -this.xfac, 16.0f * this.xfac / (float)this.size().width);
            this.md.mat.translate(this.size().width / 2, this.size().height / 2, 8.0f);
            this.md.transformed = false;
            if (this.backBuffer != null) {
                if (!this.backSize.equals(this.size())) {
                    this.newBackBuffer();
                }
                this.setBackground(this.bgcolor);
                this.backGC.setColor(this.bgcolor);
                this.backGC.fillRect(0, 0, this.size().width, this.size().height);
                this.md.paint(this.backGC);
                graphics.drawImage(this.backBuffer, 0, 0, this);
            } else {
                this.md.paint(graphics);
            }
            this.setPainted();
        } else if (this.message != null) {
            graphics.drawString("Error in model:", 3, 20);
            graphics.drawString(this.message, 10, 40);
        }
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }

    private synchronized void waitPainted() {
        while (!this.painted) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.painted = false;
    }
}

