/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import com.jcraft.weirdx.Colormap;
import com.jcraft.weirdx.Drawable;
import com.jcraft.weirdx.Pixmap;
import com.jcraft.weirdx.Resizable;
import com.jcraft.weirdx.ResizablePixmap1;
import com.jcraft.weirdx.ResizablePixmap16;
import com.jcraft.weirdx.Resource;
import java.awt.image.MemoryImageSource;

class ResizablePixmap
extends Pixmap
implements Resizable {
    int real_width = 0;
    int real_height = 0;

    ResizablePixmap(int n, Drawable drawable, int n2, int n3, byte by) {
        super(n, drawable, n2, n3, by);
        this.getData();
        this.real_width = n2;
        this.real_height = n3;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    static Pixmap createPixmap(int n, Drawable drawable, int n2, int n3, byte by) {
        Pixmap pixmap = null;
        pixmap = by == 1 ? new ResizablePixmap1(n, drawable, n2, n3) : (by == 16 ? new ResizablePixmap16(n, drawable, n2, n3) : new ResizablePixmap(n, drawable, n2, n3, by));
        Resource.add(pixmap);
        return pixmap;
    }

    public void setSize(int n, int n2) {
        if (n <= this.real_width && n2 <= this.real_height) {
            if (2 * n < this.real_width && 2 * n2 < this.real_height) {
                this.real_width /= 2;
                this.real_height /= 2;
                this.data = new byte[this.real_width * this.real_height];
                this.mis = new MemoryImageSource(this.real_width, this.real_height, this.colormap.cm, this.data, 0, this.real_width);
                this.mis.setAnimated(true);
            }
        } else {
            if (this.real_width < n) {
                this.real_width = n;
            }
            if (this.real_height < n2) {
                this.real_height = n2;
            }
            this.data = new byte[this.real_width * this.real_height];
            this.mis = new MemoryImageSource(this.real_width, this.real_height, this.colormap.cm, this.data, 0, this.real_width);
            this.mis.setAnimated(true);
        }
        this.width = n;
        this.height = n2;
    }

    public int getRealWidth() {
        return this.real_width;
    }

    public int getRealHeight() {
        return this.real_height;
    }
}

