# - Try to find LIBDBUS GLIB Bindings
# Find LIBDBUSGLIB headers, libraries and the answer to all questions.
#
#  LIBDBUSGLIB_FOUND               True if libdbus-glib got found
#  LIBDBUSGLIB_INCLUDE_DIRS        Location of libdbus-glib headers 
#  LIBDBUSGLIB_LIBRARIES           List of libraries to use libdbus-glib 
#
# Copyright (c) 2008 Bjoern Ricks <bjoern.ricks@googlemail.com>
#
#  Redistribution and use is allowed according to the terms of the New
#  BSD license.
#  For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#

INCLUDE( FindPkgConfig )

IF ( LibDbusGlib_FIND_REQUIRED )
	SET( _pkgconfig_REQUIRED "REQUIRED" )
ELSE( LibDbusGlib_FIND_REQUIRED )
	SET( _pkgconfig_REQUIRED "" )	
ENDIF ( LibDbusGlib_FIND_REQUIRED )

IF ( LIBDBUSGLIB_MIN_VERSION )
	PKG_SEARCH_MODULE( LIBDBUSGLIB ${_pkgconfig_REQUIRED} dbus-glib-1>=${LIBDBUSGLIB_MIN_VERSION} )
ELSE ( LIBDBUSGLIB_MIN_VERSION )
	PKG_SEARCH_MODULE( LIBDBUSGLIB ${_pkgconfig_REQUIRED} dbus-glib-1 )
ENDIF ( LIBDBUSGLIB_MIN_VERSION )


IF( NOT LIBDBUSGLIB_FOUND AND NOT PKG_CONFIG_FOUND )
	FIND_PATH( LIBDBUSGLIB_INCLUDE_DIRS dbus/dbus-glib.h PATH_SUFFIXES dbus-1.0 dbus )
	FIND_LIBRARY( LIBDBUSGLIB_LIBRARIES dbus-glib dbus-glib-1)

	# Report results
	IF ( LIBDBUSGLIB_LIBRARIES AND LIBDBUSGLIB_INCLUDE_DIRS )	
		SET( LIBDBUSGLIB_FOUND 1 )
		IF ( NOT LIBDBUSGLIB_FIND_QUIETLY )
			MESSAGE( STATUS "Found libdbus-glib: ${LIBDBUSGLIB_LIBRARIES}" )
		ENDIF ( NOT LIBDBUSGLIB_FIND_QUIETLY )
	ELSE ( LIBDBUSGLIB_LIBRARIES AND LIBDBUSGLIB_INCLUDE_DIRS )	
		IF ( LIBDBUSGLIB_FIND_REQUIRED )
			MESSAGE( SEND_ERROR "Could NOT find libdbus-glib" )
		ELSE ( LIBDBUSGLIB_FIND_REQUIRED )
			IF ( NOT LIBDBUSGLIB_FIND_QUIETLY )
				MESSAGE( STATUS "Could NOT find libdbus-glib" )	
			ENDIF ( NOT LIBDBUSGLIB_FIND_QUIETLY )
		ENDIF ( LIBDBUSGLIB_FIND_REQUIRED )
	ENDIF ( LIBDBUSGLIB_LIBRARIES AND LIBDBUSGLIB_INCLUDE_DIRS )
ENDIF( NOT LIBDBUSGLIB_FOUND AND NOT PKG_CONFIG_FOUND )

MARK_AS_ADVANCED( LIBDBUSGLIB_LIBRARIES LIBDBUSGLIB_INCLUDE_DIRS )