# - Try to find KDEPIM3
# Find KDEPIM3 headers, libraries and the answer to all questions.
#
#  KDEPIM3_FOUND               True if KDEPIM3 got found
#  KDEPIM3_INCLUDE_DIR         Location of KDEPIM3 headers 
#  KDEPIM3_KCAL_LIBRARIES      List of libaries to use KABC of KDEPIM3 
#  KDEPIM3_KABC_LIBRARIES      List of libaries to use KCAL of KDEPIM3 
#  KDEPIM3_DEFINITIONS         Definitions to compile KDEPIM3 
#
# Copyright (c) 2007 Daniel Gollub <gollub@b1-systems.de>
#
#  Redistribution and use is allowed according to the terms of the New
#  BSD license.
#  For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#

FIND_PACKAGE( KDE3 REQUIRED )

FIND_PATH( KDEPIM3_INCLUDE_DIR kdepimmacros.h ${KDE3_INCLUDE_DIR} )
FIND_LIBRARY( KDEPIM3_KCAL_LIBRARIES kcal ${KDE3_LIB_DIR} )
FIND_LIBRARY( KDEPIM3_KABC_LIBRARIES kabc ${KDE3_LIB_DIR} )

# Report results
IF ( KDEPIM3_KCAL_LIBRARIES AND KDEPIM3_KABC_LIBRARIES AND KDEPIM3_INCLUDE_DIR )
	SET( KDEPIM3_FOUND 1 )
	IF ( NOT KDEPIM3_FIND_QUIETLY )
		MESSAGE( STATUS "Found KDE PIM 3: ${KDEPIM3_KABC_LIBRARIES} ${KDEPIM3_KCAL_LIBRARIES}" )
	ENDIF ( NOT KDEPIM3_FIND_QUIETLY )
ELSE ( KDEPIM3_KCAL_LIBRARIES AND KDEPIM3_KABC_LIBRARIES AND KDEPIM3_INCLUDE_DIR )
	IF ( KDEPIM3_FIND_REQUIRED )
		MESSAGE( SEND_ERROR "Could NOT find KDE PIM 3" )
	ELSE ( KDEPIM3_FIND_REQUIRED )
		IF ( NOT KDEPIM3_FIND_QUIETLY )
			MESSAGE( STATUS "Could NOT find KDE PIM 3" )
		ENDIF ( NOT KDEPIM3_FIND_QUIETLY )
	ENDIF ( KDEPIM3_FIND_REQUIRED )
ENDIF ( KDEPIM3_KCAL_LIBRARIES AND KDEPIM3_KABC_LIBRARIES AND KDEPIM3_INCLUDE_DIR )

# Hide advanced variables from CMake GUIs
MARK_AS_ADVANCED( KDEPIM3_KCAL_LIBRARIES KDEPIM3_KABC_LIBRARIES KDEPIM3_INCLUDE_DIR )

