// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SSUBW2_2D_TRACE_AARCH64_H_
#define VIXL_SIM_SSUBW2_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_ssubw2_2D[] = {
  0xffffffffff80037d, 0x0000000000000000,
  0x000000000000007d, 0xffffffffffffffff,
  0x000000000000007c, 0xfffffffffffffffe,
  0x000000000000007b, 0xffffffffffffffe0,
  0x000000000000005d, 0xffffffffffffff83,
  0x0000000000000000, 0xffffffffffffff82,
  0xffffffffffffffff, 0xffffffffffffff81,
  0xfffffffffffffffe, 0xffffffffffff8003,
  0xffffffffffff8080, 0xffffffffffff8002,
  0xffffffffffff807f, 0xffffffffffff8001,
  0xffffffffffff807e, 0xffffffffcccccccd,
  0xffffffffcccccd4a, 0xffffffffaaaaaaab,
  0xffffffffaaaaab28, 0xffffffff80000003,
  0xffffffff80000080, 0xffffffff80000002,
  0xffffffff8000007f, 0xffffffff80000001,
  0xffffffff8000007e, 0x0000000080000000,
  0x000000008000007d, 0x000000007fffffff,
  0x000000008000007c, 0x0000000055555556,
  0x00000000555555d3, 0x0000000033333334,
  0x00000000333333b1, 0x0000000000008000,
  0x000000000000807d, 0x0000000000007fff,
  0x000000000000807c, 0x0000000000007ffe,
  0x000000000000807b, 0x0000000000007ffd,
  0x000000000000807a, 0x0000000000000080,
  0x00000000000000fd, 0x000000000000007f,
  0x00000000000000fc, 0x000000000000007e,
  0x00000000000000fb, 0x000000000000007d,
  0x00000000000000fa, 0x0000000000000020,
  0x000000000000009d, 0x0000000000000003,
  0x0000000000000080, 0x0000000000000002,
  0x000000000000007f, 0x0000000000000001,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xffffffffffffffe1,
  0xffffffffffffffe0, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffccccccce,
  0xffffffffcccccccd, 0xffffffffaaaaaaac,
  0xffffffffaaaaaaab, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000002,
  0xffffffff80000001, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000000,
  0x000000007fffffff, 0x0000000055555557,
  0x0000000055555556, 0x0000000033333335,
  0x0000000033333334, 0x0000000000008001,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000000081,
  0x0000000000000080, 0x0000000000000080,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x0000000000000021,
  0x0000000000000020, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffe2,
  0xffffffffffffffe1, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffcccccccf,
  0xffffffffccccccce, 0xffffffffaaaaaaad,
  0xffffffffaaaaaaac, 0xffffffff80000005,
  0xffffffff80000004, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000003,
  0xffffffff80000002, 0x0000000080000002,
  0x0000000080000001, 0x0000000080000001,
  0x0000000080000000, 0x0000000055555558,
  0x0000000055555557, 0x0000000033333336,
  0x0000000033333335, 0x0000000000008002,
  0x0000000000008001, 0x0000000000008001,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000000082,
  0x0000000000000081, 0x0000000000000081,
  0x0000000000000080, 0x0000000000000080,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000022,
  0x0000000000000021, 0x0000000000000005,
  0x0000000000000004, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000003,
  0x0000000000000003, 0x0000000000000040,
  0x0000000000000002, 0x000000000000003f,
  0x0000000000000001, 0x000000000000003e,
  0x0000000000000000, 0x0000000000000020,
  0xffffffffffffffe2, 0xffffffffffffffc3,
  0xffffffffffffff85, 0xffffffffffffffc2,
  0xffffffffffffff84, 0xffffffffffffffc1,
  0xffffffffffffff83, 0xffffffffffff8043,
  0xffffffffffff8005, 0xffffffffffff8042,
  0xffffffffffff8004, 0xffffffffffff8041,
  0xffffffffffff8003, 0xffffffffcccccd0d,
  0xffffffffcccccccf, 0xffffffffaaaaaaeb,
  0xffffffffaaaaaaad, 0xffffffff80000043,
  0xffffffff80000005, 0xffffffff80000042,
  0xffffffff80000004, 0xffffffff80000041,
  0xffffffff80000003, 0x0000000080000040,
  0x0000000080000002, 0x000000008000003f,
  0x0000000080000001, 0x0000000055555596,
  0x0000000055555558, 0x0000000033333374,
  0x0000000033333336, 0x0000000000008040,
  0x0000000000008002, 0x000000000000803f,
  0x0000000000008001, 0x000000000000803e,
  0x0000000000008000, 0x000000000000803d,
  0x0000000000007fff, 0x00000000000000c0,
  0x0000000000000082, 0x00000000000000bf,
  0x0000000000000081, 0x00000000000000be,
  0x0000000000000080, 0x00000000000000bd,
  0x000000000000007f, 0x0000000000000060,
  0x0000000000000022, 0x0000000000000043,
  0x0000000000000005, 0x0000000000000042,
  0x0000000000000004, 0x0000000000000041,
  0x0000000000000041, 0x000000000000007d,
  0x0000000000000040, 0x000000000000007c,
  0x000000000000003f, 0x000000000000007b,
  0x000000000000003e, 0x000000000000005d,
  0x0000000000000020, 0x0000000000000000,
  0xffffffffffffffc3, 0xffffffffffffffff,
  0xffffffffffffffc2, 0xfffffffffffffffe,
  0xffffffffffffffc1, 0xffffffffffff8080,
  0xffffffffffff8043, 0xffffffffffff807f,
  0xffffffffffff8042, 0xffffffffffff807e,
  0xffffffffffff8041, 0xffffffffcccccd4a,
  0xffffffffcccccd0d, 0xffffffffaaaaab28,
  0xffffffffaaaaaaeb, 0xffffffff80000080,
  0xffffffff80000043, 0xffffffff8000007f,
  0xffffffff80000042, 0xffffffff8000007e,
  0xffffffff80000041, 0x000000008000007d,
  0x0000000080000040, 0x000000008000007c,
  0x000000008000003f, 0x00000000555555d3,
  0x0000000055555596, 0x00000000333333b1,
  0x0000000033333374, 0x000000000000807d,
  0x0000000000008040, 0x000000000000807c,
  0x000000000000803f, 0x000000000000807b,
  0x000000000000803e, 0x000000000000807a,
  0x000000000000803d, 0x00000000000000fd,
  0x00000000000000c0, 0x00000000000000fc,
  0x00000000000000bf, 0x00000000000000fb,
  0x00000000000000be, 0x00000000000000fa,
  0x00000000000000bd, 0x000000000000009d,
  0x0000000000000060, 0x0000000000000080,
  0x0000000000000043, 0x000000000000007f,
  0x0000000000000042, 0x000000000000007e,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007b, 0x000000000000005e,
  0x000000000000005d, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffcccccd4b,
  0xffffffffcccccd4a, 0xffffffffaaaaab29,
  0xffffffffaaaaab28, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff8000007f,
  0xffffffff8000007e, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007d,
  0x000000008000007c, 0x00000000555555d4,
  0x00000000555555d3, 0x00000000333333b2,
  0x00000000333333b1, 0x000000000000807e,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807b,
  0x000000000000807a, 0x00000000000000fe,
  0x00000000000000fd, 0x00000000000000fd,
  0x00000000000000fc, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fb,
  0x00000000000000fa, 0x000000000000009e,
  0x000000000000009d, 0x0000000000000081,
  0x0000000000000080, 0x0000000000000080,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000007f, 0x000000000000007f,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000005f,
  0x000000000000005e, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffff8082,
  0xffffffffffff8081, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffcccccd4c,
  0xffffffffcccccd4b, 0xffffffffaaaaab2a,
  0xffffffffaaaaab29, 0xffffffff80000082,
  0xffffffff80000081, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000080,
  0xffffffff8000007f, 0x000000008000007f,
  0x000000008000007e, 0x000000008000007e,
  0x000000008000007d, 0x00000000555555d5,
  0x00000000555555d4, 0x00000000333333b3,
  0x00000000333333b2, 0x000000000000807f,
  0x000000000000807e, 0x000000000000807e,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807b, 0x00000000000000ff,
  0x00000000000000fe, 0x00000000000000fe,
  0x00000000000000fd, 0x00000000000000fd,
  0x00000000000000fc, 0x00000000000000fc,
  0x00000000000000fb, 0x000000000000009f,
  0x000000000000009e, 0x0000000000000082,
  0x0000000000000081, 0x0000000000000081,
  0x0000000000000080, 0x0000000000000080,
  0x0000000000000080, 0x0000000000007ffd,
  0x000000000000007f, 0x0000000000007ffc,
  0x000000000000007e, 0x0000000000007ffb,
  0x000000000000007d, 0x0000000000007fdd,
  0x000000000000005f, 0x0000000000007f80,
  0x0000000000000002, 0x0000000000007f7f,
  0x0000000000000001, 0x0000000000007f7e,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8082, 0xffffffffffffffff,
  0xffffffffffff8081, 0xfffffffffffffffe,
  0xffffffffffff8080, 0xffffffffcccd4cca,
  0xffffffffcccccd4c, 0xffffffffaaab2aa8,
  0xffffffffaaaaab2a, 0xffffffff80008000,
  0xffffffff80000082, 0xffffffff80007fff,
  0xffffffff80000081, 0xffffffff80007ffe,
  0xffffffff80000080, 0x0000000080007ffd,
  0x000000008000007f, 0x0000000080007ffc,
  0x000000008000007e, 0x000000005555d553,
  0x00000000555555d5, 0x000000003333b331,
  0x00000000333333b3, 0x000000000000fffd,
  0x000000000000807f, 0x000000000000fffc,
  0x000000000000807e, 0x000000000000fffb,
  0x000000000000807d, 0x000000000000fffa,
  0x000000000000807c, 0x000000000000807d,
  0x00000000000000ff, 0x000000000000807c,
  0x00000000000000fe, 0x000000000000807b,
  0x00000000000000fd, 0x000000000000807a,
  0x00000000000000fc, 0x000000000000801d,
  0x000000000000009f, 0x0000000000008000,
  0x0000000000000082, 0x0000000000007fff,
  0x0000000000000081, 0x0000000000007ffe,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007fde,
  0x0000000000007fdd, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xffffffffcccd4ccb,
  0xffffffffcccd4cca, 0xffffffffaaab2aa9,
  0xffffffffaaab2aa8, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80007fff,
  0xffffffff80007ffe, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007ffd,
  0x0000000080007ffc, 0x000000005555d554,
  0x000000005555d553, 0x000000003333b332,
  0x000000003333b331, 0x000000000000fffe,
  0x000000000000fffd, 0x000000000000fffd,
  0x000000000000fffc, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffb,
  0x000000000000fffa, 0x000000000000807e,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807b,
  0x000000000000807a, 0x000000000000801e,
  0x000000000000801d, 0x0000000000008001,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000007fff, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007fdf,
  0x0000000000007fde, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffcccd4ccc,
  0xffffffffcccd4ccb, 0xffffffffaaab2aaa,
  0xffffffffaaab2aa9, 0xffffffff80008002,
  0xffffffff80008001, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008000,
  0xffffffff80007fff, 0x0000000080007fff,
  0x0000000080007ffe, 0x0000000080007ffe,
  0x0000000080007ffd, 0x000000005555d555,
  0x000000005555d554, 0x000000003333b333,
  0x000000003333b332, 0x000000000000ffff,
  0x000000000000fffe, 0x000000000000fffe,
  0x000000000000fffd, 0x000000000000fffd,
  0x000000000000fffc, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000807f,
  0x000000000000807e, 0x000000000000807e,
  0x000000000000807d, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807c,
  0x000000000000807b, 0x000000000000801f,
  0x000000000000801e, 0x0000000000008002,
  0x0000000000008001, 0x0000000000008001,
  0x0000000000008000, 0x0000000000008000,
  0x0000000000008000, 0x000000007ffffffd,
  0x0000000000007fff, 0x000000007ffffffc,
  0x0000000000007ffe, 0x000000007ffffffb,
  0x0000000000007ffd, 0x000000007fffffdd,
  0x0000000000007fdf, 0x000000007fffff80,
  0x0000000000007f82, 0x000000007fffff7f,
  0x0000000000007f81, 0x000000007fffff7e,
  0x0000000000007f80, 0x000000007fff8000,
  0x0000000000000002, 0x000000007fff7fff,
  0x0000000000000001, 0x000000007fff7ffe,
  0x0000000000000000, 0x000000004cccccca,
  0xffffffffcccd4ccc, 0x000000002aaaaaa8,
  0xffffffffaaab2aaa, 0x0000000000000000,
  0xffffffff80008002, 0xffffffffffffffff,
  0xffffffff80008001, 0xfffffffffffffffe,
  0xffffffff80008000, 0x00000000fffffffd,
  0x0000000080007fff, 0x00000000fffffffc,
  0x0000000080007ffe, 0x00000000d5555553,
  0x000000005555d555, 0x00000000b3333331,
  0x000000003333b333, 0x0000000080007ffd,
  0x000000000000ffff, 0x0000000080007ffc,
  0x000000000000fffe, 0x0000000080007ffb,
  0x000000000000fffd, 0x0000000080007ffa,
  0x000000000000fffc, 0x000000008000007d,
  0x000000000000807f, 0x000000008000007c,
  0x000000000000807e, 0x000000008000007b,
  0x000000000000807d, 0x000000008000007a,
  0x000000000000807c, 0x000000008000001d,
  0x000000000000801f, 0x0000000080000000,
  0x0000000000008002, 0x000000007fffffff,
  0x0000000000008001, 0x000000007ffffffe,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007ffffffc,
  0x000000007ffffffb, 0x000000007fffffde,
  0x000000007fffffdd, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fffff7f,
  0x000000007fffff7e, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000007fff7fff,
  0x000000007fff7ffe, 0x000000004ccccccb,
  0x000000004cccccca, 0x000000002aaaaaa9,
  0x000000002aaaaaa8, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000d5555554,
  0x00000000d5555553, 0x00000000b3333332,
  0x00000000b3333331, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffb,
  0x0000000080007ffa, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007b,
  0x000000008000007a, 0x000000008000001e,
  0x000000008000001d, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000000,
  0x000000007fffffff, 0x000000007fffffff,
  0x000000007fffffff, 0x000000007fffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x000000007fffffdf,
  0x000000007fffffde, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000004ccccccc,
  0x000000004ccccccb, 0x000000002aaaaaaa,
  0x000000002aaaaaa9, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0x00000000ffffffff,
  0x00000000fffffffe, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000d5555555,
  0x00000000d5555554, 0x00000000b3333333,
  0x00000000b3333332, 0x0000000080007fff,
  0x0000000080007ffe, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffc,
  0x0000000080007ffb, 0x000000008000007f,
  0x000000008000007e, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007c,
  0x000000008000007b, 0x000000008000001f,
  0x000000008000001e, 0x0000000080000002,
  0x0000000080000001, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000000,
  0x0000000080000000, 0x3333333333333333,
  0x000000007fffffff, 0x3333333333333332,
  0x000000007ffffffe, 0x3333333333333331,
  0x000000007ffffffd, 0x3333333333333313,
  0x000000007fffffdf, 0x33333333333332b6,
  0x000000007fffff82, 0x33333333333332b5,
  0x000000007fffff81, 0x33333333333332b4,
  0x000000007fffff80, 0x333333333332b336,
  0x000000007fff8002, 0x333333333332b335,
  0x000000007fff8001, 0x333333333332b334,
  0x000000007fff8000, 0x3333333300000000,
  0x000000004ccccccc, 0x33333332ddddddde,
  0x000000002aaaaaaa, 0x33333332b3333336,
  0x0000000000000002, 0x33333332b3333335,
  0x0000000000000001, 0x33333332b3333334,
  0x0000000000000000, 0x33333333b3333333,
  0x00000000ffffffff, 0x33333333b3333332,
  0x00000000fffffffe, 0x3333333388888889,
  0x00000000d5555555, 0x3333333366666667,
  0x00000000b3333333, 0x333333333333b333,
  0x0000000080007fff, 0x333333333333b332,
  0x0000000080007ffe, 0x333333333333b331,
  0x0000000080007ffd, 0x333333333333b330,
  0x0000000080007ffc, 0x33333333333333b3,
  0x000000008000007f, 0x33333333333333b2,
  0x000000008000007e, 0x33333333333333b1,
  0x000000008000007d, 0x33333333333333b0,
  0x000000008000007c, 0x3333333333333353,
  0x000000008000001f, 0x3333333333333336,
  0x0000000080000002, 0x3333333333333335,
  0x0000000080000001, 0x3333333333333334,
  0x3333333333333334, 0x5555555555555555,
  0x3333333333333333, 0x5555555555555554,
  0x3333333333333332, 0x5555555555555553,
  0x3333333333333331, 0x5555555555555535,
  0x3333333333333313, 0x55555555555554d8,
  0x33333333333332b6, 0x55555555555554d7,
  0x33333333333332b5, 0x55555555555554d6,
  0x33333333333332b4, 0x555555555554d558,
  0x333333333332b336, 0x555555555554d557,
  0x333333333332b335, 0x555555555554d556,
  0x333333333332b334, 0x5555555522222222,
  0x3333333300000000, 0x5555555500000000,
  0x33333332ddddddde, 0x55555554d5555558,
  0x33333332b3333336, 0x55555554d5555557,
  0x33333332b3333335, 0x55555554d5555556,
  0x33333332b3333334, 0x55555555d5555555,
  0x33333333b3333333, 0x55555555d5555554,
  0x33333333b3333332, 0x55555555aaaaaaab,
  0x3333333388888889, 0x5555555588888889,
  0x3333333366666667, 0x555555555555d555,
  0x333333333333b333, 0x555555555555d554,
  0x333333333333b332, 0x555555555555d553,
  0x333333333333b331, 0x555555555555d552,
  0x333333333333b330, 0x55555555555555d5,
  0x33333333333333b3, 0x55555555555555d4,
  0x33333333333333b2, 0x55555555555555d3,
  0x33333333333333b1, 0x55555555555555d2,
  0x33333333333333b0, 0x5555555555555575,
  0x3333333333333353, 0x5555555555555558,
  0x3333333333333336, 0x5555555555555557,
  0x3333333333333335, 0x5555555555555556,
  0x5555555555555556, 0x7ffffffffffffffd,
  0x5555555555555555, 0x7ffffffffffffffc,
  0x5555555555555554, 0x7ffffffffffffffb,
  0x5555555555555553, 0x7fffffffffffffdd,
  0x5555555555555535, 0x7fffffffffffff80,
  0x55555555555554d8, 0x7fffffffffffff7f,
  0x55555555555554d7, 0x7fffffffffffff7e,
  0x55555555555554d6, 0x7fffffffffff8000,
  0x555555555554d558, 0x7fffffffffff7fff,
  0x555555555554d557, 0x7fffffffffff7ffe,
  0x555555555554d556, 0x7fffffffccccccca,
  0x5555555522222222, 0x7fffffffaaaaaaa8,
  0x5555555500000000, 0x7fffffff80000000,
  0x55555554d5555558, 0x7fffffff7fffffff,
  0x55555554d5555557, 0x7fffffff7ffffffe,
  0x55555554d5555556, 0x800000007ffffffd,
  0x55555555d5555555, 0x800000007ffffffc,
  0x55555555d5555554, 0x8000000055555553,
  0x55555555aaaaaaab, 0x8000000033333331,
  0x5555555588888889, 0x8000000000007ffd,
  0x555555555555d555, 0x8000000000007ffc,
  0x555555555555d554, 0x8000000000007ffb,
  0x555555555555d553, 0x8000000000007ffa,
  0x555555555555d552, 0x800000000000007d,
  0x55555555555555d5, 0x800000000000007c,
  0x55555555555555d4, 0x800000000000007b,
  0x55555555555555d3, 0x800000000000007a,
  0x55555555555555d2, 0x800000000000001d,
  0x5555555555555575, 0x8000000000000000,
  0x5555555555555558, 0x7fffffffffffffff,
  0x5555555555555557, 0x7ffffffffffffffe,
  0x7ffffffffffffffe, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7ffffffffffffffd,
  0x7ffffffffffffffc, 0x7ffffffffffffffc,
  0x7ffffffffffffffb, 0x7fffffffffffffde,
  0x7fffffffffffffdd, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffffff7f,
  0x7fffffffffffff7e, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffffff7fff,
  0x7fffffffffff7ffe, 0x7fffffffcccccccb,
  0x7fffffffccccccca, 0x7fffffffaaaaaaa9,
  0x7fffffffaaaaaaa8, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x7fffffff7fffffff,
  0x7fffffff7ffffffe, 0x800000007ffffffe,
  0x800000007ffffffd, 0x800000007ffffffd,
  0x800000007ffffffc, 0x8000000055555554,
  0x8000000055555553, 0x8000000033333332,
  0x8000000033333331, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000000007ffd,
  0x8000000000007ffc, 0x8000000000007ffc,
  0x8000000000007ffb, 0x8000000000007ffb,
  0x8000000000007ffa, 0x800000000000007e,
  0x800000000000007d, 0x800000000000007d,
  0x800000000000007c, 0x800000000000007c,
  0x800000000000007b, 0x800000000000007b,
  0x800000000000007a, 0x800000000000001e,
  0x800000000000001d, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7ffffffffffffffd,
  0x7ffffffffffffffc, 0x7fffffffffffffdf,
  0x7fffffffffffffde, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffffff80,
  0x7fffffffffffff7f, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffffff8000,
  0x7fffffffffff7fff, 0x7fffffffcccccccc,
  0x7fffffffcccccccb, 0x7fffffffaaaaaaaa,
  0x7fffffffaaaaaaa9, 0x7fffffff80000002,
  0x7fffffff80000001, 0x7fffffff80000001,
  0x7fffffff80000000, 0x7fffffff80000000,
  0x7fffffff7fffffff, 0x800000007fffffff,
  0x800000007ffffffe, 0x800000007ffffffe,
  0x800000007ffffffd, 0x8000000055555555,
  0x8000000055555554, 0x8000000033333333,
  0x8000000033333332, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000000007ffd,
  0x8000000000007ffc, 0x8000000000007ffc,
  0x8000000000007ffb, 0x800000000000007f,
  0x800000000000007e, 0x800000000000007e,
  0x800000000000007d, 0x800000000000007d,
  0x800000000000007c, 0x800000000000007c,
  0x800000000000007b, 0x800000000000001f,
  0x800000000000001e, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000000,
  0x8000000000000000, 0x8000000000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x7ffffffffffffffe,
  0x7ffffffffffffffd, 0x7fffffffffffffe0,
  0x7fffffffffffffdf, 0x7fffffffffffff83,
  0x7fffffffffffff82, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffffff81,
  0x7fffffffffffff80, 0x7fffffffffff8003,
  0x7fffffffffff8002, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffffff8001,
  0x7fffffffffff8000, 0x7fffffffcccccccd,
  0x7fffffffcccccccc, 0x7fffffffaaaaaaab,
  0x7fffffffaaaaaaaa, 0x7fffffff80000003,
  0x7fffffff80000002, 0x7fffffff80000002,
  0x7fffffff80000001, 0x7fffffff80000001,
  0x7fffffff80000000, 0x8000000080000000,
  0x800000007fffffff, 0x800000007fffffff,
  0x800000007ffffffe, 0x8000000055555556,
  0x8000000055555555, 0x8000000033333334,
  0x8000000033333333, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000000007ffd,
  0x8000000000007ffc, 0x8000000000000080,
  0x800000000000007f, 0x800000000000007f,
  0x800000000000007e, 0x800000000000007e,
  0x800000000000007d, 0x800000000000007d,
  0x800000000000007c, 0x8000000000000020,
  0x800000000000001f, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000001,
  0x8000000000000001, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000000,
  0x7fffffffffffffff, 0x7fffffffffffffff,
  0x7ffffffffffffffe, 0x7fffffffffffffe1,
  0x7fffffffffffffe0, 0x7fffffffffffff84,
  0x7fffffffffffff83, 0x7fffffffffffff83,
  0x7fffffffffffff82, 0x7fffffffffffff82,
  0x7fffffffffffff81, 0x7fffffffffff8004,
  0x7fffffffffff8003, 0x7fffffffffff8003,
  0x7fffffffffff8002, 0x7fffffffffff8002,
  0x7fffffffffff8001, 0x7fffffffccccccce,
  0x7fffffffcccccccd, 0x7fffffffaaaaaaac,
  0x7fffffffaaaaaaab, 0x7fffffff80000004,
  0x7fffffff80000003, 0x7fffffff80000003,
  0x7fffffff80000002, 0x7fffffff80000002,
  0x7fffffff80000001, 0x8000000080000001,
  0x8000000080000000, 0x8000000080000000,
  0x800000007fffffff, 0x8000000055555557,
  0x8000000055555556, 0x8000000033333335,
  0x8000000033333334, 0x8000000000008001,
  0x8000000000008000, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000007ffe,
  0x8000000000007ffd, 0x8000000000000081,
  0x8000000000000080, 0x8000000000000080,
  0x800000000000007f, 0x800000000000007f,
  0x800000000000007e, 0x800000000000007e,
  0x800000000000007d, 0x8000000000000021,
  0x8000000000000020, 0x8000000000000004,
  0x8000000000000003, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000002,
  0x8000000000000002, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000001,
  0x8000000000000000, 0x8000000000000000,
  0x7fffffffffffffff, 0x7fffffffffffffe2,
  0x7fffffffffffffe1, 0x7fffffffffffff85,
  0x7fffffffffffff84, 0x7fffffffffffff84,
  0x7fffffffffffff83, 0x7fffffffffffff83,
  0x7fffffffffffff82, 0x7fffffffffff8005,
  0x7fffffffffff8004, 0x7fffffffffff8004,
  0x7fffffffffff8003, 0x7fffffffffff8003,
  0x7fffffffffff8002, 0x7fffffffcccccccf,
  0x7fffffffccccccce, 0x7fffffffaaaaaaad,
  0x7fffffffaaaaaaac, 0x7fffffff80000005,
  0x7fffffff80000004, 0x7fffffff80000004,
  0x7fffffff80000003, 0x7fffffff80000003,
  0x7fffffff80000002, 0x8000000080000002,
  0x8000000080000001, 0x8000000080000001,
  0x8000000080000000, 0x8000000055555558,
  0x8000000055555557, 0x8000000033333336,
  0x8000000033333335, 0x8000000000008002,
  0x8000000000008001, 0x8000000000008001,
  0x8000000000008000, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000007fff,
  0x8000000000007ffe, 0x8000000000000082,
  0x8000000000000081, 0x8000000000000081,
  0x8000000000000080, 0x8000000000000080,
  0x800000000000007f, 0x800000000000007f,
  0x800000000000007e, 0x8000000000000022,
  0x8000000000000021, 0x8000000000000005,
  0x8000000000000004, 0x8000000000000004,
  0x8000000000000003, 0x8000000000000003,
  0x8000000000000003, 0x8000000000000003,
  0x8000000000000002, 0x8000000000000002,
  0x8000000000000001, 0x8000000000000001,
  0x8000000000000000, 0x7fffffffffffffe3,
  0x7fffffffffffffe2, 0x7fffffffffffff86,
  0x7fffffffffffff85, 0x7fffffffffffff85,
  0x7fffffffffffff84, 0x7fffffffffffff84,
  0x7fffffffffffff83, 0x7fffffffffff8006,
  0x7fffffffffff8005, 0x7fffffffffff8005,
  0x7fffffffffff8004, 0x7fffffffffff8004,
  0x7fffffffffff8003, 0x7fffffffccccccd0,
  0x7fffffffcccccccf, 0x7fffffffaaaaaaae,
  0x7fffffffaaaaaaad, 0x7fffffff80000006,
  0x7fffffff80000005, 0x7fffffff80000005,
  0x7fffffff80000004, 0x7fffffff80000004,
  0x7fffffff80000003, 0x8000000080000003,
  0x8000000080000002, 0x8000000080000002,
  0x8000000080000001, 0x8000000055555559,
  0x8000000055555558, 0x8000000033333337,
  0x8000000033333336, 0x8000000000008003,
  0x8000000000008002, 0x8000000000008002,
  0x8000000000008001, 0x8000000000008001,
  0x8000000000008000, 0x8000000000008000,
  0x8000000000007fff, 0x8000000000000083,
  0x8000000000000082, 0x8000000000000082,
  0x8000000000000081, 0x8000000000000081,
  0x8000000000000080, 0x8000000000000080,
  0x800000000000007f, 0x8000000000000023,
  0x8000000000000022, 0x8000000000000006,
  0x8000000000000005, 0x8000000000000005,
  0x8000000000000004, 0x8000000000000004,
  0x8000000000000004, 0xaaaaaaaaaaaaaaaa,
  0x8000000000000003, 0xaaaaaaaaaaaaaaa9,
  0x8000000000000002, 0xaaaaaaaaaaaaaaa8,
  0x8000000000000001, 0xaaaaaaaaaaaaaa8a,
  0x7fffffffffffffe3, 0xaaaaaaaaaaaaaa2d,
  0x7fffffffffffff86, 0xaaaaaaaaaaaaaa2c,
  0x7fffffffffffff85, 0xaaaaaaaaaaaaaa2b,
  0x7fffffffffffff84, 0xaaaaaaaaaaaa2aad,
  0x7fffffffffff8006, 0xaaaaaaaaaaaa2aac,
  0x7fffffffffff8005, 0xaaaaaaaaaaaa2aab,
  0x7fffffffffff8004, 0xaaaaaaaa77777777,
  0x7fffffffccccccd0, 0xaaaaaaaa55555555,
  0x7fffffffaaaaaaae, 0xaaaaaaaa2aaaaaad,
  0x7fffffff80000006, 0xaaaaaaaa2aaaaaac,
  0x7fffffff80000005, 0xaaaaaaaa2aaaaaab,
  0x7fffffff80000004, 0xaaaaaaab2aaaaaaa,
  0x8000000080000003, 0xaaaaaaab2aaaaaa9,
  0x8000000080000002, 0xaaaaaaab00000000,
  0x8000000055555559, 0xaaaaaaaaddddddde,
  0x8000000033333337, 0xaaaaaaaaaaab2aaa,
  0x8000000000008003, 0xaaaaaaaaaaab2aa9,
  0x8000000000008002, 0xaaaaaaaaaaab2aa8,
  0x8000000000008001, 0xaaaaaaaaaaab2aa7,
  0x8000000000008000, 0xaaaaaaaaaaaaab2a,
  0x8000000000000083, 0xaaaaaaaaaaaaab29,
  0x8000000000000082, 0xaaaaaaaaaaaaab28,
  0x8000000000000081, 0xaaaaaaaaaaaaab27,
  0x8000000000000080, 0xaaaaaaaaaaaaaaca,
  0x8000000000000023, 0xaaaaaaaaaaaaaaad,
  0x8000000000000006, 0xaaaaaaaaaaaaaaac,
  0x8000000000000005, 0xaaaaaaaaaaaaaaab,
  0xaaaaaaaaaaaaaaab, 0xcccccccccccccccc,
  0xaaaaaaaaaaaaaaaa, 0xcccccccccccccccb,
  0xaaaaaaaaaaaaaaa9, 0xccccccccccccccca,
  0xaaaaaaaaaaaaaaa8, 0xccccccccccccccac,
  0xaaaaaaaaaaaaaa8a, 0xcccccccccccccc4f,
  0xaaaaaaaaaaaaaa2d, 0xcccccccccccccc4e,
  0xaaaaaaaaaaaaaa2c, 0xcccccccccccccc4d,
  0xaaaaaaaaaaaaaa2b, 0xcccccccccccc4ccf,
  0xaaaaaaaaaaaa2aad, 0xcccccccccccc4cce,
  0xaaaaaaaaaaaa2aac, 0xcccccccccccc4ccd,
  0xaaaaaaaaaaaa2aab, 0xcccccccc99999999,
  0xaaaaaaaa77777777, 0xcccccccc77777777,
  0xaaaaaaaa55555555, 0xcccccccc4ccccccf,
  0xaaaaaaaa2aaaaaad, 0xcccccccc4cccccce,
  0xaaaaaaaa2aaaaaac, 0xcccccccc4ccccccd,
  0xaaaaaaaa2aaaaaab, 0xcccccccd4ccccccc,
  0xaaaaaaab2aaaaaaa, 0xcccccccd4ccccccb,
  0xaaaaaaab2aaaaaa9, 0xcccccccd22222222,
  0xaaaaaaab00000000, 0xcccccccd00000000,
  0xaaaaaaaaddddddde, 0xcccccccccccd4ccc,
  0xaaaaaaaaaaab2aaa, 0xcccccccccccd4ccb,
  0xaaaaaaaaaaab2aa9, 0xcccccccccccd4cca,
  0xaaaaaaaaaaab2aa8, 0xcccccccccccd4cc9,
  0xaaaaaaaaaaab2aa7, 0xcccccccccccccd4c,
  0xaaaaaaaaaaaaab2a, 0xcccccccccccccd4b,
  0xaaaaaaaaaaaaab29, 0xcccccccccccccd4a,
  0xaaaaaaaaaaaaab28, 0xcccccccccccccd49,
  0xaaaaaaaaaaaaab27, 0xccccccccccccccec,
  0xaaaaaaaaaaaaaaca, 0xcccccccccccccccf,
  0xaaaaaaaaaaaaaaad, 0xccccccccccccccce,
  0xaaaaaaaaaaaaaaac, 0xcccccccccccccccd,
  0xcccccccccccccccd, 0xffffffff80000000,
  0xcccccccccccccccc, 0xffffffff7fffffff,
  0xcccccccccccccccb, 0xffffffff7ffffffe,
  0xccccccccccccccca, 0xffffffff7fffffe0,
  0xccccccccccccccac, 0xffffffff7fffff83,
  0xcccccccccccccc4f, 0xffffffff7fffff82,
  0xcccccccccccccc4e, 0xffffffff7fffff81,
  0xcccccccccccccc4d, 0xffffffff7fff8003,
  0xcccccccccccc4ccf, 0xffffffff7fff8002,
  0xcccccccccccc4cce, 0xffffffff7fff8001,
  0xcccccccccccc4ccd, 0xffffffff4ccccccd,
  0xcccccccc99999999, 0xffffffff2aaaaaab,
  0xcccccccc77777777, 0xffffffff00000003,
  0xcccccccc4ccccccf, 0xffffffff00000002,
  0xcccccccc4cccccce, 0xffffffff00000001,
  0xcccccccc4ccccccd, 0x0000000000000000,
  0xcccccccd4ccccccc, 0xffffffffffffffff,
  0xcccccccd4ccccccb, 0xffffffffd5555556,
  0xcccccccd22222222, 0xffffffffb3333334,
  0xcccccccd00000000, 0xffffffff80008000,
  0xcccccccccccd4ccc, 0xffffffff80007fff,
  0xcccccccccccd4ccb, 0xffffffff80007ffe,
  0xcccccccccccd4cca, 0xffffffff80007ffd,
  0xcccccccccccd4cc9, 0xffffffff80000080,
  0xcccccccccccccd4c, 0xffffffff8000007f,
  0xcccccccccccccd4b, 0xffffffff8000007e,
  0xcccccccccccccd4a, 0xffffffff8000007d,
  0xcccccccccccccd49, 0xffffffff80000020,
  0xccccccccccccccec, 0xffffffff80000003,
  0xcccccccccccccccf, 0xffffffff80000002,
  0xccccccccccccccce, 0xffffffff80000001,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0xffffffff7fffffe1,
  0xffffffff7fffffe0, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0xffffffff4cccccce,
  0xffffffff4ccccccd, 0xffffffff2aaaaaac,
  0xffffffff2aaaaaab, 0xffffffff00000004,
  0xffffffff00000003, 0xffffffff00000003,
  0xffffffff00000002, 0xffffffff00000002,
  0xffffffff00000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffd5555557,
  0xffffffffd5555556, 0xffffffffb3333335,
  0xffffffffb3333334, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80007ffe,
  0xffffffff80007ffd, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff8000007e,
  0xffffffff8000007d, 0xffffffff80000021,
  0xffffffff80000020, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000002,
  0xffffffff80000002, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff7fffffe2,
  0xffffffff7fffffe1, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff4ccccccf,
  0xffffffff4cccccce, 0xffffffff2aaaaaad,
  0xffffffff2aaaaaac, 0xffffffff00000005,
  0xffffffff00000004, 0xffffffff00000004,
  0xffffffff00000003, 0xffffffff00000003,
  0xffffffff00000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0xffffffffd5555558,
  0xffffffffd5555557, 0xffffffffb3333336,
  0xffffffffb3333335, 0xffffffff80008002,
  0xffffffff80008001, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80007fff,
  0xffffffff80007ffe, 0xffffffff80000082,
  0xffffffff80000081, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff8000007f,
  0xffffffff8000007e, 0xffffffff80000022,
  0xffffffff80000021, 0xffffffff80000005,
  0xffffffff80000004, 0xffffffff80000004,
  0xffffffff80000003, 0xffffffff80000003,
  0xffffffff80000003, 0xffffffff80000003,
  0xffffffff80000002, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff7fffffe3,
  0xffffffff7fffffe2, 0xffffffff7fffff86,
  0xffffffff7fffff85, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fff8006,
  0xffffffff7fff8005, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff4cccccd0,
  0xffffffff4ccccccf, 0xffffffff2aaaaaae,
  0xffffffff2aaaaaad, 0xffffffff00000006,
  0xffffffff00000005, 0xffffffff00000005,
  0xffffffff00000004, 0xffffffff00000004,
  0xffffffff00000003, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0xffffffffd5555559,
  0xffffffffd5555558, 0xffffffffb3333337,
  0xffffffffb3333336, 0xffffffff80008003,
  0xffffffff80008002, 0xffffffff80008002,
  0xffffffff80008001, 0xffffffff80008001,
  0xffffffff80008000, 0xffffffff80008000,
  0xffffffff80007fff, 0xffffffff80000083,
  0xffffffff80000082, 0xffffffff80000082,
  0xffffffff80000081, 0xffffffff80000081,
  0xffffffff80000080, 0xffffffff80000080,
  0xffffffff8000007f, 0xffffffff80000023,
  0xffffffff80000022, 0xffffffff80000006,
  0xffffffff80000005, 0xffffffff80000005,
  0xffffffff80000004, 0xffffffff80000004,
  0xffffffff80000004, 0xffffffffffff8000,
  0xffffffff80000003, 0xffffffffffff7fff,
  0xffffffff80000002, 0xffffffffffff7ffe,
  0xffffffff80000001, 0xffffffffffff7fe0,
  0xffffffff7fffffe3, 0xffffffffffff7f83,
  0xffffffff7fffff86, 0xffffffffffff7f82,
  0xffffffff7fffff85, 0xffffffffffff7f81,
  0xffffffff7fffff84, 0xffffffffffff0003,
  0xffffffff7fff8006, 0xffffffffffff0002,
  0xffffffff7fff8005, 0xffffffffffff0001,
  0xffffffff7fff8004, 0xffffffffcccc4ccd,
  0xffffffff4cccccd0, 0xffffffffaaaa2aab,
  0xffffffff2aaaaaae, 0xffffffff7fff8003,
  0xffffffff00000006, 0xffffffff7fff8002,
  0xffffffff00000005, 0xffffffff7fff8001,
  0xffffffff00000004, 0x000000007fff8000,
  0x0000000000000003, 0x000000007fff7fff,
  0x0000000000000002, 0x000000005554d556,
  0xffffffffd5555559, 0x000000003332b334,
  0xffffffffb3333337, 0x0000000000000000,
  0xffffffff80008003, 0xffffffffffffffff,
  0xffffffff80008002, 0xfffffffffffffffe,
  0xffffffff80008001, 0xfffffffffffffffd,
  0xffffffff80008000, 0xffffffffffff8080,
  0xffffffff80000083, 0xffffffffffff807f,
  0xffffffff80000082, 0xffffffffffff807e,
  0xffffffff80000081, 0xffffffffffff807d,
  0xffffffff80000080, 0xffffffffffff8020,
  0xffffffff80000023, 0xffffffffffff8003,
  0xffffffff80000006, 0xffffffffffff8002,
  0xffffffff80000005, 0xffffffffffff8001,
  0xffffffffffff8001, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffffff7fe1,
  0xffffffffffff7fe0, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffffff0002,
  0xffffffffffff0001, 0xffffffffcccc4cce,
  0xffffffffcccc4ccd, 0xffffffffaaaa2aac,
  0xffffffffaaaa2aab, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0xffffffff7fff8002,
  0xffffffff7fff8001, 0x000000007fff8001,
  0x000000007fff8000, 0x000000007fff8000,
  0x000000007fff7fff, 0x000000005554d557,
  0x000000005554d556, 0x000000003332b335,
  0x000000003332b334, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff807e,
  0xffffffffffff807d, 0xffffffffffff8021,
  0xffffffffffff8020, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff7fe2,
  0xffffffffffff7fe1, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff0005,
  0xffffffffffff0004, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffffff0003,
  0xffffffffffff0002, 0xffffffffcccc4ccf,
  0xffffffffcccc4cce, 0xffffffffaaaa2aad,
  0xffffffffaaaa2aac, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0xffffffff7fff8003,
  0xffffffff7fff8002, 0x000000007fff8002,
  0x000000007fff8001, 0x000000007fff8001,
  0x000000007fff8000, 0x000000005554d558,
  0x000000005554d557, 0x000000003332b336,
  0x000000003332b335, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xffffffffffff8082,
  0xffffffffffff8081, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff807f,
  0xffffffffffff807e, 0xffffffffffff8022,
  0xffffffffffff8021, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffff8004,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xffffffffffff8003, 0xffffffffffff8003,
  0xffffffffffff8002, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff7fe3,
  0xffffffffffff7fe2, 0xffffffffffff7f86,
  0xffffffffffff7f85, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff0006,
  0xffffffffffff0005, 0xffffffffffff0005,
  0xffffffffffff0004, 0xffffffffffff0004,
  0xffffffffffff0003, 0xffffffffcccc4cd0,
  0xffffffffcccc4ccf, 0xffffffffaaaa2aae,
  0xffffffffaaaa2aad, 0xffffffff7fff8006,
  0xffffffff7fff8005, 0xffffffff7fff8005,
  0xffffffff7fff8004, 0xffffffff7fff8004,
  0xffffffff7fff8003, 0x000000007fff8003,
  0x000000007fff8002, 0x000000007fff8002,
  0x000000007fff8001, 0x000000005554d559,
  0x000000005554d558, 0x000000003332b337,
  0x000000003332b336, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffff8083,
  0xffffffffffff8082, 0xffffffffffff8082,
  0xffffffffffff8081, 0xffffffffffff8081,
  0xffffffffffff8080, 0xffffffffffff8080,
  0xffffffffffff807f, 0xffffffffffff8023,
  0xffffffffffff8022, 0xffffffffffff8006,
  0xffffffffffff8005, 0xffffffffffff8005,
  0xffffffffffff8004, 0xffffffffffff8004,
  0xffffffffffff8004, 0xffffffffffffff80,
  0xffffffffffff8003, 0xffffffffffffff7f,
  0xffffffffffff8002, 0xffffffffffffff7e,
  0xffffffffffff8001, 0xffffffffffffff60,
  0xffffffffffff7fe3, 0xffffffffffffff03,
  0xffffffffffff7f86, 0xffffffffffffff02,
  0xffffffffffff7f85, 0xffffffffffffff01,
  0xffffffffffff7f84, 0xffffffffffff7f83,
  0xffffffffffff0006, 0xffffffffffff7f82,
  0xffffffffffff0005, 0xffffffffffff7f81,
  0xffffffffffff0004, 0xffffffffcccccc4d,
  0xffffffffcccc4cd0, 0xffffffffaaaaaa2b,
  0xffffffffaaaa2aae, 0xffffffff7fffff83,
  0xffffffff7fff8006, 0xffffffff7fffff82,
  0xffffffff7fff8005, 0xffffffff7fffff81,
  0xffffffff7fff8004, 0x000000007fffff80,
  0x000000007fff8003, 0x000000007fffff7f,
  0x000000007fff8002, 0x00000000555554d6,
  0x000000005554d559, 0x00000000333332b4,
  0x000000003332b337, 0x0000000000007f80,
  0x0000000000000003, 0x0000000000007f7f,
  0x0000000000000002, 0x0000000000007f7e,
  0x0000000000000001, 0x0000000000007f7d,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffff8083, 0xffffffffffffffff,
  0xffffffffffff8082, 0xfffffffffffffffe,
  0xffffffffffff8081, 0xfffffffffffffffd,
  0xffffffffffff8080, 0xffffffffffffffa0,
  0xffffffffffff8023, 0xffffffffffffff83,
  0xffffffffffff8006, 0xffffffffffffff82,
  0xffffffffffff8005, 0xffffffffffffff81,
  0xffffffffffffff81, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffffff61,
  0xffffffffffffff60, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffffff02,
  0xffffffffffffff01, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffffff7f82,
  0xffffffffffff7f81, 0xffffffffcccccc4e,
  0xffffffffcccccc4d, 0xffffffffaaaaaa2c,
  0xffffffffaaaaaa2b, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0xffffffff7fffff82,
  0xffffffff7fffff81, 0x000000007fffff81,
  0x000000007fffff80, 0x000000007fffff80,
  0x000000007fffff7f, 0x00000000555554d7,
  0x00000000555554d6, 0x00000000333332b5,
  0x00000000333332b4, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000007f7e,
  0x0000000000007f7d, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xffffffffffffffa1,
  0xffffffffffffffa0, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff62,
  0xffffffffffffff61, 0xffffffffffffff05,
  0xffffffffffffff04, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffffff03,
  0xffffffffffffff02, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffffff7f83,
  0xffffffffffff7f82, 0xffffffffcccccc4f,
  0xffffffffcccccc4e, 0xffffffffaaaaaa2d,
  0xffffffffaaaaaa2c, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0xffffffff7fffff83,
  0xffffffff7fffff82, 0x000000007fffff82,
  0x000000007fffff81, 0x000000007fffff81,
  0x000000007fffff80, 0x00000000555554d8,
  0x00000000555554d7, 0x00000000333332b6,
  0x00000000333332b5, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000007f7f,
  0x0000000000007f7e, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xffffffffffffffa2,
  0xffffffffffffffa1, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffff84,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xffffffffffffff83, 0xffffffffffffff83,
  0xffffffffffffff82, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff63,
  0xffffffffffffff62, 0xffffffffffffff06,
  0xffffffffffffff05, 0xffffffffffffff05,
  0xffffffffffffff04, 0xffffffffffffff04,
  0xffffffffffffff03, 0xffffffffffff7f86,
  0xffffffffffff7f85, 0xffffffffffff7f85,
  0xffffffffffff7f84, 0xffffffffffff7f84,
  0xffffffffffff7f83, 0xffffffffcccccc50,
  0xffffffffcccccc4f, 0xffffffffaaaaaa2e,
  0xffffffffaaaaaa2d, 0xffffffff7fffff86,
  0xffffffff7fffff85, 0xffffffff7fffff85,
  0xffffffff7fffff84, 0xffffffff7fffff84,
  0xffffffff7fffff83, 0x000000007fffff83,
  0x000000007fffff82, 0x000000007fffff82,
  0x000000007fffff81, 0x00000000555554d9,
  0x00000000555554d8, 0x00000000333332b7,
  0x00000000333332b6, 0x0000000000007f83,
  0x0000000000007f82, 0x0000000000007f82,
  0x0000000000007f81, 0x0000000000007f81,
  0x0000000000007f80, 0x0000000000007f80,
  0x0000000000007f7f, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffa3,
  0xffffffffffffffa2, 0xffffffffffffff86,
  0xffffffffffffff85, 0xffffffffffffff85,
  0xffffffffffffff84, 0xffffffffffffff84,
  0xffffffffffffff84, 0xffffffffffffffc0,
  0xffffffffffffff83, 0xffffffffffffffbf,
  0xffffffffffffff82, 0xffffffffffffffbe,
  0xffffffffffffff81, 0xffffffffffffffa0,
  0xffffffffffffff63, 0xffffffffffffff43,
  0xffffffffffffff06, 0xffffffffffffff42,
  0xffffffffffffff05, 0xffffffffffffff41,
  0xffffffffffffff04, 0xffffffffffff7fc3,
  0xffffffffffff7f86, 0xffffffffffff7fc2,
  0xffffffffffff7f85, 0xffffffffffff7fc1,
  0xffffffffffff7f84, 0xffffffffcccccc8d,
  0xffffffffcccccc50, 0xffffffffaaaaaa6b,
  0xffffffffaaaaaa2e, 0xffffffff7fffffc3,
  0xffffffff7fffff86, 0xffffffff7fffffc2,
  0xffffffff7fffff85, 0xffffffff7fffffc1,
  0xffffffff7fffff84, 0x000000007fffffc0,
  0x000000007fffff83, 0x000000007fffffbf,
  0x000000007fffff82, 0x0000000055555516,
  0x00000000555554d9, 0x00000000333332f4,
  0x00000000333332b7, 0x0000000000007fc0,
  0x0000000000007f83, 0x0000000000007fbf,
  0x0000000000007f82, 0x0000000000007fbe,
  0x0000000000007f81, 0x0000000000007fbd,
  0x0000000000007f80, 0x0000000000000040,
  0x0000000000000003, 0x000000000000003f,
  0x0000000000000002, 0x000000000000003e,
  0x0000000000000001, 0x000000000000003d,
  0x0000000000000000, 0xffffffffffffffe0,
  0xffffffffffffffa3, 0xffffffffffffffc3,
  0xffffffffffffff86, 0xffffffffffffffc2,
  0xffffffffffffff85, 0xffffffffffffffc1,
  0xffffffffffffffc1, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffc,
  0xffffffffffffffbf, 0xfffffffffffffffb,
  0xffffffffffffffbe, 0xffffffffffffffdd,
  0xffffffffffffffa0, 0xffffffffffffff80,
  0xffffffffffffff43, 0xffffffffffffff7f,
  0xffffffffffffff42, 0xffffffffffffff7e,
  0xffffffffffffff41, 0xffffffffffff8000,
  0xffffffffffff7fc3, 0xffffffffffff7fff,
  0xffffffffffff7fc2, 0xffffffffffff7ffe,
  0xffffffffffff7fc1, 0xffffffffccccccca,
  0xffffffffcccccc8d, 0xffffffffaaaaaaa8,
  0xffffffffaaaaaa6b, 0xffffffff80000000,
  0xffffffff7fffffc3, 0xffffffff7fffffff,
  0xffffffff7fffffc2, 0xffffffff7ffffffe,
  0xffffffff7fffffc1, 0x000000007ffffffd,
  0x000000007fffffc0, 0x000000007ffffffc,
  0x000000007fffffbf, 0x0000000055555553,
  0x0000000055555516, 0x0000000033333331,
  0x00000000333332f4, 0x0000000000007ffd,
  0x0000000000007fc0, 0x0000000000007ffc,
  0x0000000000007fbf, 0x0000000000007ffb,
  0x0000000000007fbe, 0x0000000000007ffa,
  0x0000000000007fbd, 0x000000000000007d,
  0x0000000000000040, 0x000000000000007c,
  0x000000000000003f, 0x000000000000007b,
  0x000000000000003e, 0x000000000000007a,
  0x000000000000003d, 0x000000000000001d,
  0xffffffffffffffe0, 0x0000000000000000,
  0xffffffffffffffc3, 0xffffffffffffffff,
  0xffffffffffffffc2, 0xfffffffffffffffe,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xfffffffffffffffc,
  0xfffffffffffffffb, 0xffffffffffffffde,
  0xffffffffffffffdd, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffffff7f,
  0xffffffffffffff7e, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffffff7fff,
  0xffffffffffff7ffe, 0xffffffffcccccccb,
  0xffffffffccccccca, 0xffffffffaaaaaaa9,
  0xffffffffaaaaaaa8, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0xffffffff7fffffff,
  0xffffffff7ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007ffffffd,
  0x000000007ffffffc, 0x0000000055555554,
  0x0000000055555553, 0x0000000033333332,
  0x0000000033333331, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffb, 0x0000000000007ffb,
  0x0000000000007ffa, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007b, 0x000000000000007b,
  0x000000000000007a, 0x000000000000001e,
  0x000000000000001d, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xffffffffffffffff, 0xffffffffffffffff,
  0xfffffffffffffffe, 0xfffffffffffffffe,
  0xfffffffffffffffd, 0xfffffffffffffffd,
  0xfffffffffffffffc, 0xffffffffffffffdf,
  0xffffffffffffffde, 0xffffffffffffff82,
  0xffffffffffffff81, 0xffffffffffffff81,
  0xffffffffffffff80, 0xffffffffffffff80,
  0xffffffffffffff7f, 0xffffffffffff8002,
  0xffffffffffff8001, 0xffffffffffff8001,
  0xffffffffffff8000, 0xffffffffffff8000,
  0xffffffffffff7fff, 0xffffffffcccccccc,
  0xffffffffcccccccb, 0xffffffffaaaaaaaa,
  0xffffffffaaaaaaa9, 0xffffffff80000002,
  0xffffffff80000001, 0xffffffff80000001,
  0xffffffff80000000, 0xffffffff80000000,
  0xffffffff7fffffff, 0x000000007fffffff,
  0x000000007ffffffe, 0x000000007ffffffe,
  0x000000007ffffffd, 0x0000000055555555,
  0x0000000055555554, 0x0000000033333333,
  0x0000000033333332, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007ffd,
  0x0000000000007ffc, 0x0000000000007ffc,
  0x0000000000007ffb, 0x000000000000007f,
  0x000000000000007e, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007d,
  0x000000000000007c, 0x000000000000007c,
  0x000000000000007b, 0x000000000000001f,
  0x000000000000001e, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000000,
};
const unsigned kExpectedCount_NEON_ssubw2_2D = 1240;

#endif  // VIXL_SIM_SSUBW2_2D_TRACE_AARCH64_H_
