// Copyright 2017, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-negative-aarch32.cc.in template file
// using tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include <map>

#include "test-runner.h"

#include "test-utils.h"

#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) \
  M(adc)                       \
  M(adcs)                      \
  M(add)                       \
  M(adds)                      \
  M(and_)                      \
  M(ands)                      \
  M(bic)                       \
  M(bics)                      \
  M(eor)                       \
  M(eors)                      \
  M(orr)                       \
  M(orrs)                      \
  M(rsb)                       \
  M(rsbs)                      \
  M(rsc)                       \
  M(rscs)                      \
  M(sbc)                       \
  M(sbcs)                      \
  M(sub)                       \
  M(subs)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anomymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_A32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  Register rm;
  ShiftType shift;
  Register rs;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

#ifdef VIXL_NEGATIVE_TESTING
// Each element of this array produce one instruction encoding.
const TestData kTests[] = {{{cs, r13, r3, r15, LSR, r1},
                            "cs, r13, r3, r15, LSR, r1",
                            "cs_r13_r3_r15_LSR_r1"},
                           {{cc, r14, r0, r15, LSR, r7},
                            "cc, r14, r0, r15, LSR, r7",
                            "cc_r14_r0_r15_LSR_r7"},
                           {{gt, r15, r8, r15, LSL, r10},
                            "gt, r15, r8, r15, LSL, r10",
                            "gt_r15_r8_r15_LSL_r10"},
                           {{vc, r10, r14, r15, LSL, r1},
                            "vc, r10, r14, r15, LSL, r1",
                            "vc_r10_r14_r15_LSL_r1"},
                           {{ne, r15, r1, r12, LSR, r6},
                            "ne, r15, r1, r12, LSR, r6",
                            "ne_r15_r1_r12_LSR_r6"},
                           {{eq, r9, r15, r1, ROR, r1},
                            "eq, r9, r15, r1, ROR, r1",
                            "eq_r9_r15_r1_ROR_r1"},
                           {{cc, r15, r1, r15, LSR, r4},
                            "cc, r15, r1, r15, LSR, r4",
                            "cc_r15_r1_r15_LSR_r4"},
                           {{ge, r15, r5, r13, ROR, r5},
                            "ge, r15, r5, r13, ROR, r5",
                            "ge_r15_r5_r13_ROR_r5"},
                           {{vs, r15, r6, r11, LSR, r12},
                            "vs, r15, r6, r11, LSR, r12",
                            "vs_r15_r6_r11_LSR_r12"},
                           {{cs, r15, r14, r15, LSL, r3},
                            "cs, r15, r14, r15, LSL, r3",
                            "cs_r15_r14_r15_LSL_r3"},
                           {{vc, r15, r9, r7, LSL, r4},
                            "vc, r15, r9, r7, LSL, r4",
                            "vc_r15_r9_r7_LSL_r4"},
                           {{vc, r15, r7, r4, ASR, r9},
                            "vc, r15, r7, r4, ASR, r9",
                            "vc_r15_r7_r4_ASR_r9"},
                           {{gt, r15, r4, r13, LSR, r9},
                            "gt, r15, r4, r13, LSR, r9",
                            "gt_r15_r4_r13_LSR_r9"},
                           {{mi, r15, r3, r8, ROR, r6},
                            "mi, r15, r3, r8, ROR, r6",
                            "mi_r15_r3_r8_ROR_r6"},
                           {{pl, r15, r8, r9, LSR, r15},
                            "pl, r15, r8, r9, LSR, r15",
                            "pl_r15_r8_r9_LSR_r15"},
                           {{lt, r2, r11, r15, LSL, r0},
                            "lt, r2, r11, r15, LSL, r0",
                            "lt_r2_r11_r15_LSL_r0"},
                           {{pl, r1, r4, r0, LSL, r15},
                            "pl, r1, r4, r0, LSL, r15",
                            "pl_r1_r4_r0_LSL_r15"},
                           {{ge, r6, r5, r15, LSR, r8},
                            "ge, r6, r5, r15, LSR, r8",
                            "ge_r6_r5_r15_LSR_r8"},
                           {{vc, r0, r8, r5, ROR, r15},
                            "vc, r0, r8, r5, ROR, r15",
                            "vc_r0_r8_r5_ROR_r15"},
                           {{cc, r15, r7, r13, ASR, r1},
                            "cc, r15, r7, r13, ASR, r1",
                            "cc_r15_r7_r13_ASR_r1"},
                           {{gt, r4, r4, r5, LSL, r15},
                            "gt, r4, r4, r5, LSL, r15",
                            "gt_r4_r4_r5_LSL_r15"},
                           {{le, r15, r15, r3, ROR, r2},
                            "le, r15, r15, r3, ROR, r2",
                            "le_r15_r15_r3_ROR_r2"},
                           {{pl, r15, r9, r14, ROR, r13},
                            "pl, r15, r9, r14, ROR, r13",
                            "pl_r15_r9_r14_ROR_r13"},
                           {{vs, r15, r14, r13, LSL, r13},
                            "vs, r15, r14, r13, LSL, r13",
                            "vs_r15_r14_r13_LSL_r13"},
                           {{mi, r15, r15, r1, LSL, r12},
                            "mi, r15, r15, r1, LSL, r12",
                            "mi_r15_r15_r1_LSL_r12"},
                           {{pl, r11, r15, r8, LSL, r4},
                            "pl, r11, r15, r8, LSL, r4",
                            "pl_r11_r15_r8_LSL_r4"},
                           {{pl, r10, r15, r15, LSL, r14},
                            "pl, r10, r15, r15, LSL, r14",
                            "pl_r10_r15_r15_LSL_r14"},
                           {{pl, r8, r15, r13, LSL, r0},
                            "pl, r8, r15, r13, LSL, r0",
                            "pl_r8_r15_r13_LSL_r0"},
                           {{cc, r4, r0, r15, LSR, r13},
                            "cc, r4, r0, r15, LSR, r13",
                            "cc_r4_r0_r15_LSR_r13"},
                           {{hi, r15, r4, r4, ROR, r0},
                            "hi, r15, r4, r4, ROR, r0",
                            "hi_r15_r4_r4_ROR_r0"},
                           {{ge, r8, r14, r8, ROR, r15},
                            "ge, r8, r14, r8, ROR, r15",
                            "ge_r8_r14_r8_ROR_r15"},
                           {{cs, r11, r6, r15, ROR, r13},
                            "cs, r11, r6, r15, ROR, r13",
                            "cs_r11_r6_r15_ROR_r13"},
                           {{le, r0, r7, r15, ASR, r11},
                            "le, r0, r7, r15, ASR, r11",
                            "le_r0_r7_r15_ASR_r11"},
                           {{ge, r14, r15, r8, ASR, r7},
                            "ge, r14, r15, r8, ASR, r7",
                            "ge_r14_r15_r8_ASR_r7"},
                           {{hi, r11, r15, r13, LSL, r13},
                            "hi, r11, r15, r13, LSL, r13",
                            "hi_r11_r15_r13_LSL_r13"},
                           {{eq, r15, r0, r11, LSR, r4},
                            "eq, r15, r0, r11, LSR, r4",
                            "eq_r15_r0_r11_LSR_r4"},
                           {{ne, r3, r8, r15, ASR, r11},
                            "ne, r3, r8, r15, ASR, r11",
                            "ne_r3_r8_r15_ASR_r11"},
                           {{gt, r1, r12, r9, ASR, r15},
                            "gt, r1, r12, r9, ASR, r15",
                            "gt_r1_r12_r9_ASR_r15"},
                           {{le, r1, r15, r1, ASR, r13},
                            "le, r1, r15, r1, ASR, r13",
                            "le_r1_r15_r1_ASR_r13"},
                           {{al, r1, r9, r5, LSR, r15},
                            "al, r1, r9, r5, LSR, r15",
                            "al_r1_r9_r5_LSR_r15"},
                           {{vs, r15, r2, r15, ROR, r6},
                            "vs, r15, r2, r15, ROR, r6",
                            "vs_r15_r2_r15_ROR_r6"},
                           {{ne, r3, r2, r12, LSR, r15},
                            "ne, r3, r2, r12, LSR, r15",
                            "ne_r3_r2_r12_LSR_r15"},
                           {{gt, r14, r6, r15, ROR, r3},
                            "gt, r14, r6, r15, ROR, r3",
                            "gt_r14_r6_r15_ROR_r3"},
                           {{le, r8, r4, r15, LSR, r5},
                            "le, r8, r4, r15, LSR, r5",
                            "le_r8_r4_r15_LSR_r5"},
                           {{hi, r15, r10, r14, LSR, r12},
                            "hi, r15, r10, r14, LSR, r12",
                            "hi_r15_r10_r14_LSR_r12"},
                           {{ls, r15, r10, r13, LSR, r13},
                            "ls, r15, r10, r13, LSR, r13",
                            "ls_r15_r10_r13_LSR_r13"},
                           {{ne, r9, r15, r11, LSL, r4},
                            "ne, r9, r15, r11, LSL, r4",
                            "ne_r9_r15_r11_LSL_r4"},
                           {{lt, r10, r10, r8, LSL, r15},
                            "lt, r10, r10, r8, LSL, r15",
                            "lt_r10_r10_r8_LSL_r15"},
                           {{hi, r14, r13, r0, LSL, r15},
                            "hi, r14, r13, r0, LSL, r15",
                            "hi_r14_r13_r0_LSL_r15"},
                           {{gt, r15, r7, r9, ASR, r13},
                            "gt, r15, r7, r9, ASR, r13",
                            "gt_r15_r7_r9_ASR_r13"},
                           {{ge, r2, r12, r3, LSR, r15},
                            "ge, r2, r12, r3, LSR, r15",
                            "ge_r2_r12_r3_LSR_r15"},
                           {{pl, r11, r13, r3, LSR, r15},
                            "pl, r11, r13, r3, LSR, r15",
                            "pl_r11_r13_r3_LSR_r15"},
                           {{al, r13, r15, r10, LSR, r5},
                            "al, r13, r15, r10, LSR, r5",
                            "al_r13_r15_r10_LSR_r5"},
                           {{ls, r4, r15, r10, LSL, r10},
                            "ls, r4, r15, r10, LSL, r10",
                            "ls_r4_r15_r10_LSL_r10"},
                           {{ge, r15, r14, r15, LSL, r13},
                            "ge, r15, r14, r15, LSL, r13",
                            "ge_r15_r14_r15_LSL_r13"},
                           {{cs, r2, r1, r15, ASR, r1},
                            "cs, r2, r1, r15, ASR, r1",
                            "cs_r2_r1_r15_ASR_r1"},
                           {{pl, r1, r0, r11, LSR, r15},
                            "pl, r1, r0, r11, LSR, r15",
                            "pl_r1_r0_r11_LSR_r15"},
                           {{eq, r12, r3, r7, LSL, r15},
                            "eq, r12, r3, r7, LSL, r15",
                            "eq_r12_r3_r7_LSL_r15"},
                           {{hi, r15, r3, r11, ASR, r1},
                            "hi, r15, r3, r11, ASR, r1",
                            "hi_r15_r3_r11_ASR_r1"},
                           {{lt, r9, r7, r15, ROR, r15},
                            "lt, r9, r7, r15, ROR, r15",
                            "lt_r9_r7_r15_ROR_r15"},
                           {{lt, r15, r15, r7, LSL, r15},
                            "lt, r15, r15, r7, LSL, r15",
                            "lt_r15_r15_r7_LSL_r15"},
                           {{vc, r7, r15, r2, ROR, r15},
                            "vc, r7, r15, r2, ROR, r15",
                            "vc_r7_r15_r2_ROR_r15"},
                           {{vc, r15, r9, r13, ROR, r5},
                            "vc, r15, r9, r13, ROR, r5",
                            "vc_r15_r9_r13_ROR_r5"},
                           {{ge, r15, r1, r13, ASR, r10},
                            "ge, r15, r1, r13, ASR, r10",
                            "ge_r15_r1_r13_ASR_r10"},
                           {{lt, r15, r12, r8, ASR, r14},
                            "lt, r15, r12, r8, ASR, r14",
                            "lt_r15_r12_r8_ASR_r14"},
                           {{cc, r15, r1, r15, ASR, r14},
                            "cc, r15, r1, r15, ASR, r14",
                            "cc_r15_r1_r15_ASR_r14"},
                           {{vs, r15, r6, r1, LSL, r3},
                            "vs, r15, r6, r1, LSL, r3",
                            "vs_r15_r6_r1_LSL_r3"},
                           {{mi, r3, r3, r15, LSL, r5},
                            "mi, r3, r3, r15, LSL, r5",
                            "mi_r3_r3_r15_LSL_r5"},
                           {{lt, r10, r15, r13, LSR, r14},
                            "lt, r10, r15, r13, LSR, r14",
                            "lt_r10_r15_r13_LSR_r14"},
                           {{vc, r11, r15, r11, ROR, r4},
                            "vc, r11, r15, r11, ROR, r4",
                            "vc_r11_r15_r11_ROR_r4"},
                           {{vs, r15, r9, r7, ROR, r14},
                            "vs, r15, r9, r7, ROR, r14",
                            "vs_r15_r9_r7_ROR_r14"},
                           {{gt, r4, r0, r2, LSR, r15},
                            "gt, r4, r0, r2, LSR, r15",
                            "gt_r4_r0_r2_LSR_r15"},
                           {{hi, r3, r14, r12, ROR, r15},
                            "hi, r3, r14, r12, ROR, r15",
                            "hi_r3_r14_r12_ROR_r15"},
                           {{ge, r12, r15, r13, ASR, r14},
                            "ge, r12, r15, r13, ASR, r14",
                            "ge_r12_r15_r13_ASR_r14"},
                           {{vc, r13, r10, r15, ASR, r4},
                            "vc, r13, r10, r15, ASR, r4",
                            "vc_r13_r10_r15_ASR_r4"},
                           {{ls, r11, r6, r15, LSR, r5},
                            "ls, r11, r6, r15, LSR, r5",
                            "ls_r11_r6_r15_LSR_r5"},
                           {{cc, r15, r9, r7, ASR, r6},
                            "cc, r15, r9, r7, ASR, r6",
                            "cc_r15_r9_r7_ASR_r6"},
                           {{cs, r13, r12, r15, ROR, r15},
                            "cs, r13, r12, r15, ROR, r15",
                            "cs_r13_r12_r15_ROR_r15"},
                           {{gt, r15, r13, r3, ASR, r4},
                            "gt, r15, r13, r3, ASR, r4",
                            "gt_r15_r13_r3_ASR_r4"},
                           {{le, r15, r10, r5, ASR, r8},
                            "le, r15, r10, r5, ASR, r8",
                            "le_r15_r10_r5_ASR_r8"},
                           {{le, r14, r2, r15, LSR, r11},
                            "le, r14, r2, r15, LSR, r11",
                            "le_r14_r2_r15_LSR_r11"},
                           {{le, r12, r12, r15, LSL, r0},
                            "le, r12, r12, r15, LSL, r0",
                            "le_r12_r12_r15_LSL_r0"},
                           {{pl, r15, r14, r7, LSR, r14},
                            "pl, r15, r14, r7, LSR, r14",
                            "pl_r15_r14_r7_LSR_r14"},
                           {{cc, r4, r15, r0, LSL, r0},
                            "cc, r4, r15, r0, LSL, r0",
                            "cc_r4_r15_r0_LSL_r0"},
                           {{vs, r0, r12, r15, LSR, r0},
                            "vs, r0, r12, r15, LSR, r0",
                            "vs_r0_r12_r15_LSR_r0"},
                           {{lt, r4, r15, r0, ASR, r8},
                            "lt, r4, r15, r0, ASR, r8",
                            "lt_r4_r15_r0_ASR_r8"},
                           {{cs, r14, r15, r5, ASR, r15},
                            "cs, r14, r15, r5, ASR, r15",
                            "cs_r14_r15_r5_ASR_r15"},
                           {{eq, r6, r6, r5, LSL, r15},
                            "eq, r6, r6, r5, LSL, r15",
                            "eq_r6_r6_r5_LSL_r15"},
                           {{vc, r9, r15, r12, ASR, r15},
                            "vc, r9, r15, r12, ASR, r15",
                            "vc_r9_r15_r12_ASR_r15"},
                           {{lt, r14, r10, r15, ROR, r4},
                            "lt, r14, r10, r15, ROR, r4",
                            "lt_r14_r10_r15_ROR_r4"},
                           {{vc, r10, r3, r1, LSR, r15},
                            "vc, r10, r3, r1, LSR, r15",
                            "vc_r10_r3_r1_LSR_r15"},
                           {{ne, r8, r15, r7, ROR, r11},
                            "ne, r8, r15, r7, ROR, r11",
                            "ne_r8_r15_r7_ROR_r11"},
                           {{lt, r15, r14, r7, ASR, r8},
                            "lt, r15, r14, r7, ASR, r8",
                            "lt_r15_r14_r7_ASR_r8"},
                           {{pl, r8, r15, r1, LSR, r8},
                            "pl, r8, r15, r1, LSR, r8",
                            "pl_r8_r15_r1_LSR_r8"},
                           {{pl, r5, r0, r8, ROR, r15},
                            "pl, r5, r0, r8, ROR, r15",
                            "pl_r5_r0_r8_ROR_r15"},
                           {{lt, r1, r15, r1, ASR, r8},
                            "lt, r1, r15, r1, ASR, r8",
                            "lt_r1_r15_r1_ASR_r8"},
                           {{ge, r6, r5, r15, ROR, r5},
                            "ge, r6, r5, r15, ROR, r5",
                            "ge_r6_r5_r15_ROR_r5"},
                           {{eq, r15, r6, r1, ASR, r4},
                            "eq, r15, r6, r1, ASR, r4",
                            "eq_r15_r6_r1_ASR_r4"},
                           {{le, r6, r15, r4, ASR, r9},
                            "le, r6, r15, r4, ASR, r9",
                            "le_r6_r15_r4_ASR_r9"},
                           {{al, r6, r10, r15, LSR, r0},
                            "al, r6, r10, r15, LSR, r0",
                            "al_r6_r10_r15_LSR_r0"},
                           {{ge, r6, r4, r10, LSL, r15},
                            "ge, r6, r4, r10, LSL, r15",
                            "ge_r6_r4_r10_LSL_r15"},
                           {{gt, r15, r10, r11, ASR, r7},
                            "gt, r15, r10, r11, ASR, r7",
                            "gt_r15_r10_r11_ASR_r7"},
                           {{gt, r7, r15, r8, LSR, r3},
                            "gt, r7, r15, r8, LSR, r3",
                            "gt_r7_r15_r8_LSR_r3"},
                           {{eq, r1, r15, r13, LSR, r8},
                            "eq, r1, r15, r13, LSR, r8",
                            "eq_r1_r15_r13_LSR_r8"},
                           {{cs, r15, r9, r5, LSL, r9},
                            "cs, r15, r9, r5, LSL, r9",
                            "cs_r15_r9_r5_LSL_r9"},
                           {{le, r13, r4, r15, ASR, r0},
                            "le, r13, r4, r15, ASR, r0",
                            "le_r13_r4_r15_ASR_r0"},
                           {{mi, r15, r7, r10, LSL, r6},
                            "mi, r15, r7, r10, LSL, r6",
                            "mi_r15_r7_r10_LSL_r6"},
                           {{mi, r10, r15, r13, LSR, r9},
                            "mi, r10, r15, r13, LSR, r9",
                            "mi_r10_r15_r13_LSR_r9"},
                           {{ge, r9, r11, r15, ROR, r1},
                            "ge, r9, r11, r15, ROR, r1",
                            "ge_r9_r11_r15_ROR_r1"},
                           {{cc, r13, r15, r12, ASR, r6},
                            "cc, r13, r15, r12, ASR, r6",
                            "cc_r13_r15_r12_ASR_r6"},
                           {{le, r4, r2, r7, LSL, r15},
                            "le, r4, r2, r7, LSL, r15",
                            "le_r4_r2_r7_LSL_r15"},
                           {{pl, r0, r15, r5, LSR, r13},
                            "pl, r0, r15, r5, LSR, r13",
                            "pl_r0_r15_r5_LSR_r13"},
                           {{vs, r15, r1, r3, LSR, r10},
                            "vs, r15, r1, r3, LSR, r10",
                            "vs_r15_r1_r3_LSR_r10"},
                           {{ne, r5, r0, r2, LSL, r15},
                            "ne, r5, r0, r2, LSL, r15",
                            "ne_r5_r0_r2_LSL_r15"},
                           {{vc, r15, r14, r8, ASR, r12},
                            "vc, r15, r14, r8, ASR, r12",
                            "vc_r15_r14_r8_ASR_r12"},
                           {{gt, r15, r12, r1, ASR, r0},
                            "gt, r15, r12, r1, ASR, r0",
                            "gt_r15_r12_r1_ASR_r0"},
                           {{ge, r4, r15, r10, ROR, r13},
                            "ge, r4, r15, r10, ROR, r13",
                            "ge_r4_r15_r10_ROR_r13"},
                           {{eq, r11, r2, r10, LSR, r15},
                            "eq, r11, r2, r10, LSR, r15",
                            "eq_r11_r2_r10_LSR_r15"},
                           {{ne, r14, r10, r15, LSL, r9},
                            "ne, r14, r10, r15, LSL, r9",
                            "ne_r14_r10_r15_LSL_r9"},
                           {{ls, r15, r3, r6, ROR, r4},
                            "ls, r15, r3, r6, ROR, r4",
                            "ls_r15_r3_r6_ROR_r4"},
                           {{vc, r15, r3, r12, ASR, r11},
                            "vc, r15, r3, r12, ASR, r11",
                            "vc_r15_r3_r12_ASR_r11"},
                           {{hi, r10, r15, r11, ASR, r8},
                            "hi, r10, r15, r11, ASR, r8",
                            "hi_r10_r15_r11_ASR_r8"},
                           {{eq, r7, r10, r15, LSL, r10},
                            "eq, r7, r10, r15, LSL, r10",
                            "eq_r7_r10_r15_LSL_r10"},
                           {{vc, r10, r15, r3, ASR, r7},
                            "vc, r10, r15, r3, ASR, r7",
                            "vc_r10_r15_r3_ASR_r7"},
                           {{ls, r4, r15, r9, ROR, r3},
                            "ls, r4, r15, r9, ROR, r3",
                            "ls_r4_r15_r9_ROR_r3"},
                           {{al, r1, r1, r10, ASR, r15},
                            "al, r1, r1, r10, ASR, r15",
                            "al_r1_r1_r10_ASR_r15"},
                           {{lt, r15, r15, r4, ASR, r10},
                            "lt, r15, r15, r4, ASR, r10",
                            "lt_r15_r15_r4_ASR_r10"},
                           {{ne, r15, r13, r4, ROR, r7},
                            "ne, r15, r13, r4, ROR, r7",
                            "ne_r15_r13_r4_ROR_r7"},
                           {{le, r9, r5, r15, LSR, r6},
                            "le, r9, r5, r15, LSR, r6",
                            "le_r9_r5_r15_LSR_r6"},
                           {{gt, r9, r15, r7, ROR, r13},
                            "gt, r9, r15, r7, ROR, r13",
                            "gt_r9_r15_r7_ROR_r13"},
                           {{pl, r3, r15, r6, LSL, r6},
                            "pl, r3, r15, r6, LSL, r6",
                            "pl_r3_r15_r6_LSL_r6"},
                           {{ls, r15, r6, r13, LSL, r10},
                            "ls, r15, r6, r13, LSL, r10",
                            "ls_r15_r6_r13_LSL_r10"},
                           {{pl, r11, r15, r3, ASR, r9},
                            "pl, r11, r15, r3, ASR, r9",
                            "pl_r11_r15_r3_ASR_r9"},
                           {{eq, r8, r0, r10, ASR, r15},
                            "eq, r8, r0, r10, ASR, r15",
                            "eq_r8_r0_r10_ASR_r15"},
                           {{ne, r4, r5, r1, ASR, r15},
                            "ne, r4, r5, r1, ASR, r15",
                            "ne_r4_r5_r1_ASR_r15"},
                           {{eq, r13, r15, r11, LSR, r3},
                            "eq, r13, r15, r11, LSR, r3",
                            "eq_r13_r15_r11_LSR_r3"},
                           {{ge, r4, r1, r15, ASR, r10},
                            "ge, r4, r1, r15, ASR, r10",
                            "ge_r4_r1_r15_ASR_r10"},
                           {{cs, r0, r15, r11, LSL, r10},
                            "cs, r0, r15, r11, LSL, r10",
                            "cs_r0_r15_r11_LSL_r10"},
                           {{cs, r10, r4, r15, ROR, r3},
                            "cs, r10, r4, r15, ROR, r3",
                            "cs_r10_r4_r15_ROR_r3"},
                           {{ge, r15, r11, r0, LSL, r7},
                            "ge, r15, r11, r0, LSL, r7",
                            "ge_r15_r11_r0_LSL_r7"},
                           {{ne, r8, r15, r2, ASR, r14},
                            "ne, r8, r15, r2, ASR, r14",
                            "ne_r8_r15_r2_ASR_r14"},
                           {{le, r12, r8, r12, LSR, r15},
                            "le, r12, r8, r12, LSR, r15",
                            "le_r12_r8_r12_LSR_r15"},
                           {{ge, r8, r15, r0, ASR, r4},
                            "ge, r8, r15, r0, ASR, r4",
                            "ge_r8_r15_r0_ASR_r4"},
                           {{vs, r9, r10, r4, LSL, r15},
                            "vs, r9, r10, r4, LSL, r15",
                            "vs_r9_r10_r4_LSL_r15"},
                           {{ne, r6, r4, r15, LSL, r6},
                            "ne, r6, r4, r15, LSL, r6",
                            "ne_r6_r4_r15_LSL_r6"},
                           {{cc, r10, r14, r15, ROR, r10},
                            "cc, r10, r14, r15, ROR, r10",
                            "cc_r10_r14_r15_ROR_r10"},
                           {{vc, r9, r13, r15, ROR, r8},
                            "vc, r9, r13, r15, ROR, r8",
                            "vc_r9_r13_r15_ROR_r8"},
                           {{eq, r11, r12, r15, ASR, r10},
                            "eq, r11, r12, r15, ASR, r10",
                            "eq_r11_r12_r15_ASR_r10"},
                           {{cs, r15, r14, r10, ROR, r12},
                            "cs, r15, r14, r10, ROR, r12",
                            "cs_r15_r14_r10_ROR_r12"},
                           {{cc, r15, r2, r12, ASR, r5},
                            "cc, r15, r2, r12, ASR, r5",
                            "cc_r15_r2_r12_ASR_r5"},
                           {{ls, r4, r13, r15, ROR, r12},
                            "ls, r4, r13, r15, ROR, r12",
                            "ls_r4_r13_r15_ROR_r12"},
                           {{gt, r14, r2, r15, LSL, r7},
                            "gt, r14, r2, r15, LSL, r7",
                            "gt_r14_r2_r15_LSL_r7"},
                           {{ls, r0, r7, r0, ASR, r15},
                            "ls, r0, r7, r0, ASR, r15",
                            "ls_r0_r7_r0_ASR_r15"},
                           {{al, r4, r6, r15, ASR, r5},
                            "al, r4, r6, r15, ASR, r5",
                            "al_r4_r6_r15_ASR_r5"},
                           {{cc, r13, r14, r15, LSR, r9},
                            "cc, r13, r14, r15, LSR, r9",
                            "cc_r13_r14_r15_LSR_r9"},
                           {{vs, r2, r4, r12, ASR, r15},
                            "vs, r2, r4, r12, ASR, r15",
                            "vs_r2_r4_r12_ASR_r15"},
                           {{vc, r2, r14, r15, LSL, r1},
                            "vc, r2, r14, r15, LSL, r1",
                            "vc_r2_r14_r15_LSL_r1"},
                           {{hi, r15, r2, r9, ROR, r14},
                            "hi, r15, r2, r9, ROR, r14",
                            "hi_r15_r2_r9_ROR_r14"},
                           {{ls, r10, r15, r14, ASR, r12},
                            "ls, r10, r15, r14, ASR, r12",
                            "ls_r10_r15_r14_ASR_r12"},
                           {{le, r3, r9, r15, ROR, r10},
                            "le, r3, r9, r15, ROR, r10",
                            "le_r3_r9_r15_ROR_r10"},
                           {{cs, r2, r2, r15, LSR, r2},
                            "cs, r2, r2, r15, LSR, r2",
                            "cs_r2_r2_r15_LSR_r2"},
                           {{eq, r14, r6, r15, ROR, r12},
                            "eq, r14, r6, r15, ROR, r12",
                            "eq_r14_r6_r15_ROR_r12"},
                           {{pl, r8, r0, r15, ASR, r11},
                            "pl, r8, r0, r15, ASR, r11",
                            "pl_r8_r0_r15_ASR_r11"},
                           {{cc, r15, r7, r13, ROR, r7},
                            "cc, r15, r7, r13, ROR, r7",
                            "cc_r15_r7_r13_ROR_r7"},
                           {{cs, r10, r11, r12, LSR, r15},
                            "cs, r10, r11, r12, LSR, r15",
                            "cs_r10_r11_r12_LSR_r15"},
                           {{hi, r4, r15, r8, ASR, r7},
                            "hi, r4, r15, r8, ASR, r7",
                            "hi_r4_r15_r8_ASR_r7"},
                           {{hi, r15, r6, r6, LSR, r0},
                            "hi, r15, r6, r6, LSR, r0",
                            "hi_r15_r6_r6_LSR_r0"},
                           {{gt, r8, r5, r8, ROR, r15},
                            "gt, r8, r5, r8, ROR, r15",
                            "gt_r8_r5_r8_ROR_r15"},
                           {{gt, r9, r15, r7, ASR, r8},
                            "gt, r9, r15, r7, ASR, r8",
                            "gt_r9_r15_r7_ASR_r8"},
                           {{eq, r8, r9, r15, LSL, r7},
                            "eq, r8, r9, r15, LSL, r7",
                            "eq_r8_r9_r15_LSL_r7"},
                           {{ne, r4, r15, r6, ASR, r15},
                            "ne, r4, r15, r6, ASR, r15",
                            "ne_r4_r15_r6_ASR_r15"},
                           {{lt, r15, r0, r1, ASR, r9},
                            "lt, r15, r0, r1, ASR, r9",
                            "lt_r15_r0_r1_ASR_r9"},
                           {{ne, r1, r6, r15, LSL, r2},
                            "ne, r1, r6, r15, LSL, r2",
                            "ne_r1_r6_r15_LSL_r2"},
                           {{cs, r1, r1, r15, LSR, r11},
                            "cs, r1, r1, r15, LSR, r11",
                            "cs_r1_r1_r15_LSR_r11"},
                           {{lt, r15, r1, r1, ASR, r0},
                            "lt, r15, r1, r1, ASR, r0",
                            "lt_r15_r1_r1_ASR_r0"},
                           {{le, r3, r15, r11, LSR, r5},
                            "le, r3, r15, r11, LSR, r5",
                            "le_r3_r15_r11_LSR_r5"},
                           {{le, r14, r2, r4, ASR, r15},
                            "le, r14, r2, r4, ASR, r15",
                            "le_r14_r2_r4_ASR_r15"},
                           {{ne, r8, r15, r4, LSR, r9},
                            "ne, r8, r15, r4, LSR, r9",
                            "ne_r8_r15_r4_LSR_r9"},
                           {{mi, r4, r0, r9, LSR, r15},
                            "mi, r4, r0, r9, LSR, r15",
                            "mi_r4_r0_r9_LSR_r15"},
                           {{ls, r15, r14, r4, ASR, r8},
                            "ls, r15, r14, r4, ASR, r8",
                            "ls_r15_r14_r4_ASR_r8"},
                           {{lt, r6, r0, r7, ASR, r15},
                            "lt, r6, r0, r7, ASR, r15",
                            "lt_r6_r0_r7_ASR_r15"},
                           {{mi, r15, r6, r11, LSR, r1},
                            "mi, r15, r6, r11, LSR, r1",
                            "mi_r15_r6_r11_LSR_r1"},
                           {{al, r15, r1, r6, LSL, r6},
                            "al, r15, r1, r6, LSL, r6",
                            "al_r15_r1_r6_LSL_r6"},
                           {{ls, r0, r5, r15, LSL, r4},
                            "ls, r0, r5, r15, LSL, r4",
                            "ls_r0_r5_r15_LSL_r4"},
                           {{vs, r8, r15, r13, LSL, r11},
                            "vs, r8, r15, r13, LSL, r11",
                            "vs_r8_r15_r13_LSL_r11"},
                           {{lt, r4, r3, r15, LSR, r8},
                            "lt, r4, r3, r15, LSR, r8",
                            "lt_r4_r3_r15_LSR_r8"},
                           {{ne, r0, r15, r2, LSL, r14},
                            "ne, r0, r15, r2, LSL, r14",
                            "ne_r0_r15_r2_LSL_r14"},
                           {{hi, r4, r10, r15, LSL, r15},
                            "hi, r4, r10, r15, LSL, r15",
                            "hi_r4_r10_r15_LSL_r15"},
                           {{mi, r15, r0, r4, ASR, r8},
                            "mi, r15, r0, r4, ASR, r8",
                            "mi_r15_r0_r4_ASR_r8"},
                           {{gt, r0, r12, r15, LSR, r2},
                            "gt, r0, r12, r15, LSR, r2",
                            "gt_r0_r12_r15_LSR_r2"},
                           {{mi, r15, r11, r9, ROR, r14},
                            "mi, r15, r11, r9, ROR, r14",
                            "mi_r15_r11_r9_ROR_r14"},
                           {{gt, r15, r5, r9, ASR, r10},
                            "gt, r15, r5, r9, ASR, r10",
                            "gt_r15_r5_r9_ASR_r10"},
                           {{le, r14, r6, r15, ROR, r1},
                            "le, r14, r6, r15, ROR, r1",
                            "le_r14_r6_r15_ROR_r1"},
                           {{cs, r15, r13, r15, ROR, r6},
                            "cs, r15, r13, r15, ROR, r6",
                            "cs_r15_r13_r15_ROR_r6"},
                           {{al, r2, r14, r1, ASR, r15},
                            "al, r2, r14, r1, ASR, r15",
                            "al_r2_r14_r1_ASR_r15"},
                           {{gt, r15, r12, r6, LSL, r7},
                            "gt, r15, r12, r6, LSL, r7",
                            "gt_r15_r12_r6_LSL_r7"},
                           {{vs, r6, r15, r14, ROR, r12},
                            "vs, r6, r15, r14, ROR, r12",
                            "vs_r6_r15_r14_ROR_r12"},
                           {{lt, r15, r8, r13, ASR, r0},
                            "lt, r15, r8, r13, ASR, r0",
                            "lt_r15_r8_r13_ASR_r0"},
                           {{eq, r5, r11, r15, LSR, r13},
                            "eq, r5, r11, r15, LSR, r13",
                            "eq_r5_r11_r15_LSR_r13"},
                           {{vs, r5, r9, r15, LSL, r4},
                            "vs, r5, r9, r15, LSL, r4",
                            "vs_r5_r9_r15_LSL_r4"},
                           {{vs, r13, r3, r15, LSL, r11},
                            "vs, r13, r3, r15, LSL, r11",
                            "vs_r13_r3_r15_LSL_r11"},
                           {{eq, r15, r0, r10, ASR, r11},
                            "eq, r15, r0, r10, ASR, r11",
                            "eq_r15_r0_r10_ASR_r11"},
                           {{cc, r9, r7, r3, ROR, r15},
                            "cc, r9, r7, r3, ROR, r15",
                            "cc_r9_r7_r3_ROR_r15"},
                           {{eq, r14, r4, r14, ASR, r15},
                            "eq, r14, r4, r14, ASR, r15",
                            "eq_r14_r4_r14_ASR_r15"},
                           {{al, r5, r15, r5, LSR, r4},
                            "al, r5, r15, r5, LSR, r4",
                            "al_r5_r15_r5_LSR_r4"},
                           {{eq, r14, r14, r7, LSL, r15},
                            "eq, r14, r14, r7, LSL, r15",
                            "eq_r14_r14_r7_LSL_r15"},
                           {{le, r15, r14, r13, ASR, r6},
                            "le, r15, r14, r13, ASR, r6",
                            "le_r15_r14_r13_ASR_r6"},
                           {{cs, r4, r15, r13, ASR, r7},
                            "cs, r4, r15, r13, ASR, r7",
                            "cs_r4_r15_r13_ASR_r7"},
                           {{lt, r2, r15, r6, LSL, r0},
                            "lt, r2, r15, r6, LSL, r0",
                            "lt_r2_r15_r6_LSL_r0"},
                           {{al, r10, r9, r15, ASR, r4},
                            "al, r10, r9, r15, ASR, r4",
                            "al_r10_r9_r15_ASR_r4"},
                           {{vc, r10, r5, r11, LSL, r15},
                            "vc, r10, r5, r11, LSL, r15",
                            "vc_r10_r5_r11_LSL_r15"},
                           {{hi, r9, r15, r3, LSR, r15},
                            "hi, r9, r15, r3, LSR, r15",
                            "hi_r9_r15_r3_LSR_r15"},
                           {{al, r1, r2, r15, ASR, r15},
                            "al, r1, r2, r15, ASR, r15",
                            "al_r1_r2_r15_ASR_r15"},
                           {{eq, r8, r15, r12, ROR, r4},
                            "eq, r8, r15, r12, ROR, r4",
                            "eq_r8_r15_r12_ROR_r4"},
                           {{cc, r13, r10, r15, LSR, r15},
                            "cc, r13, r10, r15, LSR, r15",
                            "cc_r13_r10_r15_LSR_r15"},
                           {{hi, r10, r15, r9, ROR, r13},
                            "hi, r10, r15, r9, ROR, r13",
                            "hi_r10_r15_r9_ROR_r13"},
                           {{vs, r3, r15, r15, LSL, r7},
                            "vs, r3, r15, r15, LSL, r7",
                            "vs_r3_r15_r15_LSL_r7"},
                           {{al, r15, r5, r14, ROR, r0},
                            "al, r15, r5, r14, ROR, r0",
                            "al_r15_r5_r14_ROR_r0"},
                           {{cc, r15, r13, r10, ROR, r6},
                            "cc, r15, r13, r10, ROR, r6",
                            "cc_r15_r13_r10_ROR_r6"},
                           {{cc, r14, r6, r15, LSL, r1},
                            "cc, r14, r6, r15, LSL, r1",
                            "cc_r14_r6_r15_LSL_r1"},
                           {{ls, r6, r0, r14, LSL, r15},
                            "ls, r6, r0, r14, LSL, r15",
                            "ls_r6_r0_r14_LSL_r15"},
                           {{vc, r15, r10, r12, ROR, r3},
                            "vc, r15, r10, r12, ROR, r3",
                            "vc_r15_r10_r12_ROR_r3"},
                           {{ne, r15, r1, r13, LSL, r3},
                            "ne, r15, r1, r13, LSL, r3",
                            "ne_r15_r1_r13_LSL_r3"},
                           {{ne, r5, r15, r9, LSL, r10},
                            "ne, r5, r15, r9, LSL, r10",
                            "ne_r5_r15_r9_LSL_r10"},
                           {{lt, r8, r15, r15, LSL, r7},
                            "lt, r8, r15, r15, LSL, r7",
                            "lt_r8_r15_r15_LSL_r7"},
                           {{vs, r14, r6, r12, ROR, r15},
                            "vs, r14, r6, r12, ROR, r15",
                            "vs_r14_r6_r12_ROR_r15"},
                           {{mi, r1, r8, r15, ASR, r3},
                            "mi, r1, r8, r15, ASR, r3",
                            "mi_r1_r8_r15_ASR_r3"},
                           {{hi, r13, r15, r9, LSL, r1},
                            "hi, r13, r15, r9, LSL, r1",
                            "hi_r13_r15_r9_LSL_r1"},
                           {{lt, r3, r13, r11, LSR, r15},
                            "lt, r3, r13, r11, LSR, r15",
                            "lt_r3_r13_r11_LSR_r15"},
                           {{mi, r15, r2, r7, ASR, r13},
                            "mi, r15, r2, r7, ASR, r13",
                            "mi_r15_r2_r7_ASR_r13"},
                           {{eq, r6, r4, r11, ROR, r15},
                            "eq, r6, r4, r11, ROR, r15",
                            "eq_r6_r4_r11_ROR_r15"},
                           {{ne, r4, r13, r13, ROR, r15},
                            "ne, r4, r13, r13, ROR, r15",
                            "ne_r4_r13_r13_ROR_r15"},
                           {{cc, r9, r15, r1, LSL, r3},
                            "cc, r9, r15, r1, LSL, r3",
                            "cc_r9_r15_r1_LSL_r3"},
                           {{lt, r7, r4, r1, LSR, r15},
                            "lt, r7, r4, r1, LSR, r15",
                            "lt_r7_r4_r1_LSR_r15"},
                           {{le, r7, r15, r13, LSR, r8},
                            "le, r7, r15, r13, LSR, r8",
                            "le_r7_r15_r13_LSR_r8"},
                           {{pl, r15, r12, r5, LSR, r13},
                            "pl, r15, r12, r5, LSR, r13",
                            "pl_r15_r12_r5_LSR_r13"},
                           {{eq, r8, r10, r15, LSR, r11},
                            "eq, r8, r10, r15, LSR, r11",
                            "eq_r8_r10_r15_LSR_r11"},
                           {{ne, r5, r8, r15, ROR, r7},
                            "ne, r5, r8, r15, ROR, r7",
                            "ne_r5_r8_r15_ROR_r7"},
                           {{cc, r15, r9, r4, ROR, r3},
                            "cc, r15, r9, r4, ROR, r3",
                            "cc_r15_r9_r4_ROR_r3"},
                           {{al, r12, r1, r15, ROR, r5},
                            "al, r12, r1, r15, ROR, r5",
                            "al_r12_r1_r15_ROR_r5"},
                           {{cc, r3, r15, r11, ASR, r3},
                            "cc, r3, r15, r11, ASR, r3",
                            "cc_r3_r15_r11_ASR_r3"},
                           {{vs, r14, r9, r15, ASR, r11},
                            "vs, r14, r9, r15, ASR, r11",
                            "vs_r14_r9_r15_ASR_r11"},
                           {{ne, r3, r15, r6, ASR, r4},
                            "ne, r3, r15, r6, ASR, r4",
                            "ne_r3_r15_r6_ASR_r4"},
                           {{ne, r14, r7, r15, ASR, r13},
                            "ne, r14, r7, r15, ASR, r13",
                            "ne_r14_r7_r15_ASR_r13"},
                           {{eq, r6, r9, r7, ROR, r15},
                            "eq, r6, r9, r7, ROR, r15",
                            "eq_r6_r9_r7_ROR_r15"},
                           {{mi, r15, r3, r5, ASR, r14},
                            "mi, r15, r3, r5, ASR, r14",
                            "mi_r15_r3_r5_ASR_r14"},
                           {{vc, r3, r13, r14, LSL, r15},
                            "vc, r3, r13, r14, LSL, r15",
                            "vc_r3_r13_r14_LSL_r15"},
                           {{pl, r14, r15, r3, LSL, r10},
                            "pl, r14, r15, r3, LSL, r10",
                            "pl_r14_r15_r3_LSL_r10"},
                           {{ls, r15, r14, r6, ASR, r1},
                            "ls, r15, r14, r6, ASR, r1",
                            "ls_r15_r14_r6_ASR_r1"},
                           {{hi, r3, r15, r1, LSL, r15},
                            "hi, r3, r15, r1, LSL, r15",
                            "hi_r3_r15_r1_LSL_r15"},
                           {{cc, r10, r4, r13, ROR, r15},
                            "cc, r10, r4, r13, ROR, r15",
                            "cc_r10_r4_r13_ROR_r15"},
                           {{ne, r10, r14, r15, LSL, r13},
                            "ne, r10, r14, r15, LSL, r13",
                            "ne_r10_r14_r15_LSL_r13"},
                           {{pl, r6, r6, r15, ROR, r11},
                            "pl, r6, r6, r15, ROR, r11",
                            "pl_r6_r6_r15_ROR_r11"},
                           {{vs, r7, r6, r15, ROR, r7},
                            "vs, r7, r6, r15, ROR, r7",
                            "vs_r7_r6_r15_ROR_r7"},
                           {{al, r15, r14, r5, ROR, r15},
                            "al, r15, r14, r5, ROR, r15",
                            "al_r15_r14_r5_ROR_r15"},
                           {{mi, r14, r6, r2, ROR, r15},
                            "mi, r14, r6, r2, ROR, r15",
                            "mi_r14_r6_r2_ROR_r15"},
                           {{eq, r7, r2, r8, ASR, r15},
                            "eq, r7, r2, r8, ASR, r15",
                            "eq_r7_r2_r8_ASR_r15"},
                           {{ls, r10, r7, r15, ASR, r10},
                            "ls, r10, r7, r15, ASR, r10",
                            "ls_r10_r7_r15_ASR_r10"},
                           {{ls, r8, r11, r7, LSR, r15},
                            "ls, r8, r11, r7, LSR, r15",
                            "ls_r8_r11_r7_LSR_r15"},
                           {{hi, r11, r15, r9, LSL, r3},
                            "hi, r11, r15, r9, LSL, r3",
                            "hi_r11_r15_r9_LSL_r3"},
                           {{lt, r15, r11, r0, ROR, r0},
                            "lt, r15, r11, r0, ROR, r0",
                            "lt_r15_r11_r0_ROR_r0"},
                           {{lt, r5, r5, r15, LSR, r4},
                            "lt, r5, r5, r15, LSR, r4",
                            "lt_r5_r5_r15_LSR_r4"},
                           {{al, r9, r15, r11, LSL, r0},
                            "al, r9, r15, r11, LSL, r0",
                            "al_r9_r15_r11_LSL_r0"},
                           {{mi, r0, r15, r15, ROR, r8},
                            "mi, r0, r15, r15, ROR, r8",
                            "mi_r0_r15_r15_ROR_r8"},
                           {{gt, r11, r15, r15, ROR, r2},
                            "gt, r11, r15, r15, ROR, r2",
                            "gt_r11_r15_r15_ROR_r2"},
                           {{hi, r13, r4, r15, LSL, r8},
                            "hi, r13, r4, r15, LSL, r8",
                            "hi_r13_r4_r15_LSL_r8"},
                           {{vs, r14, r8, r15, LSR, r10},
                            "vs, r14, r8, r15, LSR, r10",
                            "vs_r14_r8_r15_LSR_r10"},
                           {{ne, r13, r14, r15, LSR, r15},
                            "ne, r13, r14, r15, LSR, r15",
                            "ne_r13_r14_r15_LSR_r15"},
                           {{vs, r2, r8, r11, LSR, r15},
                            "vs, r2, r8, r11, LSR, r15",
                            "vs_r2_r8_r11_LSR_r15"},
                           {{ne, r11, r15, r6, ASR, r0},
                            "ne, r11, r15, r6, ASR, r0",
                            "ne_r11_r15_r6_ASR_r0"},
                           {{eq, r0, r0, r15, ASR, r1},
                            "eq, r0, r0, r15, ASR, r1",
                            "eq_r0_r0_r15_ASR_r1"},
                           {{vs, r15, r3, r5, ROR, r11},
                            "vs, r15, r3, r5, ROR, r11",
                            "vs_r15_r3_r5_ROR_r11"},
                           {{hi, r15, r6, r4, LSL, r14},
                            "hi, r15, r6, r4, LSL, r14",
                            "hi_r15_r6_r4_LSL_r14"},
                           {{cs, r2, r3, r14, ASR, r15},
                            "cs, r2, r3, r14, ASR, r15",
                            "cs_r2_r3_r14_ASR_r15"},
                           {{vs, r7, r3, r15, ASR, r8},
                            "vs, r7, r3, r15, ASR, r8",
                            "vs_r7_r3_r15_ASR_r8"},
                           {{mi, r9, r10, r15, LSL, r5},
                            "mi, r9, r10, r15, LSL, r5",
                            "mi_r9_r10_r15_LSL_r5"},
                           {{mi, r15, r12, r14, LSR, r3},
                            "mi, r15, r12, r14, LSR, r3",
                            "mi_r15_r12_r14_LSR_r3"},
                           {{hi, r15, r2, r15, LSR, r7},
                            "hi, r15, r2, r15, LSR, r7",
                            "hi_r15_r2_r15_LSR_r7"},
                           {{eq, r15, r8, r1, ASR, r15},
                            "eq, r15, r8, r1, ASR, r15",
                            "eq_r15_r8_r1_ASR_r15"},
                           {{cc, r9, r15, r6, ASR, r4},
                            "cc, r9, r15, r6, ASR, r4",
                            "cc_r9_r15_r6_ASR_r4"},
                           {{hi, r15, r3, r14, LSL, r7},
                            "hi, r15, r3, r14, LSL, r7",
                            "hi_r15_r3_r14_LSL_r7"},
                           {{ge, r3, r8, r15, ASR, r7},
                            "ge, r3, r8, r15, ASR, r7",
                            "ge_r3_r8_r15_ASR_r7"},
                           {{cc, r7, r6, r15, ASR, r7},
                            "cc, r7, r6, r15, ASR, r7",
                            "cc_r7_r6_r15_ASR_r7"},
                           {{lt, r8, r5, r7, LSL, r15},
                            "lt, r8, r5, r7, LSL, r15",
                            "lt_r8_r5_r7_LSL_r15"},
                           {{mi, r15, r11, r4, ASR, r6},
                            "mi, r15, r11, r4, ASR, r6",
                            "mi_r15_r11_r4_ASR_r6"},
                           {{ge, r1, r15, r3, ROR, r0},
                            "ge, r1, r15, r3, ROR, r0",
                            "ge_r1_r15_r3_ROR_r0"},
                           {{ne, r10, r7, r8, LSR, r15},
                            "ne, r10, r7, r8, LSR, r15",
                            "ne_r10_r7_r8_LSR_r15"},
                           {{mi, r15, r0, r3, ASR, r15},
                            "mi, r15, r0, r3, ASR, r15",
                            "mi_r15_r0_r3_ASR_r15"},
                           {{mi, r0, r15, r1, LSR, r1},
                            "mi, r0, r15, r1, LSR, r1",
                            "mi_r0_r15_r1_LSR_r1"},
                           {{al, r15, r6, r5, ASR, r9},
                            "al, r15, r6, r5, ASR, r9",
                            "al_r15_r6_r5_ASR_r9"},
                           {{le, r3, r14, r5, LSL, r15},
                            "le, r3, r14, r5, LSL, r15",
                            "le_r3_r14_r5_LSL_r15"},
                           {{ge, r13, r15, r5, LSL, r0},
                            "ge, r13, r15, r5, LSL, r0",
                            "ge_r13_r15_r5_LSL_r0"},
                           {{cs, r11, r12, r15, LSL, r8},
                            "cs, r11, r12, r15, LSL, r8",
                            "cs_r11_r12_r15_LSL_r8"},
                           {{eq, r5, r15, r5, ASR, r5},
                            "eq, r5, r15, r5, ASR, r5",
                            "eq_r5_r15_r5_ASR_r5"},
                           {{mi, r9, r15, r8, LSL, r2},
                            "mi, r9, r15, r8, LSL, r2",
                            "mi_r9_r15_r8_LSL_r2"},
                           {{vc, r4, r15, r2, ROR, r8},
                            "vc, r4, r15, r2, ROR, r8",
                            "vc_r4_r15_r2_ROR_r8"},
                           {{eq, r15, r7, r10, LSR, r10},
                            "eq, r15, r7, r10, LSR, r10",
                            "eq_r15_r7_r10_LSR_r10"},
                           {{eq, r15, r14, r5, LSR, r4},
                            "eq, r15, r14, r5, LSR, r4",
                            "eq_r15_r14_r5_LSR_r4"},
                           {{pl, r11, r10, r15, ROR, r11},
                            "pl, r11, r10, r15, ROR, r11",
                            "pl_r11_r10_r15_ROR_r11"},
                           {{le, r3, r13, r15, ASR, r9},
                            "le, r3, r13, r15, ASR, r9",
                            "le_r3_r13_r15_ASR_r9"},
                           {{pl, r11, r15, r3, ASR, r5},
                            "pl, r11, r15, r3, ASR, r5",
                            "pl_r11_r15_r3_ASR_r5"},
                           {{hi, r15, r0, r3, LSL, r13},
                            "hi, r15, r0, r3, LSL, r13",
                            "hi_r15_r0_r3_LSL_r13"},
                           {{vc, r13, r12, r15, ASR, r12},
                            "vc, r13, r12, r15, ASR, r12",
                            "vc_r13_r12_r15_ASR_r12"},
                           {{ne, r13, r13, r15, ROR, r3},
                            "ne, r13, r13, r15, ROR, r3",
                            "ne_r13_r13_r15_ROR_r3"},
                           {{ge, r4, r9, r15, LSR, r2},
                            "ge, r4, r9, r15, LSR, r2",
                            "ge_r4_r9_r15_LSR_r2"},
                           {{al, r3, r15, r12, ROR, r1},
                            "al, r3, r15, r12, ROR, r1",
                            "al_r3_r15_r12_ROR_r1"},
                           {{gt, r15, r0, r10, LSR, r14},
                            "gt, r15, r0, r10, LSR, r14",
                            "gt_r15_r0_r10_LSR_r14"},
                           {{hi, r7, r1, r3, LSR, r15},
                            "hi, r7, r1, r3, LSR, r15",
                            "hi_r7_r1_r3_LSR_r15"},
                           {{vc, r9, r6, r15, LSL, r11},
                            "vc, r9, r6, r15, LSL, r11",
                            "vc_r9_r6_r15_LSL_r11"},
                           {{cs, r6, r14, r15, LSR, r8},
                            "cs, r6, r14, r15, LSR, r8",
                            "cs_r6_r14_r15_LSR_r8"},
                           {{mi, r12, r10, r15, ROR, r4},
                            "mi, r12, r10, r15, ROR, r4",
                            "mi_r12_r10_r15_ROR_r4"},
                           {{hi, r15, r15, r2, LSR, r5},
                            "hi, r15, r15, r2, LSR, r5",
                            "hi_r15_r15_r2_LSR_r5"},
                           {{ne, r1, r8, r4, LSL, r15},
                            "ne, r1, r8, r4, LSL, r15",
                            "ne_r1_r8_r4_LSL_r15"},
                           {{cc, r8, r3, r15, LSL, r9},
                            "cc, r8, r3, r15, LSL, r9",
                            "cc_r8_r3_r15_LSL_r9"},
                           {{eq, r8, r7, r15, LSR, r14},
                            "eq, r8, r7, r15, LSR, r14",
                            "eq_r8_r7_r15_LSR_r14"},
                           {{hi, r8, r15, r13, ROR, r8},
                            "hi, r8, r15, r13, ROR, r8",
                            "hi_r8_r15_r13_ROR_r8"},
                           {{vs, r1, r10, r11, LSL, r15},
                            "vs, r1, r10, r11, LSL, r15",
                            "vs_r1_r10_r11_LSL_r15"},
                           {{vc, r6, r7, r3, ASR, r15},
                            "vc, r6, r7, r3, ASR, r15",
                            "vc_r6_r7_r3_ASR_r15"},
                           {{eq, r15, r7, r7, ROR, r4},
                            "eq, r15, r7, r7, ROR, r4",
                            "eq_r15_r7_r7_ROR_r4"},
                           {{cs, r15, r13, r10, LSL, r5},
                            "cs, r15, r13, r10, LSL, r5",
                            "cs_r15_r13_r10_LSL_r5"},
                           {{ge, r10, r15, r5, LSR, r15},
                            "ge, r10, r15, r5, LSR, r15",
                            "ge_r10_r15_r5_LSR_r15"},
                           {{mi, r0, r0, r12, ROR, r15},
                            "mi, r0, r0, r12, ROR, r15",
                            "mi_r0_r0_r12_ROR_r15"},
                           {{ne, r13, r11, r0, ASR, r15},
                            "ne, r13, r11, r0, ASR, r15",
                            "ne_r13_r11_r0_ASR_r15"},
                           {{mi, r15, r8, r7, ASR, r14},
                            "mi, r15, r8, r7, ASR, r14",
                            "mi_r15_r8_r7_ASR_r14"},
                           {{vc, r12, r0, r15, LSL, r13},
                            "vc, r12, r0, r15, LSL, r13",
                            "vc_r12_r0_r15_LSL_r13"},
                           {{gt, r9, r14, r15, LSL, r5},
                            "gt, r9, r14, r15, LSL, r5",
                            "gt_r9_r14_r15_LSL_r5"},
                           {{vs, r7, r15, r4, ROR, r4},
                            "vs, r7, r15, r4, ROR, r4",
                            "vs_r7_r15_r4_ROR_r4"},
                           {{al, r7, r15, r5, LSR, r1},
                            "al, r7, r15, r5, LSR, r1",
                            "al_r7_r15_r5_LSR_r1"},
                           {{cs, r15, r0, r12, LSL, r8},
                            "cs, r15, r0, r12, LSL, r8",
                            "cs_r15_r0_r12_LSL_r8"},
                           {{ge, r15, r9, r8, ASR, r9},
                            "ge, r15, r9, r8, ASR, r9",
                            "ge_r15_r9_r8_ASR_r9"},
                           {{cc, r12, r15, r15, LSR, r13},
                            "cc, r12, r15, r15, LSR, r13",
                            "cc_r12_r15_r15_LSR_r13"},
                           {{eq, r2, r2, r15, LSR, r0},
                            "eq, r2, r2, r15, LSR, r0",
                            "eq_r2_r2_r15_LSR_r0"},
                           {{mi, r15, r10, r3, LSL, r7},
                            "mi, r15, r10, r3, LSL, r7",
                            "mi_r15_r10_r3_LSL_r7"},
                           {{ne, r14, r9, r12, ROR, r15},
                            "ne, r14, r9, r12, ROR, r15",
                            "ne_r14_r9_r12_ROR_r15"},
                           {{ge, r15, r0, r8, LSL, r13},
                            "ge, r15, r0, r8, LSL, r13",
                            "ge_r15_r0_r8_LSL_r13"},
                           {{ls, r8, r1, r12, LSR, r15},
                            "ls, r8, r1, r12, LSR, r15",
                            "ls_r8_r1_r12_LSR_r15"},
                           {{hi, r2, r15, r15, LSL, r3},
                            "hi, r2, r15, r15, LSL, r3",
                            "hi_r2_r15_r15_LSL_r3"},
                           {{mi, r13, r8, r4, LSL, r15},
                            "mi, r13, r8, r4, LSL, r15",
                            "mi_r13_r8_r4_LSL_r15"},
                           {{al, r15, r13, r11, LSR, r8},
                            "al, r15, r13, r11, LSR, r8",
                            "al_r15_r13_r11_LSR_r8"},
                           {{lt, r13, r0, r15, ROR, r7},
                            "lt, r13, r0, r15, ROR, r7",
                            "lt_r13_r0_r15_ROR_r7"},
                           {{le, r4, r4, r15, ROR, r13},
                            "le, r4, r4, r15, ROR, r13",
                            "le_r4_r4_r15_ROR_r13"},
                           {{ge, r15, r2, r9, ROR, r3},
                            "ge, r15, r2, r9, ROR, r3",
                            "ge_r15_r2_r9_ROR_r3"},
                           {{vs, r4, r15, r12, ASR, r12},
                            "vs, r4, r15, r12, ASR, r12",
                            "vs_r4_r15_r12_ASR_r12"},
                           {{vs, r10, r15, r1, ROR, r0},
                            "vs, r10, r15, r1, ROR, r0",
                            "vs_r10_r15_r1_ROR_r0"},
                           {{vc, r2, r6, r15, LSR, r1},
                            "vc, r2, r6, r15, LSR, r1",
                            "vc_r2_r6_r15_LSR_r1"},
                           {{le, r1, r9, r15, LSR, r2},
                            "le, r1, r9, r15, LSR, r2",
                            "le_r1_r9_r15_LSR_r2"},
                           {{hi, r11, r15, r4, LSL, r8},
                            "hi, r11, r15, r4, LSL, r8",
                            "hi_r11_r15_r4_LSL_r8"},
                           {{ne, r13, r8, r15, LSL, r2},
                            "ne, r13, r8, r15, LSL, r2",
                            "ne_r13_r8_r15_LSL_r2"},
                           {{pl, r9, r12, r15, LSR, r1},
                            "pl, r9, r12, r15, LSR, r1",
                            "pl_r9_r12_r15_LSR_r1"},
                           {{ls, r9, r1, r6, ASR, r15},
                            "ls, r9, r1, r6, ASR, r15",
                            "ls_r9_r1_r6_ASR_r15"},
                           {{eq, r1, r15, r7, LSL, r4},
                            "eq, r1, r15, r7, LSL, r4",
                            "eq_r1_r15_r7_LSL_r4"},
                           {{vc, r15, r15, r7, ASR, r14},
                            "vc, r15, r15, r7, ASR, r14",
                            "vc_r15_r15_r7_ASR_r14"},
                           {{cc, r1, r1, r15, ASR, r8},
                            "cc, r1, r1, r15, ASR, r8",
                            "cc_r1_r1_r15_ASR_r8"},
                           {{le, r9, r5, r15, ROR, r13},
                            "le, r9, r5, r15, ROR, r13",
                            "le_r9_r5_r15_ROR_r13"},
                           {{ls, r3, r10, r6, ASR, r15},
                            "ls, r3, r10, r6, ASR, r15",
                            "ls_r3_r10_r6_ASR_r15"},
                           {{al, r11, r13, r15, ASR, r7},
                            "al, r11, r13, r15, ASR, r7",
                            "al_r11_r13_r15_ASR_r7"},
                           {{le, r10, r3, r15, ASR, r5},
                            "le, r10, r3, r15, ASR, r5",
                            "le_r10_r3_r15_ASR_r5"},
                           {{mi, r5, r7, r11, LSL, r15},
                            "mi, r5, r7, r11, LSL, r15",
                            "mi_r5_r7_r11_LSL_r15"},
                           {{cc, r15, r2, r11, ROR, r8},
                            "cc, r15, r2, r11, ROR, r8",
                            "cc_r15_r2_r11_ROR_r8"},
                           {{hi, r15, r2, r13, ROR, r2},
                            "hi, r15, r2, r13, ROR, r2",
                            "hi_r15_r2_r13_ROR_r2"},
                           {{eq, r1, r9, r0, LSR, r15},
                            "eq, r1, r9, r0, LSR, r15",
                            "eq_r1_r9_r0_LSR_r15"},
                           {{ls, r10, r13, r15, LSL, r2},
                            "ls, r10, r13, r15, LSL, r2",
                            "ls_r10_r13_r15_LSL_r2"},
                           {{vs, r14, r15, r13, LSL, r11},
                            "vs, r14, r15, r13, LSL, r11",
                            "vs_r14_r15_r13_LSL_r11"},
                           {{pl, r8, r3, r15, LSL, r10},
                            "pl, r8, r3, r15, LSL, r10",
                            "pl_r8_r3_r15_LSL_r10"},
                           {{cs, r5, r15, r13, LSL, r3},
                            "cs, r5, r15, r13, LSL, r3",
                            "cs_r5_r15_r13_LSL_r3"},
                           {{cc, r14, r9, r10, ROR, r15},
                            "cc, r14, r9, r10, ROR, r15",
                            "cc_r14_r9_r10_ROR_r15"},
                           {{cs, r2, r2, r10, LSL, r15},
                            "cs, r2, r2, r10, LSL, r15",
                            "cs_r2_r2_r10_LSL_r15"},
                           {{ge, r13, r15, r11, LSR, r6},
                            "ge, r13, r15, r11, LSR, r6",
                            "ge_r13_r15_r11_LSR_r6"},
                           {{eq, r3, r12, r2, LSL, r15},
                            "eq, r3, r12, r2, LSL, r15",
                            "eq_r3_r12_r2_LSL_r15"},
                           {{gt, r7, r15, r11, LSR, r14},
                            "gt, r7, r15, r11, LSR, r14",
                            "gt_r7_r15_r11_LSR_r14"},
                           {{lt, r7, r9, r15, LSR, r15},
                            "lt, r7, r9, r15, LSR, r15",
                            "lt_r7_r9_r15_LSR_r15"},
                           {{lt, r5, r15, r0, LSR, r8},
                            "lt, r5, r15, r0, LSR, r8",
                            "lt_r5_r15_r0_LSR_r8"},
                           {{le, r15, r7, r4, LSL, r9},
                            "le, r15, r7, r4, LSL, r9",
                            "le_r15_r7_r4_LSL_r9"},
                           {{le, r9, r14, r2, ROR, r15},
                            "le, r9, r14, r2, ROR, r15",
                            "le_r9_r14_r2_ROR_r15"},
                           {{mi, r13, r13, r15, LSL, r4},
                            "mi, r13, r13, r15, LSL, r4",
                            "mi_r13_r13_r15_LSL_r4"},
                           {{lt, r9, r10, r15, ASR, r15},
                            "lt, r9, r10, r15, ASR, r15",
                            "lt_r9_r10_r15_ASR_r15"},
                           {{hi, r4, r15, r9, ASR, r13},
                            "hi, r4, r15, r9, ASR, r13",
                            "hi_r4_r15_r9_ASR_r13"},
                           {{cs, r6, r4, r0, ROR, r15},
                            "cs, r6, r4, r0, ROR, r15",
                            "cs_r6_r4_r0_ROR_r15"},
                           {{ls, r15, r13, r1, ASR, r4},
                            "ls, r15, r13, r1, ASR, r4",
                            "ls_r15_r13_r1_ASR_r4"},
                           {{vs, r15, r1, r15, LSR, r10},
                            "vs, r15, r1, r15, LSR, r10",
                            "vs_r15_r1_r15_LSR_r10"},
                           {{vc, r15, r9, r7, LSL, r15},
                            "vc, r15, r9, r7, LSL, r15",
                            "vc_r15_r9_r7_LSL_r15"},
                           {{ne, r7, r6, r1, ROR, r15},
                            "ne, r7, r6, r1, ROR, r15",
                            "ne_r7_r6_r1_ROR_r15"},
                           {{vc, r1, r6, r15, ROR, r8},
                            "vc, r1, r6, r15, ROR, r8",
                            "vc_r1_r6_r15_ROR_r8"},
                           {{vc, r13, r12, r10, LSR, r15},
                            "vc, r13, r12, r10, LSR, r15",
                            "vc_r13_r12_r10_LSR_r15"},
                           {{ge, r15, r11, r5, LSL, r9},
                            "ge, r15, r11, r5, LSL, r9",
                            "ge_r15_r11_r5_LSL_r9"},
                           {{ls, r15, r15, r1, ASR, r1},
                            "ls, r15, r15, r1, ASR, r1",
                            "ls_r15_r15_r1_ASR_r1"},
                           {{vs, r10, r15, r7, ROR, r3},
                            "vs, r10, r15, r7, ROR, r3",
                            "vs_r10_r15_r7_ROR_r3"},
                           {{cs, r15, r6, r15, LSL, r2},
                            "cs, r15, r6, r15, LSL, r2",
                            "cs_r15_r6_r15_LSL_r2"},
                           {{ls, r4, r15, r15, LSR, r9},
                            "ls, r4, r15, r15, LSR, r9",
                            "ls_r4_r15_r15_LSR_r9"},
                           {{le, r2, r15, r15, ROR, r6},
                            "le, r2, r15, r15, ROR, r6",
                            "le_r2_r15_r15_ROR_r6"},
                           {{ne, r12, r15, r3, ROR, r12},
                            "ne, r12, r15, r3, ROR, r12",
                            "ne_r12_r15_r3_ROR_r12"},
                           {{eq, r10, r15, r10, ROR, r13},
                            "eq, r10, r15, r10, ROR, r13",
                            "eq_r10_r15_r10_ROR_r13"},
                           {{gt, r1, r5, r15, LSL, r11},
                            "gt, r1, r5, r15, LSL, r11",
                            "gt_r1_r5_r15_LSL_r11"},
                           {{cs, r8, r10, r15, ROR, r4},
                            "cs, r8, r10, r15, ROR, r4",
                            "cs_r8_r10_r15_ROR_r4"},
                           {{vc, r7, r6, r15, LSR, r5},
                            "vc, r7, r6, r15, LSR, r5",
                            "vc_r7_r6_r15_LSR_r5"},
                           {{cc, r15, r2, r12, ASR, r0},
                            "cc, r15, r2, r12, ASR, r0",
                            "cc_r15_r2_r12_ASR_r0"},
                           {{cs, r7, r12, r15, ASR, r3},
                            "cs, r7, r12, r15, ASR, r3",
                            "cs_r7_r12_r15_ASR_r3"},
                           {{ls, r3, r15, r1, ROR, r4},
                            "ls, r3, r15, r1, ROR, r4",
                            "ls_r3_r15_r1_ROR_r4"},
                           {{gt, r7, r4, r15, ROR, r5},
                            "gt, r7, r4, r15, ROR, r5",
                            "gt_r7_r4_r15_ROR_r5"},
                           {{al, r13, r15, r10, ASR, r3},
                            "al, r13, r15, r10, ASR, r3",
                            "al_r13_r15_r10_ASR_r3"},
                           {{ne, r14, r15, r13, ASR, r10},
                            "ne, r14, r15, r13, ASR, r10",
                            "ne_r14_r15_r13_ASR_r10"},
                           {{lt, r3, r13, r4, ROR, r15},
                            "lt, r3, r13, r4, ROR, r15",
                            "lt_r3_r13_r4_ROR_r15"},
                           {{ge, r2, r14, r12, LSR, r15},
                            "ge, r2, r14, r12, LSR, r15",
                            "ge_r2_r14_r12_LSR_r15"},
                           {{ne, r15, r15, r10, ASR, r8},
                            "ne, r15, r15, r10, ASR, r8",
                            "ne_r15_r15_r10_ASR_r8"},
                           {{mi, r10, r10, r15, ROR, r4},
                            "mi, r10, r10, r15, ROR, r4",
                            "mi_r10_r10_r15_ROR_r4"},
                           {{ge, r10, r0, r15, ASR, r13},
                            "ge, r10, r0, r15, ASR, r13",
                            "ge_r10_r0_r15_ASR_r13"},
                           {{cs, r10, r9, r9, ASR, r15},
                            "cs, r10, r9, r9, ASR, r15",
                            "cs_r10_r9_r9_ASR_r15"},
                           {{pl, r11, r9, r6, LSR, r15},
                            "pl, r11, r9, r6, LSR, r15",
                            "pl_r11_r9_r6_LSR_r15"},
                           {{ge, r12, r6, r1, ROR, r15},
                            "ge, r12, r6, r1, ROR, r15",
                            "ge_r12_r6_r1_ROR_r15"},
                           {{hi, r5, r15, r7, LSL, r2},
                            "hi, r5, r15, r7, LSL, r2",
                            "hi_r5_r15_r7_LSL_r2"},
                           {{lt, r14, r15, r14, ASR, r0},
                            "lt, r14, r15, r14, ASR, r0",
                            "lt_r14_r15_r14_ASR_r0"},
                           {{vc, r4, r11, r15, LSL, r14},
                            "vc, r4, r11, r15, LSL, r14",
                            "vc_r4_r11_r15_LSL_r14"},
                           {{le, r3, r15, r6, LSL, r4},
                            "le, r3, r15, r6, LSL, r4",
                            "le_r3_r15_r6_LSL_r4"},
                           {{lt, r13, r13, r15, ROR, r15},
                            "lt, r13, r13, r15, ROR, r15",
                            "lt_r13_r13_r15_ROR_r15"},
                           {{ls, r7, r7, r15, LSL, r12},
                            "ls, r7, r7, r15, LSL, r12",
                            "ls_r7_r7_r15_LSL_r12"},
                           {{vs, r1, r2, r13, LSR, r15},
                            "vs, r1, r2, r13, LSR, r15",
                            "vs_r1_r2_r13_LSR_r15"},
                           {{hi, r13, r10, r4, ASR, r15},
                            "hi, r13, r10, r4, ASR, r15",
                            "hi_r13_r10_r4_ASR_r15"},
                           {{al, r15, r3, r13, LSL, r2},
                            "al, r15, r3, r13, LSL, r2",
                            "al_r15_r3_r13_LSL_r2"},
                           {{vs, r9, r15, r9, ASR, r15},
                            "vs, r9, r15, r9, ASR, r15",
                            "vs_r9_r15_r9_ASR_r15"},
                           {{lt, r11, r13, r11, LSL, r15},
                            "lt, r11, r13, r11, LSL, r15",
                            "lt_r11_r13_r11_LSL_r15"},
                           {{vs, r15, r3, r4, LSR, r10},
                            "vs, r15, r3, r4, LSR, r10",
                            "vs_r15_r3_r4_LSR_r10"},
                           {{cc, r3, r1, r12, LSR, r15},
                            "cc, r3, r1, r12, LSR, r15",
                            "cc_r3_r1_r12_LSR_r15"},
                           {{pl, r15, r0, r9, LSL, r9},
                            "pl, r15, r0, r9, LSL, r9",
                            "pl_r15_r0_r9_LSL_r9"},
                           {{al, r15, r7, r2, ASR, r3},
                            "al, r15, r7, r2, ASR, r3",
                            "al_r15_r7_r2_ASR_r3"},
                           {{lt, r14, r8, r15, ASR, r3},
                            "lt, r14, r8, r15, ASR, r3",
                            "lt_r14_r8_r15_ASR_r3"},
                           {{vs, r15, r10, r9, LSR, r4},
                            "vs, r15, r10, r9, LSR, r4",
                            "vs_r15_r10_r9_LSR_r4"},
                           {{cc, r15, r14, r2, ASR, r5},
                            "cc, r15, r14, r2, ASR, r5",
                            "cc_r15_r14_r2_ASR_r5"},
                           {{hi, r5, r15, r6, ASR, r0},
                            "hi, r5, r15, r6, ASR, r0",
                            "hi_r5_r15_r6_ASR_r0"},
                           {{le, r6, r6, r13, ROR, r15},
                            "le, r6, r6, r13, ROR, r15",
                            "le_r6_r6_r13_ROR_r15"},
                           {{ls, r0, r4, r6, ASR, r15},
                            "ls, r0, r4, r6, ASR, r15",
                            "ls_r0_r4_r6_ASR_r15"},
                           {{lt, r13, r4, r15, LSR, r14},
                            "lt, r13, r4, r15, LSR, r14",
                            "lt_r13_r4_r15_LSR_r14"},
                           {{gt, r1, r14, r13, LSR, r15},
                            "gt, r1, r14, r13, LSR, r15",
                            "gt_r1_r14_r13_LSR_r15"},
                           {{cs, r1, r4, r13, ASR, r15},
                            "cs, r1, r4, r13, ASR, r15",
                            "cs_r1_r4_r13_ASR_r15"},
                           {{gt, r9, r8, r0, LSR, r15},
                            "gt, r9, r8, r0, LSR, r15",
                            "gt_r9_r8_r0_LSR_r15"},
                           {{vc, r4, r15, r10, LSR, r12},
                            "vc, r4, r15, r10, LSR, r12",
                            "vc_r4_r15_r10_LSR_r12"},
                           {{ge, r3, r12, r10, LSR, r15},
                            "ge, r3, r12, r10, LSR, r15",
                            "ge_r3_r12_r10_LSR_r15"},
                           {{ne, r10, r0, r15, LSL, r15},
                            "ne, r10, r0, r15, LSL, r15",
                            "ne_r10_r0_r15_LSL_r15"},
                           {{vc, r0, r14, r6, LSR, r15},
                            "vc, r0, r14, r6, LSR, r15",
                            "vc_r0_r14_r6_LSR_r15"},
                           {{ls, r15, r1, r0, LSL, r4},
                            "ls, r15, r1, r0, LSL, r4",
                            "ls_r15_r1_r0_LSL_r4"},
                           {{al, r15, r12, r9, ASR, r8},
                            "al, r15, r12, r9, ASR, r8",
                            "al_r15_r12_r9_ASR_r8"},
                           {{mi, r13, r5, r15, ROR, r12},
                            "mi, r13, r5, r15, ROR, r12",
                            "mi_r13_r5_r15_ROR_r12"},
                           {{ge, r7, r13, r14, LSR, r15},
                            "ge, r7, r13, r14, LSR, r15",
                            "ge_r7_r13_r14_LSR_r15"},
                           {{le, r15, r0, r5, LSR, r15},
                            "le, r15, r0, r5, LSR, r15",
                            "le_r15_r0_r5_LSR_r15"},
                           {{ls, r11, r14, r15, LSL, r3},
                            "ls, r11, r14, r15, LSL, r3",
                            "ls_r11_r14_r15_LSL_r3"},
                           {{ge, r10, r12, r15, ROR, r8},
                            "ge, r10, r12, r15, ROR, r8",
                            "ge_r10_r12_r15_ROR_r8"},
                           {{vc, r6, r13, r1, ROR, r15},
                            "vc, r6, r13, r1, ROR, r15",
                            "vc_r6_r13_r1_ROR_r15"},
                           {{le, r15, r0, r13, ROR, r0},
                            "le, r15, r0, r13, ROR, r0",
                            "le_r15_r0_r13_ROR_r0"},
                           {{pl, r14, r2, r15, LSL, r2},
                            "pl, r14, r2, r15, LSL, r2",
                            "pl_r14_r2_r15_LSL_r2"},
                           {{gt, r15, r7, r9, ROR, r9},
                            "gt, r15, r7, r9, ROR, r9",
                            "gt_r15_r7_r9_ROR_r9"},
                           {{lt, r8, r2, r2, LSL, r15},
                            "lt, r8, r2, r2, LSL, r15",
                            "lt_r8_r2_r2_LSL_r15"},
                           {{cs, r10, r14, r15, LSR, r13},
                            "cs, r10, r14, r15, LSR, r13",
                            "cs_r10_r14_r15_LSR_r13"},
                           {{al, r5, r0, r15, ROR, r13},
                            "al, r5, r0, r15, ROR, r13",
                            "al_r5_r0_r15_ROR_r13"},
                           {{mi, r7, r11, r3, LSR, r15},
                            "mi, r7, r11, r3, LSR, r15",
                            "mi_r7_r11_r3_LSR_r15"},
                           {{ls, r11, r8, r15, ASR, r7},
                            "ls, r11, r8, r15, ASR, r7",
                            "ls_r11_r8_r15_ASR_r7"},
                           {{cc, r4, r8, r12, ASR, r15},
                            "cc, r4, r8, r12, ASR, r15",
                            "cc_r4_r8_r12_ASR_r15"},
                           {{gt, r6, r1, r5, ASR, r15},
                            "gt, r6, r1, r5, ASR, r15",
                            "gt_r6_r1_r5_ASR_r15"},
                           {{cc, r12, r8, r14, ROR, r15},
                            "cc, r12, r8, r14, ROR, r15",
                            "cc_r12_r8_r14_ROR_r15"},
                           {{cc, r8, r15, r11, LSR, r15},
                            "cc, r8, r15, r11, LSR, r15",
                            "cc_r8_r15_r11_LSR_r15"},
                           {{vs, r10, r15, r8, LSR, r10},
                            "vs, r10, r15, r8, LSR, r10",
                            "vs_r10_r15_r8_LSR_r10"},
                           {{vs, r15, r0, r15, LSR, r12},
                            "vs, r15, r0, r15, LSR, r12",
                            "vs_r15_r0_r15_LSR_r12"},
                           {{cc, r5, r0, r3, LSL, r15},
                            "cc, r5, r0, r3, LSL, r15",
                            "cc_r5_r0_r3_LSL_r15"},
                           {{vs, r3, r13, r15, ROR, r9},
                            "vs, r3, r13, r15, ROR, r9",
                            "vs_r3_r13_r15_ROR_r9"},
                           {{ge, r5, r6, r1, ASR, r15},
                            "ge, r5, r6, r1, ASR, r15",
                            "ge_r5_r6_r1_ASR_r15"},
                           {{le, r15, r7, r7, ROR, r6},
                            "le, r15, r7, r7, ROR, r6",
                            "le_r15_r7_r7_ROR_r6"},
                           {{ge, r9, r15, r14, ROR, r4},
                            "ge, r9, r15, r14, ROR, r4",
                            "ge_r9_r15_r14_ROR_r4"},
                           {{vc, r14, r3, r5, LSL, r15},
                            "vc, r14, r3, r5, LSL, r15",
                            "vc_r14_r3_r5_LSL_r15"},
                           {{lt, r0, r8, r15, ASR, r12},
                            "lt, r0, r8, r15, ASR, r12",
                            "lt_r0_r8_r15_ASR_r12"},
                           {{ls, r4, r11, r15, LSL, r13},
                            "ls, r4, r11, r15, LSL, r13",
                            "ls_r4_r11_r15_LSL_r13"},
                           {{ls, r15, r4, r10, ASR, r9},
                            "ls, r15, r4, r10, ASR, r9",
                            "ls_r15_r4_r10_ASR_r9"},
                           {{ls, r6, r14, r0, LSL, r15},
                            "ls, r6, r14, r0, LSL, r15",
                            "ls_r6_r14_r0_LSL_r15"},
                           {{gt, r2, r9, r15, LSL, r14},
                            "gt, r2, r9, r15, LSL, r14",
                            "gt_r2_r9_r15_LSL_r14"},
                           {{lt, r12, r3, r3, LSR, r15},
                            "lt, r12, r3, r3, LSR, r15",
                            "lt_r12_r3_r3_LSR_r15"},
                           {{lt, r15, r2, r11, LSR, r0},
                            "lt, r15, r2, r11, LSR, r0",
                            "lt_r15_r2_r11_LSR_r0"},
                           {{pl, r13, r3, r1, ASR, r15},
                            "pl, r13, r3, r1, ASR, r15",
                            "pl_r13_r3_r1_ASR_r15"},
                           {{vc, r8, r14, r15, ROR, r1},
                            "vc, r8, r14, r15, ROR, r1",
                            "vc_r8_r14_r15_ROR_r1"},
                           {{hi, r15, r10, r14, LSL, r5},
                            "hi, r15, r10, r14, LSL, r5",
                            "hi_r15_r10_r14_LSL_r5"},
                           {{ne, r0, r11, r9, LSL, r15},
                            "ne, r0, r11, r9, LSL, r15",
                            "ne_r0_r11_r9_LSL_r15"},
                           {{mi, r15, r4, r5, ASR, r7},
                            "mi, r15, r4, r5, ASR, r7",
                            "mi_r15_r4_r5_ASR_r7"},
                           {{le, r15, r13, r8, LSL, r13},
                            "le, r15, r13, r8, LSL, r13",
                            "le_r15_r13_r8_LSL_r13"},
                           {{ne, r15, r11, r5, ASR, r2},
                            "ne, r15, r11, r5, ASR, r2",
                            "ne_r15_r11_r5_ASR_r2"},
                           {{mi, r4, r15, r1, ROR, r5},
                            "mi, r4, r15, r1, ROR, r5",
                            "mi_r4_r15_r1_ROR_r5"},
                           {{al, r14, r11, r4, LSR, r15},
                            "al, r14, r11, r4, LSR, r15",
                            "al_r14_r11_r4_LSR_r15"},
                           {{hi, r15, r7, r11, LSL, r3},
                            "hi, r15, r7, r11, LSL, r3",
                            "hi_r15_r7_r11_LSL_r3"},
                           {{al, r15, r0, r8, ASR, r13},
                            "al, r15, r0, r8, ASR, r13",
                            "al_r15_r0_r8_ASR_r13"},
                           {{hi, r7, r14, r15, LSR, r5},
                            "hi, r7, r14, r15, LSR, r5",
                            "hi_r7_r14_r15_LSR_r5"},
                           {{ls, r3, r5, r15, ASR, r10},
                            "ls, r3, r5, r15, ASR, r10",
                            "ls_r3_r5_r15_ASR_r10"},
                           {{mi, r15, r7, r7, LSL, r11},
                            "mi, r15, r7, r7, LSL, r11",
                            "mi_r15_r7_r7_LSL_r11"},
                           {{cc, r14, r0, r12, LSL, r15},
                            "cc, r14, r0, r12, LSL, r15",
                            "cc_r14_r0_r12_LSL_r15"},
                           {{cc, r3, r8, r15, LSR, r14},
                            "cc, r3, r8, r15, LSR, r14",
                            "cc_r3_r8_r15_LSR_r14"},
                           {{cs, r12, r9, r15, LSR, r5},
                            "cs, r12, r9, r15, LSR, r5",
                            "cs_r12_r9_r15_LSR_r5"},
                           {{ge, r15, r3, r13, LSR, r5},
                            "ge, r15, r3, r13, LSR, r5",
                            "ge_r15_r3_r13_LSR_r5"},
                           {{al, r15, r4, r0, LSR, r5},
                            "al, r15, r4, r0, LSR, r5",
                            "al_r15_r4_r0_LSR_r5"},
                           {{ge, r6, r7, r15, LSR, r5},
                            "ge, r6, r7, r15, LSR, r5",
                            "ge_r6_r7_r15_LSR_r5"},
                           {{cs, r12, r15, r14, LSR, r7},
                            "cs, r12, r15, r14, LSR, r7",
                            "cs_r12_r15_r14_LSR_r7"},
                           {{ls, r15, r13, r6, ASR, r4},
                            "ls, r15, r13, r6, ASR, r4",
                            "ls_r15_r13_r6_ASR_r4"},
                           {{eq, r15, r5, r3, ASR, r2},
                            "eq, r15, r5, r3, ASR, r2",
                            "eq_r15_r5_r3_ASR_r2"},
                           {{le, r15, r7, r13, LSR, r11},
                            "le, r15, r7, r13, LSR, r11",
                            "le_r15_r7_r13_LSR_r11"},
                           {{cs, r9, r15, r1, LSR, r7},
                            "cs, r9, r15, r1, LSR, r7",
                            "cs_r9_r15_r1_LSR_r7"},
                           {{gt, r14, r5, r2, ASR, r15},
                            "gt, r14, r5, r2, ASR, r15",
                            "gt_r14_r5_r2_ASR_r15"},
                           {{ne, r15, r14, r15, LSL, r7},
                            "ne, r15, r14, r15, LSL, r7",
                            "ne_r15_r14_r15_LSL_r7"},
                           {{gt, r13, r15, r5, ROR, r2},
                            "gt, r13, r15, r5, ROR, r2",
                            "gt_r13_r15_r5_ROR_r2"},
                           {{gt, r6, r5, r15, ASR, r3},
                            "gt, r6, r5, r15, ASR, r3",
                            "gt_r6_r5_r15_ASR_r3"},
                           {{cs, r1, r15, r13, ROR, r3},
                            "cs, r1, r15, r13, ROR, r3",
                            "cs_r1_r15_r13_ROR_r3"},
                           {{eq, r15, r7, r13, LSR, r2},
                            "eq, r15, r7, r13, LSR, r2",
                            "eq_r15_r7_r13_LSR_r2"},
                           {{cc, r15, r15, r3, LSR, r10},
                            "cc, r15, r15, r3, LSR, r10",
                            "cc_r15_r15_r3_LSR_r10"},
                           {{hi, r5, r4, r2, LSL, r15},
                            "hi, r5, r4, r2, LSL, r15",
                            "hi_r5_r4_r2_LSL_r15"},
                           {{mi, r13, r13, r15, ASR, r14},
                            "mi, r13, r13, r15, ASR, r14",
                            "mi_r13_r13_r15_ASR_r14"},
                           {{le, r7, r15, r9, ASR, r6},
                            "le, r7, r15, r9, ASR, r6",
                            "le_r7_r15_r9_ASR_r6"},
                           {{hi, r11, r15, r13, ASR, r8},
                            "hi, r11, r15, r13, ASR, r8",
                            "hi_r11_r15_r13_ASR_r8"},
                           {{cs, r6, r15, r3, ASR, r3},
                            "cs, r6, r15, r3, ASR, r3",
                            "cs_r6_r15_r3_ASR_r3"},
                           {{cs, r2, r10, r15, LSL, r15},
                            "cs, r2, r10, r15, LSL, r15",
                            "cs_r2_r10_r15_LSL_r15"},
                           {{le, r8, r7, r15, ROR, r14},
                            "le, r8, r7, r15, ROR, r14",
                            "le_r8_r7_r15_ROR_r14"},
                           {{ls, r15, r1, r6, ASR, r9},
                            "ls, r15, r1, r6, ASR, r9",
                            "ls_r15_r1_r6_ASR_r9"},
                           {{vs, r13, r15, r11, LSR, r7},
                            "vs, r13, r15, r11, LSR, r7",
                            "vs_r13_r15_r11_LSR_r7"},
                           {{cs, r2, r6, r3, LSL, r15},
                            "cs, r2, r6, r3, LSL, r15",
                            "cs_r2_r6_r3_LSL_r15"},
                           {{lt, r9, r14, r10, LSR, r15},
                            "lt, r9, r14, r10, LSR, r15",
                            "lt_r9_r14_r10_LSR_r15"},
                           {{pl, r7, r2, r15, LSR, r11},
                            "pl, r7, r2, r15, LSR, r11",
                            "pl_r7_r2_r15_LSR_r11"},
                           {{vc, r15, r4, r13, ASR, r13},
                            "vc, r15, r4, r13, ASR, r13",
                            "vc_r15_r4_r13_ASR_r13"},
                           {{gt, r5, r15, r7, ASR, r0},
                            "gt, r5, r15, r7, ASR, r0",
                            "gt_r5_r15_r7_ASR_r0"},
                           {{vs, r4, r11, r15, LSL, r6},
                            "vs, r4, r11, r15, LSL, r6",
                            "vs_r4_r11_r15_LSL_r6"},
                           {{lt, r15, r4, r7, ROR, r2},
                            "lt, r15, r4, r7, ROR, r2",
                            "lt_r15_r4_r7_ROR_r2"},
                           {{le, r10, r15, r9, LSL, r9},
                            "le, r10, r15, r9, LSL, r9",
                            "le_r10_r15_r9_LSL_r9"},
                           {{cc, r5, r11, r15, ROR, r10},
                            "cc, r5, r11, r15, ROR, r10",
                            "cc_r5_r11_r15_ROR_r10"},
                           {{vs, r6, r13, r15, LSL, r3},
                            "vs, r6, r13, r15, LSL, r3",
                            "vs_r6_r13_r15_LSL_r3"},
                           {{eq, r7, r9, r9, ASR, r15},
                            "eq, r7, r9, r9, ASR, r15",
                            "eq_r7_r9_r9_ASR_r15"},
                           {{vs, r15, r7, r8, ASR, r12},
                            "vs, r15, r7, r8, ASR, r12",
                            "vs_r15_r7_r8_ASR_r12"},
                           {{vs, r8, r15, r7, LSL, r0},
                            "vs, r8, r15, r7, LSL, r0",
                            "vs_r8_r15_r7_LSL_r0"},
                           {{pl, r8, r13, r11, LSL, r15},
                            "pl, r8, r13, r11, LSL, r15",
                            "pl_r8_r13_r11_LSL_r15"},
                           {{vs, r15, r0, r5, ASR, r5},
                            "vs, r15, r0, r5, ASR, r5",
                            "vs_r15_r0_r5_ASR_r5"},
                           {{pl, r15, r15, r11, LSR, r12},
                            "pl, r15, r15, r11, LSR, r12",
                            "pl_r15_r15_r11_LSR_r12"},
                           {{eq, r15, r7, r4, ROR, r11},
                            "eq, r15, r7, r4, ROR, r11",
                            "eq_r15_r7_r4_ROR_r11"},
                           {{le, r1, r3, r3, LSL, r15},
                            "le, r1, r3, r3, LSL, r15",
                            "le_r1_r3_r3_LSL_r15"},
                           {{pl, r15, r4, r0, ASR, r9},
                            "pl, r15, r4, r0, ASR, r9",
                            "pl_r15_r4_r0_ASR_r9"},
                           {{ge, r10, r3, r15, LSR, r8},
                            "ge, r10, r3, r15, LSR, r8",
                            "ge_r10_r3_r15_LSR_r8"},
                           {{cc, r9, r1, r2, LSR, r15},
                            "cc, r9, r1, r2, LSR, r15",
                            "cc_r9_r1_r2_LSR_r15"},
                           {{lt, r5, r7, r4, LSR, r15},
                            "lt, r5, r7, r4, LSR, r15",
                            "lt_r5_r7_r4_LSR_r15"},
                           {{vc, r10, r0, r2, LSR, r15},
                            "vc, r10, r0, r2, LSR, r15",
                            "vc_r10_r0_r2_LSR_r15"},
                           {{gt, r7, r4, r15, ROR, r11},
                            "gt, r7, r4, r15, ROR, r11",
                            "gt_r7_r4_r15_ROR_r11"},
                           {{le, r0, r0, r15, LSL, r12},
                            "le, r0, r0, r15, LSL, r12",
                            "le_r0_r0_r15_LSL_r12"},
                           {{al, r10, r5, r15, ASR, r14},
                            "al, r10, r5, r15, ASR, r14",
                            "al_r10_r5_r15_ASR_r14"},
                           {{le, r5, r10, r13, LSR, r15},
                            "le, r5, r10, r13, LSR, r15",
                            "le_r5_r10_r13_LSR_r15"},
                           {{mi, r12, r14, r15, LSR, r15},
                            "mi, r12, r14, r15, LSR, r15",
                            "mi_r12_r14_r15_LSR_r15"},
                           {{eq, r15, r2, r6, LSR, r6},
                            "eq, r15, r2, r6, LSR, r6",
                            "eq_r15_r2_r6_LSR_r6"},
                           {{gt, r15, r13, r15, ROR, r0},
                            "gt, r15, r13, r15, ROR, r0",
                            "gt_r15_r13_r15_ROR_r0"},
                           {{ne, r5, r15, r8, ROR, r9},
                            "ne, r5, r15, r8, ROR, r9",
                            "ne_r5_r15_r8_ROR_r9"},
                           {{gt, r15, r1, r3, ROR, r15},
                            "gt, r15, r1, r3, ROR, r15",
                            "gt_r15_r1_r3_ROR_r15"},
                           {{le, r15, r13, r2, ROR, r8},
                            "le, r15, r13, r2, ROR, r8",
                            "le_r15_r13_r2_ROR_r8"},
                           {{pl, r15, r6, r15, LSR, r13},
                            "pl, r15, r6, r15, LSR, r13",
                            "pl_r15_r6_r15_LSR_r13"},
                           {{ne, r5, r15, r9, LSR, r4},
                            "ne, r5, r15, r9, LSR, r4",
                            "ne_r5_r15_r9_LSR_r4"},
                           {{vs, r2, r15, r8, LSL, r8},
                            "vs, r2, r15, r8, LSL, r8",
                            "vs_r2_r15_r8_LSL_r8"},
                           {{cs, r8, r15, r8, LSR, r4},
                            "cs, r8, r15, r8, LSR, r4",
                            "cs_r8_r15_r8_LSR_r4"},
                           {{vc, r8, r15, r0, LSR, r5},
                            "vc, r8, r15, r0, LSR, r5",
                            "vc_r8_r15_r0_LSR_r5"},
                           {{pl, r3, r3, r15, LSR, r7},
                            "pl, r3, r3, r15, LSR, r7",
                            "pl_r3_r3_r15_LSR_r7"},
                           {{eq, r1, r13, r15, ASR, r8},
                            "eq, r1, r13, r15, ASR, r8",
                            "eq_r1_r13_r15_ASR_r8"},
                           {{cs, r15, r7, r15, LSR, r8},
                            "cs, r15, r7, r15, LSR, r8",
                            "cs_r15_r7_r15_LSR_r8"},
                           {{cs, r15, r3, r2, LSL, r3},
                            "cs, r15, r3, r2, LSL, r3",
                            "cs_r15_r3_r2_LSL_r3"},
                           {{mi, r4, r0, r10, ROR, r15},
                            "mi, r4, r0, r10, ROR, r15",
                            "mi_r4_r0_r10_ROR_r15"},
                           {{ne, r4, r15, r4, ASR, r4},
                            "ne, r4, r15, r4, ASR, r4",
                            "ne_r4_r15_r4_ASR_r4"},
                           {{hi, r5, r3, r8, ROR, r15},
                            "hi, r5, r3, r8, ROR, r15",
                            "hi_r5_r3_r8_ROR_r15"},
                           {{eq, r2, r6, r15, LSR, r8},
                            "eq, r2, r6, r15, LSR, r8",
                            "eq_r2_r6_r15_LSR_r8"},
                           {{ls, r3, r15, r13, ASR, r15},
                            "ls, r3, r15, r13, ASR, r15",
                            "ls_r3_r15_r13_ASR_r15"},
                           {{ne, r15, r7, r0, ASR, r14},
                            "ne, r15, r7, r0, ASR, r14",
                            "ne_r15_r7_r0_ASR_r14"},
                           {{vs, r7, r15, r5, LSL, r8},
                            "vs, r7, r15, r5, LSL, r8",
                            "vs_r7_r15_r5_LSL_r8"},
                           {{gt, r15, r15, r3, ASR, r3},
                            "gt, r15, r15, r3, ASR, r3",
                            "gt_r15_r15_r3_ASR_r3"},
                           {{cc, r5, r15, r7, LSL, r15},
                            "cc, r5, r15, r7, LSL, r15",
                            "cc_r5_r15_r7_LSL_r15"},
                           {{gt, r7, r3, r11, ASR, r15},
                            "gt, r7, r3, r11, ASR, r15",
                            "gt_r7_r3_r11_ASR_r15"},
                           {{mi, r8, r15, r13, ROR, r9},
                            "mi, r8, r15, r13, ROR, r9",
                            "mi_r8_r15_r13_ROR_r9"},
                           {{cc, r15, r0, r14, LSR, r12},
                            "cc, r15, r0, r14, LSR, r12",
                            "cc_r15_r0_r14_LSR_r12"},
                           {{cc, r15, r1, r5, ASR, r13},
                            "cc, r15, r1, r5, ASR, r13",
                            "cc_r15_r1_r5_ASR_r13"},
                           {{cs, r14, r13, r13, ROR, r15},
                            "cs, r14, r13, r13, ROR, r15",
                            "cs_r14_r13_r13_ROR_r15"},
                           {{vc, r15, r15, r2, ASR, r4},
                            "vc, r15, r15, r2, ASR, r4",
                            "vc_r15_r15_r2_ASR_r4"},
                           {{cs, r1, r5, r14, LSR, r15},
                            "cs, r1, r5, r14, LSR, r15",
                            "cs_r1_r5_r14_LSR_r15"},
                           {{ne, r14, r4, r6, ROR, r15},
                            "ne, r14, r4, r6, ROR, r15",
                            "ne_r14_r4_r6_ROR_r15"},
                           {{ls, r2, r14, r15, ROR, r2},
                            "ls, r2, r14, r15, ROR, r2",
                            "ls_r2_r14_r15_ROR_r2"},
                           {{ge, r1, r2, r9, LSL, r15},
                            "ge, r1, r2, r9, LSL, r15",
                            "ge_r1_r2_r9_LSL_r15"},
                           {{mi, r0, r5, r15, ROR, r15},
                            "mi, r0, r5, r15, ROR, r15",
                            "mi_r0_r5_r15_ROR_r15"},
                           {{mi, r0, r7, r0, ROR, r15},
                            "mi, r0, r7, r0, ROR, r15",
                            "mi_r0_r7_r0_ROR_r15"},
                           {{vc, r5, r12, r0, LSR, r15},
                            "vc, r5, r12, r0, LSR, r15",
                            "vc_r5_r12_r0_LSR_r15"},
                           {{vs, r11, r7, r15, LSR, r10},
                            "vs, r11, r7, r15, LSR, r10",
                            "vs_r11_r7_r15_LSR_r10"},
                           {{hi, r2, r1, r15, ASR, r10},
                            "hi, r2, r1, r15, ASR, r10",
                            "hi_r2_r1_r15_ASR_r10"},
                           {{vc, r14, r12, r4, LSL, r15},
                            "vc, r14, r12, r4, LSL, r15",
                            "vc_r14_r12_r4_LSL_r15"},
                           {{al, r1, r3, r15, LSR, r0},
                            "al, r1, r3, r15, LSR, r0",
                            "al_r1_r3_r15_LSR_r0"},
                           {{vc, r8, r15, r4, LSR, r6},
                            "vc, r8, r15, r4, LSR, r6",
                            "vc_r8_r15_r4_LSR_r6"},
                           {{ls, r9, r15, r4, LSL, r11},
                            "ls, r9, r15, r4, LSL, r11",
                            "ls_r9_r15_r4_LSL_r11"},
                           {{ne, r9, r11, r15, ROR, r13},
                            "ne, r9, r11, r15, ROR, r13",
                            "ne_r9_r11_r15_ROR_r13"},
                           {{le, r7, r15, r14, LSR, r7},
                            "le, r7, r15, r14, LSR, r7",
                            "le_r7_r15_r14_LSR_r7"},
                           {{ge, r15, r8, r13, LSR, r13},
                            "ge, r15, r8, r13, LSR, r13",
                            "ge_r15_r8_r13_LSR_r13"},
                           {{ls, r4, r15, r5, ASR, r5},
                            "ls, r4, r15, r5, ASR, r5",
                            "ls_r4_r15_r5_ASR_r5"},
                           {{le, r15, r14, r7, ASR, r13},
                            "le, r15, r14, r7, ASR, r13",
                            "le_r15_r14_r7_ASR_r13"},
                           {{mi, r12, r15, r10, LSR, r3},
                            "mi, r12, r15, r10, LSR, r3",
                            "mi_r12_r15_r10_LSR_r3"},
                           {{gt, r2, r15, r13, ASR, r10},
                            "gt, r2, r15, r13, ASR, r10",
                            "gt_r2_r15_r13_ASR_r10"},
                           {{cs, r10, r15, r9, ASR, r5},
                            "cs, r10, r15, r9, ASR, r5",
                            "cs_r10_r15_r9_ASR_r5"},
                           {{hi, r11, r11, r15, LSR, r6},
                            "hi, r11, r11, r15, LSR, r6",
                            "hi_r11_r11_r15_LSR_r6"},
                           {{pl, r6, r9, r0, LSL, r15},
                            "pl, r6, r9, r0, LSL, r15",
                            "pl_r6_r9_r0_LSL_r15"},
                           {{al, r13, r6, r15, ASR, r2},
                            "al, r13, r6, r15, ASR, r2",
                            "al_r13_r6_r15_ASR_r2"},
                           {{ls, r14, r15, r7, LSL, r13},
                            "ls, r14, r15, r7, LSL, r13",
                            "ls_r14_r15_r7_LSL_r13"},
                           {{hi, r0, r13, r15, LSL, r5},
                            "hi, r0, r13, r15, LSL, r5",
                            "hi_r0_r13_r15_LSL_r5"},
                           {{le, r15, r0, r1, ROR, r7},
                            "le, r15, r0, r1, ROR, r7",
                            "le_r15_r0_r1_ROR_r7"},
                           {{lt, r15, r4, r6, ASR, r4},
                            "lt, r15, r4, r6, ASR, r4",
                            "lt_r15_r4_r6_ASR_r4"},
                           {{ls, r0, r15, r10, LSR, r9},
                            "ls, r0, r15, r10, LSR, r9",
                            "ls_r0_r15_r10_LSR_r9"},
                           {{al, r5, r15, r2, ASR, r8},
                            "al, r5, r15, r2, ASR, r8",
                            "al_r5_r15_r2_ASR_r8"},
                           {{cs, r11, r11, r15, ASR, r6},
                            "cs, r11, r11, r15, ASR, r6",
                            "cs_r11_r11_r15_ASR_r6"},
                           {{gt, r1, r9, r15, ASR, r7},
                            "gt, r1, r9, r15, ASR, r7",
                            "gt_r1_r9_r15_ASR_r7"},
                           {{gt, r4, r12, r15, LSL, r8},
                            "gt, r4, r12, r15, LSL, r8",
                            "gt_r4_r12_r15_LSL_r8"},
                           {{cc, r15, r12, r4, ASR, r14},
                            "cc, r15, r12, r4, ASR, r14",
                            "cc_r15_r12_r4_ASR_r14"},
                           {{ne, r6, r1, r8, LSL, r15},
                            "ne, r6, r1, r8, LSL, r15",
                            "ne_r6_r1_r8_LSL_r15"},
                           {{eq, r5, r7, r15, ROR, r6},
                            "eq, r5, r7, r15, ROR, r6",
                            "eq_r5_r7_r15_ROR_r6"},
                           {{gt, r5, r1, r9, LSL, r15},
                            "gt, r5, r1, r9, LSL, r15",
                            "gt_r5_r1_r9_LSL_r15"},
                           {{cs, r15, r2, r4, ROR, r9},
                            "cs, r15, r2, r4, ROR, r9",
                            "cs_r15_r2_r4_ROR_r9"},
                           {{mi, r14, r9, r15, LSL, r7},
                            "mi, r14, r9, r15, LSL, r7",
                            "mi_r14_r9_r15_LSL_r7"},
                           {{ne, r3, r6, r15, ROR, r13},
                            "ne, r3, r6, r15, ROR, r13",
                            "ne_r3_r6_r15_ROR_r13"},
                           {{pl, r12, r3, r15, LSL, r15},
                            "pl, r12, r3, r15, LSL, r15",
                            "pl_r12_r3_r15_LSL_r15"},
                           {{vs, r6, r14, r3, LSL, r15},
                            "vs, r6, r14, r3, LSL, r15",
                            "vs_r6_r14_r3_LSL_r15"},
                           {{gt, r14, r2, r15, ASR, r4},
                            "gt, r14, r2, r15, ASR, r4",
                            "gt_r14_r2_r15_ASR_r4"},
                           {{hi, r9, r15, r2, ASR, r15},
                            "hi, r9, r15, r2, ASR, r15",
                            "hi_r9_r15_r2_ASR_r15"},
                           {{lt, r7, r2, r14, LSL, r15},
                            "lt, r7, r2, r14, LSL, r15",
                            "lt_r7_r2_r14_LSL_r15"},
                           {{gt, r15, r12, r11, ASR, r13},
                            "gt, r15, r12, r11, ASR, r13",
                            "gt_r15_r12_r11_ASR_r13"},
                           {{pl, r14, r15, r12, LSR, r8},
                            "pl, r14, r15, r12, LSR, r8",
                            "pl_r14_r15_r12_LSR_r8"},
                           {{gt, r15, r11, r6, LSL, r1},
                            "gt, r15, r11, r6, LSL, r1",
                            "gt_r15_r11_r6_LSL_r1"},
                           {{gt, r1, r15, r7, LSL, r15},
                            "gt, r1, r15, r7, LSL, r15",
                            "gt_r1_r15_r7_LSL_r15"},
                           {{hi, r15, r4, r15, ASR, r6},
                            "hi, r15, r4, r15, ASR, r6",
                            "hi_r15_r4_r15_ASR_r6"},
                           {{ne, r14, r13, r15, LSL, r4},
                            "ne, r14, r13, r15, LSL, r4",
                            "ne_r14_r13_r15_LSL_r4"},
                           {{cs, r7, r4, r15, LSR, r7},
                            "cs, r7, r4, r15, LSR, r7",
                            "cs_r7_r4_r15_LSR_r7"},
                           {{gt, r4, r7, r2, ROR, r15},
                            "gt, r4, r7, r2, ROR, r15",
                            "gt_r4_r7_r2_ROR_r15"},
                           {{cs, r2, r7, r14, LSL, r15},
                            "cs, r2, r7, r14, LSL, r15",
                            "cs_r2_r7_r14_LSL_r15"},
                           {{le, r6, r4, r15, LSR, r12},
                            "le, r6, r4, r15, LSR, r12",
                            "le_r6_r4_r15_LSR_r12"},
                           {{eq, r1, r8, r15, LSR, r11},
                            "eq, r1, r8, r15, LSR, r11",
                            "eq_r1_r8_r15_LSR_r11"},
                           {{pl, r7, r15, r9, ASR, r9},
                            "pl, r7, r15, r9, ASR, r9",
                            "pl_r7_r15_r9_ASR_r9"},
                           {{cs, r13, r15, r15, LSR, r11},
                            "cs, r13, r15, r15, LSR, r11",
                            "cs_r13_r15_r15_LSR_r11"},
                           {{eq, r15, r10, r4, ASR, r2},
                            "eq, r15, r10, r4, ASR, r2",
                            "eq_r15_r10_r4_ASR_r2"},
                           {{cs, r15, r0, r15, LSL, r6},
                            "cs, r15, r0, r15, LSL, r6",
                            "cs_r15_r0_r15_LSL_r6"},
                           {{pl, r5, r15, r15, LSL, r5},
                            "pl, r5, r15, r15, LSL, r5",
                            "pl_r5_r15_r15_LSL_r5"},
                           {{hi, r10, r7, r11, ASR, r15},
                            "hi, r10, r7, r11, ASR, r15",
                            "hi_r10_r7_r11_ASR_r15"},
                           {{vs, r15, r9, r4, ROR, r4},
                            "vs, r15, r9, r4, ROR, r4",
                            "vs_r15_r9_r4_ROR_r4"},
                           {{eq, r8, r2, r9, ROR, r15},
                            "eq, r8, r2, r9, ROR, r15",
                            "eq_r8_r2_r9_ROR_r15"},
                           {{cc, r1, r6, r15, ASR, r9},
                            "cc, r1, r6, r15, ASR, r9",
                            "cc_r1_r6_r15_ASR_r9"},
                           {{cc, r5, r3, r15, LSL, r13},
                            "cc, r5, r3, r15, LSL, r13",
                            "cc_r5_r3_r15_LSL_r13"},
                           {{vc, r14, r11, r4, LSL, r15},
                            "vc, r14, r11, r4, LSL, r15",
                            "vc_r14_r11_r4_LSL_r15"},
                           {{vs, r12, r15, r11, LSL, r12},
                            "vs, r12, r15, r11, LSL, r12",
                            "vs_r12_r15_r11_LSL_r12"},
                           {{pl, r15, r2, r14, ASR, r11},
                            "pl, r15, r2, r14, ASR, r11",
                            "pl_r15_r2_r14_ASR_r11"},
                           {{gt, r0, r2, r4, ROR, r15},
                            "gt, r0, r2, r4, ROR, r15",
                            "gt_r0_r2_r4_ROR_r15"},
                           {{le, r1, r14, r2, ASR, r15},
                            "le, r1, r14, r2, ASR, r15",
                            "le_r1_r14_r2_ASR_r15"},
                           {{ne, r5, r10, r6, LSL, r15},
                            "ne, r5, r10, r6, LSL, r15",
                            "ne_r5_r10_r6_LSL_r15"},
                           {{cs, r5, r15, r13, ROR, r4},
                            "cs, r5, r15, r13, ROR, r4",
                            "cs_r5_r15_r13_ROR_r4"},
                           {{hi, r4, r15, r1, LSL, r10},
                            "hi, r4, r15, r1, LSL, r10",
                            "hi_r4_r15_r1_LSL_r10"},
                           {{vs, r8, r15, r6, ROR, r3},
                            "vs, r8, r15, r6, ROR, r3",
                            "vs_r8_r15_r6_ROR_r3"},
                           {{gt, r0, r15, r12, ROR, r15},
                            "gt, r0, r15, r12, ROR, r15",
                            "gt_r0_r15_r12_ROR_r15"},
                           {{gt, r0, r10, r15, ROR, r2},
                            "gt, r0, r10, r15, ROR, r2",
                            "gt_r0_r10_r15_ROR_r2"},
                           {{mi, r8, r2, r0, ASR, r15},
                            "mi, r8, r2, r0, ASR, r15",
                            "mi_r8_r2_r0_ASR_r15"},
                           {{lt, r4, r7, r5, LSR, r15},
                            "lt, r4, r7, r5, LSR, r15",
                            "lt_r4_r7_r5_LSR_r15"},
                           {{al, r15, r6, r8, ROR, r0},
                            "al, r15, r6, r8, ROR, r0",
                            "al_r15_r6_r8_ROR_r0"},
                           {{le, r1, r5, r15, LSR, r2},
                            "le, r1, r5, r15, LSR, r2",
                            "le_r1_r5_r15_LSR_r2"},
                           {{pl, r12, r7, r4, LSR, r15},
                            "pl, r12, r7, r4, LSR, r15",
                            "pl_r12_r7_r4_LSR_r15"},
                           {{pl, r2, r15, r10, LSL, r8},
                            "pl, r2, r15, r10, LSL, r8",
                            "pl_r2_r15_r10_LSL_r8"},
                           {{cs, r10, r10, r15, LSL, r11},
                            "cs, r10, r10, r15, LSL, r11",
                            "cs_r10_r10_r15_LSL_r11"},
                           {{lt, r15, r1, r3, LSR, r14},
                            "lt, r15, r1, r3, LSR, r14",
                            "lt_r15_r1_r3_LSR_r14"},
                           {{cc, r10, r14, r7, LSL, r15},
                            "cc, r10, r14, r7, LSL, r15",
                            "cc_r10_r14_r7_LSL_r15"},
                           {{eq, r15, r12, r9, LSR, r11},
                            "eq, r15, r12, r9, LSR, r11",
                            "eq_r15_r12_r9_LSR_r11"},
                           {{vs, r15, r2, r10, ASR, r3},
                            "vs, r15, r2, r10, ASR, r3",
                            "vs_r15_r2_r10_ASR_r3"},
                           {{ne, r15, r14, r10, LSL, r8},
                            "ne, r15, r14, r10, LSL, r8",
                            "ne_r15_r14_r10_LSL_r8"},
                           {{lt, r15, r14, r10, ROR, r1},
                            "lt, r15, r14, r10, ROR, r1",
                            "lt_r15_r14_r10_ROR_r1"},
                           {{ls, r15, r7, r7, LSR, r0},
                            "ls, r15, r7, r7, LSR, r0",
                            "ls_r15_r7_r7_LSR_r0"},
                           {{cs, r6, r14, r3, LSL, r15},
                            "cs, r6, r14, r3, LSL, r15",
                            "cs_r6_r14_r3_LSL_r15"},
                           {{gt, r6, r15, r12, ASR, r13},
                            "gt, r6, r15, r12, ASR, r13",
                            "gt_r6_r15_r12_ASR_r13"},
                           {{vs, r15, r14, r0, LSL, r1},
                            "vs, r15, r14, r0, LSL, r1",
                            "vs_r15_r14_r0_LSL_r1"},
                           {{pl, r11, r12, r15, ASR, r1},
                            "pl, r11, r12, r15, ASR, r1",
                            "pl_r11_r12_r15_ASR_r1"},
                           {{eq, r9, r7, r15, LSR, r9},
                            "eq, r9, r7, r15, LSR, r9",
                            "eq_r9_r7_r15_LSR_r9"},
                           {{ge, r8, r10, r12, ASR, r15},
                            "ge, r8, r10, r12, ASR, r15",
                            "ge_r8_r10_r12_ASR_r15"},
                           {{ne, r15, r4, r4, LSL, r11},
                            "ne, r15, r4, r4, LSL, r11",
                            "ne_r15_r4_r4_LSL_r11"},
                           {{gt, r15, r10, r10, LSL, r2},
                            "gt, r15, r10, r10, LSL, r2",
                            "gt_r15_r10_r10_LSL_r2"},
                           {{mi, r5, r15, r0, LSL, r13},
                            "mi, r5, r15, r0, LSL, r13",
                            "mi_r5_r15_r0_LSL_r13"},
                           {{cc, r11, r15, r12, LSR, r14},
                            "cc, r11, r15, r12, LSR, r14",
                            "cc_r11_r15_r12_LSR_r14"},
                           {{cc, r0, r15, r11, ROR, r11},
                            "cc, r0, r15, r11, ROR, r11",
                            "cc_r0_r15_r11_ROR_r11"},
                           {{cs, r7, r15, r7, LSL, r5},
                            "cs, r7, r15, r7, LSL, r5",
                            "cs_r7_r15_r7_LSL_r5"},
                           {{eq, r3, r15, r7, LSR, r11},
                            "eq, r3, r15, r7, LSR, r11",
                            "eq_r3_r15_r7_LSR_r11"},
                           {{pl, r9, r15, r8, ASR, r11},
                            "pl, r9, r15, r8, ASR, r11",
                            "pl_r9_r15_r8_ASR_r11"},
                           {{al, r0, r15, r10, ASR, r13},
                            "al, r0, r15, r10, ASR, r13",
                            "al_r0_r15_r10_ASR_r13"},
                           {{vs, r14, r15, r5, ROR, r15},
                            "vs, r14, r15, r5, ROR, r15",
                            "vs_r14_r15_r5_ROR_r15"},
                           {{vc, r15, r2, r2, LSR, r11},
                            "vc, r15, r2, r2, LSR, r11",
                            "vc_r15_r2_r2_LSR_r11"},
                           {{ls, r10, r15, r2, LSL, r0},
                            "ls, r10, r15, r2, LSL, r0",
                            "ls_r10_r15_r2_LSL_r0"},
                           {{vs, r2, r15, r8, LSL, r0},
                            "vs, r2, r15, r8, LSL, r0",
                            "vs_r2_r15_r8_LSL_r0"},
                           {{hi, r15, r0, r14, LSL, r11},
                            "hi, r15, r0, r14, LSL, r11",
                            "hi_r15_r0_r14_LSL_r11"},
                           {{vs, r3, r15, r9, LSL, r9},
                            "vs, r3, r15, r9, LSL, r9",
                            "vs_r3_r15_r9_LSL_r9"},
                           {{gt, r15, r14, r3, ASR, r11},
                            "gt, r15, r14, r3, ASR, r11",
                            "gt_r15_r14_r3_ASR_r11"},
                           {{ne, r4, r5, r14, LSL, r15},
                            "ne, r4, r5, r14, LSL, r15",
                            "ne_r4_r5_r14_LSL_r15"},
                           {{ge, r2, r6, r15, ROR, r0},
                            "ge, r2, r6, r15, ROR, r0",
                            "ge_r2_r6_r15_ROR_r0"},
                           {{ls, r6, r12, r10, LSR, r15},
                            "ls, r6, r12, r10, LSR, r15",
                            "ls_r6_r12_r10_LSR_r15"},
                           {{al, r2, r8, r15, ASR, r5},
                            "al, r2, r8, r15, ASR, r5",
                            "al_r2_r8_r15_ASR_r5"},
                           {{ge, r15, r15, r15, ROR, r3},
                            "ge, r15, r15, r15, ROR, r3",
                            "ge_r15_r15_r15_ROR_r3"},
                           {{ge, r6, r8, r14, ASR, r15},
                            "ge, r6, r8, r14, ASR, r15",
                            "ge_r6_r8_r14_ASR_r15"},
                           {{lt, r15, r10, r2, LSL, r2},
                            "lt, r15, r10, r2, LSL, r2",
                            "lt_r15_r10_r2_LSL_r2"},
                           {{mi, r6, r15, r14, LSR, r3},
                            "mi, r6, r15, r14, LSR, r3",
                            "mi_r6_r15_r14_LSR_r3"},
                           {{cc, r11, r15, r14, ROR, r14},
                            "cc, r11, r15, r14, ROR, r14",
                            "cc_r11_r15_r14_ROR_r14"},
                           {{cc, r5, r0, r15, ASR, r3},
                            "cc, r5, r0, r15, ASR, r3",
                            "cc_r5_r0_r15_ASR_r3"},
                           {{gt, r0, r1, r15, ROR, r0},
                            "gt, r0, r1, r15, ROR, r0",
                            "gt_r0_r1_r15_ROR_r0"},
                           {{pl, r4, r15, r2, ASR, r2},
                            "pl, r4, r15, r2, ASR, r2",
                            "pl_r4_r15_r2_ASR_r2"},
                           {{gt, r15, r13, r0, LSL, r0},
                            "gt, r15, r13, r0, LSL, r0",
                            "gt_r15_r13_r0_LSL_r0"},
                           {{hi, r15, r8, r14, LSR, r0},
                            "hi, r15, r8, r14, LSR, r0",
                            "hi_r15_r8_r14_LSR_r0"},
                           {{hi, r10, r15, r11, ROR, r11},
                            "hi, r10, r15, r11, ROR, r11",
                            "hi_r10_r15_r11_ROR_r11"},
                           {{cs, r9, r14, r7, ASR, r15},
                            "cs, r9, r14, r7, ASR, r15",
                            "cs_r9_r14_r7_ASR_r15"},
                           {{ne, r15, r4, r7, LSR, r13},
                            "ne, r15, r4, r7, LSR, r13",
                            "ne_r15_r4_r7_LSR_r13"},
                           {{vc, r13, r12, r12, ASR, r15},
                            "vc, r13, r12, r12, ASR, r15",
                            "vc_r13_r12_r12_ASR_r15"},
                           {{hi, r15, r2, r12, ROR, r0},
                            "hi, r15, r2, r12, ROR, r0",
                            "hi_r15_r2_r12_ROR_r0"},
                           {{cs, r12, r8, r15, ASR, r14},
                            "cs, r12, r8, r15, ASR, r14",
                            "cs_r12_r8_r15_ASR_r14"},
                           {{al, r3, r9, r1, LSL, r15},
                            "al, r3, r9, r1, LSL, r15",
                            "al_r3_r9_r1_LSL_r15"},
                           {{lt, r8, r1, r15, LSR, r6},
                            "lt, r8, r1, r15, LSR, r6",
                            "lt_r8_r1_r15_LSR_r6"},
                           {{mi, r12, r12, r15, LSL, r6},
                            "mi, r12, r12, r15, LSL, r6",
                            "mi_r12_r12_r15_LSL_r6"},
                           {{eq, r5, r15, r0, ROR, r4},
                            "eq, r5, r15, r0, ROR, r4",
                            "eq_r5_r15_r0_ROR_r4"},
                           {{mi, r8, r1, r5, LSR, r15},
                            "mi, r8, r1, r5, LSR, r15",
                            "mi_r8_r1_r5_LSR_r15"},
                           {{cs, r15, r9, r11, ASR, r3},
                            "cs, r15, r9, r11, ASR, r3",
                            "cs_r15_r9_r11_ASR_r3"},
                           {{ls, r15, r14, r9, ROR, r11},
                            "ls, r15, r14, r9, ROR, r11",
                            "ls_r15_r14_r9_ROR_r11"},
                           {{mi, r3, r15, r11, LSR, r11},
                            "mi, r3, r15, r11, LSR, r11",
                            "mi_r3_r15_r11_LSR_r11"},
                           {{gt, r13, r5, r14, ASR, r15},
                            "gt, r13, r5, r14, ASR, r15",
                            "gt_r13_r5_r14_ASR_r15"},
                           {{cs, r7, r15, r15, LSL, r0},
                            "cs, r7, r15, r15, LSL, r0",
                            "cs_r7_r15_r15_LSL_r0"},
                           {{cc, r15, r8, r10, ASR, r5},
                            "cc, r15, r8, r10, ASR, r5",
                            "cc_r15_r8_r10_ASR_r5"},
                           {{eq, r6, r12, r15, ASR, r8},
                            "eq, r6, r12, r15, ASR, r8",
                            "eq_r6_r12_r15_ASR_r8"},
                           {{ne, r7, r15, r7, ROR, r14},
                            "ne, r7, r15, r7, ROR, r14",
                            "ne_r7_r15_r7_ROR_r14"},
                           {{cs, r9, r2, r14, ASR, r15},
                            "cs, r9, r2, r14, ASR, r15",
                            "cs_r9_r2_r14_ASR_r15"},
                           {{pl, r8, r2, r15, ROR, r2},
                            "pl, r8, r2, r15, ROR, r2",
                            "pl_r8_r2_r15_ROR_r2"},
                           {{cc, r10, r12, r7, LSL, r15},
                            "cc, r10, r12, r7, LSL, r15",
                            "cc_r10_r12_r7_LSL_r15"},
                           {{ne, r3, r12, r15, LSL, r1},
                            "ne, r3, r12, r15, LSL, r1",
                            "ne_r3_r12_r15_LSL_r1"},
                           {{vs, r15, r10, r1, LSL, r9},
                            "vs, r15, r10, r1, LSL, r9",
                            "vs_r15_r10_r1_LSL_r9"},
                           {{al, r10, r15, r7, LSL, r15},
                            "al, r10, r15, r7, LSL, r15",
                            "al_r10_r15_r7_LSL_r15"},
                           {{ge, r13, r0, r15, LSL, r7},
                            "ge, r13, r0, r15, LSL, r7",
                            "ge_r13_r0_r15_LSL_r7"},
                           {{ls, r5, r15, r7, ASR, r5},
                            "ls, r5, r15, r7, ASR, r5",
                            "ls_r5_r15_r7_ASR_r5"},
                           {{ls, r15, r2, r1, LSL, r9},
                            "ls, r15, r2, r1, LSL, r9",
                            "ls_r15_r2_r1_LSL_r9"},
                           {{ge, r9, r15, r14, ROR, r0},
                            "ge, r9, r15, r14, ROR, r0",
                            "ge_r9_r15_r14_ROR_r0"},
                           {{cs, r4, r13, r3, ROR, r15},
                            "cs, r4, r13, r3, ROR, r15",
                            "cs_r4_r13_r3_ROR_r15"},
                           {{eq, r8, r5, r8, ASR, r15},
                            "eq, r8, r5, r8, ASR, r15",
                            "eq_r8_r5_r8_ASR_r15"},
                           {{cs, r15, r8, r8, ASR, r12},
                            "cs, r15, r8, r8, ASR, r12",
                            "cs_r15_r8_r8_ASR_r12"},
                           {{mi, r15, r2, r2, ROR, r4},
                            "mi, r15, r2, r2, ROR, r4",
                            "mi_r15_r2_r2_ROR_r4"},
                           {{hi, r2, r13, r2, ROR, r15},
                            "hi, r2, r13, r2, ROR, r15",
                            "hi_r2_r13_r2_ROR_r15"},
                           {{le, r3, r4, r15, ASR, r5},
                            "le, r3, r4, r15, ASR, r5",
                            "le_r3_r4_r15_ASR_r5"},
                           {{ne, r9, r6, r8, ROR, r15},
                            "ne, r9, r6, r8, ROR, r15",
                            "ne_r9_r6_r8_ROR_r15"},
                           {{ls, r11, r15, r14, ROR, r5},
                            "ls, r11, r15, r14, ROR, r5",
                            "ls_r11_r15_r14_ROR_r5"},
                           {{eq, r15, r9, r12, LSL, r6},
                            "eq, r15, r9, r12, LSL, r6",
                            "eq_r15_r9_r12_LSL_r6"},
                           {{mi, r3, r15, r4, LSR, r10},
                            "mi, r3, r15, r4, LSR, r10",
                            "mi_r3_r15_r4_LSR_r10"},
                           {{cs, r10, r1, r15, LSR, r1},
                            "cs, r10, r1, r15, LSR, r1",
                            "cs_r10_r1_r15_LSR_r1"},
                           {{mi, r15, r10, r11, ASR, r11},
                            "mi, r15, r10, r11, ASR, r11",
                            "mi_r15_r10_r11_ASR_r11"},
                           {{lt, r15, r11, r9, LSL, r0},
                            "lt, r15, r11, r9, LSL, r0",
                            "lt_r15_r11_r9_LSL_r0"},
                           {{vc, r6, r0, r9, LSL, r15},
                            "vc, r6, r0, r9, LSL, r15",
                            "vc_r6_r0_r9_LSL_r15"},
                           {{al, r11, r13, r15, LSR, r0},
                            "al, r11, r13, r15, LSR, r0",
                            "al_r11_r13_r15_LSR_r0"},
                           {{cs, r14, r15, r0, ASR, r12},
                            "cs, r14, r15, r0, ASR, r12",
                            "cs_r14_r15_r0_ASR_r12"},
                           {{al, r7, r15, r8, ASR, r6},
                            "al, r7, r15, r8, ASR, r6",
                            "al_r7_r15_r8_ASR_r6"},
                           {{ls, r0, r15, r5, LSL, r14},
                            "ls, r0, r15, r5, LSL, r14",
                            "ls_r0_r15_r5_LSL_r14"},
                           {{cc, r6, r5, r0, LSR, r15},
                            "cc, r6, r5, r0, LSR, r15",
                            "cc_r6_r5_r0_LSR_r15"},
                           {{ge, r5, r12, r5, ASR, r15},
                            "ge, r5, r12, r5, ASR, r15",
                            "ge_r5_r12_r5_ASR_r15"},
                           {{pl, r15, r14, r7, ROR, r9},
                            "pl, r15, r14, r7, ROR, r9",
                            "pl_r15_r14_r7_ROR_r9"},
                           {{gt, r0, r14, r15, LSL, r10},
                            "gt, r0, r14, r15, LSL, r10",
                            "gt_r0_r14_r15_LSL_r10"},
                           {{hi, r13, r9, r15, ROR, r14},
                            "hi, r13, r9, r15, ROR, r14",
                            "hi_r13_r9_r15_ROR_r14"},
                           {{ls, r15, r4, r14, LSL, r7},
                            "ls, r15, r4, r14, LSL, r7",
                            "ls_r15_r4_r14_LSL_r7"},
                           {{eq, r12, r15, r12, ASR, r5},
                            "eq, r12, r15, r12, ASR, r5",
                            "eq_r12_r15_r12_ASR_r5"},
                           {{lt, r15, r15, r7, LSL, r13},
                            "lt, r15, r15, r7, LSL, r13",
                            "lt_r15_r15_r7_LSL_r13"},
                           {{mi, r14, r15, r13, ROR, r2},
                            "mi, r14, r15, r13, ROR, r2",
                            "mi_r14_r15_r13_ROR_r2"},
                           {{hi, r5, r15, r0, ROR, r3},
                            "hi, r5, r15, r0, ROR, r3",
                            "hi_r5_r15_r0_ROR_r3"},
                           {{cs, r13, r15, r14, LSR, r1},
                            "cs, r13, r15, r14, LSR, r1",
                            "cs_r13_r15_r14_LSR_r1"},
                           {{ge, r15, r0, r4, ROR, r15},
                            "ge, r15, r0, r4, ROR, r15",
                            "ge_r15_r0_r4_ROR_r15"},
                           {{vs, r13, r8, r15, LSL, r9},
                            "vs, r13, r8, r15, LSL, r9",
                            "vs_r13_r8_r15_LSL_r9"},
                           {{mi, r0, r9, r0, ASR, r15},
                            "mi, r0, r9, r0, ASR, r15",
                            "mi_r0_r9_r0_ASR_r15"},
                           {{ne, r0, r15, r2, LSL, r2},
                            "ne, r0, r15, r2, LSL, r2",
                            "ne_r0_r15_r2_LSL_r2"},
                           {{ls, r15, r14, r12, ASR, r1},
                            "ls, r15, r14, r12, ASR, r1",
                            "ls_r15_r14_r12_ASR_r1"},
                           {{cs, r15, r7, r10, ROR, r13},
                            "cs, r15, r7, r10, ROR, r13",
                            "cs_r15_r7_r10_ROR_r13"},
                           {{vc, r15, r6, r11, ASR, r2},
                            "vc, r15, r6, r11, ASR, r2",
                            "vc_r15_r6_r11_ASR_r2"},
                           {{cc, r15, r1, r10, LSL, r7},
                            "cc, r15, r1, r10, LSL, r7",
                            "cc_r15_r1_r10_LSL_r7"},
                           {{mi, r0, r15, r12, ROR, r12},
                            "mi, r0, r15, r12, ROR, r12",
                            "mi_r0_r15_r12_ROR_r12"},
                           {{cc, r12, r15, r12, ROR, r0},
                            "cc, r12, r15, r12, ROR, r0",
                            "cc_r12_r15_r12_ROR_r0"},
                           {{cs, r15, r5, r4, ROR, r6},
                            "cs, r15, r5, r4, ROR, r6",
                            "cs_r15_r5_r4_ROR_r6"},
                           {{ge, r11, r0, r15, LSR, r10},
                            "ge, r11, r0, r15, LSR, r10",
                            "ge_r11_r0_r15_LSR_r10"},
                           {{le, r11, r12, r2, LSR, r15},
                            "le, r11, r12, r2, LSR, r15",
                            "le_r11_r12_r2_LSR_r15"},
                           {{hi, r0, r5, r15, LSR, r2},
                            "hi, r0, r5, r15, LSR, r2",
                            "hi_r0_r5_r15_LSR_r2"},
                           {{hi, r15, r8, r6, LSL, r2},
                            "hi, r15, r8, r6, LSL, r2",
                            "hi_r15_r8_r6_LSL_r2"},
                           {{gt, r7, r15, r8, ASR, r14},
                            "gt, r7, r15, r8, ASR, r14",
                            "gt_r7_r15_r8_ASR_r14"},
                           {{gt, r1, r14, r5, ASR, r15},
                            "gt, r1, r14, r5, ASR, r15",
                            "gt_r1_r14_r5_ASR_r15"},
                           {{vc, r15, r1, r1, ASR, r8},
                            "vc, r15, r1, r1, ASR, r8",
                            "vc_r15_r1_r1_ASR_r8"},
                           {{hi, r15, r12, r2, ROR, r14},
                            "hi, r15, r12, r2, ROR, r14",
                            "hi_r15_r12_r2_ROR_r14"},
                           {{gt, r10, r10, r8, ASR, r15},
                            "gt, r10, r10, r8, ASR, r15",
                            "gt_r10_r10_r8_ASR_r15"},
                           {{le, r0, r3, r15, LSR, r1},
                            "le, r0, r3, r15, LSR, r1",
                            "le_r0_r3_r15_LSR_r1"},
                           {{ne, r12, r3, r15, ASR, r9},
                            "ne, r12, r3, r15, ASR, r9",
                            "ne_r12_r3_r15_ASR_r9"},
                           {{vs, r14, r2, r14, ROR, r15},
                            "vs, r14, r2, r14, ROR, r15",
                            "vs_r14_r2_r14_ROR_r15"},
                           {{pl, r15, r0, r3, LSR, r3},
                            "pl, r15, r0, r3, LSR, r3",
                            "pl_r15_r0_r3_LSR_r3"},
                           {{le, r14, r15, r6, ROR, r14},
                            "le, r14, r15, r6, ROR, r14",
                            "le_r14_r15_r6_ROR_r14"},
                           {{gt, r4, r15, r9, LSR, r4},
                            "gt, r4, r15, r9, LSR, r4",
                            "gt_r4_r15_r9_LSR_r4"},
                           {{cc, r15, r10, r3, ROR, r0},
                            "cc, r15, r10, r3, ROR, r0",
                            "cc_r15_r10_r3_ROR_r0"},
                           {{vs, r9, r7, r15, LSR, r4},
                            "vs, r9, r7, r15, LSR, r4",
                            "vs_r9_r7_r15_LSR_r4"},
                           {{lt, r0, r12, r15, LSR, r14},
                            "lt, r0, r12, r15, LSR, r14",
                            "lt_r0_r12_r15_LSR_r14"},
                           {{cc, r6, r5, r15, ROR, r3},
                            "cc, r6, r5, r15, ROR, r3",
                            "cc_r6_r5_r15_ROR_r3"},
                           {{gt, r8, r15, r9, ROR, r1},
                            "gt, r8, r15, r9, ROR, r1",
                            "gt_r8_r15_r9_ROR_r1"},
                           {{al, r10, r15, r11, ROR, r13},
                            "al, r10, r15, r11, ROR, r13",
                            "al_r10_r15_r11_ROR_r13"},
                           {{eq, r1, r13, r15, ASR, r7},
                            "eq, r1, r13, r15, ASR, r7",
                            "eq_r1_r13_r15_ASR_r7"},
                           {{ls, r9, r5, r15, ASR, r4},
                            "ls, r9, r5, r15, ASR, r4",
                            "ls_r9_r5_r15_ASR_r4"},
                           {{cs, r3, r3, r15, LSR, r6},
                            "cs, r3, r3, r15, LSR, r6",
                            "cs_r3_r3_r15_LSR_r6"},
                           {{pl, r12, r5, r15, ROR, r8},
                            "pl, r12, r5, r15, ROR, r8",
                            "pl_r12_r5_r15_ROR_r8"},
                           {{eq, r14, r15, r4, ASR, r13},
                            "eq, r14, r15, r4, ASR, r13",
                            "eq_r14_r15_r4_ASR_r13"},
                           {{vc, r14, r5, r14, ROR, r15},
                            "vc, r14, r5, r14, ROR, r15",
                            "vc_r14_r5_r14_ROR_r15"},
                           {{hi, r14, r7, r11, ASR, r15},
                            "hi, r14, r7, r11, ASR, r15",
                            "hi_r14_r7_r11_ASR_r15"},
                           {{lt, r8, r15, r8, LSR, r1},
                            "lt, r8, r15, r8, LSR, r1",
                            "lt_r8_r15_r8_LSR_r1"},
                           {{gt, r15, r8, r7, LSR, r3},
                            "gt, r15, r8, r7, LSR, r3",
                            "gt_r15_r8_r7_LSR_r3"},
                           {{vc, r14, r15, r15, ROR, r1},
                            "vc, r14, r15, r15, ROR, r1",
                            "vc_r14_r15_r15_ROR_r1"},
                           {{le, r5, r7, r15, ROR, r15},
                            "le, r5, r7, r15, ROR, r15",
                            "le_r5_r7_r15_ROR_r15"},
                           {{cc, r8, r2, r13, LSL, r15},
                            "cc, r8, r2, r13, LSL, r15",
                            "cc_r8_r2_r13_LSL_r15"},
                           {{vc, r15, r2, r10, ASR, r7},
                            "vc, r15, r2, r10, ASR, r7",
                            "vc_r15_r2_r10_ASR_r7"},
                           {{eq, r8, r15, r15, ROR, r3},
                            "eq, r8, r15, r15, ROR, r3",
                            "eq_r8_r15_r15_ROR_r3"},
                           {{le, r15, r2, r7, LSR, r8},
                            "le, r15, r2, r7, LSR, r8",
                            "le_r15_r2_r7_LSR_r8"},
                           {{cc, r6, r0, r15, ROR, r6},
                            "cc, r6, r0, r15, ROR, r6",
                            "cc_r6_r0_r15_ROR_r6"},
                           {{hi, r2, r15, r0, LSR, r15},
                            "hi, r2, r15, r0, LSR, r15",
                            "hi_r2_r15_r0_LSR_r15"},
                           {{vs, r13, r15, r8, ROR, r1},
                            "vs, r13, r15, r8, ROR, r1",
                            "vs_r13_r15_r8_ROR_r1"},
                           {{ge, r0, r15, r6, LSR, r5},
                            "ge, r0, r15, r6, LSR, r5",
                            "ge_r0_r15_r6_LSR_r5"},
                           {{vc, r5, r10, r15, LSL, r0},
                            "vc, r5, r10, r15, LSL, r0",
                            "vc_r5_r10_r15_LSL_r0"},
                           {{pl, r1, r5, r8, ROR, r15},
                            "pl, r1, r5, r8, ROR, r15",
                            "pl_r1_r5_r8_ROR_r15"},
                           {{ne, r2, r15, r13, ROR, r12},
                            "ne, r2, r15, r13, ROR, r12",
                            "ne_r2_r15_r13_ROR_r12"},
                           {{gt, r12, r15, r7, ROR, r8},
                            "gt, r12, r15, r7, ROR, r8",
                            "gt_r12_r15_r7_ROR_r8"},
                           {{cs, r15, r4, r3, LSR, r3},
                            "cs, r15, r4, r3, LSR, r3",
                            "cs_r15_r4_r3_LSR_r3"},
                           {{cc, r14, r15, r6, ROR, r0},
                            "cc, r14, r15, r6, ROR, r0",
                            "cc_r14_r15_r6_ROR_r0"},
                           {{ne, r15, r2, r10, LSR, r15},
                            "ne, r15, r2, r10, LSR, r15",
                            "ne_r15_r2_r10_LSR_r15"},
                           {{ne, r12, r1, r0, ASR, r15},
                            "ne, r12, r1, r0, ASR, r15",
                            "ne_r12_r1_r0_ASR_r15"},
                           {{ne, r14, r15, r9, LSL, r10},
                            "ne, r14, r15, r9, LSL, r10",
                            "ne_r14_r15_r9_LSL_r10"},
                           {{cs, r0, r0, r15, LSL, r4},
                            "cs, r0, r0, r15, LSL, r4",
                            "cs_r0_r0_r15_LSL_r4"},
                           {{hi, r15, r14, r14, LSL, r12},
                            "hi, r15, r14, r14, LSL, r12",
                            "hi_r15_r14_r14_LSL_r12"},
                           {{al, r2, r12, r15, ROR, r15},
                            "al, r2, r12, r15, ROR, r15",
                            "al_r2_r12_r15_ROR_r15"},
                           {{cc, r2, r12, r6, ASR, r15},
                            "cc, r2, r12, r6, ASR, r15",
                            "cc_r2_r12_r6_ASR_r15"},
                           {{vc, r0, r0, r4, ASR, r15},
                            "vc, r0, r0, r4, ASR, r15",
                            "vc_r0_r0_r4_ASR_r15"},
                           {{le, r15, r1, r0, ASR, r15},
                            "le, r15, r1, r0, ASR, r15",
                            "le_r15_r1_r0_ASR_r15"},
                           {{ne, r2, r2, r7, LSR, r15},
                            "ne, r2, r2, r7, LSR, r15",
                            "ne_r2_r2_r7_LSR_r15"},
                           {{pl, r7, r15, r11, ASR, r0},
                            "pl, r7, r15, r11, ASR, r0",
                            "pl_r7_r15_r11_ASR_r0"},
                           {{mi, r13, r15, r11, LSL, r8},
                            "mi, r13, r15, r11, LSL, r8",
                            "mi_r13_r15_r11_LSL_r8"},
                           {{le, r15, r0, r12, ROR, r3},
                            "le, r15, r0, r12, ROR, r3",
                            "le_r15_r0_r12_ROR_r3"},
                           {{eq, r10, r4, r2, ASR, r15},
                            "eq, r10, r4, r2, ASR, r15",
                            "eq_r10_r4_r2_ASR_r15"},
                           {{cc, r15, r6, r6, LSL, r7},
                            "cc, r15, r6, r6, LSL, r7",
                            "cc_r15_r6_r6_LSL_r7"},
                           {{mi, r11, r10, r15, LSL, r6},
                            "mi, r11, r10, r15, LSL, r6",
                            "mi_r11_r10_r15_LSL_r6"},
                           {{eq, r15, r6, r7, LSL, r12},
                            "eq, r15, r6, r7, LSL, r12",
                            "eq_r15_r6_r7_LSL_r12"},
                           {{le, r10, r6, r1, LSR, r15},
                            "le, r10, r6, r1, LSR, r15",
                            "le_r10_r6_r1_LSR_r15"},
                           {{hi, r0, r4, r15, ASR, r1},
                            "hi, r0, r4, r15, ASR, r1",
                            "hi_r0_r4_r15_ASR_r1"},
                           {{le, r12, r8, r3, ASR, r15},
                            "le, r12, r8, r3, ASR, r15",
                            "le_r12_r8_r3_ASR_r15"},
                           {{gt, r13, r15, r14, LSL, r9},
                            "gt, r13, r15, r14, LSL, r9",
                            "gt_r13_r15_r14_LSL_r9"},
                           {{hi, r1, r6, r15, ROR, r9},
                            "hi, r1, r6, r15, ROR, r9",
                            "hi_r1_r6_r15_ROR_r9"},
                           {{al, r10, r15, r2, LSR, r13},
                            "al, r10, r15, r2, LSR, r13",
                            "al_r10_r15_r2_LSR_r13"},
                           {{hi, r7, r8, r9, ROR, r15},
                            "hi, r7, r8, r9, ROR, r15",
                            "hi_r7_r8_r9_ROR_r15"},
                           {{ge, r3, r5, r14, LSR, r15},
                            "ge, r3, r5, r14, LSR, r15",
                            "ge_r3_r5_r14_LSR_r15"},
                           {{vc, r13, r15, r14, LSL, r12},
                            "vc, r13, r15, r14, LSL, r12",
                            "vc_r13_r15_r14_LSL_r12"},
                           {{vs, r13, r10, r15, ASR, r8},
                            "vs, r13, r10, r15, ASR, r8",
                            "vs_r13_r10_r15_ASR_r8"},
                           {{cs, r10, r11, r15, ASR, r11},
                            "cs, r10, r11, r15, ASR, r11",
                            "cs_r10_r11_r15_ASR_r11"},
                           {{eq, r4, r15, r2, ASR, r2},
                            "eq, r4, r15, r2, ASR, r2",
                            "eq_r4_r15_r2_ASR_r2"},
                           {{cs, r11, r10, r15, LSL, r6},
                            "cs, r11, r10, r15, LSL, r6",
                            "cs_r11_r10_r15_LSL_r6"},
                           {{ne, r6, r0, r12, LSR, r15},
                            "ne, r6, r0, r12, LSR, r15",
                            "ne_r6_r0_r12_LSR_r15"},
                           {{pl, r15, r11, r13, ROR, r14},
                            "pl, r15, r11, r13, ROR, r14",
                            "pl_r15_r11_r13_ROR_r14"},
                           {{cs, r4, r9, r15, ASR, r4},
                            "cs, r4, r9, r15, ASR, r4",
                            "cs_r4_r9_r15_ASR_r4"},
                           {{le, r11, r15, r4, ASR, r13},
                            "le, r11, r15, r4, ASR, r13",
                            "le_r11_r15_r4_ASR_r13"},
                           {{ls, r7, r15, r9, ROR, r3},
                            "ls, r7, r15, r9, ROR, r3",
                            "ls_r7_r15_r9_ROR_r3"},
                           {{ge, r11, r10, r9, ROR, r15},
                            "ge, r11, r10, r9, ROR, r15",
                            "ge_r11_r10_r9_ROR_r15"},
                           {{lt, r15, r9, r6, ASR, r10},
                            "lt, r15, r9, r6, ASR, r10",
                            "lt_r15_r9_r6_ASR_r10"},
                           {{hi, r4, r1, r15, ASR, r9},
                            "hi, r4, r1, r15, ASR, r9",
                            "hi_r4_r1_r15_ASR_r9"},
                           {{le, r15, r15, r12, ROR, r5},
                            "le, r15, r15, r12, ROR, r5",
                            "le_r15_r15_r12_ROR_r5"},
                           {{ge, r0, r12, r5, ASR, r15},
                            "ge, r0, r12, r5, ASR, r15",
                            "ge_r0_r12_r5_ASR_r15"},
                           {{cs, r0, r1, r15, ASR, r1},
                            "cs, r0, r1, r15, ASR, r1",
                            "cs_r0_r1_r15_ASR_r1"},
                           {{le, r15, r0, r9, ROR, r5},
                            "le, r15, r0, r9, ROR, r5",
                            "le_r15_r0_r9_ROR_r5"},
                           {{le, r5, r4, r15, LSR, r10},
                            "le, r5, r4, r15, LSR, r10",
                            "le_r5_r4_r15_LSR_r10"},
                           {{eq, r1, r11, r15, LSR, r6},
                            "eq, r1, r11, r15, LSR, r6",
                            "eq_r1_r11_r15_LSR_r6"},
                           {{ge, r12, r14, r15, LSL, r14},
                            "ge, r12, r14, r15, LSL, r14",
                            "ge_r12_r14_r15_LSL_r14"},
                           {{ls, r2, r2, r13, LSL, r15},
                            "ls, r2, r2, r13, LSL, r15",
                            "ls_r2_r2_r13_LSL_r15"},
                           {{lt, r15, r8, r13, ROR, r3},
                            "lt, r15, r8, r13, ROR, r3",
                            "lt_r15_r8_r13_ROR_r3"},
                           {{ge, r12, r12, r15, ASR, r0},
                            "ge, r12, r12, r15, ASR, r0",
                            "ge_r12_r12_r15_ASR_r0"},
                           {{le, r15, r10, r13, ASR, r15},
                            "le, r15, r10, r13, ASR, r15",
                            "le_r15_r10_r13_ASR_r15"},
                           {{hi, r12, r8, r15, ROR, r15},
                            "hi, r12, r8, r15, ROR, r15",
                            "hi_r12_r8_r15_ROR_r15"},
                           {{pl, r5, r6, r15, ROR, r10},
                            "pl, r5, r6, r15, ROR, r10",
                            "pl_r5_r6_r15_ROR_r10"},
                           {{al, r0, r13, r15, LSL, r14},
                            "al, r0, r13, r15, LSL, r14",
                            "al_r0_r13_r15_LSL_r14"},
                           {{hi, r0, r15, r3, ASR, r3},
                            "hi, r0, r15, r3, ASR, r3",
                            "hi_r0_r15_r3_ASR_r3"},
                           {{ge, r1, r10, r11, LSR, r15},
                            "ge, r1, r10, r11, LSR, r15",
                            "ge_r1_r10_r11_LSR_r15"},
                           {{al, r15, r13, r11, LSR, r2},
                            "al, r15, r13, r11, LSR, r2",
                            "al_r15_r13_r11_LSR_r2"},
                           {{lt, r2, r6, r7, ROR, r15},
                            "lt, r2, r6, r7, ROR, r15",
                            "lt_r2_r6_r7_ROR_r15"},
                           {{ge, r11, r3, r15, ROR, r13},
                            "ge, r11, r3, r15, ROR, r13",
                            "ge_r11_r3_r15_ROR_r13"},
                           {{eq, r8, r13, r13, ASR, r15},
                            "eq, r8, r13, r13, ASR, r15",
                            "eq_r8_r13_r13_ASR_r15"},
                           {{pl, r10, r15, r7, LSR, r4},
                            "pl, r10, r15, r7, LSR, r4",
                            "pl_r10_r15_r7_LSR_r4"},
                           {{le, r15, r11, r10, ASR, r3},
                            "le, r15, r11, r10, ASR, r3",
                            "le_r15_r11_r10_ASR_r3"},
                           {{cs, r9, r15, r2, LSR, r4},
                            "cs, r9, r15, r2, LSR, r4",
                            "cs_r9_r15_r2_LSR_r4"},
                           {{mi, r15, r6, r7, ROR, r10},
                            "mi, r15, r6, r7, ROR, r10",
                            "mi_r15_r6_r7_ROR_r10"},
                           {{vs, r15, r9, r10, ASR, r10},
                            "vs, r15, r9, r10, ASR, r10",
                            "vs_r15_r9_r10_ASR_r10"},
                           {{vs, r12, r1, r2, ROR, r15},
                            "vs, r12, r1, r2, ROR, r15",
                            "vs_r12_r1_r2_ROR_r15"},
                           {{ne, r14, r4, r5, ASR, r15},
                            "ne, r14, r4, r5, ASR, r15",
                            "ne_r14_r4_r5_ASR_r15"},
                           {{ne, r15, r3, r14, LSL, r1},
                            "ne, r15, r3, r14, LSL, r1",
                            "ne_r15_r3_r14_LSL_r1"},
                           {{ge, r5, r11, r3, ASR, r15},
                            "ge, r5, r11, r3, ASR, r15",
                            "ge_r5_r11_r3_ASR_r15"},
                           {{lt, r15, r6, r1, ASR, r15},
                            "lt, r15, r6, r1, ASR, r15",
                            "lt_r15_r6_r1_ASR_r15"},
                           {{cs, r5, r2, r12, ASR, r15},
                            "cs, r5, r2, r12, ASR, r15",
                            "cs_r5_r2_r12_ASR_r15"},
                           {{cs, r14, r6, r1, ASR, r15},
                            "cs, r14, r6, r1, ASR, r15",
                            "cs_r14_r6_r1_ASR_r15"},
                           {{cs, r15, r11, r2, LSR, r15},
                            "cs, r15, r11, r2, LSR, r15",
                            "cs_r15_r11_r2_LSR_r15"},
                           {{eq, r15, r5, r3, ROR, r2},
                            "eq, r15, r5, r3, ROR, r2",
                            "eq_r15_r5_r3_ROR_r2"},
                           {{al, r4, r15, r2, LSR, r9},
                            "al, r4, r15, r2, LSR, r9",
                            "al_r4_r15_r2_LSR_r9"},
                           {{vc, r12, r3, r15, ASR, r4},
                            "vc, r12, r3, r15, ASR, r4",
                            "vc_r12_r3_r15_ASR_r4"},
                           {{al, r9, r2, r13, LSR, r15},
                            "al, r9, r2, r13, LSR, r15",
                            "al_r9_r2_r13_LSR_r15"},
                           {{ge, r0, r15, r1, ROR, r12},
                            "ge, r0, r15, r1, ROR, r12",
                            "ge_r0_r15_r1_ROR_r12"},
                           {{gt, r15, r10, r14, ROR, r2},
                            "gt, r15, r10, r14, ROR, r2",
                            "gt_r15_r10_r14_ROR_r2"},
                           {{cs, r11, r15, r8, LSL, r6},
                            "cs, r11, r15, r8, LSL, r6",
                            "cs_r11_r15_r8_LSL_r6"},
                           {{mi, r12, r15, r9, ASR, r8},
                            "mi, r12, r15, r9, ASR, r8",
                            "mi_r12_r15_r9_ASR_r8"},
                           {{vc, r2, r15, r1, ASR, r3},
                            "vc, r2, r15, r1, ASR, r3",
                            "vc_r2_r15_r1_ASR_r3"},
                           {{gt, r11, r11, r2, ROR, r15},
                            "gt, r11, r11, r2, ROR, r15",
                            "gt_r11_r11_r2_ROR_r15"},
                           {{cs, r15, r7, r11, LSR, r15},
                            "cs, r15, r7, r11, LSR, r15",
                            "cs_r15_r7_r11_LSR_r15"},
                           {{le, r15, r10, r3, ROR, r6},
                            "le, r15, r10, r3, ROR, r6",
                            "le_r15_r10_r3_ROR_r6"},
                           {{gt, r12, r15, r11, ROR, r14},
                            "gt, r12, r15, r11, ROR, r14",
                            "gt_r12_r15_r11_ROR_r14"},
                           {{ge, r0, r14, r15, ROR, r14},
                            "ge, r0, r14, r15, ROR, r14",
                            "ge_r0_r14_r15_ROR_r14"},
                           {{ls, r6, r15, r7, LSR, r4},
                            "ls, r6, r15, r7, LSR, r4",
                            "ls_r6_r15_r7_LSR_r4"},
                           {{cc, r2, r1, r4, LSL, r15},
                            "cc, r2, r1, r4, LSL, r15",
                            "cc_r2_r1_r4_LSL_r15"},
                           {{ge, r7, r15, r4, LSR, r1},
                            "ge, r7, r15, r4, LSR, r1",
                            "ge_r7_r15_r4_LSR_r1"},
                           {{ge, r13, r15, r3, LSR, r2},
                            "ge, r13, r15, r3, LSR, r2",
                            "ge_r13_r15_r3_LSR_r2"},
                           {{pl, r5, r14, r15, LSR, r8},
                            "pl, r5, r14, r15, LSR, r8",
                            "pl_r5_r14_r15_LSR_r8"},
                           {{mi, r10, r15, r11, ASR, r14},
                            "mi, r10, r15, r11, ASR, r14",
                            "mi_r10_r15_r11_ASR_r14"},
                           {{vc, r2, r10, r11, LSR, r15},
                            "vc, r2, r10, r11, LSR, r15",
                            "vc_r2_r10_r11_LSR_r15"},
                           {{ne, r8, r1, r15, LSR, r13},
                            "ne, r8, r1, r15, LSR, r13",
                            "ne_r8_r1_r15_LSR_r13"},
                           {{mi, r15, r12, r15, LSR, r10},
                            "mi, r15, r12, r15, LSR, r10",
                            "mi_r15_r12_r15_LSR_r10"},
                           {{le, r2, r15, r0, LSR, r5},
                            "le, r2, r15, r0, LSR, r5",
                            "le_r2_r15_r0_LSR_r5"},
                           {{cc, r3, r9, r9, ROR, r15},
                            "cc, r3, r9, r9, ROR, r15",
                            "cc_r3_r9_r9_ROR_r15"},
                           {{ls, r15, r8, r7, ASR, r3},
                            "ls, r15, r8, r7, ASR, r3",
                            "ls_r15_r8_r7_ASR_r3"},
                           {{cc, r7, r4, r15, LSL, r8},
                            "cc, r7, r4, r15, LSL, r8",
                            "cc_r7_r4_r15_LSL_r8"},
                           {{pl, r10, r15, r14, ASR, r15},
                            "pl, r10, r15, r14, ASR, r15",
                            "pl_r10_r15_r14_ASR_r15"},
                           {{cs, r9, r15, r15, LSR, r4},
                            "cs, r9, r15, r15, LSR, r4",
                            "cs_r9_r15_r15_LSR_r4"},
                           {{ne, r4, r2, r7, ROR, r15},
                            "ne, r4, r2, r7, ROR, r15",
                            "ne_r4_r2_r7_ROR_r15"},
                           {{ls, r6, r15, r13, ROR, r13},
                            "ls, r6, r15, r13, ROR, r13",
                            "ls_r6_r15_r13_ROR_r13"},
                           {{le, r12, r4, r1, ROR, r15},
                            "le, r12, r4, r1, ROR, r15",
                            "le_r12_r4_r1_ROR_r15"},
                           {{ge, r15, r15, r3, LSL, r14},
                            "ge, r15, r15, r3, LSL, r14",
                            "ge_r15_r15_r3_LSL_r14"},
                           {{le, r14, r15, r12, ASR, r13},
                            "le, r14, r15, r12, ASR, r13",
                            "le_r14_r15_r12_ASR_r13"},
                           {{hi, r5, r2, r2, ROR, r15},
                            "hi, r5, r2, r2, ROR, r15",
                            "hi_r5_r2_r2_ROR_r15"},
                           {{ne, r8, r13, r11, LSL, r15},
                            "ne, r8, r13, r11, LSL, r15",
                            "ne_r8_r13_r11_LSL_r15"},
                           {{al, r15, r0, r0, LSL, r10},
                            "al, r15, r0, r0, LSL, r10",
                            "al_r15_r0_r0_LSL_r10"},
                           {{ge, r11, r0, r6, LSL, r15},
                            "ge, r11, r0, r6, LSL, r15",
                            "ge_r11_r0_r6_LSL_r15"},
                           {{lt, r8, r15, r2, ROR, r13},
                            "lt, r8, r15, r2, ROR, r13",
                            "lt_r8_r15_r2_ROR_r13"},
                           {{hi, r15, r9, r3, LSR, r0},
                            "hi, r15, r9, r3, LSR, r0",
                            "hi_r15_r9_r3_LSR_r0"},
                           {{ls, r2, r15, r14, ASR, r2},
                            "ls, r2, r15, r14, ASR, r2",
                            "ls_r2_r15_r14_ASR_r2"},
                           {{gt, r3, r2, r11, ROR, r15},
                            "gt, r3, r2, r11, ROR, r15",
                            "gt_r3_r2_r11_ROR_r15"},
                           {{vs, r5, r0, r15, LSL, r3},
                            "vs, r5, r0, r15, LSL, r3",
                            "vs_r5_r0_r15_LSL_r3"},
                           {{ls, r15, r14, r13, ASR, r1},
                            "ls, r15, r14, r13, ASR, r1",
                            "ls_r15_r14_r13_ASR_r1"},
                           {{al, r11, r6, r15, LSR, r10},
                            "al, r11, r6, r15, LSR, r10",
                            "al_r11_r6_r15_LSR_r10"},
                           {{ls, r14, r2, r4, LSR, r15},
                            "ls, r14, r2, r4, LSR, r15",
                            "ls_r14_r2_r4_LSR_r15"},
                           {{vc, r13, r6, r15, LSL, r12},
                            "vc, r13, r6, r15, LSL, r12",
                            "vc_r13_r6_r15_LSL_r12"},
                           {{al, r15, r13, r6, ASR, r12},
                            "al, r15, r13, r6, ASR, r12",
                            "al_r15_r13_r6_ASR_r12"},
                           {{vc, r9, r2, r9, ASR, r15},
                            "vc, r9, r2, r9, ASR, r15",
                            "vc_r9_r2_r9_ASR_r15"},
                           {{eq, r15, r15, r3, LSR, r12},
                            "eq, r15, r15, r3, LSR, r12",
                            "eq_r15_r15_r3_LSR_r12"},
                           {{cs, r2, r15, r13, LSL, r9},
                            "cs, r2, r15, r13, LSL, r9",
                            "cs_r2_r15_r13_LSL_r9"},
                           {{eq, r9, r1, r8, ROR, r15},
                            "eq, r9, r1, r8, ROR, r15",
                            "eq_r9_r1_r8_ROR_r15"},
                           {{pl, r15, r0, r6, ROR, r0},
                            "pl, r15, r0, r6, ROR, r0",
                            "pl_r15_r0_r6_ROR_r0"},
                           {{eq, r15, r9, r3, ROR, r3},
                            "eq, r15, r9, r3, ROR, r3",
                            "eq_r15_r9_r3_ROR_r3"},
                           {{ls, r11, r14, r15, LSR, r0},
                            "ls, r11, r14, r15, LSR, r0",
                            "ls_r11_r14_r15_LSR_r0"},
                           {{vs, r14, r7, r15, LSL, r4},
                            "vs, r14, r7, r15, LSL, r4",
                            "vs_r14_r7_r15_LSL_r4"},
                           {{pl, r15, r6, r2, LSL, r0},
                            "pl, r15, r6, r2, LSL, r0",
                            "pl_r15_r6_r2_LSL_r0"},
                           {{vc, r15, r0, r14, ROR, r15},
                            "vc, r15, r0, r14, ROR, r15",
                            "vc_r15_r0_r14_ROR_r15"},
                           {{pl, r11, r13, r1, LSL, r15},
                            "pl, r11, r13, r1, LSL, r15",
                            "pl_r11_r13_r1_LSL_r15"},
                           {{pl, r10, r5, r6, LSL, r15},
                            "pl, r10, r5, r6, LSL, r15",
                            "pl_r10_r5_r6_LSL_r15"},
                           {{ge, r15, r1, r12, LSL, r12},
                            "ge, r15, r1, r12, LSL, r12",
                            "ge_r15_r1_r12_LSL_r12"},
                           {{cc, r0, r5, r12, LSR, r15},
                            "cc, r0, r5, r12, LSR, r15",
                            "cc_r0_r5_r12_LSR_r15"},
                           {{ls, r5, r15, r8, LSL, r2},
                            "ls, r5, r15, r8, LSL, r2",
                            "ls_r5_r15_r8_LSL_r2"},
                           {{eq, r15, r11, r15, LSL, r14},
                            "eq, r15, r11, r15, LSL, r14",
                            "eq_r15_r11_r15_LSL_r14"},
                           {{cc, r13, r15, r1, ROR, r5},
                            "cc, r13, r15, r1, ROR, r5",
                            "cc_r13_r15_r1_ROR_r5"},
                           {{ne, r3, r1, r15, LSL, r1},
                            "ne, r3, r1, r15, LSL, r1",
                            "ne_r3_r1_r15_LSL_r1"},
                           {{gt, r4, r15, r5, ASR, r2},
                            "gt, r4, r15, r5, ASR, r2",
                            "gt_r4_r15_r5_ASR_r2"},
                           {{le, r15, r5, r4, LSL, r9},
                            "le, r15, r5, r4, LSL, r9",
                            "le_r15_r5_r4_LSL_r9"},
                           {{pl, r15, r6, r12, ROR, r5},
                            "pl, r15, r6, r12, ROR, r5",
                            "pl_r15_r6_r12_ROR_r5"},
                           {{ge, r11, r15, r0, ASR, r0},
                            "ge, r11, r15, r0, ASR, r0",
                            "ge_r11_r15_r0_ASR_r0"},
                           {{ge, r10, r11, r15, ROR, r11},
                            "ge, r10, r11, r15, ROR, r11",
                            "ge_r10_r11_r15_ROR_r11"},
                           {{ge, r15, r8, r14, ASR, r2},
                            "ge, r15, r8, r14, ASR, r2",
                            "ge_r15_r8_r14_ASR_r2"},
                           {{ls, r15, r0, r8, LSL, r11},
                            "ls, r15, r0, r8, LSL, r11",
                            "ls_r15_r0_r8_LSL_r11"},
                           {{pl, r6, r9, r15, ASR, r0},
                            "pl, r6, r9, r15, ASR, r0",
                            "pl_r6_r9_r15_ASR_r0"},
                           {{cc, r12, r7, r15, LSR, r1},
                            "cc, r12, r7, r15, LSR, r1",
                            "cc_r12_r7_r15_LSR_r1"},
                           {{al, r6, r15, r10, ASR, r11},
                            "al, r6, r15, r10, ASR, r11",
                            "al_r6_r15_r10_ASR_r11"},
                           {{pl, r15, r5, r4, LSR, r1},
                            "pl, r15, r5, r4, LSR, r1",
                            "pl_r15_r5_r4_LSR_r1"},
                           {{cs, r8, r7, r15, LSL, r6},
                            "cs, r8, r7, r15, LSL, r6",
                            "cs_r8_r7_r15_LSL_r6"},
                           {{eq, r15, r3, r10, ROR, r2},
                            "eq, r15, r3, r10, ROR, r2",
                            "eq_r15_r3_r10_ROR_r2"},
                           {{vc, r15, r7, r5, ASR, r7},
                            "vc, r15, r7, r5, ASR, r7",
                            "vc_r15_r7_r5_ASR_r7"},
                           {{ge, r8, r9, r4, ASR, r15},
                            "ge, r8, r9, r4, ASR, r15",
                            "ge_r8_r9_r4_ASR_r15"},
                           {{gt, r5, r9, r14, ROR, r15},
                            "gt, r5, r9, r14, ROR, r15",
                            "gt_r5_r9_r14_ROR_r15"},
                           {{mi, r15, r15, r2, LSL, r5},
                            "mi, r15, r15, r2, LSL, r5",
                            "mi_r15_r15_r2_LSL_r5"},
                           {{lt, r14, r15, r13, ROR, r8},
                            "lt, r14, r15, r13, ROR, r8",
                            "lt_r14_r15_r13_ROR_r8"},
                           {{ge, r15, r15, r8, LSL, r11},
                            "ge, r15, r15, r8, LSL, r11",
                            "ge_r15_r15_r8_LSL_r11"},
                           {{al, r15, r11, r8, ROR, r7},
                            "al, r15, r11, r8, ROR, r7",
                            "al_r15_r11_r8_ROR_r7"},
                           {{mi, r8, r13, r9, LSR, r15},
                            "mi, r8, r13, r9, LSR, r15",
                            "mi_r8_r13_r9_LSR_r15"},
                           {{vc, r1, r15, r14, ASR, r9},
                            "vc, r1, r15, r14, ASR, r9",
                            "vc_r1_r15_r14_ASR_r9"},
                           {{ge, r10, r6, r11, LSL, r15},
                            "ge, r10, r6, r11, LSL, r15",
                            "ge_r10_r6_r11_LSL_r15"},
                           {{pl, r1, r15, r8, LSR, r15},
                            "pl, r1, r15, r8, LSR, r15",
                            "pl_r1_r15_r8_LSR_r15"},
                           {{ge, r10, r15, r10, LSL, r15},
                            "ge, r10, r15, r10, LSL, r15",
                            "ge_r10_r15_r10_LSL_r15"},
                           {{cc, r0, r8, r4, LSL, r15},
                            "cc, r0, r8, r4, LSL, r15",
                            "cc_r0_r8_r4_LSL_r15"},
                           {{pl, r15, r0, r7, ROR, r12},
                            "pl, r15, r0, r7, ROR, r12",
                            "pl_r15_r0_r7_ROR_r12"},
                           {{hi, r15, r7, r5, LSL, r7},
                            "hi, r15, r7, r5, LSL, r7",
                            "hi_r15_r7_r5_LSL_r7"},
                           {{ne, r15, r9, r15, LSR, r5},
                            "ne, r15, r9, r15, LSR, r5",
                            "ne_r15_r9_r15_LSR_r5"},
                           {{gt, r13, r13, r15, LSL, r2},
                            "gt, r13, r13, r15, LSL, r2",
                            "gt_r13_r13_r15_LSL_r2"},
                           {{cs, r1, r13, r15, LSL, r13},
                            "cs, r1, r13, r15, LSL, r13",
                            "cs_r1_r13_r15_LSL_r13"},
                           {{ge, r8, r15, r10, LSR, r15},
                            "ge, r8, r15, r10, LSR, r15",
                            "ge_r8_r15_r10_LSR_r15"},
                           {{cs, r15, r2, r15, LSR, r8},
                            "cs, r15, r2, r15, LSR, r8",
                            "cs_r15_r2_r15_LSR_r8"},
                           {{le, r13, r11, r9, ASR, r15},
                            "le, r13, r11, r9, ASR, r15",
                            "le_r13_r11_r9_ASR_r15"},
                           {{cs, r14, r15, r2, LSL, r10},
                            "cs, r14, r15, r2, LSL, r10",
                            "cs_r14_r15_r2_LSL_r10"},
                           {{vc, r2, r15, r13, LSR, r9},
                            "vc, r2, r15, r13, LSR, r9",
                            "vc_r2_r15_r13_LSR_r9"},
                           {{le, r1, r15, r2, LSL, r0},
                            "le, r1, r15, r2, LSL, r0",
                            "le_r1_r15_r2_LSL_r0"},
                           {{vc, r15, r12, r0, ASR, r1},
                            "vc, r15, r12, r0, ASR, r1",
                            "vc_r15_r12_r0_ASR_r1"},
                           {{cs, r2, r14, r6, LSR, r15},
                            "cs, r2, r14, r6, LSR, r15",
                            "cs_r2_r14_r6_LSR_r15"},
                           {{pl, r9, r2, r12, LSL, r15},
                            "pl, r9, r2, r12, LSL, r15",
                            "pl_r9_r2_r12_LSL_r15"},
                           {{mi, r10, r13, r14, LSL, r15},
                            "mi, r10, r13, r14, LSL, r15",
                            "mi_r10_r13_r14_LSL_r15"},
                           {{vc, r1, r13, r3, ASR, r15},
                            "vc, r1, r13, r3, ASR, r15",
                            "vc_r1_r13_r3_ASR_r15"},
                           {{pl, r14, r9, r5, ASR, r15},
                            "pl, r14, r9, r5, ASR, r15",
                            "pl_r14_r9_r5_ASR_r15"},
                           {{cs, r7, r14, r15, LSL, r5},
                            "cs, r7, r14, r15, LSL, r5",
                            "cs_r7_r14_r15_LSL_r5"},
                           {{lt, r15, r10, r10, ASR, r4},
                            "lt, r15, r10, r10, ASR, r4",
                            "lt_r15_r10_r10_ASR_r4"},
                           {{al, r14, r15, r2, LSR, r13},
                            "al, r14, r15, r2, LSR, r13",
                            "al_r14_r15_r2_LSR_r13"},
                           {{le, r4, r15, r13, LSL, r7},
                            "le, r4, r15, r13, LSL, r7",
                            "le_r4_r15_r13_LSL_r7"},
                           {{al, r15, r6, r6, ROR, r5},
                            "al, r15, r6, r6, ROR, r5",
                            "al_r15_r6_r6_ROR_r5"},
                           {{al, r11, r8, r4, ROR, r15},
                            "al, r11, r8, r4, ROR, r15",
                            "al_r11_r8_r4_ROR_r15"},
                           {{lt, r13, r7, r6, LSR, r15},
                            "lt, r13, r7, r6, LSR, r15",
                            "lt_r13_r7_r6_LSR_r15"}};
#endif

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   Register rn,
                                   const Operand& op);

#ifdef VIXL_NEGATIVE_TESTING
void TestHelper(Fn instruction, const char* mnemonic) {
  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    MacroAssembler masm(BUF_SIZE);
    masm.UseA32();

    // Values to pass to the assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    Register rm = kTests[i].operands.rm;
    ShiftType shift = kTests[i].operands.shift;
    Register rs = kTests[i].operands.rs;
    Operand op(rm, shift, rs);

    try {
      {
        ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
        (masm.*instruction)(cond, rd, rn, op);
      }
      printf("\nNegative test for: %s\n", mnemonic);
      printf("%s:%d:%s\nNo exception raised.\n",
             __FILE__,
             __LINE__,
             masm.IsUsingT32() ? "T32" : "A32");
      abort();
    } catch (const std::runtime_error&) {
      // Nothing to do, test passed.
      // TODO: Consider checking the error message here, if possible.
    }
  }
}
#else
void TestHelper(Fn, const char*) {
  printf(
      "Skipping negative tests. To enable them, build with"
      " 'negative_testing=on'.\n");
}
#endif

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                         \
  void Test_##mnemonic() { TestHelper(&MacroAssembler::mnemonic, #mnemonic); } \
  Test test_##mnemonic(                                                        \
      "AARCH32_ASSEMBLER_NEGATIVE_COND_RD_RN_OPERAND_RM_SHIFT_RS_" #mnemonic   \
      "_A32",                                                                  \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
