/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.ViewFactory;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxStyle;
import jsyntaxpane.SyntaxStyles;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.util.Configuration;

public class SyntaxView
extends PlainView {
    public static final String PROPERTY_RIGHT_MARGIN_COLOR = "RightMarginColor";
    public static final String PROPERTY_RIGHT_MARGIN_COLUMN = "RightMarginColumn";
    public static final String PROPERTY_SINGLE_COLOR_SELECT = "SingleColorSelect";
    public static final String PROPERTY_TEXTAA = "TextAA";
    private static final Logger log = Logger.getLogger(SyntaxView.class.getName());
    private SyntaxStyle DEFAULT_STYLE = SyntaxStyles.getInstance().getStyle(TokenType.DEFAULT);
    private final boolean singleColorSelect;
    private final int rightMarginColumn;
    private final Color rightMarginColor;
    private final Object textAAHint;
    private static Map<String, Object> TEXT_AA_HINT_NAMES = new HashMap<String, Object>();

    public SyntaxView(Element element, Configuration config, String prefix) {
        super(element);
        this.singleColorSelect = config.getPrefixBoolean(prefix, PROPERTY_SINGLE_COLOR_SELECT, false);
        this.rightMarginColor = new Color(config.getPrefixInteger(prefix, PROPERTY_RIGHT_MARGIN_COLOR, 0xFF7777));
        this.rightMarginColumn = config.getPrefixInteger(prefix, PROPERTY_RIGHT_MARGIN_COLUMN, 0);
        String textaa = config.getPrefixProperty(prefix, PROPERTY_TEXTAA, "DEFAULT");
        this.textAAHint = TEXT_AA_HINT_NAMES.get(textaa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int drawUnselectedText(Graphics graphics, int x, int y, int p0, int p1) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.textAAHint);
        Font saveFont = graphics.getFont();
        Color saveColor = graphics.getColor();
        SyntaxDocument doc = (SyntaxDocument)this.getDocument();
        Segment segment = this.getLineBuffer();
        if (this.rightMarginColumn > 0) {
            int m_x = this.rightMarginColumn * graphics.getFontMetrics().charWidth('m');
            int h = graphics.getFontMetrics().getHeight();
            graphics.setColor(this.rightMarginColor);
            graphics.drawLine(m_x, y, m_x, y - h);
        }
        try {
            Iterator<Token> i = doc.getTokens(p0, p1);
            int start = p0;
            while (i.hasNext()) {
                Token t = i.next();
                if (start < t.start) {
                    doc.getText(start, t.start - start, segment);
                    x = this.DEFAULT_STYLE.drawText(segment, x, y, graphics, this, start);
                }
                int l = t.length;
                int s = t.start;
                if (s < p0) {
                    l -= p0 - s;
                    s = p0;
                }
                if (s + l > p1) {
                    l = p1 - s;
                }
                doc.getText(s, l, segment);
                x = SyntaxStyles.getInstance().drawText(segment, x, y, graphics, this, t);
                start = t.end();
            }
            if (start < p1) {
                doc.getText(start, p1 - start, segment);
                x = this.DEFAULT_STYLE.drawText(segment, x, y, graphics, this, start);
            }
        }
        catch (BadLocationException ex) {
            System.err.println("Requested: " + ex.offsetRequested());
            log.log(Level.SEVERE, null, ex);
        }
        finally {
            graphics.setFont(saveFont);
            graphics.setColor(saveColor);
        }
        return x;
    }

    protected int drawSelectedText(Graphics graphics, int x, int y, int p0, int p1) throws BadLocationException {
        if (this.singleColorSelect) {
            if (this.rightMarginColumn > 0) {
                int m_x = this.rightMarginColumn * graphics.getFontMetrics().charWidth('m');
                int h = graphics.getFontMetrics().getHeight();
                graphics.setColor(this.rightMarginColor);
                graphics.drawLine(m_x, y, m_x, y - h);
            }
            return super.drawUnselectedText(graphics, x, y, p0, p1);
        }
        return this.drawUnselectedText(graphics, x, y, p0, p1);
    }

    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        super.updateDamage(changes, a, f);
        Container host = this.getContainer();
        host.repaint();
    }

    static {
        TEXT_AA_HINT_NAMES.put("DEFAULT", RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        TEXT_AA_HINT_NAMES.put("GASP", RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        TEXT_AA_HINT_NAMES.put("HBGR", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR);
        TEXT_AA_HINT_NAMES.put("HRGB", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        TEXT_AA_HINT_NAMES.put("VBGR", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR);
        TEXT_AA_HINT_NAMES.put("VRGB", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR);
        TEXT_AA_HINT_NAMES.put("OFF", RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        TEXT_AA_HINT_NAMES.put("ON", RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

