/* valaregexliteral.c generated by valac, the Vala compiler
 * generated from valaregexliteral.vala, do not modify */

/* valaregexliteral.vala
 *
 * Copyright (C) 2010  Jukka-Pekka Iivonen
 * Copyright (C) 2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jukka-Pekka Iivonen <jp0409@jippii.fi>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaRegexLiteralPrivate {
	gchar* _value;
};

static gint ValaRegexLiteral_private_offset;
static gpointer vala_regex_literal_parent_class = NULL;

static void vala_regex_literal_set_value (ValaRegexLiteral* self,
                                   const gchar* value);
static void vala_regex_literal_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static gboolean vala_regex_literal_real_is_pure (ValaExpression* base);
static gboolean vala_regex_literal_real_is_non_null (ValaExpression* base);
static gchar* vala_regex_literal_real_to_string (ValaCodeNode* base);
static gboolean vala_regex_literal_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static void vala_regex_literal_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_regex_literal_finalize (ValaCodeNode * obj);
static GType vala_regex_literal_get_type_once (void);

static inline gpointer
vala_regex_literal_get_instance_private (ValaRegexLiteral* self)
{
	return G_STRUCT_MEMBER_P (self, ValaRegexLiteral_private_offset);
}

const gchar*
vala_regex_literal_get_value (ValaRegexLiteral* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static void
vala_regex_literal_set_value (ValaRegexLiteral* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_value);
	self->priv->_value = _tmp0_;
}

/**
 * Creates a new regular expression literal.
 *
 * @param value             the literal value
 * @param source_reference  reference to source code
 * @return                  newly created string literal
 */
ValaRegexLiteral*
vala_regex_literal_construct (GType object_type,
                              const gchar* value,
                              ValaSourceReference* source_reference)
{
	ValaRegexLiteral* self = NULL;
	g_return_val_if_fail (value != NULL, NULL);
	self = (ValaRegexLiteral*) vala_literal_construct (object_type);
	vala_regex_literal_set_value (self, value);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaRegexLiteral*
vala_regex_literal_new (const gchar* value,
                        ValaSourceReference* source_reference)
{
	return vala_regex_literal_construct (VALA_TYPE_REGEX_LITERAL, value, source_reference);
}

static void
vala_regex_literal_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaRegexLiteral * self;
	self = (ValaRegexLiteral*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_regex_literal (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gboolean
vala_regex_literal_real_is_pure (ValaExpression* base)
{
	ValaRegexLiteral * self;
	gboolean result;
	self = (ValaRegexLiteral*) base;
	result = TRUE;
	return result;
}

static gboolean
vala_regex_literal_real_is_non_null (ValaExpression* base)
{
	ValaRegexLiteral * self;
	gboolean result;
	self = (ValaRegexLiteral*) base;
	result = TRUE;
	return result;
}

static gchar*
vala_regex_literal_real_to_string (ValaCodeNode* base)
{
	ValaRegexLiteral * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (ValaRegexLiteral*) base;
	_tmp0_ = self->priv->_value;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
vala_regex_literal_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaRegexLiteral * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSemanticAnalyzer* _tmp13_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ValaRegexLiteral*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	{
		GRegex* regex = NULL;
		const gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp7_;
		_tmp4_ = self->priv->_value;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		regex = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
		_tmp7_ = regex;
		if (_tmp7_ != NULL) {
		}
		_g_regex_unref0 (regex);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		const gchar* _tmp10_;
		g_clear_error (&_inner_error0_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_value;
		vala_report_error (_tmp9_, "Invalid regular expression `%s'.", _tmp10_);
		result = FALSE;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
	_tmp12_ = vala_code_context_get_analyzer (context);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_->regex_type;
	_tmp15_ = vala_data_type_copy (_tmp14_);
	_tmp16_ = _tmp15_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp16_);
	_vala_code_node_unref0 (_tmp16_);
	_tmp17_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp18_ = _tmp17_;
	result = !_tmp18_;
	return result;
}

static void
vala_regex_literal_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaRegexLiteral * self;
	self = (ValaRegexLiteral*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_regex_literal ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_regex_literal_class_init (ValaRegexLiteralClass * klass,
                               gpointer klass_data)
{
	vala_regex_literal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_regex_literal_finalize;
	g_type_class_adjust_private_offset (klass, &ValaRegexLiteral_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_regex_literal_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_regex_literal_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_regex_literal_real_is_non_null;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_regex_literal_real_to_string;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_regex_literal_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_regex_literal_real_emit;
}

static void
vala_regex_literal_instance_init (ValaRegexLiteral * self,
                                  gpointer klass)
{
	self->priv = vala_regex_literal_get_instance_private (self);
}

static void
vala_regex_literal_finalize (ValaCodeNode * obj)
{
	ValaRegexLiteral * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_REGEX_LITERAL, ValaRegexLiteral);
	_g_free0 (self->priv->_value);
	VALA_CODE_NODE_CLASS (vala_regex_literal_parent_class)->finalize (obj);
}

/**
 * Represents a regular expression literal in the source code.
 */
static GType
vala_regex_literal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaRegexLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_regex_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaRegexLiteral), 0, (GInstanceInitFunc) vala_regex_literal_instance_init, NULL };
	GType vala_regex_literal_type_id;
	vala_regex_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaRegexLiteral", &g_define_type_info, 0);
	ValaRegexLiteral_private_offset = g_type_add_instance_private (vala_regex_literal_type_id, sizeof (ValaRegexLiteralPrivate));
	return vala_regex_literal_type_id;
}

GType
vala_regex_literal_get_type (void)
{
	static volatile gsize vala_regex_literal_type_id__once = 0;
	if (g_once_init_enter (&vala_regex_literal_type_id__once)) {
		GType vala_regex_literal_type_id;
		vala_regex_literal_type_id = vala_regex_literal_get_type_once ();
		g_once_init_leave (&vala_regex_literal_type_id__once, vala_regex_literal_type_id);
	}
	return vala_regex_literal_type_id__once;
}

