/*
 * uMPS - A general purpose computer system simulator
 *
 * Copyright (C) 2010 Tomislav Jonjic
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef QMPS_SUSPECT_TYPE_DELEGATE_H
#define QMPS_SUSPECT_TYPE_DELEGATE_H

#include <QStyledItemDelegate>

class SuspectTypeDelegate : public QStyledItemDelegate {
Q_OBJECT

public:
SuspectTypeDelegate(QWidget* parent = 0);

QWidget* createEditor(QWidget* parent,
                      const QStyleOptionViewItem& option,
                      const QModelIndex& index) const;

void setEditorData(QWidget* editor, const QModelIndex& index) const;

void setModelData(QWidget* editor,
                  QAbstractItemModel* model,
                  const QModelIndex& index) const;

void updateEditorGeometry(QWidget* editor,
                          const QStyleOptionViewItem& option,
                          const QModelIndex& index) const;

private:
static const unsigned int kValidTypes = 3;

struct ItemInfo {
	unsigned int value;
	const char* label;
};

static ItemInfo valueMap[kValidTypes];
};

#endif // QMPS_SUSPECT_TYPE_DELEGATE_H
