/*
 * Copyright (C) 2019 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/&gt;.
 *
 */

#include "startbar.h"
#include <QMouseEvent>
#include <QHBoxLayout>
#include <QScreen>
#include <QDebug>
#include <QMenu>

#include <QStyle>
#define THEME_QT_SCHEMA                     "org.ukui.style"
#define THEME_Style_Name                    "styleName"
#define UKUI_PANEL_SETTINGS                 "org.ukui.panel.settings"
#define SHOW_TASKVIEW                       "showtaskview"

UKUIStartbarPlugin::UKUIStartbarPlugin(const IUKUIPanelPluginStartupInfo &startupInfo):
    QObject(),
    IUKUIPanelPlugin(startupInfo),
    m_widget(new UKUIStartBarWidget(this))
{

    m_widget->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

}

UKUIStartbarPlugin::~UKUIStartbarPlugin()
{
    delete m_widget;
}

QWidget *UKUIStartbarPlugin::widget()
{
    return m_widget;
}

void UKUIStartbarPlugin::realign()
{
    m_widget->realign();
}

UKUIStartBarWidget::UKUIStartBarWidget( IUKUIPanelPlugin *plugin, QWidget* parent ):
    m_plugin(plugin),
    m_layout(new QBoxLayout(QBoxLayout::LeftToRight, this)),
    m_divider(new Divider(false, this)),
    m_startMenuButton(new StartMenuButton(plugin, this))
{
    translator();

    m_layout->setContentsMargins(0, 0, 0, 0);
    m_layout->setSpacing(0);
    m_layout->addWidget(m_startMenuButton);
    m_layout->addWidget(m_divider);
    m_layout->setAlignment(m_divider, Qt::AlignCenter);
    const QByteArray id(UKUI_PANEL_SETTINGS);
    if(QGSettings::isSchemaInstalled(id)) {
        m_gsettings = new QGSettings(id);
    }

    showTaskviewButton();
    connect(m_gsettings, &QGSettings::changed, this, [=] (const QString &key){
        if(key == SHOW_TASKVIEW)
            showTaskviewButton();
    });

    realign();
}

void UKUIStartBarWidget::translator()
{
    QTranslator *translator = new QTranslator(this);
    translator->load(QLocale(), "startbar", "_", STARTBAR_TRANSLATION_DIR);
    QCoreApplication::installTranslator(translator);
}

UKUIStartBarWidget::~UKUIStartBarWidget()
{
    m_startMenuButton->deleteLater();
    m_taskViewButton->deleteLater();
}

/*plugin-startmenu refresh function*/
void UKUIStartBarWidget::realign()
{
    if (m_plugin->panel()->isHorizontal()) {
        m_layout->setDirection(QBoxLayout::LeftToRight);

        m_divider->setFixedWidth(1);
        m_divider->setFixedHeight(m_plugin->panel()->panelSize()/3);
    } else {
        m_layout->setDirection(QBoxLayout::TopToBottom);

        m_divider->setFixedHeight(1);
        m_divider->setFixedWidth(m_plugin->panel()->panelSize()/3);
    }

    m_startMenuButton->realign();
    if (this->findChild<TaskViewButton *>("TaskViewButton")) {
        m_taskViewButton->realign();
    }
}


void UKUIStartBarWidget::showTaskviewButton()
{
    if(m_gsettings->get(SHOW_TASKVIEW).toBool()){
        if (!this->findChild<TaskViewButton *>("TaskViewButton")) {
            m_taskViewButton = new TaskViewButton(m_plugin,this);
            m_taskViewButton->setObjectName("TaskViewButton");
            m_layout->addWidget(m_taskViewButton);
        }
    } else {
        if (this->findChild<TaskViewButton *>("TaskViewButton")) {
            if (m_taskViewButton != nullptr) {
                m_layout->removeWidget(m_taskViewButton);
                m_taskViewButton->deleteLater();
            }
        }
    }
}
