## TFSA-2021-152: Arbitrary code execution due to YAML deserialization

### CVE Number
CVE-2021-37678

### Impact
TensorFlow and Keras can be tricked to perform arbitrary code execution when
deserializing a Keras model from YAML format.

```python
from tensorflow.keras import models

payload = '''
!!python/object/new:type
args: ['z', !!python/tuple [], {'extend': !!python/name:exec }]
listitems: "__import__('os').system('cat /etc/passwd')"
'''

models.model_from_yaml(payload)
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/460e000de3a83278fb00b61a16d161b1964f15f4/tensorflow/python/keras/saving/model_config.py#L66-L104)
uses `yaml.unsafe_load` which can perform arbitrary code execution on the input.

### Patches
Given that YAML format support requires a significant amount of work, we have
removed it for now.

We have patched the issue in GitHub commit
[23d6383eb6c14084a8fc3bdf164043b974818012](https://github.com/tensorflow/tensorflow/commit/23d6383eb6c14084a8fc3bdf164043b974818012).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Arjun Shibu.
