/*
 * Stellarium
 * Copyright (C) 2005 Fabien Chereau
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Suite 500, Boston, MA  02110-1335, USA.
 */

// This file contains translations for all translatable strings stored within data files
// It is not meant to be compiled but just parsed by gettext
// names of celestial objects for screen display (Sky language) have been taken to translations_skycultures.h

class Translations
{
	void Translations(){;}

	static translationList()
	{
		// Generate Gettext strings for traduction
		Q_ASSERT(0);
		
		// TRANSLATORS: short name of dataset for DSO textures
		NC_("Nebulae", "dataset short name");

		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Planets");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Comets");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Asteroids");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Moons");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Plutinos");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Dwarf planets");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Cubewanos");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Scattered disc objects");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Oort cloud objects");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Sednoids");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Interstellar objects");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Constellations");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Custom Objects");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Asterisms");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Artificial objects");
		
		// =====================================================================
		// Special location
		N_("landing site");

		// =====================================================================
		// List of geological features by type
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: albedo features");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: arcūs");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: astra");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: catenae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: cavi");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: chaoses");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: chasmata");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: colles");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: coronae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: craters");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: dorsa");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: eruptive centers");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: faculae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: farra");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: flexūs");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: fluctūs");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: flumina");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: freta");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: fossae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: insulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: labēs");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: labyrinthi");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: lacunae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: lacūs");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: large ringed features");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: lineae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: lingulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: maculae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: maria");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: mensae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: montes");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: oceani");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: paludes");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: paterae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: planitiae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: plana");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: plumes");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: promontoria");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: regiones");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: rimae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: rupēs");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: scopuli");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: serpentes");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: sulci");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: sinūs");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: terrae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: tholi");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: undae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: valles");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: vastitates");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: virgae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: landing sites");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: lenticulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: reticula");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: tesserae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Geological features: saxa");

		// =====================================================================
		// List of geological features by celestial body (alphabetical sorting)
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Amalthea");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Ariel");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Callisto");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Ceres");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Charon");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Dactyl");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Deimos");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Dione");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Enceladus");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Epimetheus");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Eros");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Europa");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Ganymede");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Gaspra");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Hyperion");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Iapetus");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Ida");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Io");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Itokawa");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Janus");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Lutetia");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Mars");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Mathilde");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Mercury");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Mimas");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Miranda");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of the Moon");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Oberon");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Phobos");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Phoebe");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Pluto");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Proteus");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Puck");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Rhea");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Ryugu");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Steins");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Tethys");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Thebe");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Titania");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Titan");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Triton");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Umbriel");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Venus");
		// TRANSLATORS: List of geological features by celestial body (for "Lists" in the search tool)
		N_("Named geological features of Vesta");

		// =====================================================================
		// List of deep-sky objects types
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Bright galaxies");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Open star clusters");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Globular star clusters");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Planetary nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Dark nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Clusters associated with nebulosity");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("HII regions");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Reflection nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Active galaxies");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Radio galaxies");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Interacting galaxies");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Bright quasars");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Star clusters");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Stellar associations");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Star clouds");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Bipolar nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Emission nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Supernova remnants");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Supernova candidates");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Supernova remnant candidates");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Interstellar matter");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Emission objects");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("BL Lac objects");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Blazars");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Molecular Clouds");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Young Stellar Objects");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Possible Quasars");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Possible Planetary Nebulae");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Protoplanetary Nebulae");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Symbiotic stars");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Emission-line stars");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Clusters of galaxies");
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Regions of the sky");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Messier Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Caldwell Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Barnard Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Sharpless Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("van den Bergh Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("The Catalogue of Rodgers, Campbell, and Whiteoak");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Collinder Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Melotte Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("New General Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Index Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Lynds' Catalogue of Bright Nebulae");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Lynds' Catalogue of Dark Nebulae");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Cederblad Catalog");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("The Catalogue of Peculiar Galaxies");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("The Catalogue of Interacting Galaxies");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("The Catalogue of Galactic Planetary Nebulae");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("The Strasbourg-ESO Catalogue of Galactic Planetary Nebulae");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("A catalogue of Galactic supernova remnants");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("A Catalog of Rich Clusters of Galaxies");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Hickson Compact Group");		
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("ESO/Uppsala Survey of the ESO(B) Atlas")
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Catalogue of southern stars embedded in nebulosity")
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Catalogue and distances of optically visible H II regions")
		// TRANSLATORS: Type of objects (for "Lists" in the search tool)
		N_("Dwarf galaxies");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Herschel 400 Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Jack Bennett's deep sky catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("James Dunlop's southern deep sky catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Trumpler Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Stock Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("Ruprecht Catalogue");
		// TRANSLATORS: Catalogue of objects (for "Lists" in the search tool)
		N_("van den Bergh-Hagen Catalogue");
		
		// =====================================================================
		// List of stars types
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Interesting double stars");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Interesting variable stars");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Bright double stars");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Bright variable stars");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Bright stars with high proper motion");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Variable stars: Algol-type eclipsing systems");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Variable stars: the classical cepheids");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Bright carbon stars");
		// TRANSLATORS: Type of stars (for "Lists" in the search tool)
		N_("Bright barium stars");
		
		// =====================================================================
		// Landscape names
		// TRANSLATORS: Name of landscape
		N_("Guereins");
		// TRANSLATORS: Name of landscape
		N_("Trees");
		// TRANSLATORS: Name of landscape
		N_("Moon");
		// TRANSLATORS: Landscape name: Hurricane Ridge
		N_("Hurricane");
		// TRANSLATORS: Name of landscape
		N_("Ocean");
		// TRANSLATORS: Landscape name: Garching bei Munchen
		N_("Garching");
		// TRANSLATORS: Name of landscape
		N_("Mars");
		// TRANSLATORS: Name of landscape
		N_("Jupiter");
		// TRANSLATORS: Name of landscape
		N_("Saturn");
		// TRANSLATORS: Name of landscape
		N_("Uranus");
		// TRANSLATORS: Name of landscape
		N_("Neptune");
		// TRANSLATORS: Name of landscape
		N_("Geneva");
		// TRANSLATORS: Name of landscape
		N_("Grossmugl");
		// TRANSLATORS: Name of landscape
		N_("Zero Horizon");
		// TRANSLATORS: Name of landscape
		N_("Sun");

		// =====================================================================
		// 3D landscapes (scenes) names
		// TRANSLATORS: Name of 3D scene ("Sterngarten" is proper name)
		N_("Vienna Sterngarten");
		// TRANSLATORS: Name of 3D scene
		N_("Testscene");
		
		// =====================================================================
		// Script names
		// TRANSLATORS: Name of script
		N_("Landscape Tour");
		// TRANSLATORS: Name of script
		N_("Partial Lunar Eclipse");
		// TRANSLATORS: Name of script
		N_("Total Lunar Eclipse");
		// TRANSLATORS: Name of script
		N_("Screensaver");
		// TRANSLATORS: Name of script
		N_("Solar Eclipse 2009");
		// TRANSLATORS: Name of script
		N_("Startup Script");
		// TRANSLATORS: Name of script
		N_("Zodiac");
		// TRANSLATORS: Name of script
		N_("Mercury Triple Sunrise and Sunset");
		// TRANSLATORS: Name of script
		N_("Double eclipse from Deimos in 2017");
		// TRANSLATORS: Name of script
		N_("Double eclipse from Deimos in 2031");
		// TRANSLATORS: Name of script
		N_("Eclipse from Olympus Mons Jan 2, 2021");
		// TRANSLATORS: Name of script
		N_("Occultation of Earth and Jupiter 2048");
		// TRANSLATORS: Name of script
		N_("3 Transits and 2 Eclipses from Deimos 2027");
		// TRANSLATORS: Name of script
		N_("Solar System Screensaver");
		// TRANSLATORS: Name of script
		N_("Constellations Tour");
		// TRANSLATORS: Name of script
		N_("Modern Constellations Tour");
		// TRANSLATORS: Name of script
		N_("Sun from different planets");
		// TRANSLATORS: Name of script
		N_("Earth best views from other bodies");
		// TRANSLATORS: Name of script
		N_("Transit of Venus");
		// TRANSLATORS: Name of script
		N_("Sky Culture Tour");
		// TRANSLATORS: Name and description of script
		N_("Earth Events from Mercury");
		// TRANSLATORS: Name and description of script
		N_("Earth Events from a floating city on Venus");
		// TRANSLATORS: Name and description of script
		N_("Earth Events from Mars");
		// TRANSLATORS: Name of script
		N_("Earth and other planet's Greatest Elongations and Oppositions from Mars");
		// TRANSLATORS: Name of script
		N_("Earth and Mars Greatest Elongations and Transits from Callisto");
		// TRANSLATORS: Name of script
		N_("Tycho's Supernova");
		// TRANSLATORS: Name of script
		N_("Earth and other Planets from Ceres");
		// TRANSLATORS: Name of script
		N_("Messier Objects Tour");
		// TRANSLATORS: Name of script
		N_("Binocular Highlights");
		// TRANSLATORS: Name of script
		N_("20 Fun Naked-Eye Double Stars");
		// TRANSLATORS: Name of script
		N_("List of largest known stars");
		// TRANSLATORS: Name of script
		N_("Herschel 400 Tour");
		// TRANSLATORS: Name of script
		N_("Binosky: Deep Sky Objects for Binoculars");
		// TRANSLATORS: Name of script
		N_("The Jack Bennett Catalog");
		// TRANSLATORS: Name of script
		N_("Best objects in the New General Catalog");
		// TRANSLATORS: Name of script
		N_("Jupiter and triple shadow phenomena");
		// TRANSLATORS: Name of script
		N_("Jupiter without Galilean satellites");
		// TRANSLATORS: Name of script
		N_("Skybox Tiles");
		// TRANSLATORS: Name of script
		N_("Occultations of bright stars by planets");
		// TRANSLATORS: Name of script
		N_("Mutual occultations of planets");
		// TRANSLATORS: Name of script
		N_("Planet Objects Tour");
		// TRANSLATORS: Name of script
		N_("Analemma");
		// TRANSLATORS: Name of script
		N_("Martian analemma");
		// TRANSLATORS: Name of script
		N_("Saturnian analemma");
		// TRANSLATORS: Name of script
		N_("Uranian analemma");
		// TRANSLATORS: Name of script
		N_("Messier Marathon");
		// TRANSLATORS: Name of script
		N_("Random location");
		// TRANSLATORS: Name of script
		N_("Jupiter Moons");
		
		// =====================================================================
		// Script descriptions
		
		// TRANSLATORS: Description of the landscape tour script.
		N_("Look around each installed landscape.");
		// TRANSLATORS: Description of the sky culture tour script.
		N_("Look at each installed sky culture. Label style is forced to be 'Native,Translated,Modern' regardless of user setting, unless environment variable STEL_SCRIPT_OBEY_SKYCULTURE_STYLE evaluates true. (Style is restored at end.)");
		N_("Script to demonstrate a partial lunar eclipse.");
		N_("Script to demonstrate a total lunar eclipse.");
		N_("A slow, infinite tour of the sky, looking at random objects.");
		N_("Script to demonstrate a total solar eclipse which has happened in 2009 (location=Rangpur, Bangladesh).");
		N_("Script which runs automatically at startup");
		N_("This script displays the constellations of the Zodiac. That means the constellations which lie along the line which the Sun traces across the celestial sphere over the course of a year. Label style is forced to be 'Native,Translated,Modern' regardless of user setting, unless environment variable STEL_SCRIPT_OBEY_SKYCULTURE_STYLE evaluates true. It ends with changes in skyculture (if not disabled by env. var.), labeling style, and shows constellation figures, boundaries and ecliptic.");
		N_("Due to the quirks in Mercury's orbit and rotation at certain spots the sun will rise & set 3 different times in one Mercury day.");
		N_("Just before Mars eclipses the sun, Phobos pops out from behind and eclipses it first. Takes place between Scorpio and Sagittarius on April 26, 2017.");
		N_("Just before Mars eclipses the sun, Phobos pops out from behind and eclipses it first. Takes place between Taurus and Gemini on July 23, 2031.");
		N_("Phobos eclipsing the Sun as seen from Olympus Mons on Jan 2, 2021.");
		N_("Phobos occultations of Earth are common, as are occultations of Jupiter. But occultations of both on the same day are very rare. Here's one that takes place 1/23/2048. In real speed.");
		N_("Phobos races ahead of Mars and transits the sun, passes through it and then retrogrades back towards the sun and just partially transits it again (only seen in the southern hemisphere of Deimos), then Mars totally eclipses the sun while Phobos transits in darkness between Mars and Deimos. When Phobos emerges from Mars it is still eclipsed and dimmed in Mars' shadow, only to light up later.");
		N_("Screensaver of various happenings in the Solar System. 321 events in all!");
		N_("A tour of the modern constellations. Label style is forced to be 'Native,Translated,Modern' regardless of user setting, unless environment variable STEL_SCRIPT_OBEY_SKYCULTURE_STYLE evaluates true. (Style is restored at end.)");
		N_("A tour of the constellations of the selected sky culture. Label style is forced to be 'Native,Translated,Modern' regardless of user setting, unless environment variable STEL_SCRIPT_OBEY_SKYCULTURE_STYLE evaluates true. (Style is restored at end.)");
		N_("Look at the Sun from big planets of Solar System and Pluto.");
		N_("Best views of Earth from other Solar System bodies in the 21st Century.");
		N_("Transit of Venus as seen from Sydney Australia, 6th June 2012.");
		N_("Flash of the supernova observed by Tycho Brahe in 1572. The Historical Supernovae plugin has to be enabled.");
		N_("Earth and other planet's Greatest Elongations and Oppositions from Mars 2000-3000");
		N_("Earth Greatest Elongations and Transits from Callisto 2000-3000. Why Callisto? Well of the 4 Galilean Moons, Callisto is the only one outside of Jupiter's radiation belt. Therefore, if humans ever colonize Jupiter's moons, Callisto will be the one.");
		N_("Earth the other visible Planet's Greatest Elongations and Oppositions from Ceres 2000-2200");
		N_("A tour of Messier Objects");
		N_("Tours around interesting objects, which accessible to observation with binoculars. The data for the script are taken from the eponymous book by Gary Seronik.");
		N_("This script helps you make an excursion around 20 fun double stars. The list has been collected by Jerry Lodriguss and published in Sky & Telescope 09/2014. Data taken from his website, http://www.astropix.com/doubles/");
		N_("This script helps you make an excursion around largest known stars.");
		N_("A tour around objects from the Herschel 400 Catalogue");
		N_("Ben Crowell has created Binosky, an observing list of Deep Sky Objects for Binoculars. In the script we give a list of these 31 objects, ordered by Right Ascension (2000.0).");
		N_("The Jack Bennett Catalog of Southern Deep-Sky Objects (152 objects in all). The Bennett catalog was contributed by Auke Slotegraaf.");
		N_("This list of 111 objects by A.J. Crayon and Steve Coe is used by members of the Saguaro Astronomy Club of Phoenix, AZ, for the Best of the NGC achievement award.");
		N_("Demonstration of the mid-time of rare events - triple shadow phenomena of the satellites of Jupiter from 1900 to 2100. All events are given in Dynamical Time.");
		N_("The planet Jupiter sometimes appears to be without moons, when the four Galilean satellites are simultaneously invisible because they are passing across the planet's disk (transit), are behind the planet (occultation), or are in its shadow (eclipse). This script demonstrates these rare phenomena from 1900 to 2100 in Dynamical Time.");
		N_("This script demonstrates interesting phenomena - occultations bright stars by planets, 2000 to 2040.");
		N_("This script demonstrates interesting and very rare phenomena - mutual occultations of planets, 0 to 2500.");
		N_("A tour of the Solar System planets");
		N_("A demonstration of the analemma - the path of the Sun across the sky during the year on Earth.");
		N_("A demonstration of the analemma - the path of the Sun across the sky during the year on Mars.");
		N_("A demonstration of the analemma - the path of the Sun across the sky during the year on Saturn.");
		N_("A demonstration of the analemma - the path of the Sun across the sky during the year on Uranus.");
		N_("Messier Marathon on March 20, 2020. The data for the script are taken from GaoXing's observation log: http://www.xjltp.com/2_huodong/2_030301.htm");
		N_("Creates 6 tiles (North/East/South/West/Up/Down) for a skybox. These can be further used e.g. in Unity3D or other 3D environments. Output directory and filenames can be set with environment variables STEL_SKYBOX_DIR and STEL_SKYBOX_BASENAME. A data file is also written, you can set its name with environment variable OUTPUT_DATA. Please read the script to understand how to apply it to your projects.");
		N_("This script will help you make practical works for celestial navigation - he sets a random location and hides it from the GUI.");
		N_("Jupiter's Moons Orbital Simulation");

		// =====================================================================
		// Translatable SIMBAD object types (SIMBAD: Object types - https://simbad.cds.unistra.fr/guide/otypes.htx)

		NC_("Star", "SIMBAD object type");
		NC_("Massive Star", "SIMBAD object type");
		NC_("beta Cep Variable", "SIMBAD object type");
		NC_("Evolved Supergiant", "SIMBAD object type");
		NC_("Red Supergiant", "SIMBAD object type");
		NC_("Yellow Supergiant", "SIMBAD object type");
		NC_("Blue Supergiant", "SIMBAD object type");
		NC_("Wolf-Rayet", "SIMBAD object type");
		NC_("LBV=Luminous Blue Variable", "SIMBAD object type");
		NC_("Neutron Star", "SIMBAD object type");
		NC_("Pulsar", "SIMBAD object type");
		NC_("Young Stellar Object", "SIMBAD object type");
		NC_("Orion Variable", "SIMBAD object type");
		NC_("T Tauri Star", "SIMBAD object type");
		NC_("Herbig Ae/Be Star", "SIMBAD object type");
		NC_("Outflow", "SIMBAD object type");
		NC_("Herbig-Haro Object", "SIMBAD object type");
		NC_("Main Sequence Star", "SIMBAD object type");
		NC_("Be Star", "SIMBAD object type");
		NC_("Blue Straggler", "SIMBAD object type");
		NC_("SX Phe Variable", "SIMBAD object type");
		NC_("gamma Dor Variable", "SIMBAD object type");
		NC_("delta Sct Variable", "SIMBAD object type");
		NC_("Evolved Star", "SIMBAD object type");
		NC_("Red Giant Branch star", "SIMBAD object type");
		NC_("Hot Subdwarf", "SIMBAD object type");
		NC_("Horizontal Branch Star", "SIMBAD object type");
		NC_("RR Lyrae Variable", "SIMBAD object type");
		NC_("Red Clump Star", "SIMBAD object type");
		NC_("Type II Cepheid Variable", "SIMBAD object type");
		NC_("Cepheid Variable", "SIMBAD object type");
		NC_("Classical Cepheid Variable", "SIMBAD object type");
		NC_("Carbon Star", "SIMBAD object type");
		NC_("S Star", "SIMBAD object type");
		NC_("Long-Period Variable", "SIMBAD object type");
		NC_("Asymptotic Giant Branch Star", "SIMBAD object type");
		NC_("Mira Variable", "SIMBAD object type");
		NC_("O-rich AGB Star", "SIMBAD object type");
		NC_("OH/IR Star", "SIMBAD object type");
		NC_("Post-AGB Star", "SIMBAD object type");
		NC_("RV Tauri Variable", "SIMBAD object type");
		NC_("Planetary Nebula", "SIMBAD object type");
		NC_("White Dwarf", "SIMBAD object type");
		NC_("ELMWD=Extremely Low Mass White Dwarf", "SIMBAD object type");
		NC_("Chemically Peculiar Star", "SIMBAD object type");
		NC_("alpha2 CVn Variable", "SIMBAD object type");
		NC_("R CrB Variable", "SIMBAD object type");
		NC_("CH Star", "SIMBAD object type");
		NC_("Barium Star", "SIMBAD object type");
		NC_("Dwarf Carbon Star", "SIMBAD object type");
		NC_("Carbon-Enhanced Metal Poor Star", "SIMBAD object type");
		NC_("Double or Multiple Star", "SIMBAD object type");
		NC_("Eclipsing Binary", "SIMBAD object type");
		NC_("Ellipsoidal Variable", "SIMBAD object type");
		NC_("Spectroscopic Binary", "SIMBAD object type");
		NC_("RS CVn Variable", "SIMBAD object type");
		NC_("BY Dra Variable", "SIMBAD object type");
		NC_("Symbiotic Star", "SIMBAD object type");
		NC_("X-ray Binary", "SIMBAD object type");
		NC_("Low Mass X-ray Binary", "SIMBAD object type");
		NC_("High Mass X-ray Binary", "SIMBAD object type");
		NC_("Cataclysmic Binary", "SIMBAD object type");
		NC_("Classical Nova", "SIMBAD object type");
		NC_("SuperNova", "SIMBAD object type");
		NC_("Low-mass Star", "SIMBAD object type");
		NC_("Brown Dwarf", "SIMBAD object type");
		NC_("Extra-solar Planet", "SIMBAD object type");
		NC_("Variable Star", "SIMBAD object type");
		NC_("Irregular Variable", "SIMBAD object type");
		NC_("Irregular Variable with rapid variations", "SIMBAD object type");
		NC_("Eruptive Variable", "SIMBAD object type");
		NC_("Rotating Variable", "SIMBAD object type");
		NC_("Pulsating Variable", "SIMBAD object type");
		NC_("Star showing Eclipses by its Planet", "SIMBAD object type");
		NC_("Emission-line Star", "SIMBAD object type");
		NC_("High Proper Motion Star", "SIMBAD object type");
		NC_("High Velocity Star", "SIMBAD object type");
		NC_("Cluster of Stars", "SIMBAD object type");
		NC_("Globular Cluster", "SIMBAD object type");
		NC_("Open Cluster", "SIMBAD object type");
		NC_("Association of Stars", "SIMBAD object type");
		NC_("Stellar Stream", "SIMBAD object type");
		NC_("Moving Group", "SIMBAD object type");
		NC_("Interstellar Medium Object", "SIMBAD object type");
		NC_("Star Forming Region", "SIMBAD object type");
		NC_("HII Region", "SIMBAD object type");
		NC_("Cloud", "SIMBAD object type");
		NC_("Nebula", "SIMBAD object type");
		NC_("Reflection Nebula", "SIMBAD object type");
		NC_("Molecular Cloud", "SIMBAD object type");
		NC_("Dark Cloud (nebula)", "SIMBAD object type");
		NC_("Globule (low-mass dark cloud)", "SIMBAD object type");
		NC_("Cometary Globule / Pillar", "SIMBAD object type");
		NC_("High-velocity Cloud", "SIMBAD object type");
		NC_("Dense Core", "SIMBAD object type");
		NC_("Bubble", "SIMBAD object type");
		NC_("SuperNova Remnant", "SIMBAD object type");
		NC_("Interstellar Shell", "SIMBAD object type");
		NC_("Interstellar Filament", "SIMBAD object type");
		NC_("Galaxy", "SIMBAD object type");
		NC_("Low Surface Brightness Galaxy", "SIMBAD object type");
		NC_("Blue Compact Galaxy", "SIMBAD object type");
		NC_("Starburst Galaxy", "SIMBAD object type");
		NC_("HII Galaxy", "SIMBAD object type");
		NC_("Emission-line galaxy", "SIMBAD object type");
		NC_("Active Galaxy Nucleus", "SIMBAD object type");
		NC_("Seyfert Galaxy", "SIMBAD object type");
		NC_("Seyfert 1 Galaxy", "SIMBAD object type");
		NC_("Seyfert 2 Galaxy", "SIMBAD object type");
		NC_("Radio Galaxy", "SIMBAD object type");
		NC_("LINER-type Active Galaxy Nucleus", "SIMBAD object type");
		NC_("Quasar", "SIMBAD object type");
		NC_("Blazar", "SIMBAD object type");
		NC_("BL Lac", "SIMBAD object type");
		NC_("ULIRG, Ultra Luminous Infrared Galaxy", "SIMBAD object type");
		NC_("Galaxy in Pair of Galaxies", "SIMBAD object type");
		NC_("Galaxy towards a Group of Galaxies", "SIMBAD object type");
		NC_("Galaxy towards a Cluster of Galaxies", "SIMBAD object type");
		NC_("Brightest Galaxy in a Cluster (BCG)", "SIMBAD object type");
		NC_("Interacting Galaxies", "SIMBAD object type");
		NC_("Pair of Galaxies", "SIMBAD object type");
		NC_("Group of Galaxies", "SIMBAD object type");
		NC_("Compact Group of Galaxies", "SIMBAD object type");
		NC_("Cluster of Galaxies", "SIMBAD object type");
		NC_("Proto Cluster of Galaxies", "SIMBAD object type");
		NC_("Supercluster of Galaxies", "SIMBAD object type");
		NC_("Underdense Region of the Universe", "SIMBAD object type");
		NC_("Gravitational Source", "SIMBAD object type");
		NC_("(Micro)Lensing Event", "SIMBAD object type");
		NC_("Gravitational Lens System (lens+images)", "SIMBAD object type");
		NC_("Gravitational Lens", "SIMBAD object type");
		NC_("Gravitationally Lensed Image", "SIMBAD object type");
		NC_("Gravitationally Lensed Image of a Galaxy", "SIMBAD object type");
		NC_("Gravitationally Lensed Image of a Quasar", "SIMBAD object type");
		NC_("Black Hole", "SIMBAD object type");
		NC_("Gravitational Wave Event", "SIMBAD object type");
		NC_("Transient Event", "SIMBAD object type");
		NC_("Variable source", "SIMBAD object type");
		NC_("Radio Source", "SIMBAD object type");
		NC_("Metric Radio Source", "SIMBAD object type");
		NC_("Centimetric Radio Source", "SIMBAD object type");
		NC_("Millimetric Radio Source", "SIMBAD object type");
		NC_("Sub-Millimetric Source", "SIMBAD object type");
		NC_("HI (21cm) Source", "SIMBAD object type");
		NC_("Radio Burst", "SIMBAD object type");
		NC_("Maser", "SIMBAD object type");
		NC_("Infra-Red Source", "SIMBAD object type");
		NC_("Far-IR source (λ >= 30 µm)", "SIMBAD object type");
		NC_("Mid-IR Source (3 to 30 µm)", "SIMBAD object type");
		NC_("Near-IR Source (λ < 3 µm)", "SIMBAD object type");
		NC_("Optical Source", "SIMBAD object type");
		NC_("Emission Object", "SIMBAD object type");
		NC_("Blue Object", "SIMBAD object type");
		NC_("UV-emission Source", "SIMBAD object type");
		NC_("X-ray Source", "SIMBAD object type");
		NC_("Ultra-luminous X-ray Source", "SIMBAD object type");
		NC_("Gamma-ray Source", "SIMBAD object type");
		NC_("Gamma-ray Burst", "SIMBAD object type");
		NC_("Composite Object, Blend", "SIMBAD object type");
		NC_("Not an Object (Error, Artefact, ...)", "SIMBAD object type");
		NC_("Part of Cloud", "SIMBAD object type");
		NC_("Part of a Galaxy", "SIMBAD object type");
		NC_("Object of Unknown Nature", "SIMBAD object type");
		NC_("Region defined in the Sky", "SIMBAD object type");

		// =====================================================================
		// Translatable UI elements with comments for translators (extracomments)

		// src/gui/astroCalcDialog.ui:
		// TRANSLATORS: This is a filter checkbox meaning "include penumbral lunar eclipses", so the adjective should be in plural (if applicable)
		N_("Penumbral");
		// TRANSLATORS: This is a filter checkbox meaning "include hybrid solar eclipses", so the adjective should be in plural (if applicable)
		N_("Hybrid");
		// TRANSLATORS: This is a filter checkbox meaning "include annular solar eclipses", so the adjective should be in plural (if applicable)
		N_("Annular");
		// TRANSLATORS: This is a filter checkbox meaning "include partial solar/lunar eclipses", so the adjective should be in plural (if applicable)
		N_("Partial");
		// TRANSLATORS: This is a filter checkbox meaning "include total solar/lunar eclipses", so the adjective should be in plural (if applicable)
		N_("Total");
		// TRANSLATORS: full phrase is 'show line'
		NC_("line", "show line");
		// TRANSLATORS: hours
		N_("h");

		NC_("64-bit", "addressing mode");
		NC_("32-bit", "addressing mode");
		NC_("none", "sky culture classification");

		// src/gui/helpDialogGui.ui:
		// TRANSLATORS: Same text as in the Configuration window!
		N_("Edit keyboard shortcuts...");

		// src/gui/searchDialogGui.ui:
		// TRANSLATORS: See http://en.wikipedia.org/wiki/Bayer_designation
		N_("Greek letters for Bayer designations");

		// plugins/Satellites/src/gui/satellitesImportDialog.ui:
		// TRANSLATORS: The title of the window will be set during runtime
		N_("More Satellites");

		// plugins/SolarSystemEditor/src/gui/manualImportWindow.ui:
		// TRANSLATORS: The title of the window will be set during runtime
		N_("Define an object");

		// plugins/SolarSystemEditor/src/gui/mpcImportWindow.ui:
		// TRANSLATORS: The title of the window will be set during runtime
		N_("Import data");

		// =====================================================================
		// List of GUI elements (Qt's dialogs)
		N_("&Undo");
		N_("&Redo");
		N_("Cu&t");
		N_("&Copy");
		N_("&Paste");
		N_("Delete");
		N_("Select All");
		N_("Look in:");
		N_("Directory:");
		N_("Folder");
		N_("&Choose");
		N_("Cancel");
		N_("&Cancel");
		N_("Files of type:");
		N_("Date Modified");
		N_("Directories");
		N_("Computer");
		N_("&Open");
		N_("&Save");
		N_("Save");
		N_("Save As:");
		N_("Tags:");
		N_("File &name:");
		N_("Copy &Link Location");
		N_("Abort");
		N_("Ignore");
		N_("&Basic colors");
		N_("&Pick Screen Color");
		N_("&Custom colors");
		N_("&Add to Custom Colors");
		N_("Hu&e:");
		N_("&Sat:");
		N_("&Val:");
		N_("&Red:");
		N_("&Green:");
		N_("Bl&ue:");
		N_("Select Color");
		N_("Cursor at %1, %2 Press ESC to cancel");
		N_("Back");
		N_("Forward");
		N_("Parent Directory");
		N_("Create New Folder");
		N_("List View");
		N_("Detail View");
		N_("Recent Places");
		N_("%1 already exists.\nDo you want to replace it?");
		N_("&Yes");
		N_("&No");
		N_("&Select All");
		N_("&Step up");
		N_("Step &down");
		N_("&Rename");
		N_("&Delete");
		N_("&New Folder");
		N_("New Folder");
		N_("Show &hidden files");
		N_("Search");
		// =========================================================================
		// In preparation of narration. These should go away after merge of branch "narration".
		NC_("Andromeda"          , "IAU constellation name");
		NC_("Antlia"             , "IAU constellation name");
		NC_("Apus"               , "IAU constellation name");
		NC_("Aquila"             , "IAU constellation name");
		NC_("Aquarius"           , "IAU constellation name");
		NC_("Ara"                , "IAU constellation name");
		NC_("Aries"              , "IAU constellation name");
		NC_("Auriga"             , "IAU constellation name");
		NC_("Bootes"             , "IAU constellation name");
		NC_("Canis Major"        , "IAU constellation name");
		NC_("Canis Minor"        , "IAU constellation name");
		NC_("Caelum"             , "IAU constellation name");
		NC_("Camelopardalis"     , "IAU constellation name");
		NC_("Capricornus"        , "IAU constellation name");
		NC_("Carina"             , "IAU constellation name");
		NC_("Cassiopeia"         , "IAU constellation name");
		NC_("Centaurus"          , "IAU constellation name");
		NC_("Cepheus"            , "IAU constellation name");
		NC_("Cetus"              , "IAU constellation name");
		NC_("Chamaeleon"         , "IAU constellation name");
		NC_("Circinus"           , "IAU constellation name");
		NC_("Cancer"             , "IAU constellation name");
		NC_("Columba"            , "IAU constellation name");
		NC_("Coma Berenices"     , "IAU constellation name");
		NC_("Corona Australis"   , "IAU constellation name");
		NC_("Corona Borealis"    , "IAU constellation name");
		NC_("Crater"             , "IAU constellation name");
		NC_("Crux"               , "IAU constellation name");
		NC_("Corvus"             , "IAU constellation name");
		NC_("Canes Venatici"     , "IAU constellation name");
		NC_("Cygnus"             , "IAU constellation name");
		NC_("Delphinus"          , "IAU constellation name");
		NC_("Dorado"             , "IAU constellation name");
		NC_("Draco"              , "IAU constellation name");
		NC_("Equuleus"           , "IAU constellation name");
		NC_("Eridanus"           , "IAU constellation name");
		NC_("Fornax"             , "IAU constellation name");
		NC_("Gemini"             , "IAU constellation name");
		NC_("Grus"               , "IAU constellation name");
		NC_("Hercules"           , "IAU constellation name");
		NC_("Horologium"         , "IAU constellation name");
		NC_("Hydra"              , "IAU constellation name");
		NC_("Hydrus"             , "IAU constellation name");
		NC_("Indus"              , "IAU constellation name");
		NC_("Leo Minor"          , "IAU constellation name");
		NC_("Lacerta"            , "IAU constellation name");
		NC_("Leo"                , "IAU constellation name");
		NC_("Lepus"              , "IAU constellation name");
		NC_("Libra"              , "IAU constellation name");
		NC_("Lupus"              , "IAU constellation name");
		NC_("Lynx"               , "IAU constellation name");
		NC_("Lyra"               , "IAU constellation name");
		NC_("Mensa"              , "IAU constellation name");
		NC_("Microscopium"       , "IAU constellation name");
		NC_("Monoceros"          , "IAU constellation name");
		NC_("Musca"              , "IAU constellation name");
		NC_("Norma"              , "IAU constellation name");
		NC_("Octans"             , "IAU constellation name");
		NC_("Ophiuchus"          , "IAU constellation name");
		NC_("Orion"              , "IAU constellation name");
		NC_("Pavo"               , "IAU constellation name");
		NC_("Pegasus"            , "IAU constellation name");
		NC_("Perseus"            , "IAU constellation name");
		NC_("Phoenix"            , "IAU constellation name");
		NC_("Pictor"             , "IAU constellation name");
		NC_("Piscis Austrinus"   , "IAU constellation name");
		NC_("Pisces"             , "IAU constellation name");
		NC_("Puppis"             , "IAU constellation name");
		NC_("Pyxis"              , "IAU constellation name");
		NC_("Reticulum"          , "IAU constellation name");
		NC_("Sculptor"           , "IAU constellation name");
		NC_("Scorpius"           , "IAU constellation name");
		NC_("Scutum"             , "IAU constellation name");
		NC_("Serpens"            , "IAU constellation name");
		NC_("Sextans"            , "IAU constellation name");
		NC_("Sagitta"            , "IAU constellation name");
		NC_("Sagittarius"        , "IAU constellation name");
		NC_("Taurus"             , "IAU constellation name");
		NC_("Telescopium"        , "IAU constellation name");
		NC_("Triangulum Australe", "IAU constellation name");
		NC_("Triangulum"         , "IAU constellation name");
		NC_("Tucana"             , "IAU constellation name");
		NC_("Ursa Major"         , "IAU constellation name");
		NC_("Ursa Minor"         , "IAU constellation name");
		NC_("Vela"               , "IAU constellation name");
		NC_("Virgo"              , "IAU constellation name");
		NC_("Volans"             , "IAU constellation name");
		NC_("Vulpecula"          , "IAU constellation name");
		NC_("a Galaxy"                     , "Nebula narration");
		NC_("an Active galaxy"             , "Nebula narration");
		NC_("a Radio galaxy"               , "Nebula narration");
		NC_("an Interacting galaxy"        , "Nebula narration");
		NC_("a Quasar"                     , "Nebula narration");
		NC_("a Star cluster"               , "Nebula narration");
		NC_("an Open star cluster"         , "Nebula narration");
		NC_("a Globular star cluster"      , "Nebula narration");
		NC_("a Stellar association"        , "Nebula narration");
		NC_("a Star cloud"                 , "Nebula narration");
		NC_("A nebula"                     , "Nebula narration");
		NC_("a Planetary nebula"           , "Nebula narration");
		NC_("a Dark Nebula"                , "Nebula narration");
		NC_("a Reflection nebula"          , "Nebula narration");
		NC_("a Bipolar nebula"             , "Nebula narration");
		NC_("an emission nebula"           , "Nebula narration");
		NC_("a cluster associated with nebulosity", "Nebula narration");
		NC_("an H two region"              , "Nebula narration");
		NC_("a Supernova remnant"          , "Nebula narration");
		NC_("Interstellar matter"          , "Nebula narration");
		NC_("an Emission object"           , "Nebula narration");
		NC_("a BL Lacertae object"         , "Nebula narration");
		NC_("a Blazar"                     , "Nebula narration");
		NC_("a Molecular Cloud"            , "Nebula narration");
		NC_("a Young Stellar Object"       , "Nebula narration");
		NC_("a Possible Quasar"            , "Nebula narration");
		NC_("a Possible Planetary Nebula"  , "Nebula narration");
		NC_("a Protoplanetary Nebula"      , "Nebula narration");
		NC_("a Star"                       , "Nebula narration");
		NC_("a Symbiotic Star"             , "Nebula narration");
		NC_("an Emission-line Star"        , "Nebula narration");
		NC_("a Supernova Candidate"        , "Nebula narration");
		NC_("a Supernova Remnant Candidate", "Nebula narration");
		NC_("a cluster of Galaxies"        , "Nebula narration");
		NC_("a part of a Galaxy"           , "Nebula narration");
		NC_("a region of the sky"          , "Nebula narration");
		NC_("an object of unknown type"    , "Nebula narration");
		NC_("a star"                       , "object narration");
		NC_("a major planet"               , "object narration");
		NC_("a planet moon"                , "object narration");
		NC_("an observer"                  , "object narration");
		NC_("an artificial object"         , "object narration");
		NC_("an asteroid"                  , "object narration");
		NC_("a plutino"                    , "object narration");
		NC_("a comet"                      , "object narration");
		NC_("a dwarf planet"               , "object narration");
		NC_("a cubewano"                   , "object narration");
		NC_("a scattered disc object"      , "object narration");
		NC_("an Oort Cloud Object"         , "object narration");
		NC_("a sednoid"                    , "object narration");
		NC_("an interstellar object"       , "object narration");
		NC_("an object of undefined type"  , "object narration");
	}
};
