#! /usr/bin/python3
import os
import sys
import generator_utils as gen

template = """// @{generatedby}@
/* ///////////////////////// The MPI Bugs Initiative ////////////////////////

  Origin: MBI

  Description: @{shortdesc}@
    @{longdesc}@

  Version of MPI: Conforms to MPI 1.1, does not require MPI 2 implementation

BEGIN_MPI_FEATURES
  P2P!basic: @{p2pfeature}@
  P2P!nonblocking: @{ip2pfeature}@
  P2P!persistent: Lacking
  COLL!basic: @{collfeature}@
  COLL!nonblocking: Lacking
  COLL!persistent: Lacking
  COLL!tools: Lacking
  RMA: Lacking
END_MPI_FEATURES

BEGIN_MBI_TESTS
  $ mpirun -np 4 ${EXE}
  | @{outcome}@
  | @{errormsg}@
END_MBI_TESTS
//////////////////////       End of MBI headers        /////////////////// */

#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>


int main(int argc, char **argv) {
  int nprocs = -1;
  int rank = -1;
  int dest, src;
  int root = 0;
  int stag = 0, rtag = 0;
  int buff_size = 1;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &nprocs);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);
  printf("Hello from rank %d \\n", rank);

  if (nprocs != 4)
    printf("MBI ERROR: This test needs 4 processes to produce a bug!\\n");

  int dbs = sizeof(int)*nprocs; /* Size of the dynamic buffers for alltoall and friends */
  MPI_Comm newcom = MPI_COMM_WORLD;
  MPI_Datatype type = MPI_INT;
  MPI_Op op = MPI_SUM;


  @{init1}@
  @{init2}@
  @{init3}@
  @{init4}@
  if (rank == 0) {
    dest=1;
    @{operation1}@
    @{fini1}@
    @{operation2}@
    @{fini2}@
  }else if (rank==2) {
    dest=1;
    @{operation1}@
    @{fini1}@
    @{operation2}@
    @{fini2}@
  }else if (rank==1) {
    src = MPI_ANY_SOURCE;
    rtag = MPI_ANY_TAG;
    @{operation3}@ /* MBIERROR1 */
    @{operation1}@
    @{fini1}@
    src = 0;
    @{operation4}@ /* MBIERROR2 */
    @{fini3}@
    @{fini4}@
  }else if (rank==3) {
    @{operation1}@
    @{fini1}@
  }

  @{free1}@
  @{free2}@
  @{free3}@
  @{free4}@

  MPI_Finalize();
  printf("Rank %d finished normally\\n", rank);
  return 0;
}
"""


for s in gen.send + gen.isend:
    for r in gen.irecv:
        for c in gen.coll:
            patterns = {}
            patterns = {'s': s, 'r': r, 'c': c}
            patterns['generatedby'] = f'DO NOT EDIT: this file was generated by {os.path.basename(sys.argv[0])}. DO NOT EDIT.'
            patterns['p2pfeature'] = 'Yes' if s in gen.send or r in gen.recv else 'Lacking'
            patterns['ip2pfeature'] = 'Yes' if s in gen.isend or r in gen.irecv else 'Lacking'
            patterns['collfeature'] = 'Yes' if c in gen.coll else 'Lacking'
            patterns['s'] = s
            patterns['r'] = r
            patterns['c'] = c
            patterns['init1'] = gen.init[c]("1")
            patterns['init2'] = gen.init[s]("2")
            patterns['init3'] = gen.init[r]("3")
            patterns['init4'] = gen.init[r]("4")
            patterns['fini1'] = gen.fini[c]("1")
            patterns['fini2'] = gen.fini[s]("2")
            patterns['fini3'] = gen.fini[r]("3")
            patterns['fini4'] = gen.fini[r]("4")
            patterns['free1'] = gen.free[c]("1")
            patterns['free2'] = gen.free[s]("2")
            patterns['free3'] = gen.free[r]("3")
            patterns['free4'] = gen.free[r]("4")
            patterns['operation1'] = gen.operation[c]("1")
            patterns['operation2'] = gen.operation[s]("2")
            patterns['operation3'] = gen.operation[r]("3")
            patterns['operation4'] = gen.operation[r]("4")

            # Generate the incorrect matching because of the conditional
            replace = patterns.copy()
            replace['shortdesc'] = 'Message race'
            replace['longdesc'] = 'Message race in @{r}@ with @{c}@.'
            replace['outcome'] = 'ERROR: MessageRace'
            replace['errormsg'] = 'Message race. The use of wildcard receive calls (@{r}@ at @{filename}@:@{line:MBIERROR1}@ and @{r}@ at @{filename}@:@{line:MBIERROR2}@) leads to nondeterministic matching.'
            gen.make_file(template, f'MessageRace_{c}_{s}_{r}_nok.c', replace)
