// Copyright 2016-2024 dbus-secret-service Contributors
//
// Licensed under the Apache License, Version 2.0, <LICENSE-APACHE or
// http://apache.org/licenses/LICENSE-2.0> or the MIT license <LICENSE-MIT or
// http://opensource.org/licenses/MIT>, at your option. This file may not be
// copied, modified, or distributed except according to those terms.

// This code generated by dbus-codegen-rust from xml generated by
// using dbus-send to introspect the /org/freedesktop/secrets object path.
// Generation command without --file argument:
// `dbus-codegen-rust -i org.freedesktop.Secret. --interfaces=org.freedesktop.Secret.Service -c blocking`
// See https://github.com/diwic/dbus-rs
use dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

#[allow(dead_code)]
pub trait Service {
    fn open_session(
        &self,
        algorithm: &str,
        input: arg::Variant<Box<dyn arg::RefArg>>,
    ) -> Result<
        (
            arg::Variant<Box<dyn arg::RefArg + 'static>>,
            dbus::Path<'static>,
        ),
        dbus::Error,
    >;
    fn create_collection(
        &self,
        properties: arg::PropMap,
        alias: &str,
    ) -> Result<(dbus::Path<'static>, dbus::Path<'static>), dbus::Error>;
    fn search_items(
        &self,
        attributes: ::std::collections::HashMap<&str, &str>,
    ) -> Result<(Vec<dbus::Path<'static>>, Vec<dbus::Path<'static>>), dbus::Error>;
    fn unlock(
        &self,
        objects: Vec<dbus::Path>,
    ) -> Result<(Vec<dbus::Path<'static>>, dbus::Path<'static>), dbus::Error>;
    fn lock(
        &self,
        objects: Vec<dbus::Path>,
    ) -> Result<(Vec<dbus::Path<'static>>, dbus::Path<'static>), dbus::Error>;
    fn lock_service(&self) -> Result<(), dbus::Error>;
    fn change_lock(&self, collection: dbus::Path) -> Result<dbus::Path<'static>, dbus::Error>;
    #[allow(clippy::type_complexity)]
    fn get_secrets(
        &self,
        items: Vec<dbus::Path>,
        session: dbus::Path,
    ) -> Result<
        ::std::collections::HashMap<
            dbus::Path<'static>,
            (dbus::Path<'static>, Vec<u8>, Vec<u8>, String),
        >,
        dbus::Error,
    >;
    fn read_alias(&self, name: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn set_alias(&self, name: &str, collection: dbus::Path) -> Result<(), dbus::Error>;
    fn collections(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error>;
}

#[derive(Debug)]
pub struct ServiceCollectionCreated {
    pub collection: dbus::Path<'static>,
}

impl arg::AppendAll for ServiceCollectionCreated {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.collection, i);
    }
}

impl arg::ReadAll for ServiceCollectionCreated {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ServiceCollectionCreated {
            collection: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ServiceCollectionCreated {
    const NAME: &'static str = "CollectionCreated";
    const INTERFACE: &'static str = "org.freedesktop.Secret.Service";
}

#[derive(Debug)]
pub struct ServiceCollectionDeleted {
    pub collection: dbus::Path<'static>,
}

impl arg::AppendAll for ServiceCollectionDeleted {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.collection, i);
    }
}

impl arg::ReadAll for ServiceCollectionDeleted {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ServiceCollectionDeleted {
            collection: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ServiceCollectionDeleted {
    const NAME: &'static str = "CollectionDeleted";
    const INTERFACE: &'static str = "org.freedesktop.Secret.Service";
}

#[derive(Debug)]
pub struct ServiceCollectionChanged {
    pub collection: dbus::Path<'static>,
}

impl arg::AppendAll for ServiceCollectionChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.collection, i);
    }
}

impl arg::ReadAll for ServiceCollectionChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(ServiceCollectionChanged {
            collection: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for ServiceCollectionChanged {
    const NAME: &'static str = "CollectionChanged";
    const INTERFACE: &'static str = "org.freedesktop.Secret.Service";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>> Service
    for blocking::Proxy<'a, C>
{
    fn open_session(
        &self,
        algorithm: &str,
        input: arg::Variant<Box<dyn arg::RefArg>>,
    ) -> Result<
        (
            arg::Variant<Box<dyn arg::RefArg + 'static>>,
            dbus::Path<'static>,
        ),
        dbus::Error,
    > {
        self.method_call(
            "org.freedesktop.Secret.Service",
            "OpenSession",
            (algorithm, input),
        )
    }

    fn create_collection(
        &self,
        properties: arg::PropMap,
        alias: &str,
    ) -> Result<(dbus::Path<'static>, dbus::Path<'static>), dbus::Error> {
        self.method_call(
            "org.freedesktop.Secret.Service",
            "CreateCollection",
            (properties, alias),
        )
    }

    fn search_items(
        &self,
        attributes: ::std::collections::HashMap<&str, &str>,
    ) -> Result<(Vec<dbus::Path<'static>>, Vec<dbus::Path<'static>>), dbus::Error> {
        self.method_call(
            "org.freedesktop.Secret.Service",
            "SearchItems",
            (attributes,),
        )
    }

    fn unlock(
        &self,
        objects: Vec<dbus::Path>,
    ) -> Result<(Vec<dbus::Path<'static>>, dbus::Path<'static>), dbus::Error> {
        self.method_call("org.freedesktop.Secret.Service", "Unlock", (objects,))
    }

    fn lock(
        &self,
        objects: Vec<dbus::Path>,
    ) -> Result<(Vec<dbus::Path<'static>>, dbus::Path<'static>), dbus::Error> {
        self.method_call("org.freedesktop.Secret.Service", "Lock", (objects,))
    }

    fn lock_service(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.Secret.Service", "LockService", ())
    }

    fn change_lock(&self, collection: dbus::Path) -> Result<dbus::Path<'static>, dbus::Error> {
        #![allow(clippy::bind_instead_of_map)]
        self.method_call(
            "org.freedesktop.Secret.Service",
            "ChangeLock",
            (collection,),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    #[allow(clippy::type_complexity)]
    fn get_secrets(
        &self,
        items: Vec<dbus::Path>,
        session: dbus::Path,
    ) -> Result<
        ::std::collections::HashMap<
            dbus::Path<'static>,
            (dbus::Path<'static>, Vec<u8>, Vec<u8>, String),
        >,
        dbus::Error,
    > {
        #![allow(clippy::bind_instead_of_map)]
        self.method_call(
            "org.freedesktop.Secret.Service",
            "GetSecrets",
            (items, session),
        )
        .and_then(
            |r: (
                ::std::collections::HashMap<
                    dbus::Path<'static>,
                    (dbus::Path<'static>, Vec<u8>, Vec<u8>, String),
                >,
            )| Ok(r.0),
        )
    }

    fn read_alias(&self, name: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        #![allow(clippy::bind_instead_of_map)]
        self.method_call("org.freedesktop.Secret.Service", "ReadAlias", (name,))
            .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn set_alias(&self, name: &str, collection: dbus::Path) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.Secret.Service",
            "SetAlias",
            (name, collection),
        )
    }

    fn collections(&self) -> Result<Vec<dbus::Path<'static>>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            self,
            "org.freedesktop.Secret.Service",
            "Collections",
        )
    }
}
