// file automatically generated by "../../../rheolef/fem/lib/basis_symbolic_cxx.cc"
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P1qd.h"
#include "piola_fem_lagrange.h"
namespace rheolef {
using namespace std;
template<class T>
class basis_P1qd_q {
public:
  typedef basis_rep<T>          base;
  typedef typename base::size_type size_type;
  static void evaluate      (const point_basic<T>& hat_x, Eigen::Matrix<T,Eigen::Dynamic,1>& values);
  static void grad_evaluate (const point_basic<T>& hat_x, Eigen::Matrix<point_basic<T>,Eigen::Dynamic,1>& values);
  static void hat_node  (Eigen::Matrix<point_basic<T>,Eigen::Dynamic,1>&);
};
template<class T>
class basis_P1qd_H {
public:
  typedef basis_rep<T>          base;
  typedef typename base::size_type size_type;
  static void evaluate      (const point_basic<T>& hat_x, Eigen::Matrix<T,Eigen::Dynamic,1>& values);
  static void grad_evaluate (const point_basic<T>& hat_x, Eigen::Matrix<point_basic<T>,Eigen::Dynamic,1>& values);
  static void hat_node  (Eigen::Matrix<point_basic<T>,Eigen::Dynamic,1>&);
};
template<class T>
void
basis_P1qd_q<T>::evaluate (
  const point_basic<T>& hat_x,
  Eigen::Matrix<T,Eigen::Dynamic,1>& values)
{
  values.resize(3);
  values[0] =  hat_x[1]+5.0000000000000000e-01;
  values[1] = -hat_x[1]+hat_x[0];
  values[2] = -hat_x[0]+5.0000000000000000e-01;
}
template<class T>
void
basis_P1qd_q<T>::grad_evaluate (
  const point_basic<T>&                      hat_x,
  Eigen::Matrix<point_basic<T>,Eigen::Dynamic,1>& values)
{
  values.resize(3);
  values[0][0] = 0.0;
  values[0][1] = 1.0;
  values[1][0] = 1.0;
  values[1][1] = -1.0000000000000000e+00;
  values[2][0] = -1.0000000000000000e+00;
  values[2][1] = 0.0;
}
template<class T>
void
basis_P1qd_q<T>::hat_node (Eigen::Matrix<point_basic<T>,Eigen::Dynamic,1>& x)
{
  x.resize(3);
  x[0] = point_basic<T>(5.0000000000000000e-01, 5.0000000000000000e-01);
  x[1] = point_basic<T>(5.0000000000000000e-01, -5.0000000000000000e-01);
  x[2] = point_basic<T>(-5.0000000000000000e-01, -5.0000000000000000e-01);
}
template<class T>
void
basis_P1qd_H<T>::evaluate (
  const point_basic<T>& hat_x,
  Eigen::Matrix<T,Eigen::Dynamic,1>& values)
{
  values.resize(4);
  values[0] =  hat_x[2]+5.0000000000000000e-01;
  values[1] = -hat_x[2]+hat_x[1];
  values[2] =  hat_x[0]-hat_x[1];
  values[3] = -hat_x[0]+5.0000000000000000e-01;
}
template<class T>
void
basis_P1qd_H<T>::grad_evaluate (
  const point_basic<T>&                      hat_x,
  Eigen::Matrix<point_basic<T>,Eigen::Dynamic,1>& values)
{
  values.resize(4);
  values[0][0] = 0.0;
  values[0][1] = 0.0;
  values[0][2] = 1.0;
  values[1][0] = 0.0;
  values[1][1] = 1.0;
  values[1][2] = -1.0000000000000000e+00;
  values[2][0] = 1.0;
  values[2][1] = -1.0000000000000000e+00;
  values[2][2] = 0.0;
  values[3][0] = -1.0000000000000000e+00;
  values[3][1] = 0.0;
  values[3][2] = 0.0;
}
template<class T>
void
basis_P1qd_H<T>::hat_node (Eigen::Matrix<point_basic<T>,Eigen::Dynamic,1>& x)
{
  x.resize(4);
  x[0] = point_basic<T>(5.0000000000000000e-01, 5.0000000000000000e-01, 5.0000000000000000e-01);
  x[1] = point_basic<T>(5.0000000000000000e-01, 5.0000000000000000e-01, -5.0000000000000000e-01);
  x[2] = point_basic<T>(5.0000000000000000e-01, -5.0000000000000000e-01, -5.0000000000000000e-01);
  x[3] = point_basic<T>(-5.0000000000000000e-01, -5.0000000000000000e-01, -5.0000000000000000e-01);
}
template<class T>
basis_P1qd<T>::basis_P1qd()
 : base(basis_option()), _hat_node()
{
  base::_sopt.set_continuous(false);
  _initialize_cstor_sizes();
  base::_name = "P1qd";
  base::_piola_fem.piola_fem<T>::base::operator= (new_macro(piola_fem_lagrange<T>));
}
template<class T>
basis_P1qd<T>::~basis_P1qd()
{
}
template<class T>
typename basis_P1qd<T>::size_type
basis_P1qd<T>::degree () const
{
    return 1;
}
template<class T>
void
basis_P1qd<T>::evaluate (
    reference_element     hat_K,
    const point_basic<T>& hat_x,
    Eigen::Matrix<T,Eigen::Dynamic,1>& values) const
{
    switch (hat_K.variant()) {
      case reference_element::q: {
        return basis_P1qd_q<T>::evaluate (hat_x, values);
      }
      case reference_element::H: {
        return basis_P1qd_H<T>::evaluate (hat_x, values);
      }
      default : {
        error_macro ("evaluate: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P1qd<T>::grad_evaluate (
    reference_element        hat_K,
    const point_basic<T>&    hat_x,
    Eigen::Matrix<point_basic<T>,Eigen::Dynamic,1>& values) const
{
    switch (hat_K.variant()) {
      case reference_element::q: {
      return basis_P1qd_q<T>::grad_evaluate (hat_x, values);
      }
      case reference_element::H: {
      return basis_P1qd_H<T>::grad_evaluate (hat_x, values);
      }
      default : {
        error_macro ("grad_evaluate: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
template<class T>
void
basis_P1qd<T>::_compute_dofs (
  reference_element     hat_K,
  const Eigen::Matrix<T,Eigen::Dynamic,1>&   f_xnod,
        Eigen::Matrix<T,Eigen::Dynamic,1>&   dof) const
{
  dof = f_xnod;
}
template<class T>
void
basis_P1qd<T>::_initialize_cstor_sizes() const
{
  fatal_macro("::_initialize_cstor_sizes: not yet"); /* TODO */
}
template<class T>
void
basis_P1qd<T>::_initialize_data(
    reference_element hat_K) const
{
    switch (hat_K.variant()) {
      case reference_element::q: {
        return basis_P1qd_q<T>::hat_node (_hat_node[hat_K.variant()]);
      }
      case reference_element::H: {
        return basis_P1qd_H<T>::hat_node (_hat_node[hat_K.variant()]);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
// instantiation in library:
template class basis_P1qd<Float>;
} // namespace rheolef
