#! /usr/bin/env perl

# Test removal of diacritic symbols:

use strict;
use warnings;
use utf8;

use lib 'lib';
use RestfulDB::Charman qw( decode_hex_string );

binmode( STDOUT, "utf8" );

my @cases = (
    '\xD0\x9A\xD0\xB8\xD1\x80\xD0\xB8\xD0\xBB\xD0\xBB\x20\xD0\xB8' .
    '\x20\xD0\x9C\xD0\xB5\xD1\x84\xD0\xBE\xD0\xB4\xD0\xB8\xD0\xB9',

    '\x53\xC4\x85\xC5\xBE\x69\x6E\x69\x6E\x67\x61\x20' .
    '\xC5\xBD\xC4\x85\x73\x69\x73',

    '\xD0\x9A\xD0\xB8\xD1\x80\xD0\xB8\xD0\xBB\xD0\xBB \xD0\xB8 ' .
    '\xD0\x9C\xD0\xB5\xD1\x84\xD0\xBE\xD0\xB4\xD0\xB8\xD0\xB9',

    '\x53\xC4\x85\xC5\xBE\x69\x6E\x69\x6E\x67\x61 ' .
    '\xC5\xBD\xC4\x85\x73\x69\x73',

    'Gra\xC5\xBEulis',
);

local $\ = "\n";

foreach my $value (@cases) {
    print decode_hex_string( $value );
}
